/*
 * Decompiled with CFR 0.152.
 */
import com.sun.javafx.css.StyleManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Scanner;
import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class appGUI
extends StackPane {
    private modifiedMethods customMethods = new modifiedMethods();
    private TextArea textArea = new TextArea();
    private TextField textFieldA;
    private TextField textFieldB;
    private TextField textFieldC;
    private Menu menuBarOne = new Menu("_File");
    private Menu Links = new Menu("_Links");
    private Menu about = new Menu("_Help");
    private ToggleGroup userChoice = new ToggleGroup();
    private Scanner input = null;
    private PrintWriter output = null;

    appGUI() {
        this.MenuBarStuff();
        this.paint();
    }

    private void paint() {
        this.setPadding(new Insets(4.0));
        BorderPane bp = new BorderPane();
        Button genButton = new Button("Calculate");
        this.textFieldA = new TextField("A");
        this.textFieldB = new TextField("B");
        this.textFieldC = new TextField("C");
        HBox hBoxTF = new HBox();
        FlowPane topPane = new FlowPane();
        VBox radioButtons = new VBox();
        HBox generate = new HBox();
        radioButtons.setSpacing(5.0);
        genButton.setOnAction(e -> this.sentToServer());
        Label coefficientA = new Label("Coefficient A ");
        Label coefficientB = new Label("Coefficient B ");
        Label coefficientC = new Label("Coefficient C ");
        this.textArea.setEditable(false);
        this.textArea.setMinHeight(450.0);
        this.textArea.setId("text-area");
        genButton.setId("Generate-button");
        generate.getChildren().add(genButton);
        MenuBar menuOne = new MenuBar();
        menuOne.getMenus().addAll((Menu[])new Menu[]{this.menuBarOne, this.Links, this.about});
        menuOne.setId("menuColor");
        hBoxTF.getChildren().addAll((Node[])new Node[]{coefficientA, this.textFieldA, coefficientB, this.textFieldB, coefficientC, this.textFieldC, generate});
        this.textFieldA.setPrefWidth(50.0);
        this.textFieldB.setPrefWidth(50.0);
        this.textFieldC.setPrefWidth(50.0);
        hBoxTF.setSpacing(5.0);
        topPane.getChildren().add(hBoxTF);
        topPane.setAlignment(Pos.TOP_CENTER);
        topPane.setHgap(5.0);
        bp.setTop(menuOne);
        bp.setCenter(topPane);
        bp.setBottom(this.textArea);
        this.getChildren().addAll((Node[])new Node[]{bp});
    }

    private void MenuBarStuff() {
        MenuItem resetMenu = new MenuItem("Reset");
        MenuItem help = new MenuItem("Need help? Click here");
        MenuItem exitProgram = new MenuItem("Exit");
        MenuItem myWebsite = new MenuItem("Developer website");
        MenuItem appInfo = new MenuItem("Program Information");
        MenuItem github = new MenuItem("Github");
        help.setOnAction(event -> this.customMethods.directionsDialog());
        resetMenu.setOnAction(e -> this.doReset());
        exitProgram.setOnAction(e -> this.customMethods.byeUser());
        myWebsite.setOnAction(e -> {
            try {
                this.customMethods.visitLinks();
            }
            catch (IOException e1) {
                this.textArea.appendText("Error Opening Link");
            }
        });
        appInfo.setOnAction(e -> this.customMethods.appInfo());
        github.setOnAction(e -> {
            try {
                this.customMethods.gitHub();
            }
            catch (IOException e1) {
                this.textArea.appendText("Error Opening link to GitHub");
            }
        });
        RadioMenuItem darkTheme = new RadioMenuItem("Dark Theme");
        RadioMenuItem lightTheme = new RadioMenuItem("Light Theme");
        darkTheme.setOnAction(e -> this.toggleDarkTheme());
        lightTheme.setOnAction(e -> this.toggleLightTheme());
        MenuBar menuTwo = new MenuBar();
        menuTwo.getMenus().addAll((Menu[])new Menu[]{this.Links});
        menuTwo.setId("menuColor");
        ToggleGroup toggleGroup = new ToggleGroup();
        lightTheme.setToggleGroup(toggleGroup);
        darkTheme.setToggleGroup(toggleGroup);
        darkTheme.setSelected(true);
        MenuBar menuThree = new MenuBar();
        menuThree.getMenus().addAll((Menu[])new Menu[]{this.about});
        this.menuBarOne.getItems().add(resetMenu);
        this.menuBarOne.getItems().add(new SeparatorMenuItem());
        this.menuBarOne.getItems().add(exitProgram);
        this.menuBarOne.getItems().add(new SeparatorMenuItem());
        this.menuBarOne.getItems().add(lightTheme);
        this.menuBarOne.getItems().add(darkTheme);
        this.Links.getItems().add(myWebsite);
        this.Links.getItems().add(new SeparatorMenuItem());
        this.Links.getItems().add(github);
        this.about.getItems().add(help);
        this.about.getItems().add(new SeparatorMenuItem());
        this.about.getItems().add(appInfo);
    }

    private void sentToServer() {
        try {
            int coeffecientAINT = this.UserA();
            int coeffecientBINT = this.UserB();
            int coeffecientCINT = this.UserC();
        }
        catch (NullPointerException ex) {
            this.textArea.appendText("Invalid Input");
        }
        String SERVER = "cs.stcc.edu";
        int PORT = 5005;
        try (Socket socket = new Socket(SERVER, PORT);){
            System.out.println("Server Connection Success!");
            this.textArea.appendText("\nSuccessfully connected to: " + SERVER + ":" + PORT);
            this.textArea.setText("Coefficient A: " + this.UserA() + "\nCoefficient B: " + this.UserB() + "\nCoefficient C: " + this.UserC());
            this.input = new Scanner(socket.getInputStream());
            this.output = new PrintWriter(socket.getOutputStream());
            this.output.println(this.UserA());
            this.output.flush();
            this.output.println(this.UserB());
            this.output.flush();
            this.output.println(this.UserC());
            this.output.flush();
            try {
                socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (UnknownHostException exception) {
            this.textArea.appendText(exception.getMessage());
        }
        catch (NumberFormatException e) {
            this.textArea.appendText("\nNumber of Quick Picks not set.");
        }
        catch (Exception ex) {
            this.textArea.appendText("\n" + ex.getMessage());
        }
        try {
            this.input.close();
        }
        catch (Exception e) {
            System.out.println("An error Occurred");
        }
        try {
            this.output.close();
        }
        catch (Exception e) {
            System.out.println("An error Occurred");
        }
    }

    private int UserA() {
        if (this.textFieldA.getText() != null) {
            return Integer.parseInt(this.textFieldA.getText());
        }
        return this.UserA();
    }

    private int UserB() {
        if (this.textFieldB.getText() != null) {
            return Integer.parseInt(this.textFieldB.getText());
        }
        return this.UserB();
    }

    private int UserC() {
        if (this.textFieldC.getText() != null) {
            return Integer.parseInt(this.textFieldC.getText());
        }
        return this.UserC();
    }

    private void toggleDarkTheme() {
        String CustomCSS = "Stylesheets.css";
        try {
            StyleManager.getInstance().addUserAgentStylesheet("Stylesheets.css");
        }
        catch (NullPointerException e) {
            System.out.println("Stylesheet not found");
        }
    }

    private void toggleLightTheme() {
        try {
            this.getScene().getStylesheets().clear();
            Application.setUserAgentStylesheet("MODENA");
        }
        catch (NullPointerException e) {
            System.out.println("File not found");
        }
    }

    private void doReset() {
        this.textArea.setText("");
        this.textFieldA.setText("");
        this.textFieldB.setText("");
        this.textFieldC.setText("");
    }
}

