/*
 * Decompiled with CFR 0.152.
 */
package me.tyler15555.minibosses.common;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Color;
import java.util.HashMap;
import me.tyler15555.minibosses.block.MBBlocks;
import me.tyler15555.minibosses.common.CommandMiniBosses;
import me.tyler15555.minibosses.common.CommonProxy;
import me.tyler15555.minibosses.common.MBEventHandler;
import me.tyler15555.minibosses.common.MBWorldGenerator;
import me.tyler15555.minibosses.entity.EntityCrawler;
import me.tyler15555.minibosses.entity.EntityFeeder;
import me.tyler15555.minibosses.entity.EntityForestGuard;
import me.tyler15555.minibosses.entity.EntityGlider;
import me.tyler15555.minibosses.entity.EntityInfernoGolem;
import me.tyler15555.minibosses.entity.EntityIronZombie;
import me.tyler15555.minibosses.entity.EntityLivingBlock;
import me.tyler15555.minibosses.entity.EntitySprout;
import me.tyler15555.minibosses.entity.EntityStealthCreeper;
import me.tyler15555.minibosses.entity.EntitySuperSlime;
import me.tyler15555.minibosses.entity.EntityTombGuard;
import me.tyler15555.minibosses.entity.EntityWatcher;
import me.tyler15555.minibosses.item.MBItems;
import me.tyler15555.minibosses.network.PacketHandler;
import me.tyler15555.minibosses.util.ConfigHelper;
import me.tyler15555.minibosses.util.Resources;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="MiniBosses", name="Mini-Bosses", version="1.2a")
public class MiniBosses {
    public static Logger logger;
    @Mod.Instance(value="MiniBosses")
    public static MiniBosses instance;
    @SidedProxy(clientSide="me.tyler15555.minibosses.client.ClientProxy", serverSide="me.tyler15555.minibosses.common.CommonProxy")
    public static CommonProxy proxy;
    public static HashMap<String, Integer> entityBanMap;

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        event.getModLog().log(Level.INFO, "Mini-Bosses is starting to load!");
        logger = event.getModLog();
        ConfigHelper.setupConfig(new Configuration(event.getSuggestedConfigurationFile()), event.getModLog());
        Resources.setupArmorMaterials();
        GameRegistry.registerItem((Item)MBItems.ingotDarkIron, (String)"ingotDarkIron");
        GameRegistry.registerItem((Item)MBItems.darkIronHelm, (String)"darkIronHelm");
        GameRegistry.registerItem((Item)MBItems.darkIronChest, (String)"darkIronChest");
        GameRegistry.registerItem((Item)MBItems.darkIronLegs, (String)"darkIronLegs");
        GameRegistry.registerItem((Item)MBItems.darkIronBoots, (String)"darkIronBoots");
        GameRegistry.registerItem((Item)MBItems.occulus_item, (String)"itemOcculus");
        GameRegistry.registerItem((Item)MBItems.ingotInferno, (String)"ingotInferno");
        GameRegistry.registerItem((Item)MBItems.infernoHelm, (String)"infernoHelm");
        GameRegistry.registerItem((Item)MBItems.infernoChest, (String)"infernoChest");
        GameRegistry.registerItem((Item)MBItems.infernoLegs, (String)"infernoLegs");
        GameRegistry.registerItem((Item)MBItems.infernoBoots, (String)"infernoBoots");
        GameRegistry.registerItem((Item)MBItems.feederTooth, (String)"feederTooth");
        GameRegistry.registerItem((Item)MBItems.feederSword, (String)"feederSword");
        GameRegistry.registerBlock((Block)MBBlocks.blockSlime, (String)"blockSlime");
        GameRegistry.registerBlock((Block)MBBlocks.cryptStone, (String)"cryptStone");
    }

    @Mod.EventHandler
    public void loadMod(FMLInitializationEvent event) {
        PacketHandler.init();
        proxy.registerRenderers();
        proxy.registerKeyBindings();
        OreDictionary.registerOre((String)"ingotDarkIron", (Item)MBItems.ingotDarkIron);
        OreDictionary.registerOre((String)"ingotInferno", (Item)MBItems.ingotInferno);
        MinecraftForge.EVENT_BUS.register((Object)new MBEventHandler());
        EntityRegistry.registerGlobalEntityID(EntityIronZombie.class, (String)"MB-IronZombie", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)Color.GRAY.getRGB(), (int)Color.BLACK.getRGB());
        EntityRegistry.registerGlobalEntityID(EntityCrawler.class, (String)"MB-Crawler", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)Color.RED.getRGB(), (int)Color.BLACK.getRGB());
        EntityRegistry.registerGlobalEntityID(EntitySuperSlime.class, (String)"MB-SuperSlime", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)Color.GREEN.getRGB(), (int)Color.CYAN.getRGB());
        EntityRegistry.registerGlobalEntityID(EntityForestGuard.class, (String)"MB-ForestGuard", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)Color.GREEN.getRGB(), (int)Color.WHITE.getRGB());
        EntityRegistry.registerGlobalEntityID(EntityStealthCreeper.class, (String)"MB-StealthCreeper", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)Color.WHITE.getRGB(), (int)Color.GRAY.getRGB());
        EntityRegistry.registerGlobalEntityID(EntityLivingBlock.class, (String)"MB-LivingBlock", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerGlobalEntityID(EntityWatcher.class, (String)"MB-Watcher", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)Color.BLACK.getRGB(), (int)Color.WHITE.getRGB());
        EntityRegistry.registerGlobalEntityID(EntityFeeder.class, (String)"MB-Feeder", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)Color.RED.getRGB(), (int)Color.WHITE.getRGB());
        EntityRegistry.registerGlobalEntityID(EntityGlider.class, (String)"DEBUG_ENTITY", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)Color.BLACK.getRGB(), (int)Color.BLACK.getRGB());
        EntityRegistry.registerGlobalEntityID(EntityTombGuard.class, (String)"MB-TombGuard", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerGlobalEntityID(EntityInfernoGolem.class, (String)"MB-InfernoGolem", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)Color.RED.getRGB(), (int)Color.LIGHT_GRAY.getRGB());
        EntityRegistry.registerGlobalEntityID(EntitySprout.class, (String)"MB-Sprout", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.addSpawn(EntityIronZombie.class, (int)ConfigHelper.ironZombieSpawnRate, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
        EntityRegistry.addSpawn(EntitySuperSlime.class, (int)ConfigHelper.superSlimeSpawnRate, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
        EntityRegistry.addSpawn(EntityForestGuard.class, (int)ConfigHelper.forestGuardSpawnRate, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
        EntityRegistry.addSpawn(EntityCrawler.class, (int)ConfigHelper.crawlerSpawnRate, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
        EntityRegistry.addSpawn(EntityStealthCreeper.class, (int)ConfigHelper.stealthCreeperSpawnRate, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
        EntityRegistry.addSpawn(EntityFeeder.class, (int)0, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
        EntityRegistry.addSpawn(EntityInfernoGolem.class, (int)ConfigHelper.infernoGolemSpawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
        if (ConfigHelper.allowSlimeBlockCrafting) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(MBBlocks.blockSlime, 2), (Object[])new Object[]{"sss", "sss", "sss", Character.valueOf('s'), Items.field_151123_aH});
        }
        if (ConfigHelper.enableGiantSpawn) {
            EntityRegistry.addSpawn(EntityGiantZombie.class, (int)ConfigHelper.giantSpawnRate, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
        }
        if (ConfigHelper.addMiniBossesToDungeons) {
            DungeonHooks.addDungeonMob((String)"MB-IronZombie", (int)50);
            DungeonHooks.addDungeonMob((String)"MB-ForestGuard", (int)50);
        }
        if (ConfigHelper.addLootToDungeons) {
            ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(MBItems.ingotDarkIron, 3), 1, 10, 10));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(MBItems.darkIronHelm, new Object[]{"iii", "i i", "xxx", Character.valueOf('i'), "ingotDarkIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(MBItems.darkIronChest, new Object[]{"i i", "iii", "iii", Character.valueOf('i'), "ingotDarkIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(MBItems.darkIronLegs, new Object[]{"iii", "i i", "i i", Character.valueOf('i'), "ingotDarkIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(MBItems.darkIronBoots, new Object[]{"xxx", "i i", "i i", Character.valueOf('i'), "ingotDarkIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(MBItems.infernoHelm, new Object[]{"iii", "i i", "xxx", Character.valueOf('i'), "ingotInferno"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(MBItems.infernoChest, new Object[]{"i i", "iii", "iii", Character.valueOf('i'), "ingotInferno"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(MBItems.infernoLegs, new Object[]{"iii", "i i", "i i", Character.valueOf('i'), "ingotInferno"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(MBItems.infernoBoots, new Object[]{"xxx", "i i", "i i", Character.valueOf('i'), "ingotInferno"}));
        GameRegistry.registerWorldGenerator((IWorldGenerator)new MBWorldGenerator(), (int)1);
    }

    @Mod.EventHandler
    public void finishLoading(FMLPostInitializationEvent event) {
        logger.log(Level.INFO, "Mini-Bosses has finished loading!");
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message.isStringMessage() && message.getStringValue().contains(":")) {
                String[] data = message.getStringValue().split(":");
                entityBanMap.put(data[0], Integer.valueOf(data[1]));
            }
            logger.log(Level.INFO, "Mod: " + message.getSender() + " has sent a ban request!");
        }
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        ServerCommandManager manager = (ServerCommandManager)server.func_71187_D();
        manager.func_71560_a((ICommand)new CommandMiniBosses());
    }

    public static int createDarkIronRenderPrefix() {
        return proxy.registerDarkArmorRenderPrefix();
    }

    public static int createInfernoRenderPrefix() {
        return proxy.registerInfernoArmorRenderPrefix();
    }

    static {
        entityBanMap = new HashMap();
    }
}

