/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityMaterialProjectile;
import ckathode.weaponmod.item.IItemWeapon;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityBoomerang
extends EntityMaterialProjectile {
    public static final double RETURN_STRENGTH = 0.05;
    public static final float MIN_FLOAT_STRENGTH = 0.4f;
    private float soundTimer;
    public float floatStrength;

    public EntityBoomerang(World world) {
        super(world);
    }

    public EntityBoomerang(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public EntityBoomerang(World world, EntityLivingBase entityliving, ItemStack itemstack, float f) {
        this(world);
        this.field_70250_c = entityliving;
        this.setPickupModeFromEntity(entityliving);
        this.setThrownItemStack(itemstack);
        this.func_70012_b(entityliving.field_70165_t, entityliving.field_70163_u + (double)entityliving.func_70047_e(), entityliving.field_70161_v, entityliving.field_70177_z, entityliving.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.field_70163_u -= 0.1;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, f, 5.0f);
        this.soundTimer = 0.0f;
        this.floatStrength = Math.min(1.5f, f);
        this.field_70180_af.func_75692_b(29, (Object)Float.floatToRawIntBits(this.floatStrength));
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(29, (Object)Float.floatToRawIntBits(0.0f));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.floatStrength = Float.intBitsToFloat(this.field_70180_af.func_75679_c(29));
        if (this.field_70254_i) {
            return;
        }
        this.floatStrength *= 0.994f;
        if (this.floatStrength < 0.4f) {
            if (this.func_70241_g()) {
                this.func_70243_d(false);
            }
            this.floatStrength = 0.0f;
        }
        float limitedStrength = Math.min(1.0f, this.floatStrength);
        if (!this.beenInGround) {
            this.field_70177_z += 20.0f * this.floatStrength;
        }
        if (!this.beenInGround && this.field_70250_c != null && this.floatStrength > 0.0f) {
            double dx = this.field_70165_t - this.field_70250_c.field_70165_t;
            double dy = this.field_70163_u - this.field_70250_c.field_70163_u - (double)this.field_70250_c.func_70047_e();
            double dz = this.field_70161_v - this.field_70250_c.field_70161_v;
            double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
            this.field_70159_w -= 0.05 * (dx /= d);
            this.field_70181_x -= 0.05 * (dy /= d);
            this.field_70179_y -= 0.05 * (dz /= d);
            this.soundTimer += limitedStrength;
            if (this.soundTimer > 3.0f) {
                this.field_70170_p.func_72956_a((Entity)this, "random.bow", 0.6f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 2.2f - limitedStrength));
                this.soundTimer %= 3.0f;
            }
        }
        this.field_70180_af.func_75692_b(29, (Object)Float.floatToRawIntBits(this.floatStrength));
    }

    @Override
    public void onEntityHit(Entity entity) {
        if (this.field_70170_p.field_72995_K || this.floatStrength < 0.4f) {
            return;
        }
        if (entity == this.field_70250_c) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                ItemStack item = this.getPickupItem();
                if (item == null) {
                    return;
                }
                if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_70441_a(item)) {
                    this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    this.onItemPickup(player);
                    this.func_70106_y();
                    return;
                }
            }
            return;
        }
        DamageSource damagesource = null;
        damagesource = this.field_70250_c == null ? WeaponDamageSource.causeProjectileWeaponDamage(this, (Entity)this) : WeaponDamageSource.causeProjectileWeaponDamage(this, this.field_70250_c);
        float damage = ((IItemWeapon)this.thrownItem.func_77973_b()).getMeleeComponent().getEntityDamage() + 2.0f + this.extraDamage;
        damage += this.getMeleeHitDamage(entity);
        if (this.func_70241_g()) {
            damage += 2.0f;
        }
        if (entity.func_70097_a(damagesource, damage)) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            if (this.thrownItem.func_77960_j() + 1 > this.thrownItem.func_77958_k()) {
                --this.thrownItem.field_77994_a;
                this.func_70106_y();
            } else {
                if (this.field_70250_c instanceof EntityLivingBase) {
                    this.thrownItem.func_77972_a(1, (EntityLivingBase)this.field_70250_c);
                } else {
                    this.thrownItem.func_96631_a(1, this.field_70146_Z);
                }
                this.func_70016_h(0.0, 0.0, 0.0);
            }
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void onGroundHit(MovingObjectPosition mop) {
        this.xTile = mop.field_72311_b;
        this.yTile = mop.field_72312_c;
        this.zTile = mop.field_72309_d;
        this.inTile = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
        this.field_70159_w = (float)(mop.field_72307_f.field_72450_a - this.field_70165_t);
        this.field_70181_x = (float)(mop.field_72307_f.field_72448_b - this.field_70163_u);
        this.field_70179_y = (float)(mop.field_72307_f.field_72449_c - this.field_70161_v);
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / (double)f1 * 0.05;
        this.field_70163_u -= this.field_70181_x / (double)f1 * 0.05;
        this.field_70161_v -= this.field_70179_y / (double)f1 * 0.05;
        this.field_70159_w *= (double)(-this.field_70146_Z.nextFloat() * 0.5f);
        this.field_70179_y *= (double)(-this.field_70146_Z.nextFloat() * 0.5f);
        this.field_70181_x = this.field_70146_Z.nextFloat() * 0.1f;
        this.field_70254_i = mop.field_72310_e == 1;
        this.func_70243_d(false);
        this.beenInGround = true;
        this.floatStrength = 0.0f;
        if (this.inTile != null) {
            this.inTile.func_149670_a(this.field_70170_p, this.xTile, this.yTile, this.zTile, (Entity)this);
        }
    }

    @Override
    public void playHitSound() {
        this.field_70170_p.func_72956_a((Entity)this, "random.bowhit", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.9f));
    }

    @Override
    public boolean aimRotation() {
        return this.beenInGround || this.floatStrength < 0.4f;
    }

    @Override
    public int getMaxLifetime() {
        return this.pickupMode == 1 || this.pickupMode == 3 ? 0 : 1200;
    }

    @Override
    public boolean canBeCritical() {
        return true;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    public float getGravity() {
        return this.beenInGround || this.floatStrength < 0.4f ? 0.05f : 0.0f;
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    public void func_70100_b_(EntityPlayer entityplayer) {
        if (!this.beenInGround && this.field_70257_an > 5 && this.floatStrength >= 0.4f && entityplayer == this.field_70250_c) {
            ItemStack item = this.getPickupItem();
            if (item == null) {
                return;
            }
            if (entityplayer.field_71075_bZ.field_75098_d || entityplayer.field_71071_by.func_70441_a(item)) {
                this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.onItemPickup(entityplayer);
                this.func_70106_y();
                return;
            }
        }
        super.func_70100_b_(entityplayer);
    }
}

