/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.network;

import ckathode.weaponmod.AdvancedExplosion;
import ckathode.weaponmod.network.WMMessage;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class MsgExplosion
extends WMMessage {
    private double x;
    private double y;
    private double z;
    private float size;
    private List<ChunkPosition> blocks;
    private boolean smallParticles;
    private boolean bigParticles;

    public MsgExplosion(AdvancedExplosion explosion, boolean smallparts, boolean bigparts) {
        this.x = explosion.field_77284_b;
        this.y = explosion.field_77285_c;
        this.z = explosion.field_77282_d;
        this.size = explosion.field_77280_f;
        this.blocks = explosion.field_77281_g;
        this.smallParticles = smallparts;
        this.bigParticles = bigparts;
    }

    public MsgExplosion() {
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.size = buf.readFloat();
        this.smallParticles = buf.readBoolean();
        this.bigParticles = buf.readBoolean();
        int size = buf.readInt();
        this.blocks = new ArrayList<ChunkPosition>(size);
        for (int i = 0; i < size; ++i) {
            int ix = buf.readByte() + (int)this.x;
            int iy = buf.readByte() + (int)this.y;
            int iz = buf.readByte() + (int)this.z;
            this.blocks.add(new ChunkPosition(ix, iy, iz));
        }
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.size);
        buf.writeBoolean(this.smallParticles);
        buf.writeBoolean(this.bigParticles);
        int n = this.blocks.size();
        buf.writeInt(n);
        for (int i = 0; i < n; ++i) {
            ChunkPosition pos = this.blocks.get(i);
            int dx = pos.field_151329_a - (int)this.x;
            int dy = pos.field_151327_b - (int)this.y;
            int dz = pos.field_151328_c - (int)this.z;
            buf.writeByte(dx);
            buf.writeByte(dy);
            buf.writeByte(dz);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        AdvancedExplosion expl = new AdvancedExplosion((World)world, null, this.x, this.y, this.z, this.size);
        expl.setAffectedBlockPositions(this.blocks);
        expl.doParticleExplosion(this.smallParticles, this.bigParticles);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

