/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api.weapons;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mods.battlegear2.api.ISensible;
import mods.battlegear2.api.StackHolder;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class WeaponRegistry {
    private static Map<StackHolder, Pair<Wield, Boolean>> wielding = new HashMap<StackHolder, Pair<Wield, Boolean>>();
    private static Set<ISensible<StackHolder>> sensitivities = Sets.newHashSetWithExpectedSize((int)3);

    public static boolean setWeapon(String type, ItemStack stack) {
        if (type.equalsIgnoreCase("Dual")) {
            return Wield.BOTH.setWeapon(stack);
        }
        if (type.equalsIgnoreCase("MainHand")) {
            return Wield.RIGHT.setWeapon(stack);
        }
        if (type.equalsIgnoreCase("OffHand")) {
            return Wield.LEFT.setWeapon(stack);
        }
        try {
            return Wield.valueOf(type.toUpperCase(Locale.ENGLISH)).setWeapon(stack);
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    public static void addDualWeapon(ItemStack stack) {
        wielding.put(new StackHolder(stack), (Pair<Wield, Boolean>)Pair.of((Object)((Object)Wield.BOTH), (Object)false));
    }

    public static void addTwoHanded(ItemStack stack) {
        wielding.put(new StackHolder(stack), (Pair<Wield, Boolean>)Pair.of((Object)((Object)Wield.RIGHT), (Object)false));
    }

    public static void addOffhandWeapon(ItemStack stack) {
        wielding.put(new StackHolder(stack), (Pair<Wield, Boolean>)Pair.of((Object)((Object)Wield.LEFT), (Object)false));
    }

    public static boolean addSensitivity(ISensible<StackHolder> sensitivity) {
        return sensitivities.add(sensitivity);
    }

    public static boolean removeSensitivity(ISensible<StackHolder> sensitivity) {
        return sensitivities.remove(sensitivity);
    }

    public static boolean isWeapon(ItemStack stack) {
        StackHolder holder = new StackHolder(stack);
        if (sensitivities == null) {
            return wielding.containsKey(holder);
        }
        return WeaponRegistry.isWeapon(holder, sensitivities.iterator());
    }

    public static boolean isWeapon(StackHolder holder, Iterator<ISensible<StackHolder>> itr) {
        ISensible.Filter<StackHolder> filter = new ISensible.Filter<StackHolder>(holder, itr);
        return Iterators.any(wielding.keySet().iterator(), filter);
    }

    public static boolean isMainHand(ItemStack stack) {
        StackHolder holder = new StackHolder(stack);
        if (sensitivities == null) {
            Pair<Wield, Boolean> w = wielding.get(holder);
            return w != null && ((Wield)((Object)w.getLeft())).isMainhand();
        }
        return WeaponRegistry.isMainHand(holder, sensitivities.iterator());
    }

    public static boolean isMainHand(StackHolder holder, Iterator<ISensible<StackHolder>> itr) {
        final ISensible.Filter<StackHolder> filter = new ISensible.Filter<StackHolder>(holder, itr);
        return Iterators.any(wielding.entrySet().iterator(), (Predicate)new Predicate<Map.Entry<StackHolder, Pair<Wield, Boolean>>>(){

            public boolean apply(Map.Entry<StackHolder, Pair<Wield, Boolean>> input) {
                return ((Wield)((Object)input.getValue().getLeft())).isMainhand() && filter.apply((Object)input.getKey());
            }
        });
    }

    public static boolean isOffHand(ItemStack stack) {
        StackHolder holder = new StackHolder(stack);
        if (sensitivities == null) {
            Pair<Wield, Boolean> w = wielding.get(holder);
            return w != null && ((Wield)((Object)w.getLeft())).isOffhand();
        }
        return WeaponRegistry.isOffHand(holder, sensitivities.iterator());
    }

    public static boolean isOffHand(StackHolder holder, Iterator<ISensible<StackHolder>> itr) {
        final ISensible.Filter<StackHolder> filter = new ISensible.Filter<StackHolder>(holder, itr);
        return Iterators.any(wielding.entrySet().iterator(), (Predicate)new Predicate<Map.Entry<StackHolder, Pair<Wield, Boolean>>>(){

            public boolean apply(Map.Entry<StackHolder, Pair<Wield, Boolean>> input) {
                return ((Wield)((Object)input.getValue().getLeft())).isOffhand() && filter.apply((Object)input.getKey());
            }
        });
    }

    public static boolean useOverAttack(ItemStack stack, boolean inOffhand) {
        StackHolder holder = new StackHolder(stack);
        if (sensitivities == null) {
            Pair<Wield, Boolean> w = wielding.get(holder);
            return w != null && (Boolean)w.getRight() != false && (inOffhand ? ((Wield)((Object)w.getLeft())).isOffhand() : ((Wield)((Object)w.getLeft())).isMainhand());
        }
        return WeaponRegistry.useOverAttack(holder, sensitivities.iterator(), inOffhand);
    }

    public static boolean useOverAttack(StackHolder holder, Iterator<ISensible<StackHolder>> itr, final boolean inOffhand) {
        final ISensible.Filter<StackHolder> filter = new ISensible.Filter<StackHolder>(holder, itr);
        return Iterators.any(wielding.entrySet().iterator(), (Predicate)new Predicate<Map.Entry<StackHolder, Pair<Wield, Boolean>>>(){

            public boolean apply(Map.Entry<StackHolder, Pair<Wield, Boolean>> input) {
                return (Boolean)input.getValue().getRight() != false && (inOffhand ? ((Wield)((Object)input.getValue().getLeft())).isOffhand() : ((Wield)((Object)input.getValue().getLeft())).isMainhand()) && filter.apply((Object)input.getKey());
            }
        });
    }

    static {
        Collections.addAll(sensitivities, Sensitivity.ID, Sensitivity.DAMAGE, Sensitivity.NBT);
    }

    public static enum Wield {
        BOTH,
        RIGHT{

            @Override
            public boolean isOffhand() {
                return false;
            }
        }
        ,
        LEFT{

            @Override
            public boolean isMainhand() {
                return false;
            }
        };


        public boolean isOffhand() {
            return true;
        }

        public boolean isMainhand() {
            return true;
        }

        public boolean setWeapon(ItemStack stack) {
            wielding.put(new StackHolder(stack), Pair.of((Object)((Object)this), (Object)false));
            return true;
        }

        public boolean setUsable(ItemStack stack) {
            wielding.put(new StackHolder(stack), Pair.of((Object)((Object)this), (Object)true));
            return true;
        }
    }

    public static enum Sensitivity implements ISensible<StackHolder>
    {
        ORE{

            @Override
            public boolean differenciate(StackHolder holder1, StackHolder holder2) {
                return !Objects.deepEquals(OreDictionary.getOreIDs((ItemStack)holder1.stack), OreDictionary.getOreIDs((ItemStack)holder2.stack));
            }
        }
        ,
        TYPE{

            @Override
            public boolean differenciate(StackHolder holder1, StackHolder holder2) {
                return !holder1.stack.func_77973_b().getClass().equals(holder2.stack.func_77973_b().getClass());
            }
        }
        ,
        ID{

            @Override
            public boolean differenciate(StackHolder holder1, StackHolder holder2) {
                return holder1.stack.func_77973_b() != holder2.stack.func_77973_b();
            }
        }
        ,
        DAMAGE{

            @Override
            public boolean differenciate(StackHolder holder1, StackHolder holder2) {
                return holder1.stack.func_77960_j() != holder2.stack.func_77960_j();
            }
        }
        ,
        NBT{

            @Override
            public boolean differenciate(StackHolder holder1, StackHolder holder2) {
                if (holder1.stack.func_77942_o()) {
                    return !holder1.stack.func_77978_p().equals((Object)holder2.stack.func_77978_p());
                }
                return holder2.stack.func_77942_o();
            }
        };

    }
}

