/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.client.itemsRender;

import com.chocolate.chocolateQuest.items.ItemStaffHeal;
import com.chocolate.chocolateQuest.magic.Awakements;
import com.chocolate.chocolateQuest.magic.Elements;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderItemBase
implements IItemRenderer {
    private static final ResourceLocation itemGlint = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    public static IIcon swordOverlay;
    public static IIcon bigSwordOverlay;
    public static IIcon spearOverlay;
    public static IIcon daggerOverlay;
    public static IIcon staffOverlay;
    public static IIcon rosaryOverlay;
    public static IIcon wandOverlay;
    public static IIcon axeOverlay;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        EntityLivingBase p;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            p = (EntityLivingBase)data[1];
            this.renderEquipped(p, item);
        }
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            p = (EntityLivingBase)data[1];
            this.renderFirstPerson(p, item);
        }
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderInventory(item);
        }
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            Entity e = (Entity)data[1];
            GL11.glRotatef((float)(e.field_70173_aa % 360), (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderAsEntity(item);
        }
    }

    protected void renderFirstPerson(EntityLivingBase player, ItemStack itemstack) {
        this.renderItem(itemstack);
    }

    protected void renderInventory(ItemStack itemstack) {
        GL11.glScalef((float)16.0f, (float)16.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        IIcon icon = itemstack.func_77954_c();
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94209_e(), (float)icon.func_94210_h(), (float)icon.func_94212_f(), (float)icon.func_94206_g(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        GL11.glDepthMask((boolean)true);
        if (!EnchantmentHelper.func_82781_a((ItemStack)itemstack).isEmpty()) {
            RenderItemBase.renderVanillaEffect(itemstack, 0xAA8888);
        }
    }

    protected void renderAsEntity(ItemStack is) {
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.1f, (float)0.0f);
        RenderItemBase.doRenderItem(is);
        if (!EnchantmentHelper.func_82781_a((ItemStack)is).isEmpty()) {
            RenderItemBase.renderVanillaEffect(is, 0xAA8888);
        }
    }

    protected void renderEquipped(EntityLivingBase player, ItemStack itemstack) {
        this.renderItem(itemstack);
    }

    protected void renderItem(ItemStack is) {
        RenderItemBase.doRenderItem(is);
    }

    public static void doRenderItem(ItemStack itemstack) {
        RenderItemBase.doRenderItem(itemstack, 0xAA8888, false);
    }

    public static void doRenderItem(ItemStack itemstack, int color) {
        RenderItemBase.doRenderItem(itemstack, color, false);
    }

    public static void doRenderItem(ItemStack itemstack, int color, boolean effect) {
        IIcon icon = itemstack.func_77954_c();
        RenderItemBase.doRenderItem(icon, itemstack, color, false);
    }

    public static void doRenderItem(IIcon icon, ItemStack itemstack, int effectColor, boolean effect) {
        if (icon == null) {
            GL11.glPopMatrix();
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ResourceLocation resourcelocation = mc.field_71446_o.func_130087_a(itemstack.func_94608_d());
        mc.field_71446_o.func_110577_a(resourcelocation);
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        if (itemstack != null && (itemstack.func_77962_s() || effect)) {
            RenderItemBase.renderVanillaEffect(itemstack, effectColor);
        }
        GL11.glPopMatrix();
    }

    public static void registerIcons(IIconRegister iconRegister) {
        swordOverlay = iconRegister.func_94245_a("chocolatequest:enchantOverlaySword");
        bigSwordOverlay = iconRegister.func_94245_a("chocolatequest:enchantOverlayBigSword");
        daggerOverlay = iconRegister.func_94245_a("chocolatequest:enchantOverlayDagger");
        spearOverlay = iconRegister.func_94245_a("chocolatequest:enchantOverlaySpear");
        staffOverlay = iconRegister.func_94245_a("chocolatequest:enchantOverlayStaff");
        rosaryOverlay = iconRegister.func_94245_a("chocolatequest:enchantOverlayRosary");
        wandOverlay = iconRegister.func_94245_a("chocolatequest:enchantOverlayWand");
        axeOverlay = iconRegister.func_94245_a("chocolatequest:enchantOverlayAxe");
    }

    public static void renderVanillaEffect(ItemStack itemstack, int effectColor) {
        float red = (float)((double)((effectColor & 0xFF0000) >> 16) / 255.0);
        float green = (float)((double)((effectColor & 0xFF00) >> 8) / 255.0);
        float blue = (float)((double)(effectColor & 0xFF) / 255.0);
        GL11.glDepthFunc((int)514);
        GL11.glDisable((int)2896);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(itemGlint);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)768, (int)1);
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)0.5f);
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        float f8 = 0.125f;
        GL11.glScalef((float)f8, (float)f8, (float)f8);
        float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
        GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glDepthFunc((int)515);
    }

    public void renderEffect(ItemStack itemstack, IIcon iconOverlay) {
        if (itemstack != null && itemstack.field_77990_d != null && (Awakements.isAwakened(itemstack) || Elements.hasElements(itemstack) || itemstack.field_77990_d.func_74764_b("CustomPotionEffects"))) {
            List list;
            GL11.glPushMatrix();
            Minecraft mc = Minecraft.func_71410_x();
            ResourceLocation resourcelocation = mc.field_71446_o.func_130087_a(itemstack.func_94608_d());
            mc.field_71446_o.func_110577_a(resourcelocation);
            GL11.glScalef((float)1.01f, (float)1.01f, (float)1.04f);
            GL11.glTranslatef((float)-0.005f, (float)-0.005f, (float)0.002f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2896);
            float red = 1.0f;
            float green = 1.0f;
            float blue = 1.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)0.3f);
            Tessellator tessellator = Tessellator.field_78398_a;
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)iconOverlay.func_94212_f(), (float)iconOverlay.func_94206_g(), (float)iconOverlay.func_94209_e(), (float)iconOverlay.func_94210_h(), (int)iconOverlay.func_94211_a(), (int)swordOverlay.func_94216_b(), (float)0.0625f);
            if (Awakements.isAwakened(itemstack)) {
                GL11.glDepthFunc((int)514);
                GL11.glBlendFunc((int)768, (int)1);
                mc.field_71446_o.func_110577_a(itemGlint);
                red = 0.4f;
                green = 0.4f;
                blue = 0.8f;
                GL11.glMatrixMode((int)5890);
                GL11.glPushMatrix();
                GL11.glColor4f((float)red, (float)green, (float)blue, (float)0.8f);
                float f8 = 0.125f;
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
                GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
                GL11.glDepthFunc((int)515);
            }
            if ((list = ItemStaffHeal.getPotionEffects(itemstack)) != null && !list.isEmpty()) {
                this.renderElementOverlay(tessellator, 6);
            }
            if (Elements.hasElements(itemstack)) {
                for (Elements element : Elements.values()) {
                    int damage = Elements.getElementValue(itemstack, element);
                    if (damage <= 0) continue;
                    this.renderElementOverlay(tessellator, element.ordinal());
                }
            }
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
    }

    public void renderElementOverlay(Tessellator tessellator, int element) {
        GL11.glDepthFunc((int)514);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("chocolateQuest:textures/entity/shine.png"));
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        float f9 = (float)Minecraft.func_71386_F() / 10000.0f * 3.8f;
        GL11.glTranslatef((float)0.0f, (float)f9, (float)0.0f);
        float spriteWidth = 0.125f;
        float spriteOffset = spriteWidth * (float)element;
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)spriteOffset, (float)spriteOffset, (float)(spriteOffset + spriteWidth), (float)(spriteOffset + spriteWidth), (int)256, (int)128, (float)0.0625f);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glDepthFunc((int)515);
    }
}

