/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.projectile;

import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import com.chocolate.chocolateQuest.entity.projectile.ProjectileMagic;
import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.particles.EffectManager;
import com.chocolate.chocolateQuest.utils.HelperDamageSource;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;

public class ProjectileMagicExplosive
extends ProjectileMagic {
    final float DAMAGE = 1.0f;

    public ProjectileMagicExplosive(EntityBaseBall entity) {
        super(entity);
    }

    @Override
    public int getTextureIndex() {
        return 247 + this.type - (this.entity.field_70173_aa / 4 % 2 == 0 ? 0 : 16);
    }

    @Override
    public float getSize() {
        return 0.9f;
    }

    @Override
    public float getGravityVelocity() {
        return 0.12f;
    }

    @Override
    public boolean spawnParticles() {
        return true;
    }

    @Override
    public boolean hasPenetration() {
        return false;
    }

    @Override
    public void onDead() {
        byte expansion = this.entity.getlvl();
        if (this.entity.field_70170_p.field_72995_K) {
            Random rand = this.entity.getRNG();
            float desp = 0.5f + (float)(expansion / 4);
            double x = this.entity.field_70169_q;
            double y = this.entity.field_70167_r;
            double z = this.entity.field_70166_s;
            for (int i = 0; i < 25 + expansion * 5; ++i) {
                EffectManager.spawnElementParticle(0, this.entity.field_70170_p, x, y, z, (rand.nextFloat() - 0.5f) * desp, (rand.nextFloat() - 0.5f) * desp, (rand.nextFloat() - 0.5f) * desp, this.entity.getElement());
            }
            String explosion = "largeexplode";
            if (expansion > 2) {
                explosion = "hugeexplosion";
            }
            this.entity.field_70170_p.func_72869_a(explosion, x, y, z, 0.0, 0.0, 0.0);
        } else {
            double dist = 1.0f + (float)(expansion / 2);
            AxisAlignedBB var3 = this.entity.field_70121_D.func_72314_b(dist, dist / 2.0, dist);
            List list = this.entity.field_70170_p.func_72872_a(EntityLivingBase.class, var3);
            for (Entity e : list) {
                if (!(e instanceof EntityLivingBase) || e == this.entity.func_85052_h()) continue;
                Elements element = this.entity.getElement();
                DamageSource ds = element.getDamageSource();
                float damage = 1.0f * this.entity.getDamageMultiplier();
                damage = element.onHitEntity((Entity)this.entity.func_85052_h(), e, damage);
                HelperDamageSource.attackEntityWithoutKnockBack(e, ds, damage);
            }
        }
    }
}

