/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.gui;

import com.chocolate.chocolateQuest.builder.BuilderHelper;
import com.chocolate.chocolateQuest.gui.CachedEntity;
import com.chocolate.chocolateQuest.gui.InventoryBag;
import com.chocolate.chocolateQuest.items.ILoadBar;
import com.chocolate.chocolateQuest.items.ItemArmorHelmetScouter;
import com.chocolate.chocolateQuest.items.gun.ILoadableGun;
import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.utils.BDHelper;
import com.chocolate.chocolateQuest.utils.PlayerManager;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class GuiInGameStats
extends Gui {
    public static final ResourceLocation GUIBars = new ResourceLocation("chocolatequest:textures/entity/bars.png");
    private Minecraft mc;
    private int xPos;
    private int yPos;
    CachedEntity trackingEntity;
    int lastTick = 0;
    float prevFov = 0.0f;
    boolean fovModified = false;
    private static final int ICON_SIZE = 16;
    private static final int ICON_SPACING = 18;
    private static final int ICONS_PER_ROW = 16;
    private static final int COLOR = 0xFFFFFF;

    public GuiInGameStats(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderExperienceBar(RenderGameOverlayEvent event) {
        ItemStack usingItem;
        ItemStack itemstack;
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_71045_bC() != null && (itemstack = player.func_71045_bC()).func_77973_b() instanceof ILoadableGun) {
            ItemStack[] cargo = InventoryBag.getCargo(itemstack);
            int despX = 0;
            for (int i = 0; i < cargo.length; ++i) {
                if (cargo[i] == null) continue;
                ItemStack cargoItem = cargo[i];
                GL11.glPushMatrix();
                float scale = 16.0f;
                GL11.glTranslatef((float)(scale + (float)despX), (float)scale, (float)0.0f);
                GL11.glScalef((float)(-scale), (float)(-scale), (float)0.0f);
                ResourceLocation resourcelocation = this.mc.field_71446_o.func_130087_a(cargoItem.func_94608_d());
                int renderPasses = cargoItem.func_77973_b().getRenderPasses(cargoItem.func_77960_j());
                for (int f = 0; f < renderPasses; ++f) {
                    int color = cargoItem.func_77973_b().func_82790_a(cargoItem, f);
                    GL11.glColor4f((float)BDHelper.getColorRed(color), (float)BDHelper.getColorGreen(color), (float)BDHelper.getColorBlue(color), (float)1.0f);
                    IIcon icon = cargoItem.func_77973_b().func_77618_c(cargoItem.func_77960_j(), f);
                    this.mc.field_71446_o.func_110577_a(resourcelocation);
                    ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
                }
                GL11.glPopMatrix();
                if (cargoItem.field_77994_a > 1) {
                    this.func_73731_b(this.mc.field_71466_p, cargoItem.field_77994_a + "", despX + 8, 8, 0xFFFFFF);
                }
                despX = (int)((float)despX + scale);
            }
            GL11.glTranslatef((float)0.0f, (float)16.0f, (float)0.0f);
        }
        if (ItemArmorHelmetScouter.target != null) {
            this.drawScouterInfo();
        }
        GL11.glPopMatrix();
        int barPixelHeight = 11;
        float barHeight = 0.25f;
        this.mc.field_71446_o.func_110577_a(GUIBars);
        int width = 80;
        int staminaX = event.resolution.func_78326_a() - width - 5;
        int staminaY = event.resolution.func_78328_b() - 20;
        if (PlayerManager.getStamina((EntityPlayer)player) < PlayerManager.getMaxStamina((EntityPlayer)player)) {
            this.drawTexturedRect(staminaX, staminaY, staminaX + width, staminaY + barPixelHeight, 0.0f, 0.0f, 1.0f, 0.25f);
            float min = PlayerManager.getStamina((EntityPlayer)player);
            float max = PlayerManager.getMaxStamina((EntityPlayer)player);
            int barWidth = (int)(min / max * (float)width);
            this.drawTexturedRect(staminaX, staminaY, staminaX + barWidth, staminaY + barPixelHeight, 0.0f, barHeight * 2.0f, min / max, barHeight * 3.0f);
        }
        if (player.func_71045_bC() != null && player.func_71039_bw() && (usingItem = player.func_71045_bC()).func_77973_b() instanceof ILoadBar) {
            this.drawTexturedRect(staminaX, staminaY, staminaX + width, staminaY + barPixelHeight, 0.0f, 0.0f, 1.0f, 0.25f);
            ILoadBar bar = (ILoadBar)usingItem.func_77973_b();
            float max = bar.getMaxCharge();
            float min = Math.min((float)player.func_71057_bx(), max);
            int barWidth = (int)(min / max * (float)width);
            if (bar.shouldBarShine((EntityPlayer)player, usingItem)) {
                GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
            } else {
                GL11.glColor3f((float)0.5f, (float)0.0f, (float)0.0f);
            }
            this.drawTexturedRect(staminaX, staminaY, staminaX + barWidth, staminaY + barPixelHeight, 0.0f, barHeight * 3.0f, min / max, barHeight * 4.0f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (BuilderHelper.builderHelper.getStructureGenerationAmmount() > 0) {
            int builderPixelWidth = 128;
            int builderPixelHeight = 16;
            int barX = event.resolution.func_78326_a() / 2 - builderPixelWidth / 2;
            int barY = 30;
            this.drawTexturedRect(barX, barY, barX + builderPixelWidth, barY + builderPixelHeight, 0.0f, 0.0f, 1.0f, 0.25f);
            float max = 100.0f;
            float min = BuilderHelper.builderHelper.getStructureGenerationAmmount();
            builderPixelWidth = (int)(min / max * (float)builderPixelWidth);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            float desp = (float)Minecraft.func_71386_F() * 1.5E-4f;
            GL11.glTranslatef((float)(-desp), (float)0.0f, (float)0.0f);
            this.drawTexturedRect(barX + 1, barY, barX + builderPixelWidth, barY + builderPixelHeight, 0.0f, barHeight, min / max, barHeight * 2.0f);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            this.func_73731_b(this.mc.field_71466_p, StatCollector.func_74838_a((String)"strings.generate_structure"), barX, barY - 15, 0xFFFFFF);
        }
        if (this.lastTick != Minecraft.func_71410_x().field_71439_g.field_70173_aa) {
            this.lastTick = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
            if (this.trackingEntity != null) {
                this.trackingEntity.onUpdate();
            }
        }
        if (ItemArmorHelmetScouter.target != null) {
            if (this.trackingEntity == null) {
                this.trackingEntity = new CachedEntity(ItemArmorHelmetScouter.target);
            } else if (this.trackingEntity.entity != ItemArmorHelmetScouter.target) {
                this.trackingEntity = new CachedEntity(ItemArmorHelmetScouter.target);
            }
            this.drawBossBar(event.resolution.func_78326_a(), event.resolution.func_78328_b(), this.trackingEntity, 10, true);
        }
    }

    public void drawBossBar(int scaleWidth, int scaleHeight, CachedEntity trackingEntity, int posY, boolean drawName) {
        int barTotalPixelWidth;
        float health = trackingEntity.entity.func_110143_aJ();
        float maxHealth = trackingEntity.entity.func_110138_aP();
        float dif = 0.0f;
        if (trackingEntity.trackingHealth != health) {
            trackingEntity.lastDamage = dif = health - trackingEntity.trackingHealth;
            trackingEntity.damageTimer = 15;
        }
        trackingEntity.trackingHealth = health;
        int time = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
        this.mc.field_71446_o.func_110577_a(GUIBars);
        int barPixelWidth = barTotalPixelWidth = 182;
        int barPixelHeight = 8;
        int barX = scaleWidth / 2 - barPixelWidth / 2;
        int barY = posY;
        float barTextureHeight = 0.25f;
        int barType = 3;
        this.drawTexturedRect(barX, barY, barX + barPixelWidth, barY + barPixelHeight, 0.0f, 0.0f, 1.0f, 0.25f);
        float max = maxHealth;
        float min = health;
        barPixelWidth = (int)(min / max * (float)barPixelWidth);
        this.drawTexturedRect(barX + 1, barY, barX + barPixelWidth, barY + barPixelHeight, 0.0f, barTextureHeight * (float)barType, min / max, barTextureHeight * (float)(barType + 1));
        if (trackingEntity.lastDamage != 0.0f) {
            int barDifPixelWidth = (int)(Math.abs(trackingEntity.lastDamage / maxHealth) * (float)barTotalPixelWidth);
            int healthDifBarX = barX;
            if (trackingEntity.lastDamage > 0.0f) {
                healthDifBarX = barX + barPixelWidth - barDifPixelWidth;
                GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                healthDifBarX = barX + barPixelWidth;
                GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
            }
            this.drawTexturedRect(healthDifBarX, barY, healthDifBarX + barDifPixelWidth, barY + barPixelHeight, 0.1f, barTextureHeight * (float)barType, 0.9f, barTextureHeight * (float)(barType + 1));
            int textY = barY + barPixelHeight - this.mc.field_71466_p.field_78288_b;
            int textX = barX + barTotalPixelWidth;
            int color = trackingEntity.lastDamage < 0.0f ? 0xFF0000 : 65280;
            this.func_73731_b(this.mc.field_71466_p, BDHelper.floatToString(trackingEntity.lastDamage, 3), textX, textY, color);
        }
        String name = trackingEntity.entity.func_70005_c_();
        int textY = barY + 1 - this.mc.field_71466_p.field_78288_b;
        int textX = barX + barTotalPixelWidth / 2 - this.mc.field_71466_p.func_78256_a(name) / 2;
        this.func_73731_b(this.mc.field_71466_p, name, textX, textY, 0xFFFFFF);
    }

    public int drawScouterInfo() {
        int i;
        GL11.glPushMatrix();
        float scale = 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        this.xPos = 2;
        this.yPos = 2;
        this.mc.field_71446_o.func_110577_a(BDHelper.guiButtonsTexture);
        int iconBar = 25;
        int infoBars = 3;
        for (i = 0; i < infoBars; ++i) {
            this.func_73729_b(this.xPos, this.yPos + 16 * i, iconBar % 16 * 16, iconBar / 16 * 16, 64, 16);
        }
        for (i = 0; i < infoBars; ++i) {
            this.drawIcon(iconBar + 4 + i, this.xPos, this.yPos + 16 * i);
        }
        int TEXT_OFFSET = 3;
        int xResist = this.xPos + 16;
        int yResist = this.yPos + 16 * infoBars;
        int icon = 9;
        this.drawIcon(icon + 1, this.xPos, yResist);
        this.drawIcon(icon + 2, this.xPos + 32, yResist);
        this.drawIcon(icon + 3, this.xPos, yResist + 16);
        this.drawIcon(icon + 4, this.xPos + 32, yResist + 16);
        this.drawIcon(icon + 5, this.xPos, yResist + 32);
        this.drawIcon(icon + 6, this.xPos + 32, yResist + 32);
        this.drawIcon(icon, xResist, yResist);
        this.drawIcon(icon, xResist + 32, yResist);
        this.drawIcon(icon, xResist, yResist + 16);
        this.drawIcon(icon, xResist + 32, yResist + 16);
        this.drawIcon(icon, xResist, yResist + 32);
        this.drawIcon(icon, xResist + 32, yResist + 32);
        EntityLivingBase el = ItemArmorHelmetScouter.target;
        this.drawStat("   " + BDHelper.floatToString(el.func_110143_aJ(), 2) + "/" + BDHelper.floatToString(el.func_110138_aP(), 2));
        double damage = 0.0;
        int baseDamage = 0;
        IAttributeInstance attribute = el.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (attribute != null) {
            damage = attribute.func_111126_e();
            baseDamage = (int)attribute.func_111125_b();
            ItemStack weapon = el.func_71124_b(0);
            if (weapon != null) {
                damage += BDHelper.getWeaponDamage(weapon);
            }
        }
        this.drawStat("   " + damage + " (" + baseDamage + ")");
        this.drawStat("     " + el.func_70658_aO() * 4 + "%");
        this.yPos += 16;
        int protection = (int)((1.0 - BDHelper.getEnchantmentDamageReduction(el, Enchantment.field_77332_c.field_77352_x)) * 100.0);
        int projectileProtection = (int)((1.0 - BDHelper.getEnchantmentDamageReduction(el, Enchantment.field_77328_g.field_77352_x)) * 100.0);
        int physicProtection = (int)(100.0 * (1.0 - BDHelper.getDamageReductionForElement(el, Elements.physic, true)));
        int magicProtection = (int)(100.0 * (1.0 - BDHelper.getDamageReductionForElement(el, Elements.magic, true)));
        int blastProtection = (int)(100.0 * (1.0 - BDHelper.getDamageReductionForElement(el, Elements.blast, true)));
        int fireProtection = (int)(100.0 * (1.0 - BDHelper.getDamageReductionForElement(el, Elements.fire, true)));
        String text = protection + "";
        this.func_73731_b(this.mc.field_71466_p, text, xResist + TEXT_OFFSET, yResist + TEXT_OFFSET, 0xFFFFFF);
        text = projectileProtection + "";
        this.func_73731_b(this.mc.field_71466_p, text, xResist + 32 + TEXT_OFFSET, yResist + TEXT_OFFSET, 0xFFFFFF);
        text = physicProtection + "";
        this.func_73731_b(this.mc.field_71466_p, text, xResist + TEXT_OFFSET, yResist + 16 + TEXT_OFFSET, 0xFFFFFF);
        text = fireProtection + "";
        this.func_73731_b(this.mc.field_71466_p, text, xResist + 32 + TEXT_OFFSET, yResist + 16 + TEXT_OFFSET, 0xFFFFFF);
        text = blastProtection + "";
        this.func_73731_b(this.mc.field_71466_p, text, xResist + TEXT_OFFSET, yResist + 32 + TEXT_OFFSET, 0xFFFFFF);
        text = magicProtection + "";
        this.func_73731_b(this.mc.field_71466_p, text, xResist + 32 + TEXT_OFFSET, yResist + 32 + TEXT_OFFSET, 0xFFFFFF);
        if (--ItemArmorHelmetScouter.targetTimer == 0) {
            ItemArmorHelmetScouter.target = null;
        }
        GL11.glPopMatrix();
        return 0;
    }

    public void drawIcon(int icon, int xPos, int yPos) {
        this.func_73729_b(xPos, yPos, icon % 16 * 16, icon / 16 * 16, 16, 16);
    }

    public void drawStat(String text) {
        if (text.length() > 14) {
            text = text.substring(0, 12);
        }
        this.func_73731_b(this.mc.field_71466_p, text, this.xPos + 3, this.yPos + 3, 0xFFFFFF);
        this.yPos += 16;
    }

    public void drawTexturedRect(int xMin, int yMin, int xMax, int yMax, float tx, float ty, float tx1, float ty1) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)xMin, (double)yMax, (double)this.field_73735_i, (double)tx, (double)ty1);
        tessellator.func_78374_a((double)xMax, (double)yMax, (double)this.field_73735_i, (double)tx1, (double)ty1);
        tessellator.func_78374_a((double)xMax, (double)yMin, (double)this.field_73735_i, (double)tx1, (double)ty);
        tessellator.func_78374_a((double)xMin, (double)yMin, (double)this.field_73735_i, (double)tx, (double)ty);
        tessellator.func_78381_a();
    }
}

