/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.quest;

import com.chocolate.chocolateQuest.entity.npc.EntityHumanNPC;
import com.chocolate.chocolateQuest.quest.DialogActionBuildSchematic;
import com.chocolate.chocolateQuest.quest.DialogActionCommand;
import com.chocolate.chocolateQuest.quest.DialogActionConsumeItem;
import com.chocolate.chocolateQuest.quest.DialogActionCreateCounter;
import com.chocolate.chocolateQuest.quest.DialogActionEnchant;
import com.chocolate.chocolateQuest.quest.DialogActionEquipement;
import com.chocolate.chocolateQuest.quest.DialogActionGiveItem;
import com.chocolate.chocolateQuest.quest.DialogActionJoinTeam;
import com.chocolate.chocolateQuest.quest.DialogActionList;
import com.chocolate.chocolateQuest.quest.DialogActionReputation;
import com.chocolate.chocolateQuest.quest.DialogActionSetAI;
import com.chocolate.chocolateQuest.quest.DialogActionSetCurrentPositionHome;
import com.chocolate.chocolateQuest.quest.DialogActionSetItem;
import com.chocolate.chocolateQuest.quest.DialogActionSetNBT;
import com.chocolate.chocolateQuest.quest.DialogActionSetOwner;
import com.chocolate.chocolateQuest.quest.DialogActionSetTimer;
import com.chocolate.chocolateQuest.quest.DialogActionShop;
import com.chocolate.chocolateQuest.quest.DialogActionSounInABottle;
import com.chocolate.chocolateQuest.quest.DialogActionSpawnMonster;
import com.chocolate.chocolateQuest.quest.DialogActionVariableGlobal;
import com.chocolate.chocolateQuest.quest.DialogActionVariableNPC;
import com.chocolate.chocolateQuest.quest.DialogCondition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class DialogAction {
    public String name = "";
    public String surname = "";
    public int value = 0;
    public int operator = 0;
    public NBTTagCompound actionTag;
    public List<DialogCondition> conditions = null;
    public static DialogActionList[] actions = new DialogActionList[]{new DialogActionList(DialogActionShop.class, "Open shop"), new DialogActionList(DialogActionEnchant.class, "Open item upgrade"), new DialogActionList(DialogActionEquipement.class, "Open inventory"), new DialogActionList(DialogActionJoinTeam.class, "Join team"), new DialogActionList(DialogActionVariableNPC.class, "NPC variable"), new DialogActionList(DialogActionVariableGlobal.class, "Global variable"), new DialogActionList(DialogActionReputation.class, "Reputation"), new DialogActionList(DialogActionGiveItem.class, "Give item"), new DialogActionList(DialogActionConsumeItem.class, "Consume item"), new DialogActionList(DialogActionCommand.class, "Command"), new DialogActionList(DialogActionSetOwner.class, "Set owner"), new DialogActionList(DialogActionSetItem.class, "Set equipement"), new DialogActionList(DialogActionSetAI.class, "Set AI"), new DialogActionList(DialogActionSetNBT.class, "Load data from NBT"), new DialogActionList(DialogActionSpawnMonster.class, "Spawn monster"), new DialogActionList(DialogActionCreateCounter.class, "Kill counter"), new DialogActionList(DialogActionSetTimer.class, "Timer"), new DialogActionList(DialogActionSetCurrentPositionHome.class, "Set home"), new DialogActionList(DialogActionBuildSchematic.class, "Build schematic"), new DialogActionList(DialogActionSounInABottle.class, "Put in a bottle")};
    static final String[] operations = new String[]{"SET", "ADD", "SUBSTRACT"};
    byte id;

    protected DialogAction() {
    }

    public static int getIDByName(String name) {
        for (int i = 0; i < actions.length; ++i) {
            if (!DialogAction.actions[i].name.equals(name)) continue;
            return i;
        }
        return 0;
    }

    public void execute(EntityPlayer player, EntityHumanNPC npc) {
    }

    public int operateValue(int originalValue) {
        switch (this.operator) {
            case 0: {
                return this.value;
            }
            case 1: {
                return originalValue + this.value;
            }
            case 2: {
                return originalValue - this.value;
            }
        }
        return this.value;
    }

    public String operateName(EntityPlayer player) {
        if (this.name.contains("@sp")) {
            this.name = this.name.replace("@sp", player.func_70005_c_());
        }
        return this.name;
    }

    public void setType(int type) {
        this.id = (byte)type;
    }

    public byte getType() {
        return this.id;
    }

    public static DialogAction getFromNBT(NBTTagCompound tag) {
        byte type = tag.func_74771_c("Type");
        try {
            DialogAction action = actions[type].getNewInstance();
            action.readFromNBT(tag);
            return action;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74774_a("Type", this.getType());
        if (this.hasName()) {
            tag.func_74778_a("Name", this.name);
        }
        if (this.hasSurname()) {
            tag.func_74778_a("Surname", this.surname);
        }
        if (this.hasValue()) {
            tag.func_74768_a("Value", this.value);
        }
        if (this.hasOperator()) {
            tag.func_74768_a("Operator", this.operator);
        }
        if (this.hasTag() && this.actionTag != null) {
            tag.func_74782_a("ActionTag", (NBTBase)this.actionTag);
        }
        if (this.conditions != null) {
            NBTTagList list = new NBTTagList();
            for (DialogCondition condition : this.conditions) {
                NBTTagCompound conditionTag = new NBTTagCompound();
                condition.writeToNBT(conditionTag);
                list.func_74742_a((NBTBase)conditionTag);
            }
            tag.func_74782_a("Conditions", (NBTBase)list);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (this.hasName()) {
            this.name = tag.func_74779_i("Name");
        }
        if (this.hasSurname()) {
            this.surname = tag.func_74779_i("Surname");
        }
        if (this.hasValue()) {
            this.value = tag.func_74762_e("Value");
        }
        if (this.hasOperator()) {
            this.operator = tag.func_74762_e("Operator");
        }
        if (this.hasTag() && tag.func_74764_b("ActionTag")) {
            this.actionTag = (NBTTagCompound)tag.func_74781_a("ActionTag");
        }
        if (tag.func_74764_b("Conditions")) {
            NBTTagList list = (NBTTagList)tag.func_74781_a("Conditions");
            int optionCount = list.func_74745_c();
            for (int i = 0; i < optionCount; ++i) {
                this.addCondition(DialogCondition.getFromNBT(list.func_150305_b(i)));
            }
        }
    }

    public void addCondition(DialogCondition newDialog) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<DialogCondition>();
        }
        this.conditions.add(newDialog);
    }

    public void removeCondition(DialogCondition condition) {
        this.conditions.remove(condition);
    }

    public boolean hasName() {
        return true;
    }

    public String getNameForName() {
        return "Name";
    }

    public int getSelectorForName() {
        return 0;
    }

    public boolean hasSurname() {
        return false;
    }

    public String getNameForSurname() {
        return "Surname";
    }

    public int getSelectorForSurname() {
        return 0;
    }

    public boolean hasValue() {
        return false;
    }

    public String getNameForValue() {
        return "Value";
    }

    public int getSelectorForValue() {
        return 1;
    }

    public boolean hasOperator() {
        return false;
    }

    public String getNameForOperator() {
        return "Operation";
    }

    public int getSelectorForOperator() {
        return 2;
    }

    public String[] getOptionsForOperator() {
        return operations;
    }

    public boolean hasTag() {
        return false;
    }

    public String toString() {
        String s = actions[this.getType()].toString();
        if (this.hasName()) {
            s = s + " | " + this.getNameString();
        }
        if (this.hasOperator()) {
            s = s + " | " + this.getOperatorString(this.operator);
        }
        if (this.hasValue()) {
            s = s + " | " + this.value;
        }
        return s;
    }

    public String getNameString() {
        return this.name;
    }

    public String getOperatorString(int operator) {
        return this.getOptionsForOperator()[operator];
    }

    public String getValueString(int operator) {
        return this.getOptionsForOperator()[operator];
    }

    public void getSuggestions(List<String> list) {
    }

    public DialogAction copy() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return DialogAction.getFromNBT(tag);
    }
}

