/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks;

import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.BackpackCommand;
import brad16840.common.Common;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class InventoryScanner {
    public static boolean scanBackpack(EntityPlayer player, UniqueItemData data, String uuid, ScanFilter filter, HashSet<String> visited) {
        if (uuid == null || uuid.equals("none") || visited.contains(uuid) || !data.strictlyHasRequiredPermission(player.field_70170_p, player.func_70005_c_(), uuid, 2)) {
            return false;
        }
        visited.add(uuid);
        UniqueItemInventory inv = UniqueItemInventory.getInventory(null, player.field_70170_p, uuid);
        if (inv == null) {
            return false;
        }
        if (InventoryScanner.scanInventory(player, data, inv, filter, visited)) {
            return true;
        }
        return filter.checkBackpack(inv, uuid, data.getItemData(uuid, false), player);
    }

    public static boolean scanInventory(EntityPlayer player, UniqueItemData data, IInventory inventory, ScanFilter filter, HashSet<String> visited) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof Backpack) && !(stack.func_77973_b() instanceof QuantumBackpack) || !InventoryScanner.scanBackpack(player, data, InventoryScanner.getUUID(player, stack), filter, visited)) continue;
            return true;
        }
        return false;
    }

    public static boolean scanPlayer(EntityPlayer player, UniqueItemData data, ScanFilter filter) {
        NBTTagCompound tag;
        HashSet<String> visited = new HashSet<String>();
        String boundBackpack = BackpackCommand.getPlayerUuid(data, player.func_70005_c_());
        if (boundBackpack != null && data.items.containsKey(boundBackpack) && (tag = data.getItemData(boundBackpack, false)) != null && tag.func_74767_n("isEquipped") && InventoryScanner.scanBackpack(player, data, boundBackpack, filter, visited)) {
            return true;
        }
        if (InventoryScanner.scanInventory(player, data, (IInventory)player.field_71071_by, filter, visited)) {
            return true;
        }
        return InventoryScanner.scanBackpack(player, data, boundBackpack, filter, visited);
    }

    public static String getUUID(EntityPlayer player, ItemStack stack) {
        QuantumChestTileEntity.VirtualQuantumChest chest;
        if (stack.func_77973_b() instanceof QuantumBackpack && (chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, QuantumBackpack.getInfo(stack))) != null && chest.canStrictlyUse(player.field_70170_p, player.func_70005_c_())) {
            return chest.getBackpackId(player.field_70170_p, player.func_70005_c_());
        }
        return UniqueItem.getIdentifier(stack);
    }

    public static boolean backpackCanAccept(NBTTagCompound tag, ItemStack stack) {
        if (tag == null) {
            return false;
        }
        if (stack == null || !tag.func_150297_b("filtered", 99) || !tag.func_74767_n("filtered")) {
            return true;
        }
        if (!tag.func_150297_b("collect", 10)) {
            return false;
        }
        boolean inverse = (tag = tag.func_74775_l("collect")).func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
        String desc = UniqueItem.getDescriptor(stack.func_77973_b()).replace(":", "+");
        boolean isSpecified = tag.func_74764_b(desc) || tag.func_74764_b(desc + "@" + stack.func_77960_j());
        return isSpecified != inverse;
    }

    public static boolean backpackAccepts(NBTTagCompound tag, ItemStack stack) {
        if (tag == null || stack == null || tag.func_74767_n("collect-paused")) {
            return false;
        }
        boolean inverse = tag.func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
        String desc = UniqueItem.getDescriptor(stack.func_77973_b()).replace(":", "+");
        boolean isSpecified = tag.func_74764_b(desc) || tag.func_74764_b(desc + "@" + stack.func_77960_j());
        return isSpecified != inverse;
    }

    public static void loadFromInventory(EntityPlayer player, IInventory inventory) {
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        int i = 0;
        int inventorySize = inventory.func_70302_i_();
        if (inventory instanceof InventoryPlayer) {
            inventorySize = ((InventoryPlayer)inventory).field_70462_a.length;
            i = InventoryPlayer.func_70451_h();
        }
        while (i < inventorySize) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack != null && !(stack.func_77973_b() instanceof Backpack) && !(stack.func_77973_b() instanceof QuantumBackpack)) {
                InventoryScanner.scanPlayer(player, data, new AutoCollectFilter(stack));
                if (stack.field_77994_a == 0) {
                    inventory.func_70299_a(i, null);
                }
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onPlayerPickup(EntityItemPickupEvent event) {
        if (Common.disableAutoLoader) {
            return;
        }
        ItemStack stack = event.item.func_92059_d();
        EntityPlayer player = event.entityPlayer;
        if (event.item.field_145804_b > 0 || stack.field_77994_a < 1) {
            return;
        }
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        InventoryScanner.scanPlayer(player, data, new AutoCollectFilter(stack));
        if (stack.field_77994_a == 0) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onPlayerBreak(PlayerDestroyItemEvent event) {
        if (Common.disableAutoLoader) {
            return;
        }
        try {
            ItemStack stack = event.original;
            EntityPlayer player = event.entityPlayer;
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            UniqueItemData data = UniqueItemData.get(player.field_70170_p);
            if (player.func_71045_bC() != null && player.func_71045_bC().field_77994_a == 0) {
                player.func_70062_b(0, null);
            }
            try {
                player.field_71069_bz.func_75142_b();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (player.func_71045_bC() != null) {
                return;
            }
            InventoryScanner.scanPlayer(player, data, new AutoResupplyFilter(stack));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean addItemStackToInventory(UniqueItemInventory inventory, ItemStack stack, boolean canFillEmptySlots, boolean autoCollectAll) {
        if (stack == null || stack.field_77994_a == 0 || stack.func_77973_b() == null) {
            return false;
        }
        if (!stack.func_77951_h()) {
            int i;
            int originalStackSize = stack.field_77994_a;
            do {
                i = stack.field_77994_a;
                stack.field_77994_a = InventoryScanner.storePartialItemStack(inventory, stack, canFillEmptySlots, autoCollectAll);
            } while (stack.field_77994_a > 0 && stack.field_77994_a < i);
            return stack.field_77994_a < originalStackSize;
        }
        int i = InventoryScanner.getFirstEmptyStack(inventory);
        if (i < 0 || !canFillEmptySlots) {
            return false;
        }
        inventory.func_70299_a(i, ItemStack.func_77944_b((ItemStack)stack));
        stack.field_77994_a = 0;
        return true;
    }

    public static boolean canReplenishItem(EntityPlayer player, UniqueItemInventory inventory, String id, int metadata) {
        if (player.func_71045_bC() != null) {
            return false;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || !UniqueItem.getDescriptor(stack.func_77973_b()).equals(id) || metadata != Short.MAX_VALUE && metadata != stack.func_77960_j()) continue;
            player.func_70062_b(0, stack);
            inventory.func_70299_a(i, null);
            try {
                player.field_71069_bz.func_75142_b();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public static int getFirstEmptyStack(UniqueItemInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) != null) continue;
            return i;
        }
        return -1;
    }

    public static int storePartialItemStack(UniqueItemInventory inventory, ItemStack stack, boolean canFillEmptySlots, boolean collectExistingItems) {
        int spacesRemaining = stack.field_77994_a;
        int slot = -1;
        if (stack.func_77976_d() == 1) {
            slot = InventoryScanner.getFirstEmptyStack(inventory);
            if (slot < 0 || !canFillEmptySlots) {
                return spacesRemaining;
            }
            if (inventory.func_70301_a(slot) == null) {
                inventory.func_70299_a(slot, ItemStack.func_77944_b((ItemStack)stack));
            }
            return 0;
        }
        int stackLimit = Math.min(stack.func_77976_d(), inventory.func_70297_j_());
        boolean itemExists = false;
        for (int t = 0; t < inventory.func_70302_i_(); ++t) {
            ItemStack is = inventory.func_70301_a(t);
            if (is == null || is.func_77973_b() != stack.func_77973_b() || !is.func_77985_e() || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)stack) || is.func_77981_g() && is.func_77960_j() != stack.func_77960_j()) continue;
            itemExists = true;
            if (is.field_77994_a >= stackLimit) continue;
            slot = t;
            break;
        }
        if (slot < 0 && (canFillEmptySlots || collectExistingItems && itemExists)) {
            slot = InventoryScanner.getFirstEmptyStack(inventory);
        }
        if (slot < 0) {
            return spacesRemaining;
        }
        ItemStack existingStack = inventory.func_70301_a(slot);
        int spacesAvailable = Math.min(spacesRemaining, stackLimit - (existingStack == null ? 0 : existingStack.field_77994_a));
        if (spacesAvailable > 0) {
            spacesRemaining -= spacesAvailable;
            if (existingStack != null) {
                existingStack.field_77994_a += spacesAvailable;
            } else {
                ItemStack temp = ItemStack.func_77944_b((ItemStack)stack);
                temp.field_77994_a = spacesAvailable;
                inventory.func_70299_a(slot, temp);
            }
        }
        return spacesRemaining;
    }

    public static class PickItemFilter
    implements ScanFilter {
        private ItemStack target;
        private boolean wildcardMetadata;
        public int resultSlot;

        public PickItemFilter(ItemStack target, boolean wildcardMetadata) {
            this.target = target;
            this.wildcardMetadata = wildcardMetadata;
            this.resultSlot = -1;
        }

        public static int getAppropriateHotbarSlot(EntityPlayer player) {
            int currentSlot = player.field_71071_by.field_70461_c;
            for (int i = 0; i < 27; ++i) {
                int slot = (currentSlot + i) % 9;
                ItemStack stack = player.field_71071_by.func_70301_a(slot);
                if (stack != null && (i < 9 || stack.func_77973_b() instanceof Backpack || stack.func_77973_b() instanceof QuantumBackpack || i < 18 && stack.func_77948_v())) continue;
                return slot;
            }
            return -1;
        }

        @Override
        public boolean checkBackpack(UniqueItemInventory inventory, String uuid, NBTTagCompound tag, EntityPlayer player) {
            if (this.target == null) {
                return true;
            }
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                int emptySlot;
                ItemStack stack = inventory.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != this.target.func_77973_b() || !this.wildcardMetadata && stack.func_77960_j() != this.target.func_77960_j()) continue;
                int targetSlot = PickItemFilter.getAppropriateHotbarSlot(player);
                if (targetSlot < 0) {
                    return false;
                }
                ItemStack existingStack = player.field_71071_by.func_70301_a(targetSlot);
                if (existingStack != null && (emptySlot = player.field_71071_by.func_70447_i()) >= 0) {
                    ItemStack temp = player.field_71071_by.func_70301_a(emptySlot);
                    player.field_71071_by.func_70299_a(emptySlot, existingStack);
                    existingStack = temp;
                }
                player.field_71071_by.func_70299_a(targetSlot, stack);
                inventory.func_70299_a(i, existingStack);
                this.resultSlot = targetSlot;
                try {
                    player.field_71069_bz.func_75142_b();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                inventory.saveInventory();
                return true;
            }
            return false;
        }
    }

    public static class AutoResupplyFilter
    implements ScanFilter {
        private ItemStack target;

        public AutoResupplyFilter(ItemStack target) {
            this.target = target;
        }

        @Override
        public boolean checkBackpack(UniqueItemInventory inventory, String uuid, NBTTagCompound tag, EntityPlayer player) {
            boolean isSpecified;
            if (this.target == null || tag == null || !tag.func_150297_b("replenish", 10) || player.func_71045_bC() != null) {
                return false;
            }
            if ((tag = tag.func_74775_l("replenish")).func_74767_n("collect-paused")) {
                return false;
            }
            boolean inverse = tag.func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
            String id = UniqueItem.getDescriptor(this.target.func_77973_b());
            String desc = id.replace(":", "+");
            boolean bl = isSpecified = tag.func_74764_b(desc) || tag.func_74764_b(desc + "@" + this.target.func_77960_j());
            if (isSpecified == inverse) {
                return false;
            }
            if (InventoryScanner.canReplenishItem(player, inventory, id, this.target.func_77960_j())) {
                inventory.saveInventory();
                return true;
            }
            if (tag.func_74764_b(desc) != inverse && InventoryScanner.canReplenishItem(player, inventory, id, Short.MAX_VALUE)) {
                inventory.saveInventory();
                return true;
            }
            return false;
        }
    }

    public static class AutoCollectFilter
    implements ScanFilter {
        private ItemStack target;

        public AutoCollectFilter(ItemStack target) {
            this.target = target;
        }

        @Override
        public boolean checkBackpack(UniqueItemInventory inventory, String uuid, NBTTagCompound tag, EntityPlayer player) {
            boolean isSpecified;
            if (this.target == null || tag == null || this.target.field_77994_a < 1 || !tag.func_150297_b("collect", 10) && !tag.func_150297_b("fillExisting", 99) && !tag.func_150297_b("autoCollectAll", 99)) {
                return false;
            }
            boolean fillExistingStacks = tag.func_74767_n("fillExisting");
            boolean collectExistingStacks = fillExistingStacks && tag.func_74767_n("autoCollectAll");
            if ((tag = tag.func_74775_l("collect")).func_74767_n("collect-paused")) {
                return false;
            }
            boolean inverse = tag.func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
            String desc = UniqueItem.getDescriptor(this.target.func_77973_b()).replace(":", "+");
            boolean bl = isSpecified = tag.func_74764_b(desc) || tag.func_74764_b(desc + "@" + this.target.func_77960_j());
            if (isSpecified != inverse) {
                if (InventoryScanner.addItemStackToInventory(inventory, this.target, true, true)) {
                    inventory.saveInventory();
                }
            } else if (fillExistingStacks && !isSpecified && InventoryScanner.addItemStackToInventory(inventory, this.target, false, collectExistingStacks)) {
                inventory.saveInventory();
            }
            return this.target.field_77994_a < 1;
        }
    }

    public static interface ScanFilter {
        public boolean checkBackpack(UniqueItemInventory var1, String var2, NBTTagCompound var3, EntityPlayer var4);
    }
}

