/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks;

import brad16840.backpacks.BackpackChecker;
import brad16840.backpacks.InventoryScanner;
import brad16840.backpacks.blocks.BackpackBlock;
import brad16840.backpacks.blocks.BackpackBlockTileEntity;
import brad16840.backpacks.blocks.QuantumChest;
import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.gui.QuantumContainer;
import brad16840.backpacks.gui.StandaloneBackpackGui;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.BackpackPouchUpgrade;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.BlockPos;
import brad16840.common.ClientProxy;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.CustomPacket;
import brad16840.common.MessageChannel;
import brad16840.common.PacketHandler;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import brad16840.common.UnknownItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import org.apache.commons.lang3.ArrayUtils;

public class PacketHandler {
    public static String getBackpackId(EntityPlayer player, ItemStack backpack) {
        if (backpack == null) {
            return "none";
        }
        if (backpack.func_77973_b() == Common.backpack) {
            return UniqueItem.getIdentifier(backpack);
        }
        if (backpack.func_77973_b() == Common.quantumBackpack) {
            QuantumChestTileEntity.VirtualQuantumChest chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, QuantumBackpack.getInfo(backpack));
            if (chest == null) {
                return "none";
            }
            return chest.getBackpackId(player.field_70170_p, player.func_70005_c_());
        }
        return "none";
    }

    public static void registerMessages(MessageChannel channel) {
        channel.registerMessage(OpenFromQuantum.class);
        channel.registerMessage(RenameItem.class);
        channel.registerMessage(InitializePlayer.class);
        channel.registerMessage(UpdateBackpackState.class);
        channel.registerMessage(SetGuiItem.class);
        channel.registerMessage(UpdateClientTileEntity.class);
        channel.registerMessage(SetLoaderItem.class);
        channel.registerMessage(SetBackpackBlockId.class);
        channel.registerMessage(DropItemInBackpack.class);
        channel.registerMessage(InvertLoaderList.class);
        channel.registerMessage(SortBackpack.class);
        channel.registerMessage(PauseBackpackAutoCollect.class);
    }

    public static class SetBackpackBlockId
    extends MessageChannel.Message {
        public SetBackpackBlockId() {
        }

        public SetBackpackBlockId(int x, int y, int z, String uuid) {
            super(x, y, z, uuid);
            this.setClasses(Integer.class, Integer.class, Integer.class, String.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (!serverSide) {
                int x = reader.readInt();
                int y = reader.readInt();
                int z = reader.readInt();
                String id = reader.readString();
                TileEntity entity = player.field_70170_p.func_147438_o(x, y, z);
                if (!(entity instanceof BackpackBlockTileEntity)) {
                    return;
                }
                if (((BackpackBlockTileEntity)entity).backpack == null) {
                    return;
                }
                UniqueItem.setIdentifier(player, ((BackpackBlockTileEntity)entity).backpack, id);
            }
        }
    }

    public static class PauseBackpackAutoCollect
    extends MessageChannel.Message {
        public PauseBackpackAutoCollect() {
        }

        public PauseBackpackAutoCollect(String id, boolean state) {
            super(id, state);
            this.setClasses(String.class, Boolean.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String id = reader.readString();
                Boolean state = reader.readBoolean();
                UniqueItemData data = UniqueItemData.get(player.field_70170_p);
                if (!data.hasRequiredPermission(player, id, 2)) {
                    return;
                }
                NBTTagCompound tag = data.getItemData(player, id);
                if (tag == null || !tag.func_150297_b("collect", 10)) {
                    return;
                }
                tag = tag.func_74775_l("collect");
                tag.func_74757_a("collect-paused", state.booleanValue());
                data.markItemDirty(id);
                return;
            }
        }
    }

    public static class UpdateBackpackState
    extends MessageChannel.Message {
        public UpdateBackpackState() {
        }

        public UpdateBackpackState(String username, Integer backpackType) {
            super(username, backpackType == null, backpackType == null ? 0 : backpackType);
            this.setClasses(String.class, Boolean.class, Integer.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String username = reader.readString();
                if (reader.readBoolean()) {
                    reader.readInt();
                    if (!BackpackChecker.subscribedPlayers.containsKey(username)) {
                        BackpackChecker.subscribedPlayers.put(username, new WeakHashMap());
                    }
                    BackpackChecker.subscribedPlayers.get(username).put(player, 1);
                    Integer state = BackpackChecker.players.get(username);
                    Common.channel.sendToPlayer(player, new UpdateBackpackState(username, state == null ? -1 : state));
                }
            } else {
                String username = reader.readString();
                reader.readBoolean();
                BackpackChecker.handleUpdate(username, reader.readInt());
            }
        }
    }

    public static class InitializePlayer
    extends MessageChannel.Message {
        public InitializePlayer() {
            super(Arrays.asList(ArrayUtils.toObject((int[])Backpack._widths)), Arrays.asList(ArrayUtils.toObject((int[])Backpack._heights)), Backpack._forceDefaults, Common._preventQuantumChestCreation, Common._requirePermissionToDestroyQuantumChest, BackpackBlock._canDuplicate, Common._disableBackpackBlocks, Common._disableNesting);
            this.setClasses(Integer.class, Integer.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (!serverSide) {
                int i;
                int size = reader.readInt();
                Backpack.widths = new int[size];
                Backpack.heights = new int[size];
                for (i = 0; i < size; ++i) {
                    Backpack.widths[i] = reader.readInt();
                }
                reader.readInt();
                for (i = 0; i < size; ++i) {
                    Backpack.heights[i] = reader.readInt();
                }
                Backpack.forceDefaults = reader.readBoolean();
                Common.preventQuantumChestCreation = reader.readBoolean();
                Common.requirePermissionToDestroyQuantumChest = reader.readBoolean();
                BackpackBlock.canDuplicate = reader.readBoolean();
                Common.disableBackpackBlocks = reader.readBoolean();
                Common.disableNesting = reader.readBoolean();
                QuantumChestTileEntity.VirtualQuantumChest.openClientChests.clear();
                BackpackChecker.players.clear();
            }
        }
    }

    public static class SortBackpack
    extends MessageChannel.Message {
        public static Comparator<ItemStack> idSort = new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int c = UnknownItem.getItemDescriptor(o1).compareToIgnoreCase(UnknownItem.getItemDescriptor(o2));
                if (c == 0) {
                    c = Integer.compare(o1.func_77960_j(), o2.func_77960_j());
                }
                return c;
            }
        };
        public static Comparator<ItemStack> nameSort = new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int c = o1.func_82833_r().compareToIgnoreCase(o2.func_82833_r());
                if (c == 0) {
                    c = UnknownItem.getItemDescriptor(o1).compareToIgnoreCase(UnknownItem.getItemDescriptor(o2));
                }
                if (c == 0) {
                    c = Integer.compare(o1.func_77960_j(), o2.func_77960_j());
                }
                return c;
            }
        };

        public SortBackpack() {
        }

        public SortBackpack(String uuid) {
            super(uuid);
            this.setClasses(String.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                UniqueItemData data = UniqueItemData.get(player.field_70170_p);
                String uuid = reader.readString();
                UniqueItemInventory inv = UniqueItemInventory.getInventory(player, uuid);
                if (inv == null) {
                    return;
                }
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack s1 = inv.func_70301_a(i);
                    int minSize = Math.min(s1 == null ? 0 : s1.func_77976_d(), inv.func_70297_j_());
                    if (s1 == null || s1.field_77994_a >= minSize || !s1.func_77985_e()) continue;
                    for (int j = i + 1; j < inv.func_70302_i_(); ++j) {
                        ItemStack s2 = inv.func_70301_a(j);
                        if (s2 == null || s2.func_77973_b() != s1.func_77973_b() || s1.func_77981_g() && s2.func_77960_j() != s1.func_77960_j() || !ItemStack.func_77970_a((ItemStack)s2, (ItemStack)s1)) continue;
                        s1.field_77994_a += s2.func_77979_a((int)Math.min((int)(minSize - s1.field_77994_a), (int)s2.field_77994_a)).field_77994_a;
                        if (s2.field_77994_a > 0) continue;
                        inv.func_70299_a(j, null);
                    }
                }
                if (this.isSorted(inv.items, idSort)) {
                    Arrays.sort(inv.items, nameSort);
                } else {
                    Arrays.sort(inv.items, idSort);
                }
                inv.saveInventory();
                if (player.field_71070_bA != null) {
                    player.field_71070_bA.func_75142_b();
                }
            }
        }

        public boolean isSorted(ItemStack[] items, Comparator<ItemStack> comparator) {
            for (int i = 0; i < items.length - 1; ++i) {
                if (comparator.compare(items[i], items[i + 1]) <= 0) continue;
                return false;
            }
            return true;
        }
    }

    public static class InvertLoaderList
    extends MessageChannel.Message {
        public InvertLoaderList() {
        }

        public InvertLoaderList(boolean inverse, String uuid, int collect) {
            super(inverse, uuid, collect);
            this.setClasses(Boolean.class, String.class, Integer.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                UniqueItemData data = UniqueItemData.get(player.field_70170_p);
                boolean inverse = reader.readBoolean();
                String uuid = reader.readString();
                int collect = reader.readInt();
                if (!data.hasRequiredPermission(player, uuid, 2)) {
                    UniqueItemData.permissionError("modify", Backpack.name).send(player);
                    return;
                }
                if (collect == 2) {
                    NBTTagCompound tag = data.getItemData(uuid, false);
                    if (tag == null) {
                        return;
                    }
                    tag.func_74757_a("fillExisting", inverse);
                    return;
                }
                if (collect == 3) {
                    NBTTagCompound tag = data.getItemData(uuid, false);
                    if (tag == null) {
                        return;
                    }
                    tag.func_74757_a("filtered", inverse);
                    new Translatable("message.backpack" + (inverse ? "" : "un") + "locked", new Object[0]).send(player);
                    return;
                }
                if (collect == 4) {
                    NBTTagCompound tag = data.getItemData(uuid, false);
                    if (tag == null) {
                        return;
                    }
                    tag.func_74757_a("fillExisting", inverse);
                    tag.func_74757_a("autoCollectAll", inverse);
                    return;
                }
                String t = collect == 1 ? "collect" : "replenish";
                NBTTagCompound tag = data.getItemData(uuid, false);
                if (tag == null) {
                    return;
                }
                if (!tag.func_150297_b(t, 10)) {
                    tag.func_74782_a(t, (NBTBase)new NBTTagCompound());
                }
                tag.func_74775_l(t).func_74757_a("exclude", inverse);
                data.markItemDirty(uuid);
            }
        }
    }

    public static class SetLoaderItem
    extends MessageChannel.Message {
        public SetLoaderItem() {
        }

        public SetLoaderItem(boolean add, String uuid, boolean collect, NBTTagCompound tag) {
            super(add, uuid, collect, tag);
            this.setClasses(Boolean.class, String.class, Boolean.class, NBTTagCompound.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                UniqueItemData data = UniqueItemData.get(player.field_70170_p);
                reader.readBoolean();
                String uuid = reader.readString();
                String t = reader.readBoolean() ? "collect" : "replenish";
                NBTTagCompound updatedTag = reader.readNBTTagCompound();
                NBTTagCompound tag = data.getItemData(uuid, false);
                if (!data.hasRequiredPermission(player, uuid, 2)) {
                    UniqueItemData.permissionError("modify", Backpack.name).send(player);
                    return;
                }
                if (tag == null) {
                    return;
                }
                tag.func_74782_a(t, (NBTBase)updatedTag);
                data.markItemDirty(uuid);
            }
        }
    }

    public static class RenameItem
    extends MessageChannel.Message {
        public RenameItem() {
        }

        public RenameItem(String uuid, String text, int stackToClose) {
            super(uuid, text, stackToClose);
            this.setClasses(String.class, String.class, Integer.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                final String newName = reader.readString();
                int stackToClose = reader.readInt();
                UniqueItemData data = UniqueItemData.get(player.field_70170_p);
                if (!data.hasRequiredPermission(player, uuid, 2)) {
                    UniqueItemData.permissionError("rename", UniqueItemData.genericItem).send(player);
                    return;
                }
                NBTTagCompound tag = data.getItemData(player, uuid);
                if (tag == null) {
                    UniqueItemData.permissionError("rename", UniqueItemData.genericItem).send(player);
                    return;
                }
                tag.func_74782_a("custom-name", (NBTBase)new NBTTagString(newName));
                data.markItemDirty(uuid);
                UniqueItem.modifyItems(player, uuid, null, new UniqueItem.ItemStackCallback(){

                    @Override
                    public void callback(ItemStack stack) {
                        stack.func_151001_c(newName);
                    }
                });
                if (player.field_71070_bA instanceof ContainerStack) {
                    ((ContainerStack)player.field_71070_bA).closeContainer(player, stackToClose);
                }
            }
        }
    }

    public static class UpdateClientTileEntity
    extends MessageChannel.Message {
        public UpdateClientTileEntity() {
        }

        public UpdateClientTileEntity(BlockPos pos, NBTTagCompound data) {
            super(pos, data);
            this.setClasses(BlockPos.class, NBTTagCompound.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (!serverSide) {
                BlockPos pos = reader.readBlockPos();
                NBTTagCompound data = reader.readNBTTagCompound();
                TileEntity entity = player.field_70170_p.func_147438_o(pos.x, pos.y, pos.z);
                if (entity != null) {
                    entity.func_145839_a(data);
                }
            }
        }
    }

    public static class SetGuiItem
    extends MessageChannel.Message {
        public SetGuiItem() {
        }

        public SetGuiItem(ItemStack stack) {
            super(stack != null, stack != null ? stack : Integer.valueOf(0));
            this.setClasses(Boolean.class, stack != null ? ItemStack.class : Integer.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (!serverSide) {
                if (reader.readBoolean()) {
                    ((ClientProxy)Common.proxy).guiItemClient = reader.readItemStack();
                } else {
                    reader.readInt();
                    ((ClientProxy)Common.proxy).guiItemClient = null;
                }
            }
        }
    }

    public static class OpenFromQuantum
    extends MessageChannel.Message {
        public OpenFromQuantum() {
        }

        public OpenFromQuantum(int slot, int openStackId, int type, String id, int stackId, ArrayList<NBTTagCompound> tags) {
            super(slot, openStackId, type, id, stackId, tags);
            this.setClasses(Integer.class, Integer.class, Integer.class, String.class, Integer.class, NBTTagCompound.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (!serverSide) {
                int slot = reader.readInt();
                int openStackId = reader.readInt();
                int t = reader.readInt();
                String uuid = reader.readString();
                int stackId = reader.readInt();
                int tagCount = reader.readInt();
                if (!(player.field_71070_bA instanceof ContainerStack)) {
                    for (int i = 0; i < tagCount; ++i) {
                        reader.readNBTTagCompound();
                    }
                    new Translatable("problem.openquantumclientfail", new Object[0]).log(player);
                    ContainerStack.closeScreen(player);
                } else {
                    ContainerStack container = (ContainerStack)player.field_71070_bA;
                    for (int i = 0; i < tagCount; ++i) {
                        NBTTagCompound tag = reader.readNBTTagCompound();
                        if (tag == null) continue;
                        UniqueItemData.get(player.field_70170_p).updateData(tag);
                    }
                    if (container == null || !(container.getContainer(stackId) instanceof QuantumContainer)) {
                        new Translatable("problem.openquantumclientfail", new Object[0]).log(player);
                        ContainerStack.closeScreen(player);
                        return;
                    }
                    if (!((QuantumContainer)container.getContainer(stackId)).openFromServer(player, slot, openStackId, t, uuid)) {
                        new Translatable("problem.openquantumclientfail", new Object[0]).log(player);
                        ContainerStack.closeScreen(player);
                    }
                }
            }
        }
    }

    public static class DropItemInBackpack
    extends MessageChannel.Message {
        private static HashMap<EntityPlayer, Integer> thing = new HashMap();

        public DropItemInBackpack() {
        }

        public DropItemInBackpack(String uuid, boolean shift, int slot, boolean wasRightClick) {
            super(uuid, shift, slot, wasRightClick);
            this.setClasses(String.class, Boolean.class, Integer.class, Boolean.class);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                int i;
                UniqueItemData data;
                boolean clickedInventory;
                boolean clickedDye;
                String id = reader.readString();
                boolean shift = reader.readBoolean();
                int slot = reader.readInt();
                boolean wasRightClick = reader.readBoolean();
                if (id.equals("close")) {
                    try {
                        ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                boolean clickedUpgrade = id.startsWith("upgrade_");
                if (clickedUpgrade) {
                    id = id.substring(8);
                }
                if (clickedDye = id.startsWith("dye_")) {
                    id = id.substring(4);
                }
                if (clickedInventory = id.startsWith("inv_")) {
                    id = id.substring(4);
                }
                if (id.startsWith("@")) {
                    QuantumChestTileEntity.VirtualQuantumChest chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, id);
                    if (chest == null) {
                        QuantumBackpack.error_chestNotFound.send(player);
                        return;
                    }
                    id = chest.getBackpackId(player.field_70170_p, player.func_70005_c_());
                    if (id == null) {
                        UniqueItemData.permissionError("use", QuantumChest.name).send(player);
                        return;
                    }
                }
                if (!(data = UniqueItemData.get(player.field_70170_p)).strictlyHasRequiredPermission(player.field_70170_p, player.func_70005_c_(), id, 2)) {
                    UniqueItemData.permissionError("modify", Backpack.name).send(player);
                    return;
                }
                UniqueItemInventory inv = UniqueItemInventory.getInventory(null, player.field_70170_p, id);
                if (inv == null) {
                    return;
                }
                int n = i = thing.containsKey(player) ? thing.get(player) : 0;
                if (slot >= 0) {
                    boolean canStack;
                    UniqueItemInventory inventory;
                    if (slot == 999) {
                        if (player.field_71071_by.func_70445_o() == null) {
                            return;
                        }
                        if (!wasRightClick) {
                            player.func_71019_a(player.field_71071_by.func_70445_o(), true);
                            player.field_71071_by.func_70437_b((ItemStack)null);
                        } else {
                            player.func_71019_a(player.field_71071_by.func_70445_o().func_77979_a(1), true);
                            if (player.field_71071_by.func_70445_o().field_77994_a == 0) {
                                player.field_71071_by.func_70437_b((ItemStack)null);
                            }
                        }
                        Common.channel.sendToPlayer(player, new PacketHandler.TellTheClientTheHeldItemStackHasChanged(player.field_71071_by.func_70445_o()));
                        return;
                    }
                    UniqueItemInventory uniqueItemInventory = inventory = clickedInventory ? player.field_71071_by : inv;
                    if (inventory.func_70302_i_() <= slot) {
                        return;
                    }
                    ItemStack place = player.field_71071_by.func_70445_o();
                    ItemStack take = inventory.func_70301_a(slot);
                    if (clickedUpgrade) {
                        if (take == null || !(take.func_77973_b() instanceof BackpackPouchUpgrade)) {
                            return;
                        }
                        for (int upgrade = Backpack.widths.length - 1; upgrade >= 0; --upgrade) {
                            if (Backpack.widths[upgrade] != inv.width || Backpack.heights[upgrade] != inv.height) continue;
                            if (++upgrade >= Backpack.widths.length) {
                                new Translatable("problem.backpackfullyupgraded", new Object[0]).send(player);
                                return;
                            }
                            --take.field_77994_a;
                            if (take.field_77994_a == 0) {
                                inv.func_70299_a(slot, null);
                            } else {
                                inv.func_70299_a(slot, take);
                            }
                            inv.saveInventory();
                            if (!Backpack.setBackpackSize(player, id, Backpack.widths[upgrade], Backpack.heights[upgrade])) {
                                UniqueItemData.permissionError("modify", Backpack.name).send(player);
                            }
                            inv.refreshInventory();
                            Common.channel.sendToPlayer(player, new DropItemInBackpack("", false, 0, false));
                            return;
                        }
                        new Translatable("problem.irregularbackpacksize", new Object[0]).send(player);
                        return;
                    }
                    if (clickedDye) {
                        int color = take.func_77960_j();
                        --take.field_77994_a;
                        if (take.field_77994_a == 0) {
                            inv.func_70299_a(slot, null);
                        } else {
                            inv.func_70299_a(slot, take);
                        }
                        inv.saveInventory();
                        final int c = color;
                        UniqueItem.modifyItems(player, id, null, new UniqueItem.ItemStackCallback(){

                            @Override
                            public void callback(ItemStack stack) {
                                if (stack != null) {
                                    if (stack.func_77960_j() > 16) {
                                        stack.func_77964_b(c + 16);
                                    } else {
                                        stack.func_77964_b(c);
                                    }
                                }
                            }
                        });
                        Backpack.setBackpackColor(player, id, c);
                        inv.refreshInventory();
                        Common.channel.sendToPlayer(player, new DropItemInBackpack("", false, 0, false));
                        return;
                    }
                    if (inv.getIdentifier().equals(PacketHandler.getBackpackId(player, place)) || inv.getIdentifier().equals(PacketHandler.getBackpackId(player, take))) {
                        return;
                    }
                    if (!clickedInventory && !InventoryScanner.backpackCanAccept(data.getItemData(id, false), place)) {
                        return;
                    }
                    boolean bl = canStack = place != null && take != null && take.func_77973_b() == place.func_77973_b() && take.func_77985_e() && take.field_77994_a < take.func_77976_d() && take.field_77994_a < inventory.func_70297_j_() && (!take.func_77981_g() || take.func_77960_j() == place.func_77960_j()) && ItemStack.func_77970_a((ItemStack)take, (ItemStack)place);
                    if (shift && take != null) {
                        ItemStack t = place;
                        if (clickedInventory) {
                            int p;
                            if (!InventoryScanner.backpackCanAccept(data.getItemData(player, id), take)) {
                                return;
                            }
                            do {
                                p = take.field_77994_a;
                                take.field_77994_a = InventoryScanner.storePartialItemStack(inv, take, true, true);
                            } while (take.field_77994_a > 0 && take.field_77994_a < p);
                            if (take.field_77994_a <= 0) {
                                take = null;
                            } else {
                                new Translatable("message.backpackfull", new Object[0]).send(player);
                            }
                            inv.saveInventory();
                        } else {
                            player.field_71071_by.func_70441_a(take);
                        }
                        place = take;
                        take = t;
                    } else if (wasRightClick) {
                        if (place == null) {
                            if (take != null) {
                                place = take.func_77979_a(take.field_77994_a / 2);
                            }
                        } else if (take == null) {
                            take = place.func_77979_a(place.field_77994_a - 1);
                        } else {
                            if (!canStack) return;
                            int change = 1;
                            if ((change = Math.min(change, Math.min(inventory.func_70297_j_(), take.func_77976_d()) - take.field_77994_a)) < 0) {
                                change = 0;
                            }
                            int t = place.field_77994_a;
                            place.field_77994_a = take.field_77994_a + change;
                            take.field_77994_a = t - change;
                        }
                    } else if (canStack) {
                        int change = place.field_77994_a;
                        if ((change = Math.min(change, Math.min(inventory.func_70297_j_(), take.func_77976_d()) - take.field_77994_a)) < 0) {
                            change = 0;
                        }
                        int t = place.field_77994_a;
                        place.field_77994_a = take.field_77994_a + change;
                        take.field_77994_a = t - change;
                    }
                    if (place != null && place.field_77994_a == 0) {
                        place = null;
                    }
                    if (take != null && take.field_77994_a == 0) {
                        take = null;
                    }
                    inventory.func_70299_a(slot, place);
                    player.field_71071_by.func_70437_b(take);
                    if (inventory == inv) {
                        inv.saveInventory();
                    }
                    Common.channel.sendToPlayer(player, new PacketHandler.TellTheClientTheHeldItemStackHasChanged(take));
                    Common.channel.sendToPlayer(player, new DropItemInBackpack("", false, 0, false));
                    return;
                } else if (!shift) {
                    int p;
                    ItemStack item = player.field_71071_by.func_70445_o();
                    if (item == null) {
                        return;
                    }
                    do {
                        p = item.field_77994_a;
                        item.field_77994_a = InventoryScanner.storePartialItemStack(inv, item, true, true);
                    } while (item.field_77994_a > 0 && item.field_77994_a < p);
                    if (item.field_77994_a <= 0) {
                        item = null;
                    } else {
                        new Translatable("message.backpackfull", new Object[0]).send(player);
                    }
                    player.field_71071_by.func_70437_b(item);
                    Common.channel.sendToPlayer(player, new PacketHandler.TellTheClientTheHeldItemStackHasChanged(item));
                    inv.saveInventory();
                    thing.put(player, 0);
                    return;
                } else {
                    ItemStack item = player.field_71071_by.func_70445_o();
                    if (item != null) {
                        if (inv.func_70301_a(i) == null) {
                            inv.func_70299_a(i, item);
                            item = null;
                        } else {
                            for (int j = 0; j < inv.func_70302_i_(); ++j) {
                                ItemStack stack = inv.func_70301_a(j);
                                if (stack != null) continue;
                                inv.func_70299_a(j, item);
                                item = null;
                                break;
                            }
                        }
                        player.field_71071_by.func_70437_b(item);
                        inv.saveInventory();
                        if (item != null) {
                            new Translatable("message.backpackfull", new Object[0]).send(player);
                            return;
                        }
                    }
                    boolean firstrun = true;
                    for (int j = i + 1; firstrun || j != i + 1; ++j) {
                        if (j >= inv.func_70302_i_()) {
                            j = 0;
                        }
                        firstrun = false;
                        ItemStack stack = inv.func_70301_a(j);
                        if (stack == null) continue;
                        player.field_71071_by.func_70437_b(stack);
                        inv.func_70299_a(j, null);
                        Common.channel.sendToPlayer(player, new PacketHandler.TellTheClientTheHeldItemStackHasChanged(stack));
                        thing.put(player, j);
                        inv.saveInventory();
                        return;
                    }
                    new Translatable("message.backpackempty", new Object[0]).send(player);
                }
                return;
            }
            reader.readString();
            reader.readBoolean();
            reader.readInt();
            reader.readBoolean();
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null || !(mc.field_71462_r instanceof StandaloneBackpackGui)) return;
            ((StandaloneBackpackGui)mc.field_71462_r).updateBackpack();
        }
    }
}

