/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.blocks;

import brad16840.backpacks.PacketHandler;
import brad16840.backpacks.blocks.BackpackBlockTileEntity;
import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.Common;
import brad16840.common.EntityBlock164;
import brad16840.common.PacketHandler;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BackpackBlock
extends BlockContainer {
    public String field_149770_b;
    public static Translatable name;
    public static boolean _canDuplicate;
    public static boolean canDuplicate;

    public BackpackBlock(String unlocalizedName) {
        super(Material.field_151575_d);
        this.field_149770_b = unlocalizedName;
        this.func_149663_c(unlocalizedName);
        this.func_149711_c(0.01f);
        name = new Translatable("tile." + unlocalizedName + ".name", new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("backpacks16840:" + this.field_149770_b);
    }

    public void func_149719_a(IBlockAccess blockAccess, int p_149719_2_, int p_149719_3_, int p_149719_4_) {
        float w = 0.46875f;
        float h = 0.703125f;
        float d = 0.2734375f;
        float x = 0.5f - w / 2.0f;
        float y = 0.5f - h / 2.0f;
        int l = blockAccess.func_72805_g(p_149719_2_, p_149719_3_, p_149719_4_);
        if (l == 3) {
            this.func_149676_a(x, y, 0.0f, x + w, y + h, d);
        } else if (l == 4) {
            this.func_149676_a(1.0f - d, y, x, 1.0f, y + h, x + w);
        } else if (l == 5) {
            this.func_149676_a(0.0f, y, x, d, y + h, x + w);
        } else {
            this.func_149676_a(x, y, 1.0f - d, x + w, y + h, 1.0f);
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, mask, list, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return this.field_149761_L;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149742_c(World par1World, int par2, int par3, int par4) {
        return super.func_149742_c(par1World, par2, par3, par4);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        BackpackBlockTileEntity tileEntity = (BackpackBlockTileEntity)world.func_147438_o(x, y, z);
        if (tileEntity == null) {
            return ret;
        }
        ItemStack backpack = tileEntity.getBackpack();
        if (backpack != null) {
            ret.add(backpack);
        }
        return ret;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (world.field_72995_K) {
            return false;
        }
        BackpackBlockTileEntity tileEntity = (BackpackBlockTileEntity)world.func_147438_o(x, y, z);
        if (tileEntity == null) {
            return world.func_147468_f(x, y, z);
        }
        ItemStack backpack = tileEntity.getBackpack();
        if (backpack != null) {
            if (!tileEntity.hasBackpackDropped && backpack != null) {
                this.dropItem(world, backpack, x, y, z);
            } else if (backpack != null) {
                this.dropItem(world, new ItemStack(Items.field_151061_bv), x, y, z);
            }
            tileEntity.hasBackpackDropped = false;
            tileEntity.backpack = null;
            tileEntity.updateBackpackType();
        }
        return world.func_147468_f(x, y, z);
    }

    public void dropItem(World world, ItemStack itemstack, int x, int y, int z) {
        float f = world.field_73012_v.nextFloat() * 0.4f + 0.1f;
        float f1 = world.field_73012_v.nextFloat() * 0.4f + 0.1f;
        float f2 = world.field_73012_v.nextFloat() * 0.4f + 0.1f;
        while (itemstack.field_77994_a > 0) {
            int k1 = world.field_73012_v.nextInt(21) + 10;
            if (k1 > itemstack.field_77994_a) {
                k1 = itemstack.field_77994_a;
            }
            itemstack.field_77994_a -= k1;
            EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), k1, itemstack.func_77960_j()));
            float f3 = 0.05f;
            entityitem.field_145804_b = 10;
            entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
            entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
            if (itemstack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entityitem);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        BackpackBlockTileEntity tileEntity = (BackpackBlockTileEntity)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            ItemStack itemstack = tileEntity.getBackpack();
            if (itemstack != null && !tileEntity.hasBackpackDropped) {
                this.dropItem(world, itemstack, x, y, z);
            } else if (itemstack != null) {
                this.dropItem(world, new ItemStack(Items.field_151061_bv), x, y, z);
            }
            world.func_147453_f(x, y, z, par5);
        }
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        String id;
        String uuid;
        if (world.field_72995_K) {
            return true;
        }
        BackpackBlockTileEntity tileEntity = (BackpackBlockTileEntity)world.func_147438_o(x, y, z);
        if (tileEntity == null) {
            new Translatable("problem.corrupttileentity", name).send(player);
            return true;
        }
        ItemStack backpack = tileEntity.getBackpack();
        if (!UniqueItem.hasIdentifier(backpack) && backpack != null && backpack.func_77973_b() instanceof UniqueItem) {
            if (!UniqueItem.hasIdentifier(backpack) || UniqueItemData.get(player.field_70170_p).isPermissionDeleted(player, UniqueItem.getIdentifier(backpack))) {
                UniqueItem.setIdentifier(player, backpack, UUID.randomUUID().toString());
                Common.channel.sendToPlayer(player, new PacketHandler.SetBackpackBlockId(x, y, z, UniqueItem.getIdentifier(backpack)));
            } else {
                uuid = UniqueItem.getIdentifier(backpack);
                if (((UniqueItem)backpack.func_77973_b()).hasUniqueData() && !UniqueItemData.get((World)player.field_70170_p).items.containsKey(uuid)) {
                    UniqueItem.setIdentifier(player, backpack, uuid);
                    Common.channel.sendToPlayer(player, new PacketHandler.SetBackpackBlockId(x, y, z, UniqueItem.getIdentifier(backpack)));
                }
            }
        }
        uuid = UniqueItem.getIdentifier(backpack);
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b() != null) {
            if ((stack = stack.func_77946_l()).func_77973_b() == Items.field_151061_bv) {
                if (tileEntity.hasBackpackDropped) {
                    new Translatable("problem.alreadydropped", new Object[0]).send(player);
                } else if (backpack == null) {
                    new Translatable("problem.backpackisempty", new Object[0]).send(player);
                } else {
                    tileEntity.hasBackpackDropped = !canDuplicate;
                    this.dropItem(world, backpack.func_77946_l(), x, y, z);
                    --stack.field_77994_a;
                    if (stack.field_77994_a < 1) {
                        stack = null;
                    }
                    player.func_70062_b(0, stack);
                }
                return true;
            }
            if ((stack.func_77973_b() == Common.backpack || stack.func_77973_b() == Common.quantumBackpack) && backpack == null) {
                backpack = stack.func_77946_l();
                backpack.field_77994_a = 1;
                tileEntity.backpack = backpack;
                tileEntity.hasBackpackDropped = false;
                --stack.field_77994_a;
                if (stack.field_77994_a < 1) {
                    stack = null;
                }
                player.func_70062_b(0, stack);
                tileEntity.updateBackpackType();
                return true;
            }
        }
        if (backpack == null || !(backpack.func_77973_b() instanceof UniqueItem.OpenableItem)) {
            new Translatable("problem.backpackisempty", new Object[0]).send(player);
            return true;
        }
        if (backpack.func_77973_b() instanceof QuantumBackpack) {
            uuid = QuantumBackpack.getInfo(backpack);
        }
        ArrayList<Object> ids = new ArrayList<Object>();
        int count = 0;
        ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        data.subscribePlayer(player, uuid, tags, true);
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack s = player.field_71071_by.func_70301_a(i);
            if (s == null || !(s.func_77973_b() instanceof UniqueItem)) continue;
            if (!UniqueItem.hasIdentifier(s) && (id = Common.requestInventoryIdentifier(player, (IInventory)player.field_71071_by, i)) != null) {
                ++count;
                ids.add(i);
                ids.add(id);
            }
            if (((UniqueItem)s.func_77973_b()).hasUniqueData()) {
                data.subscribePlayer(player, Common.requestInventoryIdentifier(player, (IInventory)player.field_71071_by, i), tags, true);
                continue;
            }
            if (!(s.func_77973_b() instanceof QuantumBackpack)) continue;
            data.subscribePlayer(player, QuantumBackpack.getInfo(s), tags, true);
        }
        if (!tags.isEmpty() || !ids.isEmpty()) {
            Common.channel.sendToPlayer(player, new PacketHandler.InventoryIdResponse("none", ids, tags, -1, -1));
        }
        NBTTagCompound tag = null;
        if (uuid.startsWith("@")) {
            QuantumChestTileEntity.VirtualQuantumChest t = QuantumChestTileEntity.VirtualQuantumChest.getChest(world, uuid);
            if (t != null && (id = t.getBackpackId(world, player.func_70005_c_())) != null) {
                tag = data.getItemData(id, false);
            }
        } else {
            tag = data.getItemData(uuid, false);
        }
        if (tag != null) {
            boolean changed = false;
            if (tag.func_74764_b("custom-name") && !tag.func_74779_i("custom-name").equals(backpack.func_82833_r())) {
                backpack.func_151001_c(tag.func_74779_i("custom-name"));
                changed = true;
            } else if (!tag.func_74764_b("custom-name") && backpack.func_82837_s()) {
                backpack.func_77978_p().func_82580_o("display");
                changed = true;
            }
            int color = tag.func_74762_e("color");
            if (!tag.func_74764_b("color")) {
                color = 3;
            }
            if (backpack.func_77973_b() instanceof QuantumBackpack) {
                color = backpack.func_77960_j() == 0 ? 0 : ++color;
            }
            if (backpack.func_77960_j() != color) {
                backpack.func_77964_b(color);
                changed = true;
            }
            if (changed) {
                tileEntity.updateBackpackType();
            }
        }
        Common.proxy.guiItem = backpack;
        if (tileEntity.inactivePipeEntity != null && !tileEntity.allowFrontPipe && data.strictlyHasRequiredPermission(world, player.func_70005_c_(), uuid, 2)) {
            String currentEntity = tileEntity.getFrontPipeEntityName();
            if (tileEntity.inactivePipeEntity != null && tileEntity.inactivePipeEntity.equals(currentEntity)) {
                tileEntity.allowFrontPipe = true;
                tileEntity.func_70296_d();
            }
            tileEntity.inactivePipeEntity = null;
        }
        ((UniqueItem.OpenableItem)backpack.func_77973_b()).open(player, backpack, player.field_70170_p);
        return true;
    }

    public TileEntity func_149915_a(World par1World, int var2) {
        if (EntityBlock164.lastEntity instanceof BackpackBlockTileEntity) {
            EntityBlock164.lastEntity.func_145829_t();
            return EntityBlock164.lastEntity;
        }
        BackpackBlockTileEntity tileEntity = new BackpackBlockTileEntity();
        return tileEntity;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150431_aC && (world.func_72805_g(x, y, z) & 7) < 1) {
            side = 1;
        }
        if (side < 2) {
            return false;
        }
        if (block != Blocks.field_150395_bd && block != Blocks.field_150329_H && block != Blocks.field_150330_I && !block.isReplaceable((IBlockAccess)world, x, y, z)) {
            if (side == 2) {
                --z;
            } else if (side == 3) {
                ++z;
            } else if (side == 4) {
                --x;
            } else if (side == 5) {
                ++x;
            }
        }
        if (stack.field_77994_a == 0) {
            return false;
        }
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        if (y >= 255) {
            return false;
        }
        if (world.func_147472_a((Block)this, x, y, z, false, side, (Entity)player, stack)) {
            TileEntity entity;
            int metadata = this.func_149660_a(world, x, y, z, side, hitX, hitY, hitZ, side);
            if (!world.func_147465_d(x, y, z, (Block)this, metadata, 3)) {
                return true;
            }
            if (world.func_147439_a(x, y, z) == this) {
                this.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
                this.func_149714_e(world, x, y, z, metadata);
            }
            if ((entity = world.func_147438_o(x, y, z)) != null || !(entity instanceof BackpackBlockTileEntity)) {
                BackpackBlockTileEntity tileEntity = (BackpackBlockTileEntity)entity;
                tileEntity.backpack = stack.func_77946_l();
                tileEntity.backpack.field_77994_a = 1;
                tileEntity.hasBackpackDropped = false;
                tileEntity.updateBackpackType();
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.field_149762_H.func_150496_b(), (this.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_149762_H.func_150494_d() * 0.8f);
                --stack.field_77994_a;
            } else {
                world.func_147468_f(x, y, z);
            }
            return true;
        }
        return false;
    }

    static {
        _canDuplicate = true;
    }
}

