/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.gui;

import brad16840.backpacks.InventoryScanner;
import brad16840.backpacks.PacketHandler;
import brad16840.backpacks.gui.RenameContainer;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.BackpackPouchUpgrade;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import brad16840.common.gui.CraftingContainer;
import brad16840.common.gui.ImageButton;
import brad16840.common.permissions.PacketHandler;
import brad16840.common.permissions.gui.ClientState;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemSign;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class BackpackContainer
extends StackableContainer
implements ContainerStack.LoadableContainer {
    private static HashMap<String, WeakReference<BackpackContainer>> openContainersServer = new HashMap();
    private static HashMap<String, WeakReference<BackpackContainer>> openContainersClient = new HashMap();
    public static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/backpack.png");
    private UniqueItemInventory inventory;
    private String id;
    private String name = "???";
    private int width;
    private int height;

    public static BackpackContainer openContainer(EntityPlayer player, String guid, boolean fromChest) {
        IInventory parentInventory;
        ItemStack stack;
        HashMap<String, WeakReference<BackpackContainer>> openContainers;
        HashMap<String, WeakReference<BackpackContainer>> hashMap = openContainers = player.field_70170_p.field_72995_K ? openContainersClient : openContainersServer;
        if (openContainers.containsKey(guid)) {
            if (openContainers.get(guid).get() == null) {
                openContainers.remove(guid);
            } else {
                return (BackpackContainer)openContainers.get(guid).get();
            }
        }
        if (!(fromChest || (stack = UniqueItem.getItem(parentInventory = UniqueItem.getInventoryContaining(player, guid, null), guid)) != null && stack.func_77973_b() instanceof Backpack)) {
            return null;
        }
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        NBTTagCompound tag = data.getItemData(player, guid);
        if (tag == null) {
            UniqueItemData.permissionError("open", Backpack.name).log(player);
            return null;
        }
        UniqueItemInventory inventory = UniqueItemInventory.createInventory(Common.backpack, player, guid);
        if (inventory == null) {
            return null;
        }
        BackpackContainer container = new BackpackContainer(player, Backpack.getBackpackSize(player.field_70170_p, tag, guid, true), Backpack.getBackpackSize(player.field_70170_p, tag, guid, false), inventory);
        openContainers.put(guid, new WeakReference<BackpackContainer>(container));
        return container;
    }

    public int getOffset() {
        if (this.container.layout.isTop(this.stackId)) {
            return 22;
        }
        return 0;
    }

    public BackpackContainer(EntityPlayer player, int width, int height, UniqueItemInventory inventory) {
        super(14 + width * 18, 24 + height * 18 + 22);
        this.inventory = inventory;
        this.id = inventory.getIdentifier();
        this.idChain = new ArrayList();
        UniqueItem.refreshIdChain(player, this.id, null, this.idChain);
        this.width = width;
        this.height = height;
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        int cachedStackId = this.stackId;
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        NBTTagCompound tag = data.getItemData(player, this.id);
        if (tag == null) {
            UniqueItemData.permissionError("use", Backpack.name).log(player);
            return false;
        }
        if (!this.container.fromChest && !UniqueItem.refreshIdChain(player, this.id, null, this.idChain)) {
            new Translatable("problem.backpack404", new Object[0]).log(player);
            return false;
        }
        if (this.inventory == null) {
            this.inventory = UniqueItemInventory.createInventory(Common.backpack, player, this.id);
        }
        if (this.inventory == null) {
            new Translatable("problem.backpack404", new Object[0]).log(player);
            return false;
        }
        this.inventory.refreshInventory();
        if (!this.container.fromChest) {
            ItemStack backpack = UniqueItem.findItem(player, this.getId());
            if (backpack == null || !(backpack.func_77973_b() instanceof Backpack)) {
                new Translatable("problem.backpack404", new Object[0]).log(player);
                return false;
            }
            this.name = backpack.func_82833_r();
        } else if (tag.func_74764_b("custom-name")) {
            this.name = tag.func_74779_i("custom-name");
        } else {
            int color = tag.func_74762_e("color");
            if (!tag.func_74764_b("color")) {
                color = 3;
            }
            this.name = new ItemStack((Item)Common.backpack, 1, color).func_82833_r();
        }
        this.width = Backpack.getBackpackSize(player.field_70170_p, tag, this.id, true);
        this.height = Backpack.getBackpackSize(player.field_70170_p, tag, this.id, false);
        if (this.guiWidth != 14 + this.width * 18 || this.guiHeight != 24 + this.height * 18 + 22) {
            this.guiWidth = 14 + this.width * 18;
            this.guiHeight = 24 + this.height * 18 + 22;
            this.container.reupdateContainers = true;
            return true;
        }
        this.stackId = cachedStackId;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.addSlotToContainer(ContainerStack.ContainerSection.CHEST, new BackpackContainerSlot(player, (IInventory)this.inventory, x + y * this.width, 8 + x * 18, 18 + y * 18 + this.getOffset()));
            }
        }
        return true;
    }

    @Override
    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        for (StackableContainer container1 : containers) {
            ItemStack backpack;
            BackpackContainer that = (BackpackContainer)container1;
            int cachedStackId = that.stackId;
            if (!this.container.fromChest && !UniqueItem.refreshIdChain(player, that.id, null, that.idChain)) {
                return false;
            }
            if (that.inventory == null) {
                return false;
            }
            that.inventory.refreshInventory();
            if (!(this.container.fromChest || (backpack = UniqueItem.findItem(player, that.getId())) != null && backpack.func_77973_b() instanceof Backpack)) {
                return false;
            }
            that.stackId = cachedStackId;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        final int cachedStackId = this.stackId;
        this.gui.addButton(new StackableContainer.ContainerButton(0, 0, this.container.layout.isTop(this.stackId) ? 0 : this.guiHeight - 20, this.guiWidth, 20, this.gui.getBackButtonText(this), new ContainerStack.Callback(){

            @Override
            public void call() {
                BackpackContainer.this.gui.closeContainer(cachedStackId);
            }
        }, 68));
        if (this.width > 5 && UniqueItemData.get(Minecraft.func_71410_x().field_71439_g.field_70170_p).hasRequiredPermission((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.id, 2)) {
            this.gui.addButton(new ImageButton((StackableContainer)this, 1, this.guiWidth - 24, this.container.layout.isTop(this.stackId) ? 7 : this.guiHeight - 20, 23, 13, texture, 0, 78).setCallback(new ContainerStack.Callback(){

                @Override
                public void call() {
                    Common.channel.sendToServer(new PacketHandler.SortBackpack(BackpackContainer.this.getId()));
                }
            }));
        }
    }

    @Override
    public void onClosed(EntityPlayer player) {
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, StackableContainer.ContainerSlot slot) {
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        if (!data.hasRequiredPermission(player, this.id, 2)) {
            return null;
        }
        ItemStack itemstack = null;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            if (Common.disableNesting && (itemstack1.func_77973_b() instanceof Backpack || itemstack1.func_77973_b() instanceof QuantumBackpack)) {
                return null;
            }
            if (!InventoryScanner.backpackCanAccept(data.getItemData(this.getId(), false), itemstack1)) {
                return null;
            }
            itemstack = itemstack1.func_77946_l();
            slot.func_75215_d(null);
            if (!this.container.mergeItemStack(this, itemstack1, 0, this.inventory.func_70302_i_(), false)) {
                slot.func_75215_d(itemstack1);
                return null;
            }
            slot.func_75220_a(itemstack1, itemstack);
            if (itemstack1.field_77994_a != 0) {
                slot.func_75215_d(itemstack1);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a || slot.func_75211_c() != null && slot.func_75211_c().field_77994_a == itemstack.field_77994_a && this.container.getContainer(slot.stackId) == this) {
                return null;
            }
            slot.func_82870_a(player, itemstack);
        }
        return itemstack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int mouseX, int mouseY) {
        this.gui.text(this, this.name).truncateString(this.guiWidth - 16).drawString(8, 6 + this.getOffset(), -12566464);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        int xCovered = 0;
        for (int x = 0; x < this.width; ++x) {
            int offsetX = x == 0 ? 0 : (x == this.width - 1 ? 43 : 25);
            int w = x == 0 || x == this.width - 1 ? 25 : 18;
            int yCovered = 0;
            for (int y = 0; y < this.height; ++y) {
                int offsetY;
                int n = y == 0 ? 0 : (offsetY = y == this.height - 1 ? 53 : 35);
                int h = y == 0 ? 35 : (y == this.height - 1 ? 25 : 18);
                this.gui.drawTexture(this, xCovered, yCovered + this.getOffset(), w, h, offsetX, offsetY);
                yCovered += h;
            }
            xCovered += w;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        if (keyCode == Common.permissionKey.func_151463_i()) {
            if ((Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) && this.stackId == 0) {
                return false;
            }
            String id = this.getId();
            Common.channel.sendToServer(new PacketHandler.OpenGroup(0, new ClientState.PermissionGroupState(id, "I_" + id, 0, true), true));
            return true;
        }
        if (Common.loaderKeyBinding != null && keyCode == Common.loaderKeyBinding.func_151463_i()) {
            Common.channel.sendToServer(new PacketHandler.OpenEditorWindow("loader", Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? 1 : 0, false));
            return true;
        }
        if (Common.pauseLoaderKeyBinding != null && keyCode == Common.pauseLoaderKeyBinding.func_151463_i()) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            UniqueItemData data = UniqueItemData.get(player.field_70170_p);
            if (!data.hasRequiredPermission((EntityPlayer)player, this.id, 2)) {
                UniqueItemData.permissionError("modify", this.name).log((EntityPlayer)player);
                return true;
            }
            NBTTagCompound tag = data.getItemData((EntityPlayer)player, this.id);
            if (tag == null || !tag.func_150297_b("collect", 10)) {
                return true;
            }
            boolean wasPaused = (tag = tag.func_74775_l("collect")).func_74767_n("collect-paused");
            tag.func_74757_a("collect-paused", !wasPaused);
            data.markItemDirty(this.id);
            new Translatable("message.backpackcollection" + (wasPaused ? "un" : "") + "paused", new Object[0]).log((EntityPlayer)player);
            Common.channel.sendToServer(new PacketHandler.PauseBackpackAutoCollect(this.id, !wasPaused));
            return true;
        }
        return false;
    }

    @Override
    public boolean customRightClick(EntityPlayer player, int slot, boolean holdingShift) {
        ItemStack stack = this.container.func_75139_a(slot).func_75211_c();
        int openStackId = this.stackId;
        if (holdingShift && ++openStackId >= this.container.stacks.length) {
            openStackId = 0;
        }
        if (stack != null) {
            if (stack.func_77973_b() instanceof Backpack) {
                this.container.saveInventories(player);
                StackableContainer c = ((Backpack)stack.func_77973_b()).openContainer(player, this.inventory, this.container.func_75139_a(slot).getSlotIndex(), stack, openStackId);
                if (c != null) {
                    this.container.addContainer(player, ((Backpack)stack.func_77973_b()).getPreferreredStack(this.container, openStackId), c);
                } else if (this.isClient()) {
                    this.gui.overrideFailed = true;
                }
                return true;
            }
            if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150462_ai) && !Common.disableCraftingGui) {
                this.container.saveInventories(player);
                this.container.addContainer(player, openStackId, new CraftingContainer(player));
                return true;
            }
            if (stack.func_77973_b() instanceof BackpackPouchUpgrade) {
                for (int upgrade = Backpack.widths.length - 1; upgrade >= 0; --upgrade) {
                    if (Backpack.widths[upgrade] != this.width || Backpack.heights[upgrade] != this.height) continue;
                    if (++upgrade >= Backpack.widths.length) {
                        new Translatable("problem.backpackfullyupgraded", new Object[0]).log(player);
                        return true;
                    }
                    UniqueItemData data = UniqueItemData.get(player.field_70170_p);
                    if (!data.hasRequiredPermission(player, this.id, 2)) {
                        UniqueItemData.permissionError("resize", Backpack.name).log(player);
                        return true;
                    }
                    --stack.field_77994_a;
                    if (stack.field_77994_a == 0) {
                        this.container.func_75139_a(slot).func_75215_d(null);
                    } else {
                        this.container.func_75139_a(slot).func_75218_e();
                    }
                    this.container.saveInventories(player);
                    if (!Backpack.setBackpackSize(player, this.id, Backpack.widths[upgrade], Backpack.heights[upgrade])) {
                        UniqueItemData.permissionError("modify", Backpack.name).log(player);
                    }
                    this.inventory.refreshInventory();
                    this.container.updateContainers(player);
                    return true;
                }
                new Translatable("problem.irregularbackpacksize", new Object[0]).log(player);
                return true;
            }
            if (stack.func_77973_b() instanceof Backpack.BackpackResizer) {
                UniqueItemData data = UniqueItemData.get(player.field_70170_p);
                if (!data.hasRequiredPermission(player, this.id, 2)) {
                    UniqueItemData.permissionError("resize", Backpack.name).log(player);
                    return true;
                }
                int i = this.container.func_75139_a(slot).getSlotIndex();
                int y = i / this.width;
                int x = i - y * this.width;
                this.container.saveInventories(player);
                if (!Backpack.setBackpackSize(player, this.id, x + 2, y + 2)) {
                    UniqueItemData.permissionError("modify", Backpack.name).log(player);
                }
                this.inventory.refreshInventory();
                this.container.updateContainers(player);
                return true;
            }
            if (stack.func_77973_b() instanceof ItemDye) {
                int color;
                UniqueItemData data = UniqueItemData.get(player.field_70170_p);
                if (!data.hasRequiredPermission(player, this.id, 2)) {
                    UniqueItemData.permissionError("dye", Backpack.name).log(player);
                    return true;
                }
                --stack.field_77994_a;
                if (stack.field_77994_a == 0) {
                    this.container.func_75139_a(slot).func_75215_d(null);
                } else {
                    this.container.func_75139_a(slot).func_75218_e();
                }
                this.container.saveInventories(player);
                final int c = color = stack.func_77960_j();
                UniqueItem.modifyItems(player, this.getId(), null, new UniqueItem.ItemStackCallback(){

                    @Override
                    public void callback(ItemStack stack) {
                        if (stack != null) {
                            if (stack.func_77960_j() > 16) {
                                stack.func_77964_b(c + 16);
                            } else {
                                stack.func_77964_b(c);
                            }
                        }
                    }
                });
                Backpack.setBackpackColor(player, this.getId(), c);
                this.container.updateContainers(player);
                return true;
            }
            if (stack.func_77973_b() instanceof ItemSign) {
                if (!UniqueItemData.get(player.field_70170_p).hasRequiredPermission(player, this.id, 2)) {
                    UniqueItemData.permissionError("rename", Backpack.name).log(player);
                    return true;
                }
                --stack.field_77994_a;
                if (stack.field_77994_a == 0) {
                    this.container.func_75139_a(slot).func_75215_d(null);
                } else {
                    this.container.func_75139_a(slot).func_75218_e();
                }
                this.container.saveInventories(player);
                this.container.addContainer(player, null, new RenameContainer(this.getId()));
                return true;
            }
            if (stack.func_77973_b() instanceof UniqueItem.OpenableItem) {
                this.container.saveInventories(player);
                UniqueItem.OpenableItem item = (UniqueItem.OpenableItem)stack.func_77973_b();
                StackableContainer c = item.openContainer(player, this.inventory, this.container.func_75139_a(slot).getSlotIndex(), stack, openStackId);
                if (c != null) {
                    this.container.addContainer(player, item.getPreferreredStack(this.container, openStackId), c);
                } else if (this.isClient()) {
                    this.gui.overrideFailed = true;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int getSlotCount() {
        return this.width * this.height;
    }

    @Override
    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        for (StackableContainer container1 : containers) {
            ((BackpackContainer)container1).inventory.saveInventory();
        }
    }

    @Override
    public int getRowSize() {
        return this.width;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public class BackpackContainerSlot
    extends StackableContainer.ContainerSlot {
        public BackpackContainerSlot(EntityPlayer player, IInventory inventory, int par2, int par3, int par4) {
            super(player, inventory, par2, par3, par4);
        }

        @Override
        public boolean func_75214_a(ItemStack stack) {
            if (Common.disableNesting && (stack.func_77973_b() instanceof Backpack || stack.func_77973_b() instanceof QuantumBackpack)) {
                return false;
            }
            if (!InventoryScanner.backpackCanAccept(UniqueItemData.get(((UniqueItemInventory)this.field_75224_c).world).getItemData(BackpackContainer.this.getId(), false), stack)) {
                return false;
            }
            return super.func_75214_a(stack);
        }
    }
}

