/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.backpacks.blocks.BackpackBlockRenderer;
import brad16840.backpacks.blocks.BackpackBlockTileEntity;
import brad16840.backpacks.blocks.QuantumChest;
import brad16840.backpacks.blocks.QuantumChestRenderer;
import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.gui.BackpackContainer;
import brad16840.backpacks.gui.ModelQuantumChest;
import brad16840.backpacks.gui.QuantumChestContainer;
import brad16840.backpacks.gui.QuantumContainer;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.BackpackRenderer;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.BlockPos;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.ContainerStackGui;
import brad16840.common.CustomItemRenderer;
import brad16840.common.KeyBindingRegistry;
import brad16840.common.PacketHandler;
import brad16840.common.Proxy;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.gui.ArmorContainer;
import brad16840.common.gui.ChestContainer;
import brad16840.common.gui.CraftingContainer;
import brad16840.common.gui.EmptyContainer;
import brad16840.common.gui.PlayerContainer;
import brad16840.common.gui.RestorerContainer;
import brad16840.common.permissions.PacketHandler;
import brad16840.common.permissions.gui.PlayerView;
import brad16840.core.ClassTransformer;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class ClientProxy
extends Proxy {
    public ItemStack guiItemClient;

    @Override
    public void init(Common c) {
        Common.permissionKey = new KeyBinding("key.backpacks.permission", 25, "Backpacks!");
        ClientRegistry.registerKeyBinding((KeyBinding)Common.permissionKey);
        if (ClassTransformer.renderItemWasPatched) {
            MinecraftForgeClient.registerItemRenderer((Item)Common.unknownItem, (IItemRenderer)new CustomItemRenderer());
        }
        QuantumChest.customRenderType = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new ISimpleBlockRenderingHandler(){
            private ModelQuantumChest chest = new ModelQuantumChest();
            private float rotation = 0.0f;

            public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
                this.chest.render(0, 0.0625f, false);
                this.rotation = (int)(Minecraft.func_71386_F() % 7200L / 20L);
                float s = 0.9f - Math.abs(0.1f * (this.rotation % 180.0f - 90.0f) / 90.0f) * 0.0f - 0.05f;
                GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
                GL11.glScalef((float)s, (float)s, (float)s);
                GL11.glRotatef((float)(-this.rotation), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(45.0f + this.rotation), (float)1.0f, (float)0.0f, (float)1.0f);
                this.chest.render(1, 0.0625f, false);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(-90.0f - this.rotation * 2.0f), (float)1.0f, (float)0.0f, (float)1.0f);
                this.chest.render(1, 0.0625f, true);
                GL11.glPopMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }

            public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
                return false;
            }

            public boolean shouldRender3DInInventory(int modelId) {
                return true;
            }

            public int getRenderId() {
                return QuantumChest.customRenderType;
            }
        });
        if (Common.renderBackpacksIn3D) {
            MinecraftForgeClient.registerItemRenderer((Item)Common.backpack, (IItemRenderer)new BackpackRenderer(false));
            MinecraftForgeClient.registerItemRenderer((Item)Common.quantumBackpack, (IItemRenderer)new BackpackRenderer(true));
        }
        Common.loaderKeyBinding = new KeyBinding("key.backpackloader.edit", 38, "Backpacks!");
        Common.pauseLoaderKeyBinding = new KeyBinding("key.backpackloader.pause", 197, "Backpacks!");
        Common.openFirstKeyBinding = new KeyBindingRegistry.KeyHandler(new KeyBinding("key.backpacks.openfirst", 38, "Backpacks!")){

            @Override
            public void keyPressed() {
                if (this.alreadyTriggered) {
                    return;
                }
                Minecraft mc = Minecraft.func_71410_x();
                if (mc == null || mc.field_71439_g == null) {
                    return;
                }
                EntityClientPlayerMP player = mc.field_71439_g;
                if (mc.field_71462_r == null) {
                    Common.channel.sendToServer(new PacketHandler.OpenItemOnServer("auto_" + (Common.reverseBackpackSearch ? "backward" : "forward")));
                    return;
                }
            }
        };
        KeyBindingRegistry.registerKeyHandler(new KeyBindingRegistry.KeyHandler(Minecraft.func_71410_x().field_71474_y.field_74322_I){

            @Override
            public void keyPressed() {
                try {
                    Minecraft mc = Minecraft.func_71410_x();
                    MovingObjectPosition target = mc.field_71476_x;
                    ItemStack result = null;
                    EntityClientPlayerMP player = mc.field_71439_g;
                    WorldClient world = mc.field_71441_e;
                    if (target == null || player.field_71075_bZ.field_75098_d) {
                        return;
                    }
                    if (target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                        int x = target.field_72311_b;
                        int y = target.field_72312_c;
                        int z = target.field_72309_d;
                        Block block = world.func_147439_a(x, y, z);
                        if (block.isAir((IBlockAccess)world, x, y, z)) {
                            return;
                        }
                        result = block.getPickBlock(target, (World)world, x, y, z, (EntityPlayer)player);
                    } else {
                        if (target.field_72313_a != MovingObjectPosition.MovingObjectType.ENTITY || target.field_72308_g == null) {
                            return;
                        }
                        result = null;
                    }
                    if (result == null) {
                        return;
                    }
                    Common.channel.sendToServer(new PacketHandler.ForceResupplyBlock(result));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        KeyBindingRegistry.registerKeyHandler(Common.openFirstKeyBinding);
        ClientRegistry.registerKeyBinding((KeyBinding)Common.loaderKeyBinding);
        ClientRegistry.registerKeyBinding((KeyBinding)Common.pauseLoaderKeyBinding);
        Common.loadKeyBinding = new KeyBindingRegistry.KeyHandler(new KeyBinding("key.backpackloader.load", 38, "Backpacks!")){

            @Override
            public void keyPressed() {
                if (this.alreadyTriggered) {
                    return;
                }
                Minecraft mc = Minecraft.func_71410_x();
                if (mc == null || mc.field_71439_g == null) {
                    return;
                }
                EntityClientPlayerMP player = mc.field_71439_g;
                if (player.field_71070_bA instanceof ContainerStack) {
                    return;
                }
                if (mc.field_71462_r == null) {
                    return;
                }
                if (player.field_71070_bA instanceof ContainerChest || player.field_71070_bA instanceof ContainerPlayer) {
                    Common.channel.sendToServer(new PacketHandler.OpenEditorWindow("loadbackpack", 0, false));
                }
            }
        };
        KeyBindingRegistry.registerKeyHandler(Common.loadKeyBinding);
        ClientRegistry.bindTileEntitySpecialRenderer(QuantumChestTileEntity.class, (TileEntitySpecialRenderer)new QuantumChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(BackpackBlockTileEntity.class, (TileEntitySpecialRenderer)new BackpackBlockRenderer());
    }

    @Override
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        StackableContainer c;
        if (id == 0) {
            Block block = world.func_147439_a(x, y, z);
            if (block == Blocks.field_150462_ai) {
                return ContainerStackGui.create(player, new StackableContainer[]{new CraftingContainer(player), new PlayerContainer(player.field_71071_by)});
            }
            IInventory inventory = ChestContainer.getInventory(player, world, x, y, z);
            if (inventory != null) {
                return ContainerStackGui.create(player, new StackableContainer[]{new ChestContainer(inventory, x, y, z), new PlayerContainer(player.field_71071_by)});
            }
        } else {
            if (id == 1) {
                return ContainerStackGui.create(player, new StackableContainer[]{new ArmorContainer(player.field_71071_by), new PlayerContainer(player.field_71071_by)});
            }
            if (id == 2) {
                return ContainerStackGui.create(player, new StackableContainer[]{new CraftingContainer(player), new PlayerContainer(player.field_71071_by)});
            }
        }
        ItemStack stack = player.func_71045_bC();
        if (this.guiItemClient != null) {
            stack = this.guiItemClient;
        }
        if (id == 4) {
            if (stack != null && stack.func_77973_b() instanceof Backpack) {
                c = BackpackContainer.openContainer(player, UniqueItem.getIdentifier(stack), this.guiItemClient != null);
                if (c != null) {
                    return ContainerStackGui.create(player, new StackableContainer[]{c, new PlayerContainer(player.field_71071_by)}, this.guiItemClient != null);
                }
            } else {
                new Translatable("problem.openbackpack404", new Object[0]).log(player);
            }
        } else {
            if (id == 5) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (tileEntity == null || !(tileEntity instanceof QuantumChestTileEntity)) {
                    ContainerStack.closeScreen(player);
                    return null;
                }
                return ContainerStackGui.create(player, new StackableContainer[]{new QuantumChestContainer((QuantumChestTileEntity)tileEntity, new BlockPos(x, y, z), world.field_73011_w.field_76574_g, "@Pos: " + x + ", " + y + ", " + z + "; Dim: " + world.field_73011_w.field_76574_g), new PlayerContainer(player.field_71071_by)});
            }
            if (id == 6) {
                c = Common.backpack.viewItem(player, null, x);
                if (c != null) {
                    return ContainerStackGui.create(player, new StackableContainer[]{c, new RestorerContainer("backpack", x)});
                }
            } else {
                if (id == 7) {
                    if (PacketHandler.SetPermissionPlayerData.currentData == null) {
                        return null;
                    }
                    c = new PlayerView(PacketHandler.SetPermissionPlayerData.currentData);
                    PacketHandler.SetPermissionPlayerData.currentData = null;
                    return ContainerStackGui.create(player, new StackableContainer[]{c, new EmptyContainer()});
                }
                int dimension = id - 10067;
                String chestId = "@Pos: " + x + ", " + y + ", " + z + "; Dim: " + dimension;
                QuantumChestTileEntity.VirtualQuantumChest chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, chestId);
                if (chest == null) {
                    QuantumBackpack.error_chestNotFound.log(player);
                } else if (!chest.canPlayerUse(player)) {
                    UniqueItemData.permissionError("use", QuantumChest.name).log(player);
                } else if (chest.backpackId == null || UniqueItemData.get(player.field_70170_p).isPermissionDeleted(player, chest.backpackId)) {
                    QuantumBackpack.error_chestEmpty.log(player);
                } else {
                    QuantumContainer c2 = chest.openPreparedContainer(player, null);
                    if (c2 != null) {
                        return ContainerStackGui.create(player, new StackableContainer[]{c2, new PlayerContainer(player.field_71071_by)}, this.guiItemClient != null);
                    }
                }
                ContainerStack.closeScreen(player);
            }
        }
        return null;
    }
}

