/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.backpacks.InventoryScanner;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.BackpackCommand;
import brad16840.common.BlockPos;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.CustomPacket;
import brad16840.common.DynamicRecipes;
import brad16840.common.Logger;
import brad16840.common.MessageChannel;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import brad16840.common.UnknownItem;
import brad16840.common.gui.BlockSelector;
import brad16840.common.gui.NBTEditor;
import brad16840.common.gui.RecipeEditor;
import brad16840.common.gui.RestorerContainer;
import brad16840.common.permissions.PermissionData;
import brad16840.common.permissions.PermissionGroup;
import brad16840.common.permissions.PermissionPlayer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldSettings;

public class PacketHandler {
    public static boolean isOp(EntityPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
            return false;
        }
        boolean b = MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(player.func_146103_bH());
        if (!b && Common.allowOpFunctionsInSinglePlayer) {
            return MinecraftServer.func_71276_C().func_71203_ab().func_72365_p().func_71264_H() && MinecraftServer.func_71276_C().func_71203_ab().func_72365_p().func_71214_G().equalsIgnoreCase(player.func_70005_c_());
        }
        return b;
    }

    public static void registerMessages(MessageChannel channel) {
        channel.registerMessage(SubscribeToItem.class);
        channel.registerMessage(InventoryIdRequest.class);
        channel.registerMessage(InventoryIdResponse.class);
        channel.registerMessage(DataUpdate.class);
        channel.registerMessage(CreateRestorerView.class);
        channel.registerMessage(CustomRightClick.class);
        channel.registerMessage(ServerRightClick.class);
        channel.registerMessage(CloseContainer.class);
        channel.registerMessage(LogMessage.class);
        channel.registerMessage(RestorerButtonClicked.class);
        channel.registerMessage(OpenChest.class);
        channel.registerMessage(OpenItemOnServer.class);
        channel.registerMessage(OpenRestorerOnServer.class);
        channel.registerMessage(InitializePlayer.class);
        channel.registerMessage(OverrideRecipe.class);
        channel.registerMessage(OpenEditorWindow.class);
        channel.registerMessage(EditNBT.class);
        channel.registerMessage(TellTheClientTheHeldItemStackHasChanged.class);
        channel.registerMessage(OverrideCustomItem.class);
        channel.registerMessage(ForceResupplyBlock.class);
    }

    public static class InitializePlayer
    extends MessageChannel.Message {
        @Override
        public void send(CustomPacket packet) {
            packet.write(Common._disableItemRestorers);
            packet.write(Common._disableChestOpening);
            packet.write(Common._disableCraftingGui);
            packet.write(Common._allEditorsRequireOpPermission);
            packet.write(DynamicRecipes.recipesServerSide.size());
            for (String string : DynamicRecipes.recipesServerSide) {
                packet.write(string);
            }
            packet.write(DynamicRecipes.disabledRecipesServerSide.size());
            for (String string : DynamicRecipes.disabledRecipesServerSide) {
                packet.write(string);
            }
            packet.write(UnknownItem._customItems.size() + UnknownItem._existingCustomItems.size());
            for (String string : UnknownItem._existingCustomItems.keySet()) {
                packet.write(string).write(UnknownItem._existingCustomItems.get(string));
            }
            for (String string : UnknownItem._customItems.keySet()) {
                packet.write(string).write(UnknownItem._customItems.get(string));
            }
            packet.write(DynamicRecipes.FurnaceRecipe.serverRecipes.size());
            for (DynamicRecipes.FurnaceRecipe furnaceRecipe : DynamicRecipes.FurnaceRecipe.serverRecipes.keySet()) {
                packet.write(furnaceRecipe.output).write(furnaceRecipe.input).write(DynamicRecipes.FurnaceRecipe.serverRecipes.get(furnaceRecipe));
            }
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (!serverSide) {
                int i;
                int i2;
                Logger.clear();
                Common.disableItemRestorers = reader.readBoolean();
                Common.disableChestOpening = reader.readBoolean();
                Common.disableCraftingGui = reader.readBoolean();
                Common.allEditorsRequireOpPermission = reader.readBoolean();
                int recipes = reader.readInt();
                DynamicRecipes.recipes.clear();
                CraftingManager.func_77594_a().func_77592_b().addAll(DynamicRecipes.disabledRecipes.values());
                DynamicRecipes.disabledRecipes.clear();
                Iterator iterator = CraftingManager.func_77594_a().func_77592_b().iterator();
                while (iterator.hasNext()) {
                    IRecipe recipe = (IRecipe)iterator.next();
                    if (!(recipe instanceof DynamicRecipes.Recipe)) continue;
                    iterator.remove();
                }
                for (i2 = 0; i2 < recipes; ++i2) {
                    try {
                        DynamicRecipes.processRecipe(reader.readString(), false);
                        continue;
                    }
                    catch (DynamicRecipes.DynamicRecipeException e) {
                        throw new RuntimeException("The dynamic recipes that the server sent us were unprocessable/invalid: " + e.getMessage(), e);
                    }
                }
                CraftingManager.func_77594_a().func_77592_b().addAll(DynamicRecipes.recipes.values());
                recipes = reader.readInt();
                for (i2 = 0; i2 < recipes; ++i2) {
                    try {
                        DynamicRecipes.processRecipe("!" + reader.readString(), false);
                        continue;
                    }
                    catch (DynamicRecipes.DynamicRecipeException e) {
                        throw new RuntimeException("The dynamic recipes that the server sent us were unprocessable/invalid: " + e.getMessage(), e);
                    }
                }
                int customItems = reader.readInt();
                UnknownItem.customItems.clear();
                for (i = 0; i < customItems; ++i) {
                    String id = reader.readString();
                    UnknownItem.customItems.put(id, reader.readNBTTagCompound());
                }
                recipes = reader.readInt();
                DynamicRecipes.FurnaceRecipe.resetRecipes();
                for (i = 0; i < recipes; ++i) {
                    ItemStack output = reader.readItemStack();
                    DynamicRecipes.FurnaceRecipe r = DynamicRecipes.FurnaceRecipe.getRecipe(output, reader.readItemStack());
                    if (reader.readBoolean()) {
                        r.enable(false);
                        continue;
                    }
                    r.disable(false);
                }
                DynamicRecipes.sortRecipes();
                DynamicRecipes.cacheInvalidated = true;
            }
        }
    }

    public static class TellTheClientTheHeldItemStackHasChanged
    extends MessageChannel.Message {
        public TellTheClientTheHeldItemStackHasChanged() {
        }

        public TellTheClientTheHeldItemStackHasChanged(ItemStack stack) {
            super(stack != null, stack != null ? stack : Integer.valueOf(0));
            this.setClasses(Boolean.class, stack != null ? ItemStack.class : Integer.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (!serverSide) {
                if (!reader.readBoolean()) {
                    reader.readInt();
                    player.field_71071_by.func_70437_b(null);
                } else {
                    player.field_71071_by.func_70437_b(reader.readItemStack());
                }
            }
        }
    }

    public static class EditNBT
    extends MessageChannel.Message {
        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                if (!(player.field_71070_bA instanceof ContainerStack)) {
                    ContainerStack.closeScreen(player);
                    return;
                }
                ((ContainerStack)player.field_71070_bA).addContainer(player, null, new NBTEditor(null, ""));
                return;
            }
        }
    }

    public static class OpenEditorWindow
    extends MessageChannel.Message {
        public static ArrayList<CustomEditor> editors = new ArrayList();
        public static ArrayList<String> nonOpEditors = new ArrayList();

        public OpenEditorWindow() {
        }

        public OpenEditorWindow(String type, int stackId, boolean isOp) {
            super(type, stackId, isOp);
            this.setClasses(String.class, Integer.class, Boolean.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String type = reader.readString();
                int stackId = reader.readInt();
                reader.readBoolean();
                boolean isOp = PacketHandler.isOp(player);
                if (!type.equals("loadbackpack")) {
                    if (!(isOp || nonOpEditors.contains(type) && !Common.allEditorsRequireOpPermission)) {
                        return;
                    }
                    if (!(player instanceof EntityPlayerMP) || ((EntityPlayerMP)player).field_71134_c.func_73081_b() == WorldSettings.GameType.ADVENTURE) {
                        return;
                    }
                }
                if (player.field_71070_bA instanceof ContainerStack) {
                    ContainerStack container = (ContainerStack)player.field_71070_bA;
                    if (type.equals("selector")) {
                        container.addContainer(player, stackId, new BlockSelector());
                    } else if (type.equals("recipe")) {
                        if (Common.disableRecipeEditor) {
                            return;
                        }
                        container.addContainers(player, new StackableContainer[]{new BlockSelector(), new RecipeEditor(isOp)});
                    } else {
                        boolean found = false;
                        for (CustomEditor e : editors) {
                            if (!e.loadEditor(type, stackId, container, player)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            return;
                        }
                    }
                    Common.channel.sendToPlayer(player, new OpenEditorWindow(type, stackId, isOp));
                } else if (type.equals("loadbackpack")) {
                    boolean found = false;
                    for (CustomEditor e : editors) {
                        if (!e.loadEditor(type, stackId, null, player)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return;
                    }
                    Common.channel.sendToPlayer(player, new OpenEditorWindow(type, stackId, isOp));
                }
            } else {
                String type = reader.readString();
                int stackId = reader.readInt();
                boolean isOp = reader.readBoolean();
                if (!(player.field_71070_bA instanceof ContainerStack)) {
                    if (type.equals("loadbackpack")) {
                        boolean found = false;
                        for (CustomEditor e : editors) {
                            if (!e.loadEditor(type, stackId, null, player)) continue;
                            found = true;
                            break;
                        }
                        return;
                    }
                    ContainerStack.closeScreen(player);
                    return;
                }
                ContainerStack container = (ContainerStack)player.field_71070_bA;
                if (type.equals("selector")) {
                    container.addContainer(player, stackId, new BlockSelector());
                } else if (type.equals("recipe")) {
                    container.addContainers(player, new StackableContainer[]{new BlockSelector(), new RecipeEditor(isOp)});
                } else {
                    boolean found = false;
                    for (CustomEditor e : editors) {
                        if (!e.loadEditor(type, stackId, container, player)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return;
                    }
                }
            }
        }

        static {
            nonOpEditors.add("recipe");
        }

        public static interface CustomEditor {
            public boolean loadEditor(String var1, int var2, ContainerStack var3, EntityPlayer var4);
        }
    }

    public static class ForceResupplyBlock
    extends MessageChannel.Message {
        public ForceResupplyBlock() {
        }

        public ForceResupplyBlock(ItemStack stack) {
            super(stack);
            this.setClasses(ItemStack.class);
        }

        public ForceResupplyBlock(int slot) {
            super(slot);
            this.setClasses(Integer.class);
        }

        private boolean vanillaCanPick(EntityPlayer player, ItemStack target) {
            ItemStack stack;
            int i;
            for (i = 0; i < 9; ++i) {
                stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || !stack.func_77969_a(target) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)target)) continue;
                return true;
            }
            for (i = InventoryPlayer.func_70451_h(); i < player.field_71071_by.func_70302_i_(); ++i) {
                stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || !stack.func_77969_a(target) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)target)) continue;
                int slot = InventoryScanner.PickItemFilter.getAppropriateHotbarSlot(player);
                if (slot < 0) {
                    return true;
                }
                ItemStack existing = player.field_71071_by.func_70301_a(slot);
                player.field_71071_by.func_70299_a(slot, stack);
                player.field_71071_by.func_70299_a(i, existing);
                this.setActiveSlot(player, slot);
                return true;
            }
            return false;
        }

        private boolean InventoryScannerWouldRepick(EntityPlayer player, ItemStack target, boolean wildcardMetadata) {
            ItemStack stack;
            int i;
            for (i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
                stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != target.func_77973_b() || !wildcardMetadata && stack.func_77960_j() != target.func_77960_j()) continue;
                this.setActiveSlot(player, i);
                return true;
            }
            for (i = InventoryPlayer.func_70451_h(); i < InventoryPlayer.func_70451_h(); ++i) {
                stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != target.func_77973_b() || !wildcardMetadata && stack.func_77960_j() != target.func_77960_j()) continue;
                int slot = InventoryScanner.PickItemFilter.getAppropriateHotbarSlot(player);
                if (slot < 0) {
                    return true;
                }
                ItemStack existing = player.field_71071_by.func_70301_a(slot);
                player.field_71071_by.func_70299_a(slot, stack);
                player.field_71071_by.func_70299_a(i, existing);
                this.setActiveSlot(player, slot);
                return true;
            }
            return false;
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                ItemStack target = reader.readItemStack();
                try {
                    player.field_71069_bz.func_75142_b();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                UniqueItemData data = UniqueItemData.get(player.func_130014_f_());
                if (target == null || this.vanillaCanPick(player, target)) {
                    return;
                }
                if (this.InventoryScannerWouldRepick(player, target, false)) {
                    return;
                }
                InventoryScanner.PickItemFilter filter = new InventoryScanner.PickItemFilter(target, false);
                if (!InventoryScanner.scanPlayer(player, data, filter)) {
                    if (this.InventoryScannerWouldRepick(player, target, true)) {
                        return;
                    }
                    filter = new InventoryScanner.PickItemFilter(target, true);
                    if (target.func_77981_g() || !InventoryScanner.scanPlayer(player, data, filter)) {
                        return;
                    }
                }
                if (filter.resultSlot != -1) {
                    this.setActiveSlot(player, filter.resultSlot);
                }
            } else {
                int slot = reader.readInt();
                this.setActiveSlotLocally(player, slot);
            }
        }

        public void setActiveSlot(EntityPlayer player, int slot) {
            this.setActiveSlotLocally(player, slot);
            Common.channel.sendToPlayer(player, new ForceResupplyBlock(slot));
        }

        public void setActiveSlotLocally(EntityPlayer player, int slot) {
            if (slot < 0 || slot > 8) {
                return;
            }
            player.field_71071_by.field_70461_c = slot;
        }
    }

    public static class OverrideCustomItem
    extends MessageChannel.Message {
        public OverrideCustomItem() {
        }

        public OverrideCustomItem(String id, NBTTagCompound tag) {
            super(id, tag);
            this.setClasses(String.class, NBTTagCompound.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String id = reader.readString();
                NBTTagCompound tag = reader.readNBTTagCompound();
                if (!PacketHandler.isOp(player) || Common.disableCustomItemEditing) {
                    return;
                }
                UnknownItem._customItems.put(id, tag);
                UnknownItem.customItems.put(id, tag);
                Common.channel.sendToAll(new OverrideCustomItem(id, tag));
                Common.saveOverriddenCustomItems();
            } else {
                String id = reader.readString();
                NBTTagCompound tag = reader.readNBTTagCompound();
                UnknownItem.customItems.put(id, tag);
            }
        }
    }

    public static class OverrideRecipe
    extends MessageChannel.Message {
        public OverrideRecipe() {
        }

        public OverrideRecipe(String remove, String add) {
            super(remove, add);
            this.setClasses(String.class, String.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                if (!PacketHandler.isOp(player)) {
                    return;
                }
                String remove = reader.readString();
                String add = reader.readString();
                DynamicRecipes.settingOverriddenValues = true;
                if (remove != null) {
                    DynamicRecipes.processRecipe("!" + remove, true);
                }
                if (add != null) {
                    DynamicRecipes.processRecipe(add, true);
                }
                DynamicRecipes.settingOverriddenValues = false;
                Common.channel.sendToAll(new OverrideRecipe(remove, add));
                Common.saveOverriddenDRDValues();
                DynamicRecipes.sortRecipes();
            } else {
                String remove = reader.readString();
                String add = reader.readString();
                DynamicRecipes.settingOverriddenValues = true;
                if (remove != null) {
                    DynamicRecipes.processRecipe("!" + remove, false);
                }
                if (add != null) {
                    DynamicRecipes.processRecipe(add, false);
                }
                DynamicRecipes.settingOverriddenValues = false;
                if (player.field_71070_bA instanceof ContainerStack) {
                    ContainerStack stack = (ContainerStack)player.field_71070_bA;
                    if (stack.stacks.length > 1 && stack.getContainer(1) instanceof RecipeEditor) {
                        ((RecipeEditor)stack.getContainer(1)).recipeChanged(remove, add);
                    }
                }
                DynamicRecipes.sortRecipes();
            }
        }
    }

    public static class OpenRestorerOnServer
    extends MessageChannel.Message {
        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                ItemStack stack = player.func_71045_bC();
                if (stack == null || !(stack.func_77973_b() instanceof UniqueItem.ItemRestorer)) {
                    return;
                }
                ((UniqueItem.ItemRestorer)stack.func_77973_b()).restore(player, stack, player.field_70170_p);
            }
        }
    }

    public static class OpenItemOnServer
    extends MessageChannel.Message {
        public OpenItemOnServer() {
        }

        public OpenItemOnServer(String uuid) {
            super(uuid);
            this.setClasses(String.class);
        }

        private void forceSubscribe(EntityPlayer player, UniqueItemData data) {
            ArrayList<Object> ids = new ArrayList<Object>();
            ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                String id;
                ItemStack s = player.field_71071_by.func_70301_a(i);
                if (s == null || !(s.func_77973_b() instanceof UniqueItem)) continue;
                if (!UniqueItem.hasIdentifier(s) && (id = Common.requestInventoryIdentifier(player, (IInventory)player.field_71071_by, i)) != null) {
                    ids.add(i);
                    ids.add(id);
                }
                if (((UniqueItem)s.func_77973_b()).hasUniqueData()) {
                    data.subscribePlayer(player, Common.requestInventoryIdentifier(player, (IInventory)player.field_71071_by, i), tags, true);
                    continue;
                }
                if (!(s.func_77973_b() instanceof QuantumBackpack)) continue;
                data.subscribePlayer(player, QuantumBackpack.getInfo(s), tags, true);
            }
            if (!tags.isEmpty() || !ids.isEmpty()) {
                Common.channel.sendToPlayer(player, new InventoryIdResponse("none", ids, tags, -1, -1));
            }
        }

        private void openAutoBackpack(EntityPlayer player, boolean reverseSearch) {
            NBTTagCompound tag;
            String playerName;
            UniqueItemData data;
            String uuid;
            int searchMatch = -1;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                if (i >= player.field_71071_by.func_70302_i_()) {
                    return;
                }
                int index = reverseSearch ? player.field_71071_by.func_70302_i_() - 1 - i : i;
                ItemStack stack = player.field_71071_by.func_70301_a(index);
                if (stack == null || stack.func_77973_b() != Common.backpack && stack.func_77973_b() != Common.quantumBackpack) continue;
                searchMatch = index;
                break;
            }
            if ((uuid = BackpackCommand.getPlayerUuid(data = UniqueItemData.get(player.field_70170_p), playerName = player.func_70005_c_())) != null && data.items.containsKey(uuid) && (tag = data.getItemData(uuid, false)) != null && data.strictlyHasRequiredPermission(player.field_70170_p, playerName, uuid, 2) && (searchMatch < 0 || tag.func_74767_n("isEquipped"))) {
                BackpackCommand.openBackpack(data, player, uuid);
                return;
            }
            if (searchMatch >= 0) {
                this.forceSubscribe(player, data);
                ItemStack stack = player.field_71071_by.func_70301_a(searchMatch);
                if (stack != null && stack.func_77973_b() instanceof UniqueItem.OpenableItem) {
                    ((UniqueItem.OpenableItem)stack.func_77973_b()).open(player, stack, player.field_70170_p);
                }
            }
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String id = reader.readString();
                if (id.equals("inventory") || id.equals("none")) {
                    player.openGui((Object)"backpacks16840", 1, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    return;
                }
                if (id.equals("auto_forward")) {
                    this.openAutoBackpack(player, false);
                    return;
                }
                if (id.equals("auto_backward")) {
                    this.openAutoBackpack(player, true);
                    return;
                }
                if (id.equals("workbench") && !Common.disableCraftingGui) {
                    ItemStack s = player.field_71071_by.func_70445_o();
                    player.field_71071_by.func_70437_b(null);
                    player.openGui((Object)"backpacks16840", 2, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    if (player.field_71070_bA instanceof ContainerStack) {
                        player.field_71071_by.func_70437_b(s);
                        Common.channel.sendToPlayer(player, new TellTheClientTheHeldItemStackHasChanged(s));
                    } else if (s != null) {
                        player.func_71019_a(s, false);
                    }
                    return;
                }
                ItemStack stack = UniqueItem.findItem(player, id);
                if (stack == null || !(stack.func_77973_b() instanceof UniqueItem.OpenableItem)) {
                    return;
                }
                ((UniqueItem.OpenableItem)stack.func_77973_b()).open(player, stack, player.field_70170_p);
            }
        }
    }

    public static class OpenChest
    extends MessageChannel.Message {
        public OpenChest() {
        }

        public OpenChest(BlockPos pos) {
            super(pos);
            this.setClasses(BlockPos.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                BlockPos pos = reader.readBlockPos();
                player.openGui((Object)"backpacks16840", 0, player.field_70170_p, pos.x, pos.y, pos.z);
            }
        }
    }

    public static class RestorerButtonClicked
    extends MessageChannel.Message {
        public RestorerButtonClicked() {
        }

        public RestorerButtonClicked(int button, String selectedStack) {
            super(button, selectedStack);
            this.setClasses(Integer.class, String.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                if (player.field_71070_bA instanceof ContainerStack && ((ContainerStack)player.field_71070_bA).getContainer(1) instanceof RestorerContainer) {
                    ((RestorerContainer)((ContainerStack)player.field_71070_bA).getContainer(1)).specialButton(player, reader.readInt(), reader.readString());
                } else {
                    reader.readInt();
                    reader.readString();
                }
            }
        }
    }

    public static class LogMessage
    extends MessageChannel.Message {
        public LogMessage() {
        }

        public LogMessage(Translatable message) {
            super(message);
            this.setClasses(Translatable.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            reader.readSerializable(Translatable.class).log(player);
        }
    }

    public static class CloseContainer
    extends MessageChannel.Message {
        public CloseContainer() {
        }

        public CloseContainer(int stackId) {
            super(stackId);
            this.setClasses(Integer.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                if (player.field_71070_bA instanceof ContainerStack) {
                    ((ContainerStack)player.field_71070_bA).closeContainer(player, reader.readInt());
                } else {
                    reader.readInt();
                }
            }
        }
    }

    public static class ServerRightClick
    extends MessageChannel.Message {
        public ServerRightClick() {
        }

        public ServerRightClick(int slot, int mouseClick, boolean holdingShift, short transactionId) {
            super(slot, mouseClick, holdingShift, transactionId);
            this.setClasses(Integer.class, Integer.class, Boolean.class, Integer.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                if (player.field_71070_bA instanceof ContainerStack) {
                    ((ContainerStack)player.field_71070_bA).tryRightClick(reader.readInt(), reader.readInt(), reader.readBoolean(), player, (short)reader.readInt());
                } else {
                    reader.readInt();
                    reader.readInt();
                    reader.readBoolean();
                    reader.readInt();
                }
            }
        }
    }

    public static class CustomRightClick
    extends MessageChannel.Message {
        public CustomRightClick() {
        }

        public CustomRightClick(int slot, int mouseClick, boolean holdingShift) {
            super(slot, mouseClick, holdingShift);
            this.setClasses(Integer.class, Integer.class, Boolean.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                if (player.field_71070_bA instanceof ContainerStack) {
                    if (!((ContainerStack)player.field_71070_bA).overrideRightClick(reader.readInt(), reader.readInt(), reader.readBoolean(), player)) {
                        new Translatable("problem.guioutofsync", new Object[0]).send(player);
                        ContainerStack.closeScreen(player);
                    }
                } else {
                    reader.readInt();
                    reader.readInt();
                    reader.readBoolean();
                }
            }
        }
    }

    public static class CreateRestorerView
    extends MessageChannel.Message {
        public CreateRestorerView() {
        }

        public CreateRestorerView(String type, String selectedId, int playerInventorySlot, boolean addRestorer, boolean clearExisting, boolean alreadyOpened) {
            super(type, selectedId, playerInventorySlot, addRestorer, clearExisting, alreadyOpened);
            this.setClasses(String.class, String.class, Integer.class, Boolean.class, Boolean.class, Boolean.class);
        }

        public CreateRestorerView(ArrayList<NBTTagCompound> tags) {
            super(tags, false);
            this.setClasses(NBTTagCompound.class, Boolean.class);
        }

        public CreateRestorerView(ArrayList<NBTTagCompound> tags, String type, String selectedId, int playerInventorySlot, boolean addRestorer, boolean clearExisting) {
            super(tags, true, type, selectedId, addRestorer, clearExisting, playerInventorySlot);
            this.setClasses(NBTTagCompound.class, Boolean.class, String.class, String.class, Boolean.class, Boolean.class, Integer.class);
        }

        public static void subscribePlayerForRestore(EntityPlayer player) {
            ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
            UniqueItemData data = UniqueItemData.get(player.field_70170_p);
            PermissionData.get(player.field_70170_p).loadAllPermissions(player.field_70170_p);
            PermissionPlayer playerPermission = PermissionGroup.getPlayerPermission(player);
            try {
                for (String uuid : data.items.keySet()) {
                    int accessLevel;
                    NBTTagCompound tag = data.items.get(uuid);
                    if (tag == null || tag.func_74764_b("deleted") || (accessLevel = PermissionGroup.getGroup(player.field_70170_p, "I_" + uuid).getAccessLevel(playerPermission)) != 4) continue;
                    try {
                        data.subscribePlayer(player, uuid, tags, true);
                    }
                    catch (Exception e) {
                        Logger.logger.error("Exception while subscribing player to restorable item: " + e.toString());
                        e.printStackTrace();
                    }
                }
            }
            catch (ConcurrentModificationException e) {
                return;
            }
            Common.channel.sendToPlayer(player, new CreateRestorerView(tags));
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String type = reader.readString();
                String selectedId = reader.readString();
                int slot = reader.readInt();
                boolean addRestorer = reader.readBoolean();
                boolean clearExisting = reader.readBoolean();
                if (!reader.readBoolean()) {
                    ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
                    UniqueItemData data = UniqueItemData.get(player.field_70170_p);
                    PermissionData.get(player.field_70170_p).loadAllPermissions(player.field_70170_p);
                    PermissionPlayer playerPermission = PermissionGroup.getPlayerPermission(player);
                    try {
                        for (String uuid : data.items.keySet()) {
                            int accessLevel;
                            NBTTagCompound tag = data.items.get(uuid);
                            if (tag == null || tag.func_74764_b("deleted") || (accessLevel = PermissionGroup.getGroup(player.field_70170_p, "I_" + uuid).getAccessLevel(playerPermission)) != 4) continue;
                            data.subscribePlayer(player, uuid, tags, true);
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        return;
                    }
                    Common.channel.sendToPlayer(player, new CreateRestorerView(tags, type, selectedId, slot, addRestorer, clearExisting));
                }
                RestorerContainer.createView(player, type, selectedId, addRestorer, clearExisting, false, slot);
            } else {
                int num = reader.readInt();
                for (int i = 0; i < num; ++i) {
                    NBTTagCompound tag = reader.readNBTTagCompound();
                    if (tag == null) continue;
                    UniqueItemData.get(player.field_70170_p).updateData(tag);
                }
                if (reader.readBoolean()) {
                    RestorerContainer.createView(player, reader.readString(), reader.readString(), reader.readBoolean(), reader.readBoolean(), false, reader.readInt());
                } else if (player.field_71070_bA instanceof ContainerStack) {
                    ((ContainerStack)player.field_71070_bA).updateContainers(player);
                }
            }
        }
    }

    public static class DataUpdate
    extends MessageChannel.Message {
        public DataUpdate() {
        }

        public DataUpdate(ArrayList<NBTTagCompound> tags) {
            super(tags);
            this.setClasses(NBTTagCompound.class);
        }

        public DataUpdate(NBTTagCompound tag) {
            super(1, tag);
            this.setClasses(Integer.class, NBTTagCompound.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (!serverSide) {
                UniqueItemData data = UniqueItemData.get(player.field_70170_p);
                int num = reader.readInt();
                for (int i = 0; i < num; ++i) {
                    data.updateData(reader.readNBTTagCompound());
                }
            }
        }
    }

    public static class InventoryIdResponse
    extends MessageChannel.Message {
        public InventoryIdResponse() {
        }

        public InventoryIdResponse(String parentGuid, ArrayList<Object> ids, ArrayList<NBTTagCompound> tags, int slotToOpen, int stackToOpenIn) {
            super(parentGuid, ids, tags, slotToOpen, stackToOpenIn);
            this.setClasses(String.class, Object.class, NBTTagCompound.class, Integer.class, Integer.class);
        }

        public InventoryIdResponse(String parentGuid, int slotToOpen, int stackToOpenIn, ArrayList<Integer> stackState) {
            super(parentGuid, slotToOpen, stackToOpenIn, stackState);
            this.setClasses(String.class, Integer.class, Integer.class, Integer.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (!serverSide) {
                ItemStack stack;
                int i;
                String parentGuid = reader.readString();
                if (player.field_71070_bA instanceof ContainerStack) {
                    ((ContainerStack)player.field_71070_bA).saveInventories(player);
                }
                UniqueItemData data = UniqueItemData.get(player.field_70170_p);
                Object inventory = player.field_71071_by;
                if (!parentGuid.equals("none")) {
                    inventory = UniqueItemInventory.getInventory(player, parentGuid);
                }
                if (inventory == null) {
                    int i2;
                    int length = reader.readInt() / 2;
                    for (i2 = 0; i2 < length; ++i2) {
                        reader.readInt();
                        reader.readString();
                    }
                    length = reader.readInt();
                    for (i2 = 0; i2 < length; ++i2) {
                        reader.readNBTTagCompound();
                    }
                    reader.readInt();
                    reader.readInt();
                    return;
                }
                int length = reader.readInt() / 2;
                for (i = 0; i < length; ++i) {
                    int index = reader.readInt();
                    Common.setInventoryIdentifier(player, (IInventory)inventory, index, reader.readString());
                }
                if (inventory instanceof UniqueItemInventory) {
                    ((UniqueItemInventory)inventory).saveInventory();
                }
                length = reader.readInt();
                for (i = 0; i < length; ++i) {
                    NBTTagCompound tag = reader.readNBTTagCompound();
                    data.updateData(tag);
                }
                int slotToOpen = reader.readInt();
                int stackToOpenIn = reader.readInt();
                if (slotToOpen >= 0 && (stack = inventory.func_70301_a(slotToOpen)) != null && stack.func_77973_b() instanceof UniqueItem.OpenableItem) {
                    if (stackToOpenIn == -1) {
                        if (((UniqueItem.OpenableItem)stack.func_77973_b()).open(player, stack, player.field_70170_p)) {
                            Common.channel.sendToServer(new InventoryIdResponse(parentGuid, slotToOpen, stackToOpenIn, new ArrayList<Integer>()));
                        }
                    } else {
                        StackableContainer c = ((UniqueItem.OpenableItem)stack.func_77973_b()).openContainer(player, UniqueItem.getInventoryContaining(player, UniqueItem.getIdentifier(stack), null), slotToOpen, stack, stackToOpenIn);
                        if (c != null && player.field_71070_bA instanceof ContainerStack) {
                            int i3;
                            ContainerStack container = (ContainerStack)player.field_71070_bA;
                            if (!container.refreshInventories(player)) {
                                return;
                            }
                            ArrayList<Integer> stackState = new ArrayList<Integer>();
                            for (i3 = 0; i3 < container.stacks.length; ++i3) {
                                stackState.add(container.stacks[i3].size());
                            }
                            container.addContainer(player, ((UniqueItem.OpenableItem)stack.func_77973_b()).getPreferreredStack(container, stackToOpenIn), c);
                            for (i3 = 0; i3 < container.stacks.length; ++i3) {
                                stackState.add(container.stacks[i3].size());
                            }
                            Common.channel.sendToServer(new InventoryIdResponse(parentGuid, slotToOpen, stackToOpenIn, stackState));
                        }
                    }
                }
            } else {
                ItemStack stack;
                String parentGuid = reader.readString();
                int slotToOpen = reader.readInt();
                int stackToOpenIn = reader.readInt();
                Object inventory = player.field_71071_by;
                if (!parentGuid.equals("none")) {
                    inventory = UniqueItemInventory.getInventory(player, parentGuid);
                }
                if (inventory == null) {
                    int length = reader.readInt();
                    for (int i = 0; i < length; ++i) {
                        reader.readInt();
                    }
                    return;
                }
                if (slotToOpen >= 0 && (stack = inventory.func_70301_a(slotToOpen)) != null && stack.func_77973_b() instanceof UniqueItem.OpenableItem) {
                    if (stackToOpenIn == -1) {
                        int length = reader.readInt();
                        for (int i = 0; i < length; ++i) {
                            reader.readInt();
                        }
                        ((UniqueItem.OpenableItem)stack.func_77973_b()).open(player, stack, player.field_70170_p);
                    } else {
                        StackableContainer c = ((UniqueItem.OpenableItem)stack.func_77973_b()).openContainer(player, UniqueItem.getInventoryContaining(player, UniqueItem.getIdentifier(stack), null), slotToOpen, stack, stackToOpenIn);
                        if (c != null && player.field_71070_bA instanceof ContainerStack) {
                            int i;
                            ContainerStack container = (ContainerStack)player.field_71070_bA;
                            if (reader.readInt() / 2 != container.stacks.length) {
                                new Translatable("problem.guioutofsync", new Object[0]).send(player);
                                ContainerStack.closeScreen(player);
                                return;
                            }
                            boolean wasTheSame = true;
                            for (i = 0; i < container.stacks.length; ++i) {
                                if (container.stacks[i].size() == reader.readInt()) continue;
                                wasTheSame = false;
                            }
                            if (wasTheSame) {
                                container.addContainer(player, ((UniqueItem.OpenableItem)stack.func_77973_b()).getPreferreredStack(container, stackToOpenIn), c);
                            }
                            for (i = 0; i < container.stacks.length; ++i) {
                                if (container.stacks[i].size() == reader.readInt()) continue;
                                new Translatable("problem.guioutofsync", new Object[0]).send(player);
                                ContainerStack.closeScreen(player);
                                return;
                            }
                        } else {
                            int length = reader.readInt();
                            for (int i = 0; i < length; ++i) {
                                reader.readInt();
                            }
                            new Translatable("problem.guioutofsync", new Object[0]).send(player);
                            ContainerStack.closeScreen(player);
                        }
                    }
                }
            }
        }
    }

    public static class InventoryIdRequest
    extends MessageChannel.Message {
        public InventoryIdRequest() {
        }

        public InventoryIdRequest(String parentGuid, ArrayList<Integer> indices, ArrayList<String> uuids, int slotToOpen, int stackToOpenIn) {
            super(parentGuid, indices, uuids, slotToOpen, stackToOpenIn);
            this.setClasses(String.class, Integer.class, String.class, Integer.class, Integer.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                int i;
                String parentGuid = reader.readString();
                if (player.field_71070_bA instanceof ContainerStack) {
                    ((ContainerStack)player.field_71070_bA).saveInventories(player);
                }
                Object inventory = player.field_71071_by;
                if (!parentGuid.equals("none")) {
                    inventory = UniqueItemInventory.getInventory(player, parentGuid);
                }
                if (inventory == null) {
                    reader.readInt();
                    int length = reader.readInt();
                    for (int i2 = 0; i2 < length; ++i2) {
                        reader.readInt();
                    }
                    length = reader.readInt();
                    ArrayList tags = new ArrayList();
                    for (int i3 = 0; i3 < length; ++i3) {
                        reader.readString();
                    }
                    reader.readInt();
                    reader.readInt();
                    return;
                }
                ContainerStack container = null;
                if (player.field_71070_bA instanceof ContainerStack) {
                    container = (ContainerStack)player.field_71070_bA;
                    container.func_75142_b();
                }
                int length = reader.readInt();
                ArrayList<Object> ids = new ArrayList<Object>();
                int count = 0;
                for (int i4 = 0; i4 < length; ++i4) {
                    int index = reader.readInt();
                    String id = Common.requestInventoryIdentifier(player, (IInventory)inventory, index);
                    if (id == null) continue;
                    ++count;
                    ids.add(index);
                    ids.add(id);
                }
                if (inventory instanceof UniqueItemInventory) {
                    ((UniqueItemInventory)inventory).saveInventory();
                }
                if (container != null) {
                    container.detectAndIgnoreChanges();
                }
                UniqueItemData data = UniqueItemData.get(player.field_70170_p);
                int num = reader.readInt();
                ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
                for (i = 0; i < count; ++i) {
                    ItemStack stack = inventory.func_70301_a(((Integer)ids.get(i * 2)).intValue());
                    if (stack == null) continue;
                    if (stack.func_77973_b() instanceof QuantumBackpack) {
                        data.subscribePlayer(player, QuantumBackpack.getInfo(stack), tags, false);
                        continue;
                    }
                    if (!((UniqueItem)stack.func_77973_b()).hasUniqueData()) continue;
                    data.subscribePlayer(player, (String)ids.get(i * 2 + 1), tags, false);
                }
                for (i = 0; i < num; ++i) {
                    data.subscribePlayer(player, reader.readString(), tags, false);
                }
                Common.channel.sendToPlayer(player, new InventoryIdResponse(parentGuid, ids, tags, reader.readInt(), reader.readInt()));
                if (container != null) {
                    container.refreshInventories(player);
                }
            }
        }
    }

    public static class SubscribeToItem
    extends MessageChannel.Message {
        public SubscribeToItem() {
        }

        public SubscribeToItem(String uuid) {
            super(uuid);
            this.setClasses(String.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
                UniqueItemData.get(player.field_70170_p).subscribePlayer(player, uuid, tags, false);
                Common.channel.sendToPlayer(player, new DataUpdate(tags));
            }
        }
    }
}

