/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.gui;

import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.UniqueItem;
import brad16840.common.gui.CraftingContainer;
import brad16840.common.gui.RestorerContainer;
import brad16840.common.permissions.PacketHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class PlayerContainer
extends StackableContainer {
    public InventoryPlayer inventory;
    public static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/player.png");

    public PlayerContainer(InventoryPlayer inventory) {
        super(176, 100);
        this.inventory = inventory;
        inventory.field_70458_d.func_71064_a((StatBase)AchievementList.field_76004_f, 1);
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlotToContainer(ContainerStack.ContainerSection.INVENTORY_NOT_HOTBAR, new StackableContainer.ContainerSlot(this, player, (IInventory)this.inventory, x + y * 9 + 9, 8 + x * 18, 18 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlotToContainer(ContainerStack.ContainerSection.INVENTORY_HOTBAR, new StackableContainer.ContainerSlot(this, player, (IInventory)this.inventory, x, 8 + x * 18, 76));
        }
        return true;
    }

    @Override
    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        return true;
    }

    @Override
    public void onClosed(EntityPlayer player) {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof UniqueItem.UpdatableItem)) continue;
            ((UniqueItem.UpdatableItem)stack.func_77973_b()).updateItemStack(null, stack);
        }
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, StackableContainer.ContainerSlot slot) {
        ItemStack itemstack = null;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (!this.container.mergeItemStack(this, itemstack1, 0, 36, false)) {
                return null;
            }
            slot.func_75220_a(itemstack1, itemstack);
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, itemstack);
        }
        return itemstack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int x, int y) {
        this.gui.text(this, this.inventory.func_145818_k_() ? this.inventory.func_145825_b() : I18n.func_135052_a((String)this.inventory.func_145825_b(), (Object[])new Object[0])).truncateString(this.guiWidth - 16).drawString(8, 6, -12566464);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture(this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
    }

    @Override
    public String getId() {
        return "none";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        if (keyCode == Common.permissionKey.func_151463_i()) {
            if ((Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) && this.stackId == 0) {
                return false;
            }
            Common.channel.sendToServer(new PacketHandler.OpenPlayer());
            return true;
        }
        if (Common.loadKeyBinding != null && keyCode == Common.loadKeyBinding.keyBinding.func_151463_i()) {
            Common.channel.sendToServer(new PacketHandler.OpenEditorWindow("loadbackpack", Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? 1 : 0, false));
            return true;
        }
        return false;
    }

    @Override
    public boolean customRightClick(EntityPlayer player, int slot, boolean holdingShift) {
        ItemStack stack = this.container.func_75139_a(slot).func_75211_c();
        int openStackId = this.stackId;
        if (holdingShift && ++openStackId >= this.container.stacks.length) {
            openStackId = 0;
        }
        if (stack != null) {
            this.container.saveInventories(player);
            if (stack.func_77973_b() instanceof UniqueItem.OpenableItem) {
                UniqueItem.OpenableItem item = (UniqueItem.OpenableItem)stack.func_77973_b();
                StackableContainer c = item.openContainer(player, (IInventory)player.field_71071_by, this.container.func_75139_a(slot).getSlotIndex(), stack, openStackId);
                if (c != null) {
                    this.container.addContainer(player, item.getPreferreredStack(this.container, openStackId), c);
                } else if (this.isClient()) {
                    this.gui.overrideFailed = true;
                }
                return true;
            }
            if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150462_ai) && !Common.disableCraftingGui) {
                this.container.addContainer(player, openStackId, new CraftingContainer(player));
                return true;
            }
            if (stack.func_77973_b() instanceof UniqueItem.ItemRestorer) {
                if (Common.disableItemRestorers) {
                    return false;
                }
                if (!player.field_70170_p.field_72995_K) {
                    PacketHandler.CreateRestorerView.subscribePlayerForRestore(player);
                }
                RestorerContainer.createView(player, ((UniqueItem.ItemRestorer)stack.func_77973_b()).getType(), null, true, false, false, this.container.func_75139_a(slot).getSlotIndex());
                return true;
            }
        }
        return false;
    }

    @Override
    public int getSlotCount() {
        return 36;
    }

    @Override
    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    @Override
    public int getRowSize() {
        return 9;
    }
}

