/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RadioButtonGroup {
    public int xPos;
    public int yPos;
    public int height;
    public RadioButtons buttons;

    public RadioButtonGroup(int xPos, int yPos, int height, RadioButtons buttons) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.height = height;
        this.buttons = buttons;
    }

    public boolean mouseDown(int mx, int my) {
        if ((mx -= this.xPos) > 0 && (my -= this.yPos) > 0 && my < this.height) {
            for (int i = 0; i < this.buttons.size(); ++i) {
                int width = this.buttons.getButtonWidth(i);
                if (mx < width) {
                    this.buttons.buttonClicked(i);
                    return true;
                }
                mx -= width;
            }
        }
        return false;
    }

    public void drawForeground(int mx, int my) {
        int s = 0;
        for (int i = 0; i < this.buttons.size(); ++i) {
            int width = this.buttons.getButtonWidth(i);
            this.buttons.drawButtonForeground(i, this.xPos + s, this.yPos, width, this.height, mx, my);
            s += width;
        }
    }

    public void drawBackground(int mx, int my) {
        int s = 0;
        for (int i = 0; i < this.buttons.size(); ++i) {
            int width = this.buttons.getButtonWidth(i);
            this.buttons.drawButtonBackground(i, this.xPos + s, this.yPos, width, this.height, mx, my);
            s += width;
        }
    }

    public static interface RadioButtons {
        public int size();

        public int getButtonWidth(int var1);

        public void drawButtonForeground(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

        public void drawButtonBackground(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

        public void buttonClicked(int var1);
    }
}

