/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.gui;

import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.DynamicRecipes;
import brad16840.common.Logger;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UnknownItem;
import brad16840.common.gui.BlockSelector;
import brad16840.common.gui.ImageButton;
import brad16840.common.gui.NBTEditor;
import brad16840.common.gui.TitledImageButton;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class RecipeEditor
extends StackableContainer
implements BlockSelector.BlockSelectionListener {
    public static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/recipe_editor.png");
    private String selectedId;
    private int selectedMetadata;
    private int currentRecipeIndex = -1;
    private IRecipe currentRecipe = null;
    private int recipeType = 0;
    private ArrayList<IRecipe> recipes = new ArrayList();
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerButton prevRecipeButton;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerButton nextRecipeButton;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerButton dynamicToggleButton;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerButton showDisabledButton;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerButton shapelessButton;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerButton shapeToggleButton;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerButton filterOutputButton;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerButton saveButton;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerButton deleteButton;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerButton copyButton;
    @SideOnly(value=Side.CLIENT)
    private TitledImageButton nbtButton;
    private String savingRecipe = null;
    private int showDisabled = 0;
    private int showDynamics = 2;
    private int showShaped = 2;
    private int filterOutput = 2;
    private boolean isDisabled;
    private StackableContainer.ContainerSlot filterSlot;
    private FilterInventory filterInventory = new FilterInventory();
    @SideOnly(value=Side.CLIENT)
    protected RecipeInventory recipeInventory;
    private StackableContainer.ContainerSlot[] recipeSlots = new StackableContainer.ContainerSlot[10];
    private boolean readOnly = false;

    public RecipeEditor(boolean isOp) {
        super(227, 108);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return;
        }
        this.readOnly = !isOp;
        this.recipeInventory = new RecipeInventory();
        this.filter();
    }

    private boolean matchesFilter(ItemStack filter, ItemStack b) {
        if (b == null || filter.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        int filterMeta = filter.func_77960_j();
        int bMeta = b.func_77960_j();
        if (filterMeta != Short.MAX_VALUE && bMeta != Short.MAX_VALUE && filterMeta != bMeta) {
            return false;
        }
        if (filter.func_77973_b() instanceof UnknownItem) {
            return UnknownItem.getItemDescriptor(filter).equals(UnknownItem.getItemDescriptor(b));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void _scanRecipes(List list) {
        for (int i = 0; i < list.size(); ++i) {
            IRecipe recipe;
            if (!(list.get(i) instanceof IRecipe) || !((recipe = (IRecipe)list.get(i)) instanceof ShapedRecipes) && !(recipe instanceof ShapelessRecipes) && !(recipe instanceof ShapedOreRecipe) && !(recipe instanceof ShapelessOreRecipe) || this.showDynamics != 2 && this.showDynamics == 1 != recipe instanceof DynamicRecipes.Recipe || this.showShaped == 3 || this.showShaped == 1 && !(recipe instanceof DynamicRecipes.ShapedRecipe) && !(recipe instanceof ShapedOreRecipe) || this.showShaped == 0 && !(recipe instanceof DynamicRecipes.ShapelessRecipe) && !(recipe instanceof ShapelessOreRecipe)) continue;
            if (this.filterInventory.stack != null) {
                boolean match;
                block20: {
                    ShapedRecipes r;
                    match = false;
                    if (this.filterOutput != 0 && this.matchesFilter(this.filterInventory.stack, DynamicRecipes.getSafeRecipeOutput(recipe))) {
                        match = true;
                    } else if (this.filterOutput != 1 && recipe instanceof ShapedRecipes) {
                        r = (ShapedRecipes)recipe;
                        for (ItemStack itemStack : r.field_77574_d) {
                            if (!this.matchesFilter(this.filterInventory.stack, itemStack)) continue;
                            match = true;
                            break;
                        }
                    } else if (this.filterOutput != 1 && recipe instanceof ShapelessRecipes) {
                        r = (ShapelessRecipes)recipe;
                        for (Object s : r.field_77579_b) {
                            if (!this.matchesFilter(this.filterInventory.stack, (ItemStack)s)) continue;
                            match = true;
                            break;
                        }
                    } else if (this.filterOutput != 1 && recipe instanceof ShapedOreRecipe) {
                        r = (ShapedOreRecipe)recipe;
                        for (Object object : r.getInput()) {
                            if (object instanceof ItemStack) {
                                if (!this.matchesFilter(this.filterInventory.stack, (ItemStack)object)) continue;
                                match = true;
                                break;
                            }
                            if (!(object instanceof ArrayList)) continue;
                            for (ItemStack o : (ArrayList)object) {
                                if (!this.matchesFilter(this.filterInventory.stack, o)) continue;
                                match = true;
                                break block20;
                            }
                            break;
                        }
                    } else if (this.filterOutput != 1 && recipe instanceof ShapelessOreRecipe) {
                        r = (ShapelessOreRecipe)recipe;
                        for (Object s : r.getInput()) {
                            if (s instanceof ItemStack) {
                                if (!this.matchesFilter(this.filterInventory.stack, (ItemStack)s)) continue;
                                match = true;
                                break;
                            }
                            if (!(s instanceof ArrayList)) continue;
                            for (ItemStack itemStack : (ArrayList)s) {
                                if (!this.matchesFilter(this.filterInventory.stack, itemStack)) continue;
                                match = true;
                                break block20;
                            }
                            break;
                        }
                    }
                }
                if (!match) continue;
            }
            if (recipe == this.currentRecipe) {
                this.currentRecipeIndex = this.recipes.size();
            }
            this.recipes.add(recipe);
        }
    }

    public void filterFurnaceRecipe(DynamicRecipes.FurnaceRecipe recipe) {
        if (this.filterInventory.stack != null) {
            boolean match = false;
            if (this.filterOutput != 0 && this.matchesFilter(this.filterInventory.stack, DynamicRecipes.getSafeRecipeOutput(recipe))) {
                match = true;
            } else if (this.filterOutput != 1) {
                match = this.matchesFilter(this.filterInventory.stack, recipe.input);
            }
            if (!match) {
                return;
            }
        }
        if (this.showDisabled == 0 && !recipe.enabled || this.showDisabled == 1 && recipe.enabled) {
            return;
        }
        if (recipe == this.currentRecipe) {
            this.currentRecipeIndex = this.recipes.size();
        }
        this.recipes.add(recipe);
    }

    @SideOnly(value=Side.CLIENT)
    public void filter() {
        this.recipes.clear();
        this.currentRecipeIndex = -1;
        if (this.showDisabled != 1) {
            this._scanRecipes(CraftingManager.func_77594_a().func_77592_b());
        }
        if (this.showDisabled != 0) {
            this._scanRecipes(new ArrayList<IRecipe>(DynamicRecipes.disabledRecipes.values()));
        }
        if (this.showShaped == 2 || this.showShaped == 3) {
            Map m = FurnaceRecipes.func_77602_a().func_77599_b();
            for (DynamicRecipes.FurnaceRecipe recipe : DynamicRecipes.FurnaceRecipe.clientRecipes.keySet()) {
                this.filterFurnaceRecipe(recipe);
            }
            for (DynamicRecipes.FurnaceRecipe o : m.keySet()) {
                DynamicRecipes.FurnaceRecipe recipe = DynamicRecipes.FurnaceRecipe.getRecipe((ItemStack)m.get(o), (ItemStack)o);
                if (DynamicRecipes.FurnaceRecipe.clientRecipes.containsKey(recipe)) continue;
                this.filterFurnaceRecipe(recipe);
            }
        }
        Collections.sort(this.recipes, new Comparator<IRecipe>(){

            @Override
            public int compare(IRecipe o1, IRecipe o2) {
                String s = DynamicRecipes.getRepresentation(o1);
                String s2 = DynamicRecipes.getRepresentation(o2);
                if (DynamicRecipes.overriddenRecipes.contains(s)) {
                    if (!DynamicRecipes.overriddenRecipes.contains(s2)) {
                        return -1;
                    }
                } else if (DynamicRecipes.overriddenRecipes.contains(s2)) {
                    return 1;
                }
                if (DynamicRecipes.FurnaceRecipe.overriddenRecipes.contains(o1)) {
                    if (!DynamicRecipes.FurnaceRecipe.overriddenRecipes.contains(o2)) {
                        return -1;
                    }
                } else if (DynamicRecipes.FurnaceRecipe.overriddenRecipes.contains(o2)) {
                    return 1;
                }
                return s.replace("*", "|").compareToIgnoreCase(s2.replace("*", "|"));
            }
        });
        this.currentRecipeIndex = this.recipes.indexOf(this.currentRecipe);
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return true;
        }
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                this.recipeSlots[y * 3 + x] = new StackableContainer.ContainerSlot(this, player, this.recipeInventory, y * 3 + x, 8 + x * 18, 28 + y * 18);
            }
        }
        this.recipeSlots[9] = new StackableContainer.ContainerSlot(this, player, this.recipeInventory, 9, 80, 46);
        this.filterSlot = new StackableContainer.ContainerSlot(this, player, this.filterInventory, 0, 203, 19);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void selectionChanged(String id, int metadata) {
        if (id != null && id.equals(this.selectedId) && metadata == this.selectedMetadata) {
            return;
        }
        this.selectedId = id;
        this.selectedMetadata = metadata;
    }

    @Override
    public boolean allowMultipleSelections() {
        return false;
    }

    @Override
    public void addCustomTabs(ArrayList<BlockSelector.CustomTab> list) {
    }

    @SideOnly(value=Side.CLIENT)
    public void updateButtons() {
        this.shapeToggleButton.field_146126_j = new Translatable("button.shape." + (this.showShaped == 2 ? "both" : (this.showShaped == 1 ? "shaped" : (this.showShaped == 0 ? "shapeless" : "furnace"))), new Object[0]).translate();
        this.filterOutputButton.field_146126_j = new Translatable("button.involves." + (this.filterOutput == 2 ? "both" : (this.filterOutput == 1 ? "creates" : "uses")), new Object[0]).translate();
        this.showDisabledButton.field_146126_j = new Translatable("button.state." + (this.showDisabled == 2 ? "both" : (this.showDisabled == 1 ? "disabled" : "enabled")), new Object[0]).translate();
        this.shapelessButton.field_146126_j = new Translatable("button.shape." + (this.recipeType == 1 ? "shapeless" : (this.recipeType == 0 ? "shaped" : "furnace")), new Object[0]).translate();
        this.copyButton.field_146124_l = !this.readOnly && this.currentRecipe != null;
        this.copyButton.field_146126_j = (this.currentRecipeIndex == -1 ? "--" : Integer.valueOf(this.currentRecipeIndex + 1)) + " / " + this.recipes.size();
        this.saveButton.field_146124_l = !this.readOnly && !this.isDisabled;
        this.shapelessButton.field_146124_l = !this.readOnly && !this.isDisabled;
        this.deleteButton.field_146124_l = !this.readOnly && this.currentRecipe != null;
        this.deleteButton.field_146126_j = new Translatable("button.state." + (this.isDisabled ? "enable" : "disable"), new Object[0]).translate();
        boolean bl = this.nbtButton.field_146124_l = this.recipeInventory.items[9] != null;
        if (this.recipeInventory.items[9] != null) {
            this.nbtButton.colors[1] = this.recipeInventory.items[9].func_77942_o() ? -11184811 : -10066330;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void recipeChanged(String remove, String add) {
        boolean replaced = false;
        if (remove != null && remove.equals(DynamicRecipes.getRepresentation(this.currentRecipe))) {
            replaced = true;
        }
        if (add != null) {
            if (add.equals(this.savingRecipe)) {
                replaced = true;
                this.savingRecipe = null;
            }
            if (replaced) {
                this.currentRecipe = DynamicRecipes.recipes.get(add);
                if (this.currentRecipe == null) {
                    this.currentRecipe = DynamicRecipes.findRecipe(add, null);
                }
                if (add.startsWith("smelt")) {
                    this.currentRecipe = DynamicRecipes.FurnaceRecipe.existingRecipes.get(add);
                }
            }
        }
        this.recipeInventory.updateItems();
        this.filter();
        this.updateButtons();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        this.prevRecipeButton = new ImageButton((StackableContainer)this, 1, 124, 82, 17, 18, texture, 0, 180);
        this.nextRecipeButton = new ImageButton((StackableContainer)this, 1, 203, 82, 17, 18, texture, 0, 198);
        this.dynamicToggleButton = new StackableContainer.ContainerButton(this, 1, 116, 62, 59, 20, "");
        this.shapeToggleButton = new TitledImageButton(this, "", 1, 156, 39, 64, 18, texture, 0, 108);
        this.shapelessButton = new TitledImageButton(this, "", 1, 38, 7, 64, 18, texture, 0, 108);
        this.showDisabledButton = new TitledImageButton(this, "", 1, 156, 60, 64, 18, texture, 0, 108);
        this.saveButton = new TitledImageButton(this, new Translatable("button.save", new Object[0]).translate(), 1, 7, 83, 48, 18, texture, 0, 126);
        this.deleteButton = new TitledImageButton(this, new Translatable("button.state.disable", new Object[0]).translate(), 1, 58, 83, 48, 18, texture, 0, 126);
        this.copyButton = new TitledImageButton(this, "", 1, 143, 82, 58, 18, texture, 0, 162);
        this.filterOutputButton = new TitledImageButton(this, "", 1, 124, 18, 75, 18, texture, 0, 144);
        this.nbtButton = new TitledImageButton(this, new Translatable("button.nbt", new Object[0]).translate(), 1, 75, 65, 26, 15, texture, 51, 180);
        this.prevRecipeButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                RecipeEditor.this.currentRecipeIndex = RecipeEditor.this.currentRecipeIndex - 1;
                if (RecipeEditor.this.currentRecipeIndex < 0) {
                    RecipeEditor.this.currentRecipeIndex = RecipeEditor.this.recipes.size() - 1;
                }
                if (RecipeEditor.this.currentRecipeIndex >= 0) {
                    RecipeEditor.this.currentRecipe = (IRecipe)RecipeEditor.this.recipes.get(RecipeEditor.this.currentRecipeIndex);
                    RecipeEditor.this.recipeInventory.updateItems();
                } else {
                    RecipeEditor.this.currentRecipeIndex = -1;
                }
                RecipeEditor.this.updateButtons();
            }
        };
        this.nextRecipeButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                RecipeEditor.this.currentRecipeIndex = RecipeEditor.this.currentRecipeIndex + 1;
                if (RecipeEditor.this.currentRecipeIndex >= RecipeEditor.this.recipes.size()) {
                    RecipeEditor.this.currentRecipeIndex = 0;
                }
                if (RecipeEditor.this.currentRecipeIndex < RecipeEditor.this.recipes.size()) {
                    RecipeEditor.this.currentRecipe = (IRecipe)RecipeEditor.this.recipes.get(RecipeEditor.this.currentRecipeIndex);
                    RecipeEditor.this.recipeInventory.updateItems();
                } else {
                    RecipeEditor.this.currentRecipeIndex = -1;
                }
                RecipeEditor.this.updateButtons();
            }
        };
        this.dynamicToggleButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                RecipeEditor.this.showDynamics = RecipeEditor.this.showDynamics + 1;
                if (RecipeEditor.this.showDynamics > 2) {
                    RecipeEditor.this.showDynamics = 0;
                }
                RecipeEditor.this.filter();
                RecipeEditor.this.updateButtons();
            }
        };
        this.shapelessButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                RecipeEditor.this.recipeType = RecipeEditor.this.recipeType + 1;
                if (RecipeEditor.this.recipeType > 2) {
                    RecipeEditor.this.recipeType = 0;
                }
                RecipeEditor.this.updateButtons();
            }
        };
        this.shapeToggleButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                RecipeEditor.this.showShaped = RecipeEditor.this.showShaped + 1;
                if (RecipeEditor.this.showShaped > 3) {
                    RecipeEditor.this.showShaped = 0;
                }
                RecipeEditor.this.filter();
                RecipeEditor.this.updateButtons();
            }
        };
        this.filterOutputButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                RecipeEditor.this.filterOutput = RecipeEditor.this.filterOutput + 1;
                if (RecipeEditor.this.filterOutput > 2) {
                    RecipeEditor.this.filterOutput = 0;
                }
                RecipeEditor.this.filter();
                RecipeEditor.this.updateButtons();
            }
        };
        this.showDisabledButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                RecipeEditor.this.showDisabled = RecipeEditor.this.showDisabled + 1;
                if (RecipeEditor.this.showDisabled > 2) {
                    RecipeEditor.this.showDisabled = 0;
                }
                RecipeEditor.this.filter();
                RecipeEditor.this.updateButtons();
            }
        };
        this.saveButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                if (!RecipeEditor.this.recipeInventory.isValid()) {
                    new Translatable("problem.invalidrecipe", new Object[0]).log((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                    return;
                }
                String remove = null;
                if (RecipeEditor.this.currentRecipe != null) {
                    remove = DynamicRecipes.getRepresentation(RecipeEditor.this.currentRecipe);
                }
                String add = RecipeEditor.this.recipeInventory.getRepresentation();
                RecipeEditor.this.savingRecipe = add;
                Common.channel.sendToServer(new PacketHandler.OverrideRecipe(remove, add));
            }
        };
        this.deleteButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                if (RecipeEditor.this.currentRecipe == null) {
                    return;
                }
                RecipeEditor.this.savingRecipe = null;
                if (RecipeEditor.this.currentRecipe instanceof DynamicRecipes.FurnaceRecipe) {
                    String repr = ((DynamicRecipes.FurnaceRecipe)RecipeEditor.this.currentRecipe).getRepresentation();
                    if (!((DynamicRecipes.FurnaceRecipe)((RecipeEditor)RecipeEditor.this).currentRecipe).enabled) {
                        Common.channel.sendToServer(new PacketHandler.OverrideRecipe(null, repr));
                    } else {
                        Common.channel.sendToServer(new PacketHandler.OverrideRecipe(repr, null));
                    }
                    return;
                }
                String repr = DynamicRecipes.getRepresentation(RecipeEditor.this.currentRecipe);
                if (DynamicRecipes.disabledRecipes.containsKey(repr)) {
                    Common.channel.sendToServer(new PacketHandler.OverrideRecipe(null, repr));
                } else {
                    Common.channel.sendToServer(new PacketHandler.OverrideRecipe(repr, null));
                }
            }
        };
        this.copyButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                if (RecipeEditor.this.currentRecipe == null) {
                    return;
                }
                RecipeEditor.this.isDisabled = false;
                RecipeEditor.this.currentRecipe = null;
                RecipeEditor.this.currentRecipeIndex = -1;
                RecipeEditor.this.updateButtons();
            }
        };
        this.nbtButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                if (RecipeEditor.this.recipeInventory.items[9] == null) {
                    return;
                }
                String nbt = "";
                if (RecipeEditor.this.recipeInventory.items[9].func_77942_o()) {
                    nbt = DynamicRecipes.tagToString(RecipeEditor.this.recipeInventory.items[9].func_77978_p());
                }
                Common.channel.sendToServer(new PacketHandler.EditNBT());
                RecipeEditor.this.container.addContainer((EntityPlayer)Minecraft.func_71410_x().field_71439_g, null, new NBTEditor(RecipeEditor.this, nbt));
            }
        };
        this.gui.addButton(this.prevRecipeButton);
        this.gui.addButton(this.nextRecipeButton);
        this.gui.addButton(this.shapeToggleButton);
        this.gui.addButton(this.filterOutputButton);
        this.gui.addButton(this.showDisabledButton);
        this.gui.addButton(this.shapelessButton);
        this.gui.addButton(this.saveButton);
        this.gui.addButton(this.deleteButton);
        this.gui.addButton(this.copyButton);
        this.gui.addButton(this.nbtButton);
        this.updateButtons();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        return false;
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    @Override
    public void onClosed(EntityPlayer player) {
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, StackableContainer.ContainerSlot slot) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int mouseX, int mouseY) {
        int hoverI = (mouseY - 27) / 18 * 3 + (mouseX - 7) / 18;
        if (mouseX < 7 || mouseY < 27 || mouseX >= 61 || mouseY >= 81) {
            hoverI = -1;
        }
        if (mouseX > 78 && mouseY > 44 && mouseX <= 96 && mouseY <= 62) {
            hoverI = 9;
        }
        for (int i = 0; i < 10; ++i) {
            StackableContainer.ContainerSlot slot = this.recipeSlots[i];
            if (this.recipeType == 2 && i != 5 && i != 9) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.gui.bindTexture(texture);
                this.gui.drawTexture(this, slot.field_75223_e - this.gui.getOffsetX(this) + this.container.getOffsetX(this) - this.gui.getScrollX() - 1, slot.field_75221_f - this.gui.getOffsetY(this) + this.container.getOffsetY(this) - this.gui.getScrollY() - 1, 18, 18, 0, 216, 200.0f);
                continue;
            }
            if (hoverI == i) {
                this.gui.customTooltipItem = slot.func_75211_c();
            }
            GL11.glEnable((int)2896);
            this.recipeInventory.setWildcard(false);
            this.gui.drawSlotInventory(this, slot);
            this.recipeInventory.setWildcard(true);
            GL11.glDisable((int)2896);
            ItemStack stack = slot.func_75211_c();
            if (stack == null || stack.func_77960_j() != Short.MAX_VALUE) continue;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3042);
            this.gui.bindTexture(texture);
            this.gui.drawTexture(this, slot.field_75223_e - this.gui.getOffsetX(this) + this.container.getOffsetX(this) + 6 - this.gui.getScrollX(), slot.field_75221_f - this.gui.getOffsetY(this) + this.container.getOffsetY(this) + 7 - this.gui.getScrollY(), 9, 9, 0, 247, 200.0f);
            GL11.glDisable((int)3042);
        }
        StackableContainer.ContainerSlot slot = this.filterSlot;
        if (mouseX > slot.field_75223_e - 2 && mouseY > slot.field_75221_f - 2 && mouseX < slot.field_75223_e + 17 && mouseY < slot.field_75221_f + 17) {
            this.gui.customTooltipItem = slot.func_75211_c();
        }
        GL11.glEnable((int)2896);
        this.recipeInventory.setWildcard(false);
        this.gui.drawSlotInventory(this, slot);
        this.recipeInventory.setWildcard(true);
        GL11.glDisable((int)2896);
        ItemStack stack = slot.func_75211_c();
        if (stack != null && stack.func_77960_j() == Short.MAX_VALUE) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3042);
            this.gui.bindTexture(texture);
            this.gui.drawTexture(this, slot.field_75223_e - this.gui.getOffsetX(this) + this.container.getOffsetX(this) + 6 - this.gui.getScrollX(), slot.field_75221_f - this.gui.getOffsetY(this) + this.container.getOffsetY(this) + 7 - this.gui.getScrollY(), 9, 9, 0, 247, 200.0f);
            GL11.glDisable((int)3042);
        }
        this.gui.text(this, new Translatable("gui.recipeeditor.recipefilter", new Object[0]).translate()).truncateString(96).drawCenteredString(172, 8, -12566464);
        this.gui.text(this, new Translatable("gui.recipeeditor.typesetter", new Object[0]).translate()).truncateString(30).drawString(6, 12, -12566464, true);
        this.gui.text(this, new Translatable("gui.recipeeditor.typefilter", new Object[0]).translate()).truncateString(32).drawString(125, 44, -12566464);
        this.gui.text(this, new Translatable("gui.recipeeditor.statefilter", new Object[0]).translate()).truncateString(32).drawString(125, 65, -12566464);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture(this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
        int hoverI = (mouseY - 27) / 18 * 3 + (mouseX - 7) / 18;
        if (mouseX < 7 || mouseY < 27 || mouseX >= 61 || mouseY >= 81) {
            hoverI = -1;
        }
        if (mouseX > 78 && mouseY > 44 && mouseX <= 96 && mouseY <= 62) {
            hoverI = -1;
            this.gui.drawRectangle(this, 80, 46, 96, 62, -8850318);
        }
        if (hoverI >= 0 && hoverI < 9) {
            int y = hoverI / 3;
            int x = hoverI - y * 3;
            this.gui.drawRectangle(this, 8 + x * 18, 28 + y * 18, 24 + x * 18, 44 + y * 18, -8850318);
        }
        StackableContainer.ContainerSlot slot = this.filterSlot;
        if (mouseX > slot.field_75223_e - 2 && mouseY > slot.field_75221_f - 2 && mouseX < slot.field_75223_e + 17 && mouseY < slot.field_75221_f + 17) {
            this.gui.drawRectangle(this, 203, 19, 219, 35, -8850318);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseDown(int mouseX, int mouseY, int button) {
        int hoverI = (mouseY - 27) / 18 * 3 + (mouseX - 7) / 18;
        if (mouseX < 7 || mouseY < 27 || mouseX >= 61 || mouseY >= 81) {
            hoverI = -1;
        }
        if (mouseX > 78 && mouseY > 44 && mouseX <= 96 && mouseY <= 62) {
            hoverI = 9;
        }
        if (hoverI == 9) {
            if (button == 2 || Keyboard.isKeyDown((int)157) || Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                ItemStack stack = this.recipeInventory.items[hoverI];
                if (stack == null) {
                    return true;
                }
                ((BlockSelector)this.container.getContainer(0)).setSelectedItem(UnknownItem.getItemDescriptor(stack), stack.func_77960_j());
                return true;
            }
            if (button == 1) {
                if (this.recipeInventory.items[hoverI] != null) {
                    --this.recipeInventory.items[hoverI].field_77994_a;
                    if (this.recipeInventory.items[hoverI].field_77994_a < 1) {
                        this.recipeInventory.items[hoverI] = null;
                    }
                }
            } else if (this.selectedId != null) {
                int metadata = this.selectedMetadata;
                if (metadata == Short.MAX_VALUE) {
                    metadata = 0;
                }
                if (this.recipeInventory.items[hoverI] == null) {
                    this.recipeInventory.items[hoverI] = UnknownItem.wrap(this.selectedId, metadata);
                } else if (this.recipeInventory.items[hoverI].func_77960_j() == metadata && UnknownItem.getItemDescriptor(this.recipeInventory.items[hoverI]).equals(this.selectedId)) {
                    ++this.recipeInventory.items[hoverI].field_77994_a;
                    if (this.recipeInventory.items[hoverI].field_77994_a > 64) {
                        this.recipeInventory.items[hoverI].field_77994_a = 64;
                    }
                } else {
                    this.recipeInventory.items[hoverI] = UnknownItem.wrap(this.selectedId, metadata);
                }
            }
            this.updateButtons();
            return true;
        }
        if (hoverI >= 0) {
            if (this.recipeType == 2 && hoverI != 5) {
                return true;
            }
            if (button == 2 || Keyboard.isKeyDown((int)157) || Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                ItemStack stack = this.recipeInventory.items[hoverI];
                if (stack == null) {
                    return true;
                }
                ((BlockSelector)this.container.getContainer(0)).setSelectedItem(UnknownItem.getItemDescriptor(stack), stack.func_77960_j());
                return true;
            }
            if (button == 1) {
                this.recipeInventory.items[hoverI] = null;
            } else if (this.selectedId != null) {
                this.recipeInventory.items[hoverI] = UnknownItem.wrap(this.selectedId, this.selectedMetadata);
            }
            return true;
        }
        StackableContainer.ContainerSlot slot = this.filterSlot;
        if (mouseX > slot.field_75223_e - 2 && mouseY > slot.field_75221_f - 2 && mouseX < slot.field_75223_e + 16 && mouseY < slot.field_75221_f + 16) {
            if (button == 1) {
                this.filterInventory.stack = null;
            } else if (this.selectedId != null) {
                this.filterInventory.stack = UnknownItem.wrap(this.selectedId, this.selectedMetadata);
            }
            this.filter();
            this.updateButtons();
        }
        return false;
    }

    @Override
    public String getId() {
        return "none";
    }

    @Override
    public int getRowSize() {
        return 0;
    }

    @Override
    public void selectionsChanged(HashMap<String, HashSet<Integer>> selectedItems) {
    }

    @Override
    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        return false;
    }

    @Override
    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    private class FilterInventory
    extends ContainerStack.InvalidInventory {
        public ItemStack stack;

        private FilterInventory() {
        }

        @Override
        public ItemStack func_70301_a(int i) {
            if (this.stack == null) {
                return null;
            }
            ItemStack stack = this.stack.func_77946_l();
            if (!RecipeEditor.this.recipeInventory.wildcard && stack.func_77960_j() == Short.MAX_VALUE) {
                stack.func_77964_b(0);
            }
            return stack;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected class RecipeInventory
    extends ContainerStack.InvalidInventory {
        public boolean wildcard = true;
        public ItemStack[] items = new ItemStack[10];

        protected RecipeInventory() {
        }

        public void updateItems() {
            RecipeEditor.this.recipeType = 0;
            IRecipe r = RecipeEditor.this.currentRecipe;
            try {
                if (r instanceof ShapedOreRecipe) {
                    r = DynamicRecipes.evaluateRecipe(DynamicRecipes.getRepresentation(r));
                } else if (r instanceof ShapelessOreRecipe) {
                    r = DynamicRecipes.evaluateRecipe(DynamicRecipes.getRepresentation(r));
                }
            }
            catch (DynamicRecipes.DynamicRecipeException e) {
                Logger.logger.error(e.getMessage());
                r = null;
            }
            if (r == null) {
                RecipeEditor.this.isDisabled = false;
            } else {
                RecipeEditor.this.isDisabled = DynamicRecipes.disabledRecipes.containsKey(DynamicRecipes.getRepresentation(r));
                if (!RecipeEditor.this.isDisabled) {
                    RecipeEditor.this.isDisabled = DynamicRecipes.disabledRecipes.containsValue(RecipeEditor.this.currentRecipe);
                }
            }
            if (r instanceof ShapedRecipes) {
                ShapedRecipes recipe = (ShapedRecipes)r;
                for (int x = 0; x < 3; ++x) {
                    for (int y = 0; y < 3; ++y) {
                        if (x >= recipe.field_77576_b || y >= recipe.field_77577_c) {
                            this.items[y * 3 + x] = null;
                            continue;
                        }
                        this.items[y * 3 + x] = recipe.field_77574_d[y * recipe.field_77576_b + x];
                        if (this.items[y * 3 + x] == null) continue;
                        this.items[y * 3 + x] = this.items[y * 3 + x].func_77946_l();
                        this.items[y * 3 + x].field_77994_a = 1;
                    }
                }
                this.items[9] = DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe).func_77946_l();
            } else if (r instanceof ShapelessRecipes) {
                RecipeEditor.this.recipeType = 1;
                ShapelessRecipes recipe = (ShapelessRecipes)r;
                int j = 0;
                for (int i = 0; i < 9; ++i) {
                    if (i >= recipe.field_77579_b.size()) {
                        this.items[i] = null;
                        continue;
                    }
                    this.items[i] = (ItemStack)recipe.field_77579_b.get(j);
                    if (this.items[i] != null) {
                        this.items[i] = this.items[i].func_77946_l();
                        this.items[i].field_77994_a = 1;
                    }
                    ++j;
                }
                this.items[9] = DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe).func_77946_l();
            } else if (r instanceof DynamicRecipes.FurnaceRecipe) {
                RecipeEditor.this.isDisabled = !((DynamicRecipes.FurnaceRecipe)r).enabled;
                RecipeEditor.this.recipeType = 2;
                for (int i = 0; i < 9; ++i) {
                    this.items[i] = null;
                }
                this.items[5] = ((DynamicRecipes.FurnaceRecipe)r).input.func_77946_l();
                this.items[5].field_77994_a = 1;
                this.items[9] = ((DynamicRecipes.FurnaceRecipe)r).output.func_77946_l();
            } else {
                for (int i = 0; i < 10; ++i) {
                    this.items[i] = null;
                }
            }
        }

        @Override
        public ItemStack func_70301_a(int i) {
            if (this.items[i] == null) {
                return null;
            }
            ItemStack stack = this.items[i].func_77946_l();
            if (!this.wildcard && stack.func_77960_j() == Short.MAX_VALUE) {
                stack.func_77964_b(0);
            }
            return stack;
        }

        @Override
        public int func_70302_i_() {
            return 10;
        }

        public void setWildcard(boolean b) {
            this.wildcard = b;
        }

        public boolean isValid() {
            if (this.items[9] == null) {
                return false;
            }
            if (RecipeEditor.this.recipeType == 2) {
                return this.items[5] != null;
            }
            boolean input = false;
            for (int i = 0; i < 9; ++i) {
                if (this.items[i] == null) continue;
                input = true;
                break;
            }
            return input;
        }

        public String getRepresentation() {
            if (!this.isValid()) {
                return null;
            }
            if (RecipeEditor.this.recipeType == 1) {
                ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
                for (int i = 0; i < 9; ++i) {
                    if (this.items[i] == null) continue;
                    inputs.add(this.items[i].func_77946_l());
                }
                return new DynamicRecipes.ShapelessRecipe(UnknownItem.unwrap(this.items[9]), inputs).getRepresentation();
            }
            if (RecipeEditor.this.recipeType == 2) {
                return DynamicRecipes.FurnaceRecipe.getRecipe(UnknownItem.unwrap(this.items[9]), this.items[5].func_77946_l()).getRepresentation();
            }
            int x0 = 3;
            int y0 = 3;
            int x2 = 0;
            int y2 = 0;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (this.items[j * 3 + i] == null) continue;
                    if (i < x0) {
                        x0 = i;
                    }
                    if (j < y0) {
                        y0 = j;
                    }
                    if (i > x2) {
                        x2 = i;
                    }
                    if (j <= y2) continue;
                    y2 = j;
                }
            }
            int width = 1 + x2 - x0;
            int height = 1 + y2 - y0;
            if (width > height) {
                height = width;
                if (y0 + height > 3) {
                    y0 = 3 - height;
                }
                y2 = y0 + height - 1;
            }
            if (height > width) {
                width = height;
                if (x0 + width > 3) {
                    x0 = 3 - width;
                }
                x2 = x0 + width - 1;
            }
            ItemStack[] inputs = new ItemStack[width * height];
            for (int x = x0; x <= x2; ++x) {
                for (int y = y0; y <= y2; ++y) {
                    ItemStack stack = this.items[y * 3 + x];
                    if (stack != null) {
                        stack = stack.func_77946_l();
                    }
                    inputs[(y - y0) * width + (x - x0)] = stack;
                }
            }
            return new DynamicRecipes.ShapedRecipe(width, height, inputs, UnknownItem.unwrap(this.items[9])).getRepresentation();
        }
    }
}

