/*
 * Decompiled with CFR 0.152.
 */
package brad16840.plugins.nei;

import brad16840.common.Common;
import brad16840.common.DynamicRecipes;
import brad16840.plugins.nei.PositionedStackOverride;
import codechicken.core.ReflectionManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.recipe.ShapedRecipeHandler;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ShapedRecipeHandlerOverride
extends ShapedRecipeHandler {
    public String getRecipeName() {
        String name = super.getRecipeName();
        if (!Common.overrideNEI) {
            name = name + "!";
        }
        return name;
    }

    public ShapedRecipeHandler.CachedShapedRecipe forgeShapedRecipe(ShapedOreRecipe recipe) {
        try {
            Object[] items;
            int width = (Integer)ReflectionManager.getField(ShapedOreRecipe.class, Integer.class, (Object)recipe, (int)4);
            int height = (Integer)ReflectionManager.getField(ShapedOreRecipe.class, Integer.class, (Object)recipe, (int)5);
            for (Object item : items = recipe.getInput()) {
                if (!(item instanceof List) || !((List)item).isEmpty()) continue;
                return null;
            }
            return new CachedShapedRecipeOverride(width, height, items, recipe.func_77571_b());
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Error loading recipe: ", (Throwable)e);
            return null;
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (!outputId.equals("crafting") || ((Object)((Object)this)).getClass() != ShapedRecipeHandlerOverride.class) {
            super.loadCraftingRecipes(outputId, results);
            return;
        }
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            CachedShapedRecipeOverride recipe = null;
            if (irecipe instanceof DynamicRecipes.ShapedRecipe) {
                recipe = new CachedShapedRecipeOverride((DynamicRecipes.ShapedRecipe)irecipe);
            } else {
                if (!Common.overrideNEI) continue;
                if (irecipe instanceof ShapedRecipes) {
                    recipe = new CachedShapedRecipeOverride((ShapedRecipes)irecipe);
                } else if (irecipe instanceof ShapedOreRecipe) {
                    recipe = this.forgeShapedRecipe((ShapedOreRecipe)irecipe);
                }
            }
            if (recipe == null) continue;
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            CachedShapedRecipeOverride recipe = null;
            if (irecipe instanceof DynamicRecipes.ShapedRecipe) {
                if (PositionedStackOverride.areStacksReallySameTypeCrafting(irecipe.func_77571_b(), result)) {
                    recipe = new CachedShapedRecipeOverride((DynamicRecipes.ShapedRecipe)irecipe);
                }
            } else {
                if (!Common.overrideNEI) continue;
                if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) {
                    if (irecipe instanceof ShapedRecipes) {
                        recipe = new CachedShapedRecipeOverride((ShapedRecipes)irecipe);
                    } else if (irecipe instanceof ShapedOreRecipe) {
                        recipe = this.forgeShapedRecipe((ShapedOreRecipe)irecipe);
                    }
                }
            }
            if (recipe == null) continue;
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            CachedShapedRecipeOverride recipe = null;
            if (irecipe instanceof DynamicRecipes.ShapedRecipe) {
                recipe = new CachedShapedRecipeOverride((DynamicRecipes.ShapedRecipe)irecipe);
                if (!recipe.contains(recipe.ingredients, ingredient)) {
                    continue;
                }
            } else {
                if (!Common.overrideNEI) continue;
                if (irecipe instanceof ShapedRecipes) {
                    recipe = new CachedShapedRecipeOverride((ShapedRecipes)irecipe);
                } else if (irecipe instanceof ShapedOreRecipe) {
                    recipe = this.forgeShapedRecipe((ShapedOreRecipe)irecipe);
                }
            }
            if (recipe == null || !recipe.contains(recipe.ingredients, ingredient.func_77973_b())) continue;
            recipe.computeVisuals();
            if (!recipe.contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public class CachedShapedRecipeOverride
    extends ShapedRecipeHandler.CachedShapedRecipe {
        public CachedShapedRecipeOverride(ShapedRecipes recipe) {
            this(recipe.field_77576_b, recipe.field_77577_c, recipe.field_77574_d, recipe.func_77571_b());
        }

        public CachedShapedRecipeOverride(int width, int height, Object[] items, ItemStack out) {
            super((ShapedRecipeHandler)ShapedRecipeHandlerOverride.this, width, height, items, out);
            this.result = new PositionedStackOverride(out, 119, 24);
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    Object item = items[y * width + x];
                    if (item == null) continue;
                    PositionedStackOverride stack = new PositionedStackOverride(item, 25 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }
    }
}

