/*
 * Decompiled with CFR 0.152.
 */
package brad16840.plugins.nei;

import brad16840.common.Common;
import brad16840.common.DynamicRecipes;
import brad16840.plugins.nei.PositionedStackOverride;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ShapelessRecipeHandlerOverride
extends ShapelessRecipeHandler {
    private ShapelessRecipeHandler.CachedShapelessRecipe shapelessRecipe(ShapelessRecipes recipe) {
        if (recipe.field_77579_b != null) {
            try {
                return new CachedShapelessRecipeOverride(recipe.field_77579_b, recipe.func_77571_b());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getRecipeName() {
        String name = super.getRecipeName();
        if (!Common.overrideNEI) {
            name = name + "!";
        }
        return name;
    }

    public ShapelessRecipeHandler.CachedShapelessRecipe forgeShapelessRecipe(ShapelessOreRecipe recipe) {
        try {
            ArrayList items = recipe.getInput();
            for (Object item : items) {
                if (!(item instanceof List) || !((List)item).isEmpty()) continue;
                return null;
            }
            return new ShapelessRecipeHandler.CachedShapelessRecipe((ShapelessRecipeHandler)this, (List)items, recipe.func_77571_b());
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Error loading recipe: ", (Throwable)e);
            return null;
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (!outputId.equals("crafting") || ((Object)((Object)this)).getClass() != ShapelessRecipeHandlerOverride.class) {
            super.loadCraftingRecipes(outputId, results);
            return;
        }
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            ShapelessRecipeHandler.CachedShapelessRecipe recipe = null;
            if (irecipe instanceof DynamicRecipes.ShapelessRecipe) {
                recipe = this.shapelessRecipe((DynamicRecipes.ShapelessRecipe)irecipe);
            } else {
                if (!Common.overrideNEI) continue;
                if (irecipe instanceof ShapelessRecipes) {
                    recipe = this.shapelessRecipe((ShapelessRecipes)irecipe);
                } else if (irecipe instanceof ShapelessOreRecipe) {
                    recipe = this.forgeShapelessRecipe((ShapelessOreRecipe)irecipe);
                }
            }
            if (recipe == null) continue;
            this.arecipes.add(recipe);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            ShapelessRecipeHandler.CachedShapelessRecipe recipe = null;
            if (irecipe instanceof DynamicRecipes.ShapelessRecipe) {
                if (PositionedStackOverride.areStacksReallySameTypeCrafting(irecipe.func_77571_b(), result)) {
                    recipe = this.shapelessRecipe((DynamicRecipes.ShapelessRecipe)irecipe);
                }
            } else {
                if (!Common.overrideNEI) continue;
                if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) {
                    if (irecipe instanceof ShapelessRecipes) {
                        recipe = this.shapelessRecipe((ShapelessRecipes)irecipe);
                    } else if (irecipe instanceof ShapelessOreRecipe) {
                        recipe = this.forgeShapelessRecipe((ShapelessOreRecipe)irecipe);
                    }
                }
            }
            if (recipe == null) continue;
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            ShapelessRecipeHandler.CachedShapelessRecipe recipe = null;
            if (irecipe instanceof DynamicRecipes.ShapelessRecipe) {
                recipe = this.shapelessRecipe((DynamicRecipes.ShapelessRecipe)irecipe);
            } else {
                if (!Common.overrideNEI) continue;
                if (irecipe instanceof ShapelessRecipes) {
                    recipe = this.shapelessRecipe((ShapelessRecipes)irecipe);
                } else if (irecipe instanceof ShapelessOreRecipe) {
                    recipe = this.forgeShapelessRecipe((ShapelessOreRecipe)irecipe);
                }
            }
            if (recipe == null || !recipe.contains((Collection)recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation((Collection)recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public class CachedShapelessRecipeOverride
    extends ShapelessRecipeHandler.CachedShapelessRecipe {
        public CachedShapelessRecipeOverride(List<?> var1, ItemStack input) {
            super((ShapelessRecipeHandler)ShapelessRecipeHandlerOverride.this, var1, input);
        }

        public void setResult(ItemStack output) {
            this.result = new PositionedStackOverride(output, 119, 24);
        }

        public void setIngredients(List<?> items) {
            this.ingredients.clear();
            for (int ingred = 0; ingred < items.size(); ++ingred) {
                PositionedStackOverride stack = new PositionedStackOverride(items.get(ingred), 25 + ShapelessRecipeHandlerOverride.this.stackorder[ingred][0] * 18, 6 + ShapelessRecipeHandlerOverride.this.stackorder[ingred][1] * 18);
                stack.setMaxSize(1);
                this.ingredients.add(stack);
            }
        }
    }
}

