/*
 * Decompiled with CFR 0.152.
 */
package kuuu.more.nei;

import codechicken.core.ReflectionManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import kuuu.more.crafting.recipes.InventorTableCraftingManager;
import kuuu.more.gui.InventorTableGui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class InventorTableShapedRecipeHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "inventorcrafting", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return InventorTableGui.class;
    }

    public String getRecipeName() {
        return "Inventor's Table";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("inventorcrafting") && ((Object)((Object)this)).getClass() == InventorTableShapedRecipeHandler.class) {
            for (IRecipe irecipe : InventorTableCraftingManager.getInstance().getRecipeList()) {
                CachedShapedRecipe recipe = null;
                if (irecipe instanceof ShapedRecipes) {
                    recipe = new CachedShapedRecipe((ShapedRecipes)irecipe);
                } else if (irecipe instanceof ShapedOreRecipe) {
                    recipe = this.forgeShapedRecipe((ShapedOreRecipe)irecipe);
                }
                if (recipe == null) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IRecipe irecipe : InventorTableCraftingManager.getInstance().getRecipeList()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) continue;
            CachedShapedRecipe recipe = null;
            if (irecipe instanceof ShapedRecipes) {
                recipe = new CachedShapedRecipe((ShapedRecipes)irecipe);
            } else if (irecipe instanceof ShapedOreRecipe) {
                recipe = this.forgeShapedRecipe((ShapedOreRecipe)irecipe);
            }
            if (recipe == null) continue;
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRecipe irecipe : InventorTableCraftingManager.getInstance().getRecipeList()) {
            CachedShapedRecipe recipe = null;
            if (irecipe instanceof ShapedRecipes) {
                recipe = new CachedShapedRecipe((ShapedRecipes)irecipe);
            } else if (irecipe instanceof ShapedOreRecipe) {
                recipe = this.forgeShapedRecipe((ShapedOreRecipe)irecipe);
            }
            if (recipe == null || !recipe.contains(recipe.ingredients, ingredient.func_77973_b())) continue;
            recipe.computeVisuals();
            if (!recipe.contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public CachedShapedRecipe forgeShapedRecipe(ShapedOreRecipe recipe) {
        Object[] items;
        int height;
        int width;
        try {
            width = (Integer)ReflectionManager.getField(ShapedOreRecipe.class, Integer.class, (Object)recipe, (int)4);
            height = (Integer)ReflectionManager.getField(ShapedOreRecipe.class, Integer.class, (Object)recipe, (int)5);
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Error loading recipe", (Throwable)e);
            return null;
        }
        for (Object item : items = recipe.getInput()) {
            if (!(item instanceof List) || !((List)item).isEmpty()) continue;
            return null;
        }
        return new CachedShapedRecipe(width, height, items, recipe.func_77571_b());
    }

    public String getGuiTexture() {
        return new ResourceLocation("more:textures/gui/InventorTableGUI.png").toString();
    }

    public String getOverlayIdentifier() {
        return "inventorcrafting";
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return super.hasOverlay(gui, container, recipe) || this.isRecipe2x2(recipe) && RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)"inventorcrafting");
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        IRecipeOverlayRenderer renderer = super.getOverlayRenderer(gui, recipe);
        if (renderer != null) {
            return renderer;
        }
        IStackPositioner positioner = RecipeInfo.getStackPositioner((GuiContainer)gui, (String)"inventorcrafting");
        if (positioner == null) {
            return null;
        }
        return new DefaultOverlayRenderer(this.getIngredientStacks(recipe), positioner);
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        IOverlayHandler handler = super.getOverlayHandler(gui, recipe);
        if (handler != null) {
            return handler;
        }
        return RecipeInfo.getOverlayHandler((GuiContainer)gui, (String)"crafting2x2");
    }

    public boolean isRecipe2x2(int recipe) {
        for (PositionedStack stack : this.getIngredientStacks(recipe)) {
            if (stack.relx <= 43 && stack.rely <= 24) continue;
            return false;
        }
        return true;
    }

    public class CachedShapedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public CachedShapedRecipe(int width, int height, Object[] items, ItemStack out) {
            super((TemplateRecipeHandler)InventorTableShapedRecipeHandler.this);
            this.result = new PositionedStack((Object)out, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(width, height, items);
        }

        public CachedShapedRecipe(ShapedRecipes recipe) {
            this(recipe.field_77576_b, recipe.field_77577_c, recipe.field_77574_d, recipe.func_77571_b());
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(InventorTableShapedRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
        }
    }
}

