/*
 * Decompiled with CFR 0.152.
 */
package kuuu.more.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kuuu.more.crafting.recipes.InventorTableCraftingManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class InventorTableShapelessRecipeHandler
extends ShapedRecipeHandler {
    public int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {0, 1}, {1, 1}, {0, 2}, {1, 2}, {2, 0}, {2, 1}, {2, 2}};

    public String getRecipeName() {
        return "Inventor's Table Shapeless";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("inventorshapelesscrafting") && ((Object)((Object)this)).getClass() == InventorTableShapelessRecipeHandler.class) {
            List allrecipes = InventorTableCraftingManager.getInstance().getRecipeList();
            for (IRecipe irecipe : allrecipes) {
                CachedShapelessRecipe recipe = null;
                if (irecipe instanceof ShapelessRecipes) {
                    recipe = this.shapelessRecipe((ShapelessRecipes)irecipe);
                } else if (irecipe instanceof ShapelessOreRecipe) {
                    recipe = this.forgeShapelessRecipe((ShapelessOreRecipe)irecipe);
                }
                if (recipe == null) continue;
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List allrecipes = InventorTableCraftingManager.getInstance().getRecipeList();
        for (IRecipe irecipe : allrecipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) continue;
            CachedShapelessRecipe recipe = null;
            if (irecipe instanceof ShapelessRecipes) {
                recipe = this.shapelessRecipe((ShapelessRecipes)irecipe);
            } else if (irecipe instanceof ShapelessOreRecipe) {
                recipe = this.forgeShapelessRecipe((ShapelessOreRecipe)irecipe);
            }
            if (recipe == null) continue;
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List allrecipes = InventorTableCraftingManager.getInstance().getRecipeList();
        for (IRecipe irecipe : allrecipes) {
            CachedShapelessRecipe recipe = null;
            if (irecipe instanceof ShapelessRecipes) {
                recipe = this.shapelessRecipe((ShapelessRecipes)irecipe);
            } else if (irecipe instanceof ShapelessOreRecipe) {
                recipe = this.forgeShapelessRecipe((ShapelessOreRecipe)irecipe);
            }
            if (recipe == null || !recipe.contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    private CachedShapelessRecipe shapelessRecipe(ShapelessRecipes recipe) {
        if (recipe.field_77579_b == null) {
            return null;
        }
        return new CachedShapelessRecipe(recipe.field_77579_b, recipe.func_77571_b());
    }

    public CachedShapelessRecipe forgeShapelessRecipe(ShapelessOreRecipe recipe) {
        ArrayList items = recipe.getInput();
        for (Object item : items) {
            if (!(item instanceof List) || !((List)item).isEmpty()) continue;
            return null;
        }
        return new CachedShapelessRecipe(items, recipe.func_77571_b());
    }

    public boolean isRecipe2x2(int recipe) {
        return this.getIngredientStacks(recipe).size() <= 4;
    }

    public class CachedShapelessRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public CachedShapelessRecipe() {
            super((TemplateRecipeHandler)InventorTableShapelessRecipeHandler.this);
            this.ingredients = new ArrayList();
        }

        public CachedShapelessRecipe(ItemStack output) {
            this();
            this.setResult(output);
        }

        public CachedShapelessRecipe(Object[] input, ItemStack output) {
            this(Arrays.asList(input), output);
        }

        public CachedShapelessRecipe(List<?> input, ItemStack output) {
            this(output);
            this.setIngredients(input);
        }

        public void setIngredients(List<?> items) {
            this.ingredients.clear();
            for (int ingred = 0; ingred < items.size(); ++ingred) {
                PositionedStack stack = new PositionedStack(items.get(ingred), 25 + InventorTableShapelessRecipeHandler.this.stackorder[ingred][0] * 18, 6 + InventorTableShapelessRecipeHandler.this.stackorder[ingred][1] * 18);
                stack.setMaxSize(1);
                this.ingredients.add(stack);
            }
        }

        public void setResult(ItemStack output) {
            this.result = new PositionedStack((Object)output, 119, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(InventorTableShapelessRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

