/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs;

import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.EntityFear;
import lycanite.lycanitesmobs.api.network.MessageEntityPickedUp;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedEntity
implements IExtendedEntityProperties {
    public static String EXT_PROP_NAME = "LycanitesMobsEntity";
    public static String[] FORCE_REMOVE_ENTITY_IDS;
    public static int FORCE_REMOVE_ENTITY_TICKS;
    public Entity entity;
    public Entity pickedUpByEntity;
    private int pickedUpByEntityID;
    double[] lastSafePos;
    private boolean playerAllowFlyingSnapshot;
    private boolean playerIsFlyingSnapshot;
    public EntityFear fearEntity;
    boolean forceRemoveChecked = false;
    boolean forceRemove = false;
    int forceRemoveTicks = FORCE_REMOVE_ENTITY_TICKS;

    public static ExtendedEntity getForEntity(Entity entity) {
        if (entity == null) {
            return null;
        }
        IExtendedEntityProperties entityIExt = entity.getExtendedProperties(EXT_PROP_NAME);
        ExtendedEntity entityExt = entityIExt != null ? (ExtendedEntity)entityIExt : new ExtendedEntity(entity);
        return entityExt;
    }

    public ExtendedEntity(Entity entity) {
        entity.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)this);
    }

    public void init(Entity entity, World world) {
        this.entity = entity;
    }

    public void onUpdate() {
        if (this.entity == null) {
            return;
        }
        if (this.entity.field_70170_p != null && !this.entity.field_70170_p.field_72995_K && FORCE_REMOVE_ENTITY_IDS != null && FORCE_REMOVE_ENTITY_IDS.length > 0 && !this.forceRemoveChecked) {
            LycanitesMobs.printDebug("ForceRemoveEntity", "Forced entity removal, checking: " + this.entity.func_70005_c_());
            for (String forceRemoveID : FORCE_REMOVE_ENTITY_IDS) {
                if (!forceRemoveID.equalsIgnoreCase(this.entity.func_70005_c_())) continue;
                this.forceRemove = true;
                break;
            }
            this.forceRemoveChecked = true;
        }
        if (this.forceRemove && this.forceRemoveTicks-- <= 0) {
            this.entity.func_70106_y();
        }
        if (this.lastSafePos == null) {
            this.lastSafePos = new double[]{this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v};
        }
        if (this.entity.field_70145_X || !this.entity.func_70094_T()) {
            this.lastSafePos[0] = this.entity.field_70165_t;
            this.lastSafePos[1] = this.entity.field_70163_u;
            this.lastSafePos[2] = this.entity.field_70161_v;
        }
        if (this.pickedUpByEntity != null) {
            if (!this.pickedUpByEntity.func_70089_S()) {
                this.setPickedUpByEntity(null);
            } else if (this.pickedUpByEntity instanceof EntityLivingBase) {
                if (((EntityLivingBase)this.pickedUpByEntity).func_110143_aJ() <= 0.0f) {
                    this.setPickedUpByEntity(null);
                }
            } else if (this.entity instanceof EntityLivingBase && ObjectManager.getPotionEffect("weight") != null) {
                if (((EntityLivingBase)this.entity).func_70644_a((Potion)ObjectManager.getPotionEffect("weight"))) {
                    this.setPickedUpByEntity(null);
                }
            } else if (this.entity.func_70068_e(this.pickedUpByEntity) > 32.0) {
                this.setPickedUpByEntity(null);
            }
        }
        if (this.pickedUpByEntity != null) {
            double[] pickupOffset = new double[]{0.0, 0.0, 0.0};
            if (this.pickedUpByEntity instanceof EntityCreatureBase) {
                pickupOffset = ((EntityCreatureBase)this.pickedUpByEntity).getPickupOffset(this.entity);
            }
            double yPos = this.pickedUpByEntity.field_70163_u;
            if (this.entity.field_70170_p.field_72995_K && this.entity instanceof EntityPlayer) {
                yPos = this.pickedUpByEntity.field_70121_D.field_72338_b + (double)this.entity.field_70131_O;
            }
            this.entity.func_70107_b(this.pickedUpByEntity.field_70165_t + pickupOffset[0], yPos + pickupOffset[1], this.pickedUpByEntity.field_70161_v + pickupOffset[2]);
            this.entity.field_70159_w = this.pickedUpByEntity.field_70159_w;
            this.entity.field_70181_x = this.pickedUpByEntity.field_70181_x;
            this.entity.field_70179_y = this.pickedUpByEntity.field_70179_y;
            this.entity.field_70143_R = 0.0f;
            if (!this.entity.field_70170_p.field_72995_K && this.entity instanceof EntityPlayer) {
                ((EntityPlayer)this.entity).field_71075_bZ.field_75101_c = true;
            }
            if (!this.entity.func_70089_S()) {
                this.setPickedUpByEntity(null);
            }
            if (this.entity instanceof EntityLivingBase && ((EntityLivingBase)this.entity).func_110143_aJ() <= 0.0f) {
                this.setPickedUpByEntity(null);
            }
        } else if (this.pickedUpByEntityID != (this.pickedUpByEntity != null ? this.pickedUpByEntity.func_145782_y() : 0)) {
            int n = this.pickedUpByEntityID = this.pickedUpByEntity != null ? this.pickedUpByEntity.func_145782_y() : 0;
        }
        if (this.fearEntity != null && !this.fearEntity.func_70089_S()) {
            this.fearEntity = null;
        }
    }

    public void onDeath() {
        this.setPickedUpByEntity(null);
    }

    public void setPickedUpByEntity(Entity pickedUpByEntity) {
        if (this.pickedUpByEntity == pickedUpByEntity || this.entity == null) {
            return;
        }
        if (this.entity.field_70154_o != null) {
            this.entity.func_70078_a(null);
        }
        if (this.entity.field_70153_n != null) {
            this.entity.field_70153_n.func_70078_a(null);
        }
        this.pickedUpByEntity = pickedUpByEntity;
        if (!this.entity.field_70170_p.field_72995_K) {
            if (this.entity instanceof EntityPlayer) {
                if (pickedUpByEntity != null) {
                    this.playerAllowFlyingSnapshot = ((EntityPlayer)this.entity).field_71075_bZ.field_75101_c;
                    this.playerIsFlyingSnapshot = ((EntityPlayer)this.entity).field_71075_bZ.field_75100_b;
                } else {
                    ((EntityPlayer)this.entity).field_71075_bZ.field_75101_c = this.playerAllowFlyingSnapshot;
                    ((EntityPlayer)this.entity).field_71075_bZ.field_75100_b = this.playerIsFlyingSnapshot;
                }
            }
            if (pickedUpByEntity == null) {
                if (this.lastSafePos != null && this.lastSafePos.length >= 3) {
                    this.entity.func_70107_b(this.lastSafePos[0], this.lastSafePos[1], this.lastSafePos[2]);
                }
                this.entity.field_70159_w = 0.0;
                this.entity.field_70181_x = 0.0;
                this.entity.field_70179_y = 0.0;
                this.entity.field_70143_R = 0.0f;
            }
            MessageEntityPickedUp message = new MessageEntityPickedUp(this.entity, pickedUpByEntity);
            LycanitesMobs.packetHandler.sendToDimension(message, this.entity.field_71093_bK);
        }
    }

    public boolean isFeared() {
        return this.pickedUpByEntity instanceof EntityFear;
    }

    public void loadNBTData(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_150297_b("ActiveEffects", 9)) {
            NBTTagList nbttaglist = nbtTagCompound.func_150295_c("ActiveEffects", 9);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                byte potionID = nbttagcompound1.func_74771_c("Id");
                if (potionID < Potion.field_76425_a.length && Potion.field_76425_a[potionID] != null) continue;
                nbttaglist.func_74744_a(i);
                LycanitesMobs.printWarning("EffectsSetup", "Found a null potion effect in entity NBTTag, this effect has been removed.");
            }
        }
    }

    public void saveNBTData(NBTTagCompound nbtTagCompound) {
    }

    static {
        FORCE_REMOVE_ENTITY_TICKS = 40;
    }
}

