/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs;

import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.PotionBase;
import lycanite.lycanitesmobs.Utilities;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.info.EntityListCustom;
import lycanite.lycanitesmobs.api.info.GroupInfo;
import lycanite.lycanitesmobs.api.info.MobInfo;
import lycanite.lycanitesmobs.api.info.ObjectLists;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;

public class ObjectManager {
    public static Map<String, Block> blocks = new HashMap<String, Block>();
    public static Map<String, Fluid> fluids = new HashMap<String, Fluid>();
    public static Map<Block, Item> buckets = new HashMap<Block, Item>();
    public static Map<String, Item> items = new HashMap<String, Item>();
    public static Map<String, Class> tileEntities = new HashMap<String, Class>();
    public static Map<String, PotionBase> potionEffects = new HashMap<String, PotionBase>();
    public static Map<String, EntityListCustom> entityLists = new HashMap<String, EntityListCustom>();
    public static Map<String, MobInfo> mobs = new HashMap<String, MobInfo>();
    public static Map<String, Class> projectiles = new HashMap<String, Class>();
    public static Map<String, DamageSource> damageSources = new HashMap<String, DamageSource>();
    public static Map<String, Achievement> achievements = new HashMap<String, Achievement>();
    public static GroupInfo currentGroup;

    public static void setCurrentGroup(GroupInfo group) {
        currentGroup = group;
    }

    public static Block addBlock(String name, Block block) {
        name = name.toLowerCase();
        blocks.put(name, block);
        GameRegistry.registerBlock((Block)block, (String)name);
        return block;
    }

    public static Fluid addFluid(Fluid fluid) {
        String name = fluid.getUnlocalizedName().toLowerCase();
        fluids.put(name, fluid);
        FluidRegistry.registerFluid((Fluid)fluid);
        return fluid;
    }

    public static Item addBucket(Item bucket, Block block, Fluid fluid) {
        buckets.put(block, bucket);
        FluidContainerRegistry.registerFluidContainer((Fluid)fluid, (ItemStack)new ItemStack(bucket), (ItemStack)new ItemStack(Items.field_151133_ar));
        return bucket;
    }

    public static Item addItem(String name, Item item) {
        name = name.toLowerCase();
        items.put(name, item);
        if (currentGroup != null) {
            GameRegistry.registerItem((Item)item, (String)name, (String)ObjectManager.currentGroup.name);
        }
        return item;
    }

    public static Item addItem(String name, Item item, int weight, int minAmount, int maxAmount) {
        Utilities.addDungeonLoot(new ItemStack(item), minAmount, maxAmount, weight);
        Utilities.addStrongholdLoot(new ItemStack(item), minAmount, maxAmount, weight * 2);
        Utilities.addVillageLoot(new ItemStack(item), minAmount, maxAmount, weight);
        return ObjectManager.addItem(name, item);
    }

    public static Class addTileEntity(String name, Class tileEntityClass) {
        name = name.toLowerCase();
        tileEntities.put(name, tileEntityClass);
        GameRegistry.registerTileEntity((Class)tileEntityClass, (String)("lycanitesmobs." + name));
        return tileEntityClass;
    }

    public static PotionBase addPotionEffect(String name, ConfigBase config, boolean isBad, int color, int iconX, int iconY, boolean goodEffect) {
        int effectIDOverride = config.getInt("Potion Effects", name + " Effect Override ID", 0);
        name = name.toLowerCase();
        PotionBase potion = effectIDOverride > 0 ? new PotionBase(effectIDOverride, "potion." + name, isBad, color) : new PotionBase("potion." + name, isBad, color);
        potion.func_76399_b(iconX, iconY);
        potionEffects.put(name, potion);
        ObjectLists.addEffect(goodEffect ? "buffs" : "debuffs", potion);
        return potion;
    }

    public static MobInfo addMob(MobInfo mobInfo) {
        GroupInfo group = mobInfo.group;
        String name = mobInfo.name.toLowerCase();
        mobs.put(name, mobInfo);
        AssetManager.addSound(name + "_say", group, "entity." + name + ".say");
        AssetManager.addSound(name + "_hurt", group, "entity." + name + ".hurt");
        AssetManager.addSound(name + "_death", group, "entity." + name + ".death");
        AssetManager.addSound(name + "_step", group, "entity." + name + ".step");
        AssetManager.addSound(name + "_attack", group, "entity." + name + ".attack");
        AssetManager.addSound(name + "_jump", group, "entity." + name + ".jump");
        AssetManager.addSound(name + "_fly", group, "entity." + name + ".fly");
        AssetManager.addSound(name + "_tame", group, "entity." + name + ".tame");
        AssetManager.addSound(name + "_beg", group, "entity." + name + ".beg");
        AssetManager.addSound(name + "_eat", group, "entity." + name + ".eat");
        AssetManager.addSound(name + "_mount", group, "entity." + name + ".mount");
        return mobInfo;
    }

    public static void addProjectile(String name, Class entityClass, int updateFrequency) {
        name = name.toLowerCase();
        GroupInfo group = currentGroup;
        AssetManager.addSound(name, group, "projectile." + name);
        int projectileID = group.getNextProjectileID();
        EntityRegistry.registerModEntity((Class)entityClass, (String)name, (int)projectileID, (Object)group.mod, (int)64, (int)updateFrequency, (boolean)true);
        projectiles.put(name, entityClass);
    }

    public static void addProjectile(String name, Class entityClass) {
        ObjectManager.addProjectile(name, entityClass, 1);
    }

    public static void addProjectile(String name, Class entityClass, Item item, BehaviorProjectileDispense dispenseBehaviour) {
        name = name.toLowerCase();
        ObjectManager.addProjectile(name, entityClass);
        BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)dispenseBehaviour);
    }

    public static void addDamageSource(String name, DamageSource damageSource) {
        name = name.toLowerCase();
        damageSources.put(name, damageSource);
    }

    public static void addAchievement(String name, Achievement achievement) {
        if (achievements.containsKey(name = name.toLowerCase())) {
            return;
        }
        achievement.func_75971_g();
        achievements.put(name, achievement);
    }

    public static Block getBlock(String name) {
        if (!blocks.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return blocks.get(name);
    }

    public static Item getItem(String name) {
        if (!items.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return items.get(name);
    }

    public static Class getTileEntity(String name) {
        if (!tileEntities.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return tileEntities.get(name);
    }

    public static PotionBase getPotionEffect(String name) {
        if (!potionEffects.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return potionEffects.get(name);
    }

    public static Class getMob(String mobName) {
        if (!mobs.containsKey(mobName = mobName.toLowerCase())) {
            return null;
        }
        return ObjectManager.mobs.get((Object)mobName).entityClass;
    }

    public static MobInfo getMobInfo(String mobName) {
        if (!mobs.containsKey(mobName = mobName.toLowerCase())) {
            return null;
        }
        return mobs.get(mobName);
    }

    public static DamageSource getDamageSource(String name) {
        if (!damageSources.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return damageSources.get(name);
    }

    public static Achievement getAchievement(String name) {
        if (!achievements.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return achievements.get(name);
    }
}

