/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.entity;

import Reika.RotaryCraft.API.Interfaces.FlyingMob;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.ExtendedEntity;
import lycanite.lycanitesmobs.ExtendedWorld;
import lycanite.lycanitesmobs.GuiHandler;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.entity.BossHealth;
import lycanite.lycanitesmobs.api.entity.EntityFear;
import lycanite.lycanitesmobs.api.entity.EntityHitArea;
import lycanite.lycanitesmobs.api.entity.EntityItemCustom;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIMoveRestriction;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRevenge;
import lycanite.lycanitesmobs.api.entity.ai.FlightNavigator;
import lycanite.lycanitesmobs.api.info.AltarInfo;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.api.info.ExtraMobBehaviour;
import lycanite.lycanitesmobs.api.info.GroupInfo;
import lycanite.lycanitesmobs.api.info.MobInfo;
import lycanite.lycanitesmobs.api.info.SpawnInfo;
import lycanite.lycanitesmobs.api.info.Subspecies;
import lycanite.lycanitesmobs.api.inventory.ContainerCreature;
import lycanite.lycanitesmobs.api.inventory.InventoryCreature;
import lycanite.lycanitesmobs.api.pets.PetEntry;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class EntityCreatureBase
extends EntityLiving
implements FlyingMob {
    public static Map<Class, Double> baseHealthMap = new HashMap<Class, Double>();
    public MobInfo mobInfo;
    public GroupInfo group;
    public Subspecies subspecies = null;
    public EnumCreatureAttribute attribute = EnumCreatureAttribute.UNDEAD;
    public ExtraMobBehaviour extraMobBehaviour;
    public String spawnEventType = "";
    public int spawnEventCount = -1;
    public PetEntry petEntry;
    public boolean altarSummoned = false;
    public boolean forceBossHealthBar = false;
    public long updateTick = 0L;
    public float setWidth = 0.6f;
    public float setDepth = 0.6f;
    public float setHeight = 1.8f;
    public double sizeScale = 1.0;
    public EntityHitArea[][][] hitAreas;
    public float hitAreaScale = 1.0f;
    public int defense = 0;
    public int experience = 5;
    public byte attackPhase = 0;
    public byte attackPhaseMax = 0;
    public int fleeTime = 200;
    public int currentFleeTime = 0;
    public float fleeHealthPercent = 0.0f;
    public int battlePhase = 0;
    public int damageMax = 0;
    public boolean boss = false;
    public int bossRange = 60;
    public boolean isHostileByDefault = true;
    public boolean spreadFire = false;
    public boolean stealthPrev = false;
    public int currentBlockingTime = 0;
    public int blockingTime = 60;
    public Entity pickupEntity;
    private ChunkCoordinates homePosition = new ChunkCoordinates(0, 0, 0);
    private float homeDistanceMax = -1.0f;
    public boolean firstSpawn = true;
    public SpawnTypeBase spawnedFromType = null;
    public boolean spawnsInBlock = false;
    public boolean spawnsUnderground = true;
    public boolean spawnsOnLand = true;
    public boolean spawnsInWater = false;
    public boolean isLavaCreature = false;
    public boolean isMinion = false;
    public boolean isTemporary = false;
    public int temporaryDuration = 0;
    public boolean forceNoDespawn = false;
    public boolean spawnedRare = false;
    private boolean leashAIActive = false;
    private EntityAIBase leashMoveTowardsRestrictionAI = new EntityAIMoveRestriction(this);
    public FlightNavigator flightNavigator;
    private EntityLivingBase masterTarget;
    private EntityLivingBase parentTarget;
    private EntityLivingBase avoidTarget;
    public List<EntityPlayer> guiViewers = new ArrayList<EntityPlayer>();
    public int guiRefreshTick = 0;
    public int guiRefreshTime = 2;
    public short justAttacked = 0;
    public short justAttackedTime = (short)5;
    public boolean hasAttackSound = false;
    public boolean hasStepSound = true;
    public boolean hasJumpSound = false;
    public int flySoundSpeed = 0;
    public boolean extraAnimation01 = false;
    protected BossHealth bossHealth;
    private static byte watcherID = (byte)12;
    public boolean initiated = false;
    public InventoryCreature inventory;
    public List<DropRate> drops = new ArrayList<DropRate>();
    public EntityAITargetAttack aiTargetPlayer = new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class);
    public EntityAITargetRevenge aiDefendAnimals = new EntityAITargetRevenge(this).setHelpClasses(IAnimals.class);

    public EntityCreatureBase(World world) {
        super(world);
    }

    public void setupMob() {
        this.updateSize();
        this.field_70138_W = 0.5f;
        this.field_70728_aV = this.experience;
        this.inventory = new InventoryCreature(this.func_70005_c_(), this);
        if (this.mobInfo.defaultDrops) {
            this.loadItemDrops();
        }
        this.loadCustomDrops();
        this.field_70728_aV = this.experience;
        this.field_70178_ae = !this.canBurn();
    }

    public void loadItemDrops() {
    }

    public void loadCustomDrops() {
        for (DropRate drop : this.mobInfo.customDrops) {
            DropRate newDrop = new DropRate(drop.item.func_77946_l(), drop.chance).setMinAmount(drop.minAmount).setMaxAmount(drop.maxAmount).setChance(drop.chance).setSubspecies(drop.subspeciesID).setBurningDrop(drop.burningItem);
            this.drops.add(newDrop);
        }
    }

    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 0.0);
        baseAttributes.put("movementSpeed", 0.0);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 0.0);
        baseAttributes.put("attackDamage", 0.0);
        this.applyEntityAttributes(baseAttributes);
    }

    protected void applyEntityAttributes(HashMap<String, Double> baseAttributes) {
        this.mobInfo = MobInfo.mobClassToInfo.get(this.getClass());
        this.group = this.mobInfo.group;
        this.extraMobBehaviour = new ExtraMobBehaviour(this);
        this.flightNavigator = new FlightNavigator(this);
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        if (baseAttributes.containsKey("maxHealth")) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(baseAttributes.get("maxHealth") * this.getHealthMultiplier() + (double)this.getHealthBoost());
            baseHealthMap.put(this.getClass(), baseAttributes.get("maxHealth"));
        }
        if (baseAttributes.containsKey("movementSpeed")) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseAttributes.get("movementSpeed").doubleValue());
        }
        if (baseAttributes.containsKey("knockbackResistance")) {
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(baseAttributes.get("knockbackResistance").doubleValue());
        }
        if (baseAttributes.containsKey("followRange")) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(baseAttributes.get("followRange").doubleValue());
        }
        if (baseAttributes.containsKey("attackDamage")) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(baseAttributes.get("attackDamage").doubleValue());
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a((int)WATCHER_ID.TARGET.id, (Object)0);
        this.field_70180_af.func_75682_a((int)WATCHER_ID.ATTACK_PHASE.id, (Object)0);
        this.field_70180_af.func_75682_a((int)WATCHER_ID.ANIMATION.id, (Object)0);
        this.field_70180_af.func_75682_a((int)WATCHER_ID.CLIMBING.id, (Object)0);
        this.field_70180_af.func_75682_a((int)WATCHER_ID.STEALTH.id, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a((int)WATCHER_ID.COLOR.id, (Object)0);
        this.field_70180_af.func_75682_a((int)WATCHER_ID.SIZE.id, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_75682_a((int)WATCHER_ID.SUBSPECIES.id, (Object)0);
        this.initiated = true;
    }

    public String getConfigName() {
        return this.mobInfo.name;
    }

    public String func_70005_c_() {
        if (this.func_94056_bM()) {
            return this.func_94057_bL();
        }
        return this.getFullName();
    }

    public String getFullName() {
        String name = "";
        if (!"".equals(this.getAgeName())) {
            name = name + this.getAgeName() + " ";
        }
        if (!"".equals(this.getSubspeciesTitle())) {
            name = name + this.getSubspeciesTitle() + " ";
        }
        return name + this.getSpeciesName();
    }

    public String getSpeciesName() {
        String entityName = EntityList.func_75621_b((Entity)this);
        if (entityName == null) {
            return "Creature";
        }
        return StatCollector.func_74838_a((String)("entity." + entityName + ".name"));
    }

    public String getSubspeciesTitle() {
        if (this.getSubspecies() != null) {
            return this.getSubspecies().getTitle();
        }
        return "";
    }

    public String getAgeName() {
        return "";
    }

    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        return this.spawnCheck(this.field_70170_p, i, j, k);
    }

    public boolean spawnCheck(World world, int i, int j, int k) {
        if (world.field_72995_K) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", " ~O==================== Spawn Check: " + this.getConfigName() + " ====================O~");
        LycanitesMobs.printDebug("MobSpawns", "Attempting to Spawn: " + this.getConfigName());
        LycanitesMobs.printDebug("MobSpawns", "Checking for peaceful difficulty...");
        if (!this.mobInfo.peacefulDifficulty && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Target Spawn Location: x" + i + " y" + j + " z" + k);
        LycanitesMobs.printDebug("MobSpawns", "Fixed spawn check (light level, obstacles, etc)...");
        if (!this.fixedSpawnCheck(world, i, j, k)) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Checking for nearby spawner...");
        if (this.isSpawnerNearby(world, i, j, k)) {
            LycanitesMobs.printDebug("MobSpawns", "Spawner found, skpping other checks.");
            LycanitesMobs.printDebug("MobSpawns", "Spawn Check Passed!");
            return true;
        }
        LycanitesMobs.printDebug("MobSpawns", "No spawner found.");
        LycanitesMobs.printDebug("MobSpawns", "Natural spawn check (dimension, area limit, ground type, water, lava, underground)...");
        if (!this.naturalSpawnCheck(world, i, j, k)) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "All enviroment checks passed.");
        if (this.mobInfo.spawnInfo.spawnChance < 1.0) {
            if (this.mobInfo.spawnInfo.spawnChance <= 0.0) {
                LycanitesMobs.printDebug("MobSpawns", "Applying Forced Spawn Chance - Chance is 0 = No Spawning");
                return false;
            }
            double spawnRoll = this.field_70146_Z.nextDouble();
            LycanitesMobs.printDebug("MobSpawns", "Applying Forced Spawn Chance - Rolled: " + spawnRoll + " Must be less than: " + this.mobInfo.spawnInfo.spawnChance);
            if (spawnRoll > this.mobInfo.spawnInfo.spawnChance) {
                return false;
            }
        }
        LycanitesMobs.printDebug("MobSpawns", "Spawn Check Passed!");
        return true;
    }

    public boolean fixedSpawnCheck(World world, int i, int j, int k) {
        if (this.spawnedFromType == null || this.spawnedFromType != null && !this.spawnedFromType.ignoreLight) {
            byte light = this.testLightLevel(i, j, k);
            boolean validLight = false;
            Block spawnBlock = world.func_147439_a(i, j, k);
            LycanitesMobs.printDebug("MobSpawns", "Checking light level: Darkness");
            if (this.mobInfo.spawnInfo.spawnsInDark && light <= 1) {
                validLight = true;
            }
            LycanitesMobs.printDebug("MobSpawns", "Checking light level: Lightness");
            if (this.mobInfo.spawnInfo.spawnsInLight && light >= 2) {
                validLight = true;
            }
            if (!validLight) {
                return false;
            }
        }
        LycanitesMobs.printDebug("MobSpawns", "Checking entity collision.");
        if (!this.field_70170_p.func_72855_b(this.field_70121_D)) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Checking solid block collision.");
        return this.spawnsInBlock || this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty();
    }

    public boolean naturalSpawnCheck(World world, int i, int j, int k) {
        LycanitesMobs.printDebug("MobSpawns", "Checking dimension.");
        if (!this.isNativeDimension(this.field_70170_p)) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Block preference.");
        if (this.getBlockPathWeight(i, j, k) < 0.0f && this.spawnedFromType == null) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Checking for liquid (water, lava, ooze, etc).");
        if (!this.spawnsInWater && this.field_70170_p.func_72953_d(this.field_70121_D)) {
            return false;
        }
        if (!this.spawnsOnLand && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Checking for underground.");
        if (!this.spawnsUnderground && this.isBlockUnderground(i, j + 1, k)) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Checking required blocks.");
        if (!this.spawnBlockCheck(world, i, j, k)) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Counting mobs of the same kind, max allowed is: " + this.mobInfo.spawnInfo.spawnAreaLimit);
        if (!this.spawnLimitCheck(world, i, j, k)) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Checking for nearby bosses.");
        List bosses = this.getNearbyEntities(IBossDisplayData.class, SpawnInfo.spawnLimitRange);
        return bosses.size() <= 0;
    }

    public boolean isNativeDimension(World world) {
        if (this.spawnedFromType != null && this.spawnedFromType.ignoreDimension) {
            LycanitesMobs.printDebug("MobSpawns", "Dimension check is ignored by " + this.spawnedFromType.typeName + " spawn type.");
            return true;
        }
        if (world == null || world.field_73011_w == null || this.mobInfo == null || this.mobInfo.spawnInfo == null || this.mobInfo.spawnInfo.dimensionTypes == null) {
            LycanitesMobs.printDebug("MobSpawns", "No dimension spawn settings were found for this mob, defaulting to valid.");
            return true;
        }
        for (String spawnDimensionType : this.mobInfo.spawnInfo.dimensionTypes) {
            if ("ALL".equalsIgnoreCase(spawnDimensionType)) {
                LycanitesMobs.printDebug("MobSpawns", "All dimensions allowed.");
                return true;
            }
            if ("VANILLA".equalsIgnoreCase(spawnDimensionType)) {
                LycanitesMobs.printDebug("MobSpawns", "Vanilla only: Overworld, Nether and End.");
                return world.field_73011_w.field_76574_g > -2 && world.field_73011_w.field_76574_g < 2;
            }
            if (!"GROUP".equalsIgnoreCase(spawnDimensionType)) continue;
            for (String groupSpawnDimensionType : this.mobInfo.group.dimensionTypes) {
                if ("ALL".equalsIgnoreCase(groupSpawnDimensionType)) {
                    LycanitesMobs.printDebug("MobSpawns", "All dimensions allowed by group.");
                    return true;
                }
                if (!"VANILLA".equalsIgnoreCase(groupSpawnDimensionType)) continue;
                LycanitesMobs.printDebug("MobSpawns", "Vanilla only by group: Overworld, Nether and End.");
                return world.field_73011_w.field_76574_g > -2 && world.field_73011_w.field_76574_g < 2;
            }
            for (int spawnDimension : this.mobInfo.group.dimensionBlacklist) {
                if (world.field_73011_w.field_76574_g != spawnDimension) continue;
                LycanitesMobs.printDebug("MobSpawns", "Dimension is in group " + (this.mobInfo.group.dimensionWhitelist ? "whitelist, allowed" : "blacklist, not allowed") + ".");
                return this.mobInfo.group.dimensionWhitelist;
            }
            if (this.mobInfo.spawnInfo.dimensionBlacklist != null && this.mobInfo.spawnInfo.dimensionBlacklist.length != 0) continue;
            LycanitesMobs.printDebug("MobSpawns", "Dimension was not in group " + (this.mobInfo.group.dimensionWhitelist ? "whitelist, not allowed" : "blacklist, allowed") + " and there are no entries in the mob specific black/whitelist.");
            return !this.mobInfo.group.dimensionWhitelist;
        }
        for (int spawnDimension : this.mobInfo.spawnInfo.dimensionBlacklist) {
            if (world.field_73011_w.field_76574_g != spawnDimension) continue;
            LycanitesMobs.printDebug("MobSpawns", "Dimension is in " + (this.mobInfo.spawnInfo.dimensionWhitelist ? "whitelist, allowed" : "blacklist, not allowed") + ".");
            return this.mobInfo.spawnInfo.dimensionWhitelist;
        }
        LycanitesMobs.printDebug("MobSpawns", "Dimension was not in " + (this.mobInfo.spawnInfo.dimensionWhitelist ? "whitelist, not allowed" : "blacklist, allowed") + ".");
        return !this.mobInfo.spawnInfo.dimensionWhitelist;
    }

    public boolean spawnLimitCheck(World world, int i, int j, int k) {
        int spawnLimit = this.mobInfo.spawnInfo.spawnAreaLimit;
        double range = SpawnInfo.spawnLimitRange;
        LycanitesMobs.printDebug("MobSpawns", "Checking spawn area limit. Limit of: " + spawnLimit + " Range of: " + range);
        if (spawnLimit > 0 && range > 0.0) {
            List targets = this.getNearbyEntities(this.mobInfo.entityClass, range);
            LycanitesMobs.printDebug("MobSpawns", "Found " + targets.size() + " of this mob within the radius (class is " + this.mobInfo.entityClass + ").");
            if (targets.size() >= spawnLimit) {
                return false;
            }
        }
        return true;
    }

    public boolean spawnBlockCheck(World world, int x, int y, int z) {
        if (this.spawnedFromType != null) {
            SpawnInfo cfr_ignored_0 = this.mobInfo.spawnInfo;
            if (SpawnInfo.enforceBlockCost) {
                Block block;
                int k;
                int j;
                int i;
                int blocksFound = 0;
                if (this.spawnedFromType.materials != null) {
                    for (i = x - this.spawnedFromType.range; i <= x + this.spawnedFromType.range; ++i) {
                        for (j = y - this.spawnedFromType.range; j <= y + this.spawnedFromType.range; ++j) {
                            for (k = z - this.spawnedFromType.range; k <= z + this.spawnedFromType.range; ++k) {
                                Material blockMaterial = world.func_147439_a(i, j, k).func_149688_o();
                                for (Material material : this.spawnedFromType.materials) {
                                    if (blockMaterial != material || ++blocksFound < this.mobInfo.spawnInfo.spawnBlockCost) continue;
                                    return true;
                                }
                            }
                        }
                    }
                }
                if (this.spawnedFromType.blocks != null) {
                    for (i = x - this.spawnedFromType.range; i <= x + this.spawnedFromType.range; ++i) {
                        for (j = y - this.spawnedFromType.range; j <= y + this.spawnedFromType.range; ++j) {
                            for (k = z - this.spawnedFromType.range; k <= z + this.spawnedFromType.range; ++k) {
                                block = world.func_147439_a(i, j, k);
                                for (Block block2 : this.spawnedFromType.blocks) {
                                    if (block != block2 || ++blocksFound < this.mobInfo.spawnInfo.spawnBlockCost) continue;
                                    return true;
                                }
                            }
                        }
                    }
                }
                if (this.spawnedFromType.blockStrings != null) {
                    for (i = x - this.spawnedFromType.range; i <= x + this.spawnedFromType.range; ++i) {
                        for (j = y - this.spawnedFromType.range; j <= y + this.spawnedFromType.range; ++j) {
                            for (k = z - this.spawnedFromType.range; k <= z + this.spawnedFromType.range; ++k) {
                                block = world.func_147439_a(i, j, k);
                                for (String string : this.spawnedFromType.blockStrings) {
                                    if (block != ObjectManager.getBlock(string) || ++blocksFound < this.mobInfo.spawnInfo.spawnBlockCost) continue;
                                    return true;
                                }
                            }
                        }
                    }
                }
                return false;
            }
        }
        return true;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData livingData) {
        livingData = super.func_110161_a(livingData);
        return livingData;
    }

    protected boolean func_70692_ba() {
        if (this.mobInfo.spawnInfo.despawnForced) {
            return true;
        }
        if (!this.mobInfo.spawnInfo.despawnNatural) {
            return false;
        }
        if (this.forceNoDespawn) {
            return false;
        }
        if (this.boss || this.getSubspeciesIndex() >= 3) {
            return false;
        }
        if (this.isPersistant() || this.func_110167_bD() || this.func_94056_bM() && "".equals(this.spawnEventType)) {
            return false;
        }
        return super.func_70692_ba();
    }

    public boolean isPersistant() {
        return false;
    }

    public boolean despawnCheck() {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (!this.mobInfo.mobEnabled) {
            return true;
        }
        if (this.isTemporary && this.temporaryDuration-- <= 0) {
            return true;
        }
        if (this.func_110167_bD() || this.isPersistant()) {
            this.spawnEventType = "";
            this.spawnEventCount = -1;
        } else {
            if (!this.mobInfo.peacefulDifficulty && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && !this.func_94056_bM()) {
                return true;
            }
            ExtendedWorld worldExt = ExtendedWorld.getForWorld(this.field_70170_p);
            if (worldExt != null && !"".equals(this.spawnEventType) && this.spawnEventCount >= 0 && this.spawnEventCount != worldExt.getWorldEventCount()) {
                return true;
            }
        }
        return false;
    }

    public boolean isSpawnerNearby(World world, int x, int y, int z) {
        if (world == null) {
            return false;
        }
        int checkRange = 8;
        if (!world.func_72873_a(x, y, z, checkRange)) {
            return false;
        }
        for (int i = x - checkRange; i <= x + checkRange; ++i) {
            for (int j = y - checkRange; j <= y + checkRange; ++j) {
                for (int k = z - checkRange; k <= z + checkRange; ++k) {
                    TileEntity tileEntity;
                    Block spawnerBlock = world.func_147439_a(i, j, k);
                    if (spawnerBlock == null || (tileEntity = world.func_147438_o(i, j, k)) == null || !(tileEntity instanceof TileEntityMobSpawner) || !((TileEntityMobSpawner)tileEntity).func_145881_a().func_98276_e().equals(ObjectManager.entityLists.get(this.group.filename).getEntityString((Entity)this))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isBlockUnderground(int x, int y, int z) {
        if (this.field_70170_p.func_72937_j(x, y, z)) {
            return false;
        }
        for (int j = y; j < this.field_70170_p.func_72800_K(); ++j) {
            Material blockMaterial = this.field_70170_p.func_147439_a(x, j, z).func_149688_o();
            if (blockMaterial == Material.field_151579_a || blockMaterial == Material.field_151584_j || blockMaterial == Material.field_151585_k || blockMaterial == Material.field_151577_b || blockMaterial == Material.field_151582_l) continue;
            return true;
        }
        return false;
    }

    public boolean isBoss() {
        return this.boss;
    }

    public void summonMinion(EntityLivingBase minion, double angle, double distance) {
        double angleRadians = Math.toRadians(angle);
        double x = this.field_70165_t + (((double)this.field_70130_N + distance) * Math.cos(angleRadians) - Math.sin(angleRadians));
        double y = this.field_70163_u + 1.0;
        double z = this.field_70161_v + (((double)this.field_70130_N + distance) * Math.sin(angleRadians) + Math.cos(angleRadians));
        minion.func_70012_b(x, y, z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
        if (minion instanceof EntityCreatureBase) {
            ((EntityCreatureBase)minion).setMinion(true);
            ((EntityCreatureBase)minion).setSubspecies(this.getSubspeciesIndex(), true);
            ((EntityCreatureBase)minion).setMasterTarget((EntityLivingBase)this);
        }
        this.field_70170_p.func_72838_d((Entity)minion);
        if (this.func_70638_az() != null) {
            minion.func_70604_c(this.func_70638_az());
        }
    }

    public void onMinionUpdate(EntityLivingBase minion, long tick) {
    }

    public void onMinionDeath(EntityLivingBase minion) {
    }

    public void setMinion(boolean minion) {
        this.isMinion = minion;
    }

    public boolean isMinion() {
        return this.isMinion;
    }

    public void setTemporary(int duration) {
        this.temporaryDuration = duration;
        this.isTemporary = true;
    }

    public void unsetTemporary() {
        this.isTemporary = false;
        this.temporaryDuration = 0;
    }

    public boolean isBoundPet() {
        return this.hasPetEntry();
    }

    public boolean hasPetEntry() {
        return this.getPetEntry() != null;
    }

    public PetEntry getPetEntry() {
        return this.petEntry;
    }

    public void setPetEntry(PetEntry petEntry) {
        this.petEntry = petEntry;
    }

    public boolean isPetType(String type) {
        if (!this.hasPetEntry()) {
            return false;
        }
        return type.equals(this.getPetEntry().getType());
    }

    public void onFirstSpawn() {
        if (MobInfo.subspeciesSpawn) {
            this.getRandomSubspecies();
        }
        if (MobInfo.randomSizes) {
            this.getRandomSize();
        }
    }

    public void getRandomSubspecies() {
        if (this.subspecies == null && !this.isMinion()) {
            this.subspecies = this.mobInfo.getRandomSubspecies((EntityLivingBase)this, this.spawnedRare);
            this.applySubspeciesHealthMultiplier();
            if (this.subspecies != null) {
                LycanitesMobs.printDebug("Subspecies", "Setting " + this.getSpeciesName() + " to " + this.subspecies.getTitle());
            } else {
                LycanitesMobs.printDebug("Subspecies", "Setting " + this.getSpeciesName() + " to base species.");
            }
        }
    }

    public void getRandomSize() {
        this.sizeScale = 1.0 + 0.35 * (0.5 - this.func_70681_au().nextDouble());
        this.updateSize();
    }

    public double getBaseHealth() {
        if (baseHealthMap.containsKey(this.getClass())) {
            return baseHealthMap.get(this.getClass()) * this.getHealthMultiplier() + (double)this.getHealthBoost();
        }
        return 10.0;
    }

    public void applySubspeciesHealthMultiplier() {
        if (this.getSubspeciesIndex() < 1) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseHealth());
            this.func_70606_j((float)this.getBaseHealth());
        } else if (this.getSubspeciesIndex() < 3) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseHealth() * 4.0);
            this.func_70606_j((float)(this.getBaseHealth() * Subspecies.uncommonHealthScale));
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseHealth() * 10.0);
            this.func_70606_j((float)(this.getBaseHealth() * Subspecies.rareHealthScale));
        }
    }

    public double getDifficultyMultiplier(String stat) {
        if (this.field_70170_p == null || this.field_70170_p.field_73013_u == null) {
            return MobInfo.difficultyMutlipliers.get("NORMAL-" + stat.toUpperCase());
        }
        EnumDifficulty difficulty = this.field_70170_p.field_73013_u;
        String difficultyName = "Easy";
        if (difficulty.func_151525_a() >= 3) {
            difficultyName = "Hard";
        } else if (difficulty == EnumDifficulty.NORMAL) {
            difficultyName = "Normal";
        }
        return MobInfo.difficultyMutlipliers.get(difficultyName.toUpperCase() + "-" + stat.toUpperCase());
    }

    public double getAltarMultiplier(String stat) {
        return AltarInfo.rareSubspeciesMutlipliers.get(stat.toUpperCase());
    }

    public double getHealthMultiplier() {
        double multiplier = this.mobInfo.multiplierHealth * this.getDifficultyMultiplier("health");
        if (this.altarSummoned) {
            multiplier *= this.getAltarMultiplier("health");
        }
        if (this.extraMobBehaviour != null) {
            multiplier *= this.extraMobBehaviour.multiplierHealth;
        }
        return multiplier;
    }

    public int getHealthBoost() {
        int boost = this.mobInfo.boostHealth;
        if (this.extraMobBehaviour != null) {
            boost += this.extraMobBehaviour.boostHealth;
        }
        return boost;
    }

    public double getDefenseMultiplier() {
        double multiplier = this.mobInfo.multiplierDefense * this.getDifficultyMultiplier("defense");
        if (this.altarSummoned) {
            multiplier *= this.getAltarMultiplier("defense");
        }
        if (this.extraMobBehaviour != null) {
            multiplier *= this.extraMobBehaviour.multiplierDefense;
        }
        return multiplier;
    }

    public int getDefenseBoost() {
        int boost = this.mobInfo.boostDefense;
        if (this.extraMobBehaviour != null) {
            boost += this.extraMobBehaviour.boostDefense;
        }
        return boost;
    }

    public double getSpeedMultiplier() {
        double multiplier = this.mobInfo.multiplierSpeed * this.getDifficultyMultiplier("speed");
        if (this.altarSummoned) {
            multiplier *= this.getAltarMultiplier("speed");
        }
        if (this.extraMobBehaviour != null) {
            multiplier *= this.extraMobBehaviour.multiplierSpeed;
        }
        return multiplier;
    }

    public float getSpeedBoost() {
        int boost = this.mobInfo.boostSpeed / 100;
        if (this.extraMobBehaviour != null) {
            boost += this.extraMobBehaviour.boostSpeed;
        }
        return boost;
    }

    public double getDamageMultiplier() {
        double multiplier = this.mobInfo.multiplierDamage * this.getDifficultyMultiplier("damage");
        if (this.altarSummoned) {
            multiplier *= this.getAltarMultiplier("damage");
        }
        if (this.extraMobBehaviour != null) {
            multiplier *= this.extraMobBehaviour.multiplierDamage;
        }
        return multiplier;
    }

    public int getDamageBoost() {
        int boost = this.mobInfo.boostDamage;
        if (this.extraMobBehaviour != null) {
            boost += this.extraMobBehaviour.boostDamage;
        }
        return boost;
    }

    public double getHasteMultiplier() {
        double multiplier = this.mobInfo.multiplierHaste * this.getDifficultyMultiplier("haste");
        if (this.altarSummoned) {
            multiplier *= this.getAltarMultiplier("haste");
        }
        if (this.extraMobBehaviour != null) {
            multiplier *= this.extraMobBehaviour.multiplierHaste;
        }
        return multiplier;
    }

    public int getHasteBoost() {
        int boost = this.mobInfo.boostHaste;
        if (this.extraMobBehaviour != null) {
            boost += this.extraMobBehaviour.boostHaste;
        }
        return boost;
    }

    public int getHaste(int ticks) {
        ticks -= this.getHasteBoost();
        double ticksScale = 1.0 / this.getHasteMultiplier();
        ticks = Math.round((float)ticks * (float)ticksScale);
        return Math.max(0, ticks);
    }

    public double getEffectMultiplier() {
        double multiplier = this.mobInfo.multiplierEffect * this.getDifficultyMultiplier("effect");
        if (this.altarSummoned) {
            multiplier *= this.getAltarMultiplier("effect");
        }
        if (this.extraMobBehaviour != null) {
            multiplier *= this.extraMobBehaviour.multiplierEffect;
        }
        return multiplier;
    }

    public int getEffectBoost() {
        int boost = this.mobInfo.boostEffect;
        if (this.extraMobBehaviour != null) {
            boost += this.extraMobBehaviour.boostEffect;
        }
        return boost;
    }

    public int getEffectDuration(int seconds) {
        return Math.round((float)seconds * (float)this.getEffectMultiplier() * 20.0f) + this.getEffectBoost();
    }

    public float getEffectStrength(float value) {
        return Math.round(value * (float)this.getEffectMultiplier()) + this.getEffectBoost();
    }

    public double getPierceMultiplier() {
        double multiplier = this.mobInfo.multiplierPierce * this.getDifficultyMultiplier("pierce");
        if (this.altarSummoned) {
            multiplier *= this.getAltarMultiplier("pierce");
        }
        if (this.extraMobBehaviour != null) {
            multiplier *= this.extraMobBehaviour.multiplierPierce;
        }
        return multiplier;
    }

    public double getPierceBoost() {
        int boost = this.mobInfo.boostPierce;
        if (this.extraMobBehaviour != null) {
            boost += this.extraMobBehaviour.boostPierce;
        }
        return boost;
    }

    public double getPierceBase() {
        return 5.0;
    }

    public double getPierceValue() {
        double value = this.getPierceBase();
        value *= 1.0 / this.getPierceMultiplier();
        return Math.max(1.0, value -= Math.max(0.0, this.getPierceBoost()));
    }

    public void updateBattlePhase() {
    }

    public int getBattlePhase() {
        return this.battlePhase;
    }

    public void setSubspecies(int subspeciesIndex, boolean resetHealth) {
        this.subspecies = this.mobInfo.getSubspecies(subspeciesIndex);
        int scaledExp = this.experience;
        if (subspeciesIndex == 1 || subspeciesIndex == 2) {
            scaledExp = Math.round((float)((double)this.experience * Subspecies.uncommonExperienceScale));
        } else if (subspeciesIndex >= 3) {
            scaledExp = Math.round((float)((double)this.experience * Subspecies.rareExperienceScale));
        }
        this.field_70728_aV = scaledExp;
        if (resetHealth) {
            this.applySubspeciesHealthMultiplier();
        }
    }

    public Subspecies getSubspecies() {
        return this.subspecies;
    }

    public int getSubspeciesIndex() {
        return this.getSubspecies() != null ? this.getSubspecies().index : 0;
    }

    public void func_70071_h_() {
        if (this.field_70180_af != null) {
            this.onSyncUpdate();
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.updateHitAreas();
        }
        if (this.despawnCheck()) {
            if (!this.isBoundPet()) {
                this.inventory.dropInventory();
            }
            this.func_70106_y();
        }
        boolean bl = this.field_70178_ae = !this.canBurn();
        if (!this.canWalk() && !this.canFly() && !this.func_70090_H() && this.isMoving() || !this.canMove()) {
            this.clearMovement();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
            if (this.flySoundSpeed > 0 && this.field_70173_aa % 20 == 0) {
                this.playFlySound();
            }
        }
        if (!this.field_70170_p.field_72995_K && this.guiViewers.size() <= 0) {
            this.guiRefreshTick = 0;
        }
        if (!this.field_70170_p.field_72995_K && this.guiRefreshTick > 0 && --this.guiRefreshTick <= 0) {
            this.refreshGUIViewers();
            this.guiRefreshTick = 0;
        }
    }

    protected void func_70619_bc() {
        if (this.useFlightNavigator()) {
            this.flightNavigator.updateFlight();
        }
        super.func_70619_bc();
    }

    public void func_70636_d() {
        float brightness;
        super.func_70636_d();
        this.updateBattlePhase();
        this.func_82168_bl();
        if (!this.field_70170_p.field_72995_K && this.firstSpawn) {
            this.onFirstSpawn();
            this.firstSpawn = false;
        }
        if (this.hasAttackTarget() && this.func_70638_az() instanceof EntityPlayer) {
            EntityPlayer targetPlayer = (EntityPlayer)this.func_70638_az();
            if (targetPlayer.field_71075_bZ.field_75098_d) {
                this.func_70624_b(null);
            }
        }
        if (this.hasAvoidTarget() && this.currentFleeTime-- <= 0) {
            this.setAvoidTarget(null);
        }
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= this.getFallingMod();
        }
        if (!this.field_70170_p.field_72995_K && this.daylightBurns() && this.field_70170_p.func_72935_r() && (brightness = this.func_70013_c(1.0f)) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))) {
            boolean shouldBurn = true;
            ItemStack helmet = this.inventory.getEquipmentStack("head");
            if (helmet != null) {
                if (helmet.func_77984_f()) {
                    helmet.func_77964_b(helmet.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (helmet.func_77952_i() >= helmet.func_77958_k()) {
                        this.func_70669_a(helmet);
                        this.func_70062_b(4, null);
                    }
                }
                shouldBurn = false;
            }
            if (shouldBurn) {
                this.func_70015_d(8);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.waterDamage() && this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (!this.field_70170_p.field_72995_K && !this.canBreatheAboveWater()) {
            int currentAir = this.func_70086_ai();
            if (this.func_70089_S()) {
                if (!this.isLavaCreature && !this.waterContact() || this.isLavaCreature && !this.lavaContact()) {
                    this.func_70050_g(--currentAir);
                    if (this.func_70086_ai() <= -200) {
                        this.func_70050_g(-180);
                        this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                    }
                } else {
                    this.func_70050_g(299);
                }
            }
        }
        float light = this.func_70013_c(1.0f);
        if (!this.mobInfo.spawnInfo.spawnsInLight && light > 0.5f) {
            this.field_70708_bq += 2;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isStealthed() && !this.func_82150_aj()) {
                this.func_82142_c(true);
            } else if (!this.isStealthed() && this.func_82150_aj() && !this.func_82165_m(Potion.field_76441_p.field_76415_H)) {
                this.func_82142_c(false);
            }
        }
        if (this.isStealthed()) {
            if (this.stealthPrev != this.isStealthed()) {
                this.startStealth();
            }
            this.onStealth();
        } else if (this.func_82150_aj() && !this.func_82165_m(Potion.field_76441_p.field_76415_H)) {
            this.func_82142_c(false);
        }
        this.stealthPrev = this.isStealthed();
        if (this.currentBlockingTime > 0) {
            --this.currentBlockingTime;
        }
        if (this.currentBlockingTime < 0) {
            this.currentBlockingTime = 0;
        }
        if (this.field_70173_aa % 10 == 0 && !this.field_70170_p.field_72995_K && this.func_70089_S() && this.canPickupItems()) {
            this.pickupItems();
        }
        if (this.pickupEntity != null) {
            if (!this.pickupEntity.func_70089_S()) {
                this.dropPickupEntity();
            } else if (this.pickupEntity instanceof EntityLivingBase) {
                if (((EntityLivingBase)this.pickupEntity).func_110143_aJ() <= 0.0f) {
                    this.dropPickupEntity();
                }
            } else if (this.func_70068_e(this.pickupEntity) > 32.0) {
                this.dropPickupEntity();
            }
        }
        if (this.field_70170_p.field_72995_K && this.showBossHealthBar()) {
            if (this.bossHealth == null) {
                this.bossHealth = new BossHealth((EntityLivingBase)this);
            }
            BossStatus.func_82824_a((IBossDisplayData)this.bossHealth, (boolean)true);
        }
        if (this.getMasterTarget() != null && this.getMasterTarget() instanceof EntityCreatureBase) {
            ((EntityCreatureBase)this.getMasterTarget()).onMinionUpdate((EntityLivingBase)this, this.updateTick);
        }
        ++this.updateTick;
    }

    public void onSyncUpdate() {
        byte animations;
        if (!this.field_70170_p.field_72995_K) {
            byte targets = 0;
            if (this.func_70638_az() != null) {
                targets = (byte)(targets + TARGET_ID.ATTACK.id);
            }
            if (this.getMasterTarget() != null) {
                targets = (byte)(targets + TARGET_ID.MASTER.id);
            }
            if (this.getParentTarget() != null) {
                targets = (byte)(targets + TARGET_ID.PARENT.id);
            }
            if (this.getAvoidTarget() != null) {
                targets = (byte)(targets + TARGET_ID.AVOID.id);
            }
            if (this.getRiderTarget() != null) {
                targets = (byte)(targets + TARGET_ID.RIDER.id);
            }
            this.field_70180_af.func_75692_b((int)WATCHER_ID.TARGET.id, (Object)targets);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b((int)WATCHER_ID.ATTACK_PHASE.id, (Object)this.attackPhase);
        }
        if (!this.field_70170_p.field_72995_K) {
            animations = 0;
            if (this.justAttacked == this.justAttackedTime) {
                animations = (byte)(animations + ANIM_ID.ATTACKED.id);
                this.justAttacked = 0;
                this.playAttackSound();
            }
            if (this.field_70122_E) {
                animations = (byte)(animations + ANIM_ID.GROUNDED.id);
            }
            if (this.isBlocking()) {
                animations = (byte)(animations + ANIM_ID.BLOCKING.id);
            }
            if (this.isMinion()) {
                animations = (byte)(animations + ANIM_ID.MINION.id);
            }
            if (this.extraAnimation01()) {
                animations = (byte)(animations + ANIM_ID.EXTRA01.id);
            }
            this.field_70180_af.func_75692_b((int)WATCHER_ID.ANIMATION.id, (Object)animations);
        } else if (this.field_70170_p.field_72995_K) {
            animations = this.field_70180_af.func_75683_a((int)WATCHER_ID.ANIMATION.id);
            if (this.justAttacked > 0) {
                this.justAttacked = (short)(this.justAttacked - 1);
            } else if ((animations & ANIM_ID.ATTACKED.id) > 0) {
                this.setJustAttacked();
            }
            this.field_70122_E = (animations & ANIM_ID.GROUNDED.id) > 0;
            boolean bl = this.extraAnimation01 = (animations & ANIM_ID.EXTRA01.id) > 0;
        }
        if (this.field_70170_p.field_72995_K) {
            boolean bl = this.isMinion = (this.field_70180_af.func_75683_a((int)WATCHER_ID.ANIMATION.id) & ANIM_ID.MINION.id) > 0;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b((int)WATCHER_ID.SUBSPECIES.id, (Object)((byte)this.getSubspeciesIndex()));
        } else if (this.getSubspeciesIndex() != this.field_70180_af.func_75683_a((int)WATCHER_ID.SUBSPECIES.id)) {
            this.setSubspecies(this.field_70180_af.func_75683_a((int)WATCHER_ID.SUBSPECIES.id), false);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b((int)WATCHER_ID.SIZE.id, (Object)Float.valueOf((float)this.sizeScale));
        } else if (this.sizeScale != (double)this.field_70180_af.func_111145_d((int)WATCHER_ID.SIZE.id)) {
            this.sizeScale = this.field_70180_af.func_111145_d((int)WATCHER_ID.SIZE.id);
            this.updateSize();
        }
    }

    public void updateHitAreas() {
        int hitAreaHeightCount = Math.max(1, Math.round(this.field_70131_O / 4.0f));
        int hitAreaWidthCount = Math.max(1, Math.round(this.field_70130_N / 4.0f));
        if (hitAreaHeightCount < 2 && hitAreaWidthCount < 2) {
            this.hitAreas = null;
            return;
        }
        if (this.hitAreas == null || this.hitAreas[0] == null || this.hitAreas[0][0] == null || this.hitAreas.length != hitAreaHeightCount || this.hitAreas[0].length != hitAreaWidthCount || this.hitAreas[0][0].length != hitAreaWidthCount) {
            this.hitAreas = new EntityHitArea[hitAreaHeightCount][hitAreaWidthCount][hitAreaWidthCount];
        }
        for (int y = 0; y < hitAreaHeightCount; ++y) {
            for (int x = 0; x < hitAreaWidthCount; ++x) {
                for (int z = 0; z < hitAreaWidthCount; ++z) {
                    if (y != 0 && y != hitAreaHeightCount - 1 && x != 0 && x != hitAreaWidthCount - 1 && z != 0 && z != hitAreaWidthCount - 1) continue;
                    if (this.hitAreas[y][x][z] == null) {
                        this.hitAreas[y][x][z] = new EntityHitArea((Entity)this, this.field_70130_N / (float)hitAreaWidthCount * this.hitAreaScale, this.field_70131_O / (float)hitAreaHeightCount);
                        this.field_70170_p.func_72838_d((Entity)this.hitAreas[y][x][z]);
                    }
                    this.hitAreas[y][x][z].field_70165_t = this.field_70165_t - (double)(this.field_70130_N * this.hitAreaScale / 2.0f) + (double)(this.field_70130_N * this.hitAreaScale / (float)hitAreaWidthCount / 2.0f) + (double)(this.field_70130_N * this.hitAreaScale / (float)hitAreaWidthCount * (float)x);
                    this.hitAreas[y][x][z].field_70163_u = this.field_70163_u + (double)(this.field_70131_O / (float)hitAreaHeightCount * (float)y);
                    this.hitAreas[y][x][z].field_70161_v = this.field_70161_v - (double)(this.field_70130_N * this.hitAreaScale / 2.0f) + (double)(this.field_70130_N * this.hitAreaScale / (float)hitAreaWidthCount / 2.0f) + (double)(this.field_70130_N * this.hitAreaScale / (float)hitAreaWidthCount * (float)z);
                    this.hitAreas[y][x][z].field_70177_z = this.field_70177_z;
                }
            }
        }
    }

    public float getBlockPathWeight(int par1, int par2, int par3) {
        if (this.mobInfo.spawnInfo.spawnsInDark && !this.mobInfo.spawnInfo.spawnsInLight) {
            return 0.5f - this.field_70170_p.func_72801_o(par1, par2, par3);
        }
        if (this.mobInfo.spawnInfo.spawnsInLight && !this.mobInfo.spawnInfo.spawnsInDark) {
            return this.field_70170_p.func_72801_o(par1, par2, par3) - 0.5f;
        }
        return 0.0f;
    }

    public boolean useFlightNavigator() {
        boolean freeSwimming;
        boolean bl = freeSwimming = this.canSwim() && this.func_70090_H();
        return this.canFly() || freeSwimming;
    }

    public void func_70612_e(float moveStrafe, float moveForward) {
        if (!this.useFlightNavigator()) {
            super.func_70612_e(moveStrafe, moveForward);
        } else {
            this.flightNavigator.flightMovement(moveStrafe, moveForward);
        }
    }

    public void clearMovement() {
        if (!this.useFlightNavigator()) {
            this.func_70661_as().func_75499_g();
        } else {
            this.flightNavigator.clearTargetPosition(1.0);
        }
    }

    protected void func_110159_bB() {
        super.func_110159_bB();
        if (this.func_110167_bD() && this.func_110166_bE() != null && this.func_110166_bE().field_70170_p == this.field_70170_p) {
            Entity entity = this.func_110166_bE();
            this.setHome((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, 5.0f);
            float distance = this.func_70032_d(entity);
            this.testLeash(distance);
            if (!this.leashAIActive) {
                this.field_70714_bg.func_75776_a(2, this.leashMoveTowardsRestrictionAI);
                this.func_70661_as().func_75491_a(false);
                this.leashAIActive = true;
            }
            if (distance > 4.0f) {
                this.func_70661_as().func_75497_a(entity, 1.0);
            }
            if (distance > 6.0f) {
                double d0 = (entity.field_70165_t - this.field_70165_t) / (double)distance;
                double d1 = (entity.field_70163_u - this.field_70163_u) / (double)distance;
                double d2 = (entity.field_70161_v - this.field_70161_v) / (double)distance;
                this.field_70159_w += d0 * Math.abs(d0) * 0.4;
                this.field_70181_x += d1 * Math.abs(d1) * 0.4;
                this.field_70179_y += d2 * Math.abs(d2) * 0.4;
            }
            if (distance > 10.0f) {
                this.func_110160_i(true, true);
            }
        } else if (!this.func_110167_bD() && this.leashAIActive) {
            this.leashAIActive = false;
            this.field_70714_bg.func_85156_a(this.leashMoveTowardsRestrictionAI);
            this.func_70661_as().func_75491_a(true);
            this.detachHome();
        }
    }

    public boolean func_96092_aw() {
        return !this.canSwim();
    }

    public boolean isMoving() {
        if (!this.useFlightNavigator()) {
            return this.func_70661_as().func_75505_d() != null;
        }
        return !this.flightNavigator.atTargetPosition();
    }

    public boolean func_110164_bC() {
        return false;
    }

    public boolean func_70104_M() {
        return super.func_70104_M();
    }

    public boolean canLeash(EntityPlayer player) {
        return false;
    }

    public void testLeash(float distance) {
    }

    public void func_70659_e(float speed) {
        super.func_70659_e((speed + this.getSpeedBoost()) * this.getAISpeedModifier() * (float)this.getSpeedMultiplier());
    }

    public float getAISpeedModifier() {
        return 1.0f;
    }

    public double getFallingMod() {
        return 1.0;
    }

    public void leap(double distance, double leapHeight) {
        double angle = Math.toRadians(this.field_70177_z);
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        this.field_70159_w = xAmount * distance + this.field_70159_w * 0.2;
        this.field_70179_y = zAmount * distance + this.field_70179_y * 0.2;
        this.field_70181_x = leapHeight;
    }

    public void leap(float range, double leapHeight, Entity target) {
        if (target == null) {
            return;
        }
        float distance = target.func_70032_d((Entity)this);
        if (distance > 2.0f && distance <= range) {
            double xDist = this.func_70638_az().field_70165_t - this.field_70165_t;
            double zDist = this.func_70638_az().field_70161_v - this.field_70161_v;
            float mixedDist = MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist));
            this.field_70159_w = xDist / (double)mixedDist * 0.5 * 0.8 + this.field_70159_w * 0.2;
            this.field_70179_y = zDist / (double)mixedDist * 0.5 * 0.8 + this.field_70179_y * 0.2;
            this.field_70181_x = leapHeight;
        }
    }

    public void setHome(int x, int y, int z, float distance) {
        this.setHomePosition(x, y, z);
        this.setHomeDistanceMax(distance);
    }

    public void setHomePosition(int x, int y, int z) {
        this.homePosition = new ChunkCoordinates(x, y, z);
    }

    public void setHomeDistanceMax(float newDist) {
        this.homeDistanceMax = newDist;
    }

    public ChunkCoordinates getHomePosition() {
        return this.homePosition;
    }

    public float getHomeDistanceMax() {
        return this.homeDistanceMax;
    }

    public void detachHome() {
        this.setHomeDistanceMax(-1.0f);
    }

    public boolean hasHome() {
        return this.getHomePosition() != null && this.getHomeDistanceMax() >= 0.0f;
    }

    public boolean positionNearHome(int x, int y, int z) {
        if (!this.hasHome()) {
            return true;
        }
        return this.getDistanceFromHome(x, y, z) < this.getHomeDistanceMax() * this.getHomeDistanceMax();
    }

    public float getDistanceFromHome(int x, int y, int z) {
        if (!this.hasHome()) {
            return 0.0f;
        }
        return this.homePosition.func_71569_e(x, y, z);
    }

    public float getDistanceFromHome() {
        return this.homePosition.func_71569_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
    }

    public ChunkCoordinates getWanderPosition(ChunkCoordinates wanderPosition) {
        return wanderPosition;
    }

    public int restrictYHeightFromGround(ChunkCoordinates coords, int minY, int maxY) {
        int groundY = this.getGroundY(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        int airYMax = Math.min(this.getAirY(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c), groundY + maxY);
        int airYMin = Math.min(airYMax, groundY + minY);
        if (airYMin >= airYMax) {
            return airYMin;
        }
        return airYMin + this.func_70681_au().nextInt(airYMax - airYMin);
    }

    public int getGroundY(int x, int y, int z) {
        if (y <= 0) {
            return 0;
        }
        Block startBlock = this.field_70170_p.func_147439_a(x, y, z);
        if (startBlock == null || startBlock.isAir((IBlockAccess)this.field_70170_p, x, y, z)) {
            Block possibleGroundBlock;
            int possibleGroundY = Math.max(0, y - 1);
            while (possibleGroundY >= 0 && ((possibleGroundBlock = this.field_70170_p.func_147439_a(x, possibleGroundY, z)) == null || possibleGroundBlock.isAir((IBlockAccess)this.field_70170_p, x, possibleGroundY, z))) {
                y = possibleGroundY--;
            }
        }
        return y;
    }

    public int getAirY(int x, int y, int z) {
        int yMax = this.field_70170_p.field_73011_w.getActualHeight() - 1;
        if (y >= yMax) {
            return yMax;
        }
        if (this.field_70170_p.func_72937_j(x, y, z)) {
            return yMax;
        }
        Block startBlock = this.field_70170_p.func_147439_a(x, y, z);
        if (startBlock == null || startBlock.isAir((IBlockAccess)this.field_70170_p, x, y, z)) {
            Block possibleGroundBlock;
            int possibleAirY = Math.min(yMax, y + 1);
            while (possibleAirY <= yMax && ((possibleGroundBlock = this.field_70170_p.func_147439_a(x, possibleAirY, z)) == null || possibleGroundBlock.isAir((IBlockAccess)this.field_70170_p, x, possibleAirY, z))) {
                y = possibleAirY++;
            }
        }
        return y;
    }

    public int getWaterSurfaceY(int x, int y, int z) {
        if (y <= 0) {
            return 0;
        }
        int yMax = this.field_70170_p.field_73011_w.getActualHeight() - 1;
        if (y >= yMax) {
            return yMax;
        }
        int yLimit = 24;
        yMax = Math.min(yMax, y + yLimit);
        Block startBlock = this.field_70170_p.func_147439_a(x, y, z);
        if (startBlock != null && startBlock.func_149688_o() == Material.field_151586_h) {
            int possibleSurfaceY = y;
            ++possibleSurfaceY;
            while (possibleSurfaceY <= yMax) {
                Block possibleSurfaceBlock = this.field_70170_p.func_147439_a(x, possibleSurfaceY, z);
                if (possibleSurfaceBlock != null && possibleSurfaceBlock.isAir((IBlockAccess)this.field_70170_p, x, possibleSurfaceY, z)) {
                    return possibleSurfaceY;
                }
                if (possibleSurfaceBlock == null || possibleSurfaceBlock.func_149688_o() != Material.field_151586_h) {
                    return possibleSurfaceY - 1;
                }
                ++possibleSurfaceY;
            }
            return Math.max(possibleSurfaceY - 1, y);
        }
        return y;
    }

    protected void func_70105_a(float width, float height) {
        super.func_70105_a(width * (float)this.sizeScale, height * (float)this.sizeScale);
        this.field_70130_N = width;
        this.field_70131_O = height;
        this.hitAreas = null;
    }

    public void updateSize() {
        this.func_70105_a(Math.max(this.setWidth, 0.5f), Math.max(this.setHeight, 0.5f));
    }

    public void setSizeScale(double scale) {
        this.sizeScale = scale;
        this.updateSize();
    }

    public double getRenderScale() {
        return this.sizeScale;
    }

    public boolean func_70686_a(Class targetClass) {
        if (!MobInfo.mobsAttackVillagers && targetClass == EntityVillager.class) {
            return false;
        }
        return !this.isBlocking();
    }

    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (!MobInfo.mobsAttackVillagers && targetEntity instanceof EntityVillager) {
            return false;
        }
        if (targetEntity instanceof EntityPlayer) {
            EntityPlayer targetPlayer = (EntityPlayer)targetEntity;
            if (targetPlayer.field_71075_bZ.field_75098_d) {
                return false;
            }
        }
        if (targetEntity instanceof EntityCreatureBase) {
            if (((EntityCreatureBase)targetEntity).getMasterTarget() == this) {
                return false;
            }
            if (!(this instanceof IBossDisplayData) && this.getOwner() == null && targetEntity instanceof IBossDisplayData && !((EntityCreatureBase)targetEntity).canAttackEntity((EntityLivingBase)this)) {
                return false;
            }
        }
        return true;
    }

    public EntityLivingBase getMasterAttackTarget() {
        if (this.masterTarget == null) {
            return null;
        }
        if (this.masterTarget instanceof EntityLiving) {
            return ((EntityLiving)this.masterTarget).func_70638_az();
        }
        return null;
    }

    public EntityLivingBase getParentAttackTarget() {
        if (this.parentTarget == null) {
            return null;
        }
        if (this.parentTarget instanceof EntityCreatureBase) {
            return ((EntityCreatureBase)this.parentTarget).func_70638_az();
        }
        if (this.parentTarget instanceof EntityCreature) {
            return ((EntityCreature)this.parentTarget).func_70638_az();
        }
        return null;
    }

    public void func_70604_c(EntityLivingBase entityLivingBase) {
        boolean aggressiveOverride = false;
        if (this.extraMobBehaviour != null) {
            aggressiveOverride = this.extraMobBehaviour.aggressiveOverride;
        }
        if (!aggressiveOverride && this.fleeHealthPercent > 0.0f && this.func_110143_aJ() / this.func_110138_aP() <= this.fleeHealthPercent) {
            this.setAvoidTarget(entityLivingBase);
        } else {
            super.func_70604_c(entityLivingBase);
        }
    }

    public boolean meleeAttack(Entity target, double damageScale) {
        boolean success = true;
        if (this.attackEntityAsMob(target, damageScale) && this.spreadFire && this.func_70027_ad() && (double)this.field_70146_Z.nextFloat() < this.getEffectMultiplier()) {
            target.func_70015_d(this.getEffectDuration(4) / 20);
        }
        this.setJustAttacked();
        return success;
    }

    public void rangedAttack(Entity target, float range) {
        this.setJustAttacked();
    }

    public byte getAttackPhase() {
        return this.field_70180_af.func_75683_a((int)WATCHER_ID.ATTACK_PHASE.id);
    }

    public void setAttackPhase(byte setAttackPhase) {
        this.attackPhase = setAttackPhase;
    }

    public void nextAttackPhase() {
        this.attackPhase = (byte)(this.attackPhase + 1);
        if (this.attackPhase > this.attackPhaseMax - 1) {
            this.attackPhase = 0;
        }
    }

    public boolean attackEntityAsMob(Entity target, double damageScale) {
        if (!this.func_70089_S()) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (!this.func_70685_l(target)) {
            return false;
        }
        float damage = this.getAttackDamage(damageScale);
        int i = 0;
        if (target instanceof EntityLivingBase) {
            damage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
            i += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
        }
        boolean attackSuccess = false;
        float pierceDamage = 1.0f + (float)Math.floor((double)damage / this.getPierceValue());
        if (damage <= pierceDamage) {
            attackSuccess = target.func_70097_a(this.getDamageSource(null).func_76348_h().func_151518_m(), damage);
        } else {
            int hurtResistantTimeBefore = target.field_70172_ad;
            target.func_70097_a(this.getDamageSource(null).func_76348_h().func_151518_m(), pierceDamage);
            target.field_70172_ad = hurtResistantTimeBefore;
            attackSuccess = target.func_70097_a(this.getDamageSource(null), damage -= pierceDamage);
        }
        if (attackSuccess) {
            int fireEnchantDuration;
            if (i > 0) {
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((fireEnchantDuration = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                target.func_70015_d(fireEnchantDuration * 4);
            }
        }
        return attackSuccess;
    }

    public float getAttackDamage(double damageScale) {
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        damage += (float)this.getDamageBoost();
        damage = (float)((double)damage * this.getAttackDamageScale());
        damage = (float)((double)damage * damageScale);
        return damage;
    }

    public double getAttackDamageScale() {
        return this.getDamageMultiplier();
    }

    public DamageSource getDamageSource(EntityDamageSource nestedDamageSource) {
        if (nestedDamageSource != null) {
            return nestedDamageSource;
        }
        return DamageSource.func_76358_a((EntityLivingBase)this);
    }

    public boolean func_70097_a(DamageSource damageSrc, float damage) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.isDamageTypeApplicable(damageSrc.func_76355_l())) {
            return false;
        }
        if (!this.isDamageEntityApplicable(damageSrc.func_76346_g())) {
            return false;
        }
        damage = this.getDamageAfterDefense(damage);
        damage *= this.getDamageModifier(damageSrc);
        if (this.isBoss() && !(damageSrc.func_76346_g() instanceof EntityPlayer)) {
            damage *= 0.25f;
        }
        if (super.func_70097_a(damageSrc, damage)) {
            this.onDamage(damageSrc, damage);
            Entity entity = damageSrc.func_76364_f();
            if (entity instanceof EntityThrowable) {
                entity = ((EntityThrowable)entity).func_85052_h();
            }
            if (entity != null && !(entity instanceof EntityPlayer)) {
                damage = (damage + 1.0f) / 2.0f;
            }
            if (entity instanceof EntityLivingBase && this.field_70153_n != entity && this.field_70154_o != entity) {
                if (entity != this) {
                    this.func_70604_c((EntityLivingBase)entity);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean attackEntityFromArea(EntityHitArea entityHitArea, DamageSource damageSrc, float damage) {
        return this.func_70097_a(damageSrc, damage);
    }

    public float getDamageAfterDefense(float damage) {
        float baseDefense = this.defense + this.getDefenseBoost();
        float scaledDefense = baseDefense * (float)this.getDefenseMultiplier();
        float minDamage = 0.0f;
        if (this.isBlocking()) {
            if (scaledDefense <= 0.0f) {
                scaledDefense = 1.0f;
            }
            scaledDefense *= (float)this.getBlockingMultiplier();
        }
        damage -= scaledDefense;
        if (this.damageMax > 0) {
            damage = Math.min(damage, (float)this.damageMax);
        }
        return Math.max(damage, minDamage);
    }

    public void onDamage(DamageSource damageSrc, float damage) {
    }

    public float getDamageModifier(DamageSource damageSrc) {
        return 1.0f;
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (!this.field_70729_aU) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!this.isBoundPet()) {
                this.inventory.dropInventory();
            }
            if (damageSource.func_76346_g() != null && damageSource.func_76346_g() instanceof EntityPlayer) {
                ((EntityPlayer)damageSource.func_76346_g()).func_71064_a((StatBase)ObjectManager.getAchievement(this.mobInfo.name + ".kill"), 1);
            }
        }
        if (this.getMasterTarget() != null && this.getMasterTarget() instanceof EntityCreatureBase) {
            ((EntityCreatureBase)this.getMasterTarget()).onMinionDeath((EntityLivingBase)this);
        }
    }

    public boolean isAggressive() {
        if (this.extraMobBehaviour != null && this.extraMobBehaviour.aggressiveOverride) {
            return true;
        }
        return true;
    }

    public boolean isProtective(Entity entity) {
        return true;
    }

    public boolean hasAttackTarget() {
        if (!this.field_70170_p.field_72995_K) {
            return this.func_70638_az() != null;
        }
        return (this.field_70180_af.func_75683_a((int)WATCHER_ID.TARGET.id) & TARGET_ID.ATTACK.id) > 0;
    }

    public EntityLivingBase getMasterTarget() {
        return this.masterTarget;
    }

    public void setMasterTarget(EntityLivingBase setTarget) {
        this.masterTarget = setTarget;
    }

    public boolean hasMaster() {
        if (!this.field_70170_p.field_72995_K) {
            return this.getMasterTarget() != null;
        }
        return (this.field_70180_af.func_75683_a((int)WATCHER_ID.TARGET.id) & TARGET_ID.MASTER.id) > 0;
    }

    public EntityLivingBase getParentTarget() {
        return this.parentTarget;
    }

    public void setParentTarget(EntityLivingBase setTarget) {
        this.parentTarget = setTarget;
    }

    public boolean hasParent() {
        if (!this.field_70170_p.field_72995_K) {
            return this.getParentTarget() != null;
        }
        return (this.field_70180_af.func_75683_a((int)WATCHER_ID.TARGET.id) & TARGET_ID.PARENT.id) > 0;
    }

    public EntityLivingBase getAvoidTarget() {
        return this.avoidTarget;
    }

    public void setAvoidTarget(EntityLivingBase setTarget) {
        this.currentFleeTime = this.fleeTime;
        this.avoidTarget = setTarget;
    }

    public boolean hasAvoidTarget() {
        if (!this.field_70170_p.field_72995_K) {
            return this.getAvoidTarget() != null;
        }
        return (this.field_70180_af.func_75683_a((int)WATCHER_ID.TARGET.id) & TARGET_ID.AVOID.id) > 0;
    }

    public EntityLivingBase getOwner() {
        return null;
    }

    public EntityLivingBase getRider() {
        if (this.field_70153_n instanceof EntityLivingBase) {
            return (EntityLivingBase)this.field_70153_n;
        }
        return null;
    }

    public Entity getRiderTarget() {
        return this.field_70153_n;
    }

    public void setRiderTarget(Entity setTarget) {
        this.field_70153_n = setTarget;
    }

    public boolean hasRiderTarget() {
        if (!this.field_70170_p.field_72995_K) {
            return this.getRiderTarget() != null;
        }
        return (this.field_70180_af.func_75683_a((int)WATCHER_ID.TARGET.id) & TARGET_ID.RIDER.id) > 0;
    }

    public double[] getFacingPosition(double distance) {
        return this.getFacingPosition((Entity)this, distance, 0.0);
    }

    public double[] getFacingPosition(Entity entity, double distance, double angleOffset) {
        return this.getFacingPosition(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, distance, Math.toRadians(entity.field_70177_z) + angleOffset);
    }

    public double[] getFacingPosition(double x, double y, double z, double distance, double angle) {
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        double[] coords = new double[]{x + distance * xAmount, y, z + distance * zAmount};
        return coords;
    }

    @Override
    public boolean isHostile() {
        return this.isHostileByDefault;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount) {
            if (this.isMinion()) {
                return false;
            }
            for (EnumCreatureType creatureType : this.mobInfo.spawnInfo.creatureTypes) {
                if (creatureType != type) continue;
                return true;
            }
            return false;
        }
        if (type.func_75598_a() == IMob.class) {
            return this.isHostile();
        }
        return type.func_75598_a().isAssignableFrom(this.getClass());
    }

    public boolean canMove() {
        return !this.isBlocking();
    }

    public boolean canWalk() {
        return true;
    }

    public boolean canSwim() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.swimmingOverride;
    }

    public boolean canJump() {
        return !this.isBlocking();
    }

    public boolean canClimb() {
        return false;
    }

    public boolean canFly() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.flightOverride;
    }

    @Override
    public boolean isCurrentlyFlying() {
        return this.canFly();
    }

    public boolean canBeTempted() {
        return this.getSubspeciesIndex() < 3;
    }

    public void onEat() {
    }

    public boolean canStealth() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.stealthOverride;
    }

    public float getStealth() {
        return this.field_70180_af.func_111145_d((int)WATCHER_ID.STEALTH.id);
    }

    public void setStealth(float setStealth) {
        setStealth = Math.min(setStealth, 1.0f);
        setStealth = Math.max(setStealth, 0.0f);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b((int)WATCHER_ID.STEALTH.id, (Object)Float.valueOf(setStealth));
        }
    }

    public boolean isStealthed() {
        return this.getStealth() >= 1.0f;
    }

    public void startStealth() {
    }

    public void onStealth() {
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az() instanceof EntityLiving && ((EntityLiving)this.func_70638_az()).func_70638_az() != null) {
            ((EntityLiving)this.func_70638_az()).func_70624_b(null);
        }
    }

    public boolean func_70617_f_() {
        if (this.useFlightNavigator() || this.canSwim()) {
            return false;
        }
        if (this.canClimb()) {
            return (this.field_70180_af.func_75683_a((int)WATCHER_ID.CLIMBING.id) & 1) != 0;
        }
        return super.func_70617_f_();
    }

    public void setBesideClimbableBlock(boolean collided) {
        if (this.canClimb()) {
            byte climbing = this.field_70180_af.func_75683_a((int)WATCHER_ID.CLIMBING.id);
            climbing = collided ? (byte)(climbing | 1) : (byte)(climbing & 0xFFFFFFFE);
            this.field_70180_af.func_75692_b((int)WATCHER_ID.CLIMBING.id, (Object)climbing);
        }
    }

    public boolean isBesideClimbableBlock() {
        return (this.field_70180_af.func_75683_a((int)WATCHER_ID.CLIMBING.id) & 1) != 0;
    }

    protected void func_70069_a(float fallDistance) {
        if (this.useFlightNavigator()) {
            return;
        }
        fallDistance -= this.getFallResistance();
        if (this.getFallResistance() >= 100.0f) {
            fallDistance = 0.0f;
        }
        super.func_70069_a(fallDistance);
    }

    protected void func_70064_a(double fallDistance, boolean onGround) {
        if (!this.useFlightNavigator()) {
            super.func_70064_a(fallDistance, onGround);
        }
    }

    public void setBlocking() {
        this.currentBlockingTime = this.blockingTime;
    }

    public boolean isBlocking() {
        if (this.field_70170_p.field_72995_K) {
            return (this.field_70180_af.func_75683_a((int)WATCHER_ID.ANIMATION.id) & ANIM_ID.BLOCKING.id) > 0;
        }
        return this.currentBlockingTime > 0;
    }

    public int getBlockingMultiplier() {
        return 4;
    }

    public boolean canPickupEntity(Entity entity) {
        if (this.getPickupEntity() == entity) {
            return false;
        }
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(entity);
        if (extendedEntity == null) {
            return false;
        }
        if (entity.field_70154_o != null && !(entity.field_70154_o instanceof EntityBoat) && !(entity.field_70154_o instanceof EntityMinecart) || entity.field_70153_n != null) {
            return false;
        }
        if (entity instanceof EntityLivingBase && ObjectManager.getPotionEffect("weight") != null && ((EntityLivingBase)entity).func_70644_a((Potion)ObjectManager.getPotionEffect("weight"))) {
            return false;
        }
        return extendedEntity.pickedUpByEntity == null || extendedEntity.pickedUpByEntity instanceof EntityFear;
    }

    public void pickupEntity(Entity entity) {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(entity);
        if (extendedEntity != null) {
            extendedEntity.setPickedUpByEntity((Entity)this);
        }
        this.pickupEntity = entity;
    }

    public Entity getPickupEntity() {
        return this.pickupEntity;
    }

    public boolean hasPickupEntity() {
        return this.getPickupEntity() != null;
    }

    public void dropPickupEntity() {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity());
        if (extendedEntity != null) {
            extendedEntity.setPickedUpByEntity(null);
        }
        this.pickupEntity = null;
    }

    public double[] getPickupOffset(Entity entity) {
        return new double[]{0.0, 0.0, 0.0};
    }

    public void destroyArea(int x, int y, int z, float strength, boolean drop) {
        this.destroyArea(x, y, z, strength, drop, 0);
    }

    public void destroyArea(int x, int y, int z, float strength, boolean drop, int range) {
        int w = -((int)Math.ceil(this.field_70130_N) + range);
        while ((double)w <= Math.ceil(this.field_70130_N) + (double)range) {
            int d = -((int)Math.ceil(this.field_70130_N) + range);
            while ((double)d <= Math.ceil(this.field_70130_N) + (double)range) {
                int h = 0;
                while ((double)h <= Math.ceil(this.field_70131_O)) {
                    Block block = this.field_70170_p.func_147439_a(x + w, y + h, z + d);
                    if (block instanceof Block && block != null) {
                        float hardness = block.func_149712_f(this.field_70170_p, x + w, y + h, z + d);
                        Material material = block.func_149688_o();
                        if (hardness >= 0.0f && strength >= hardness && strength >= block.func_149638_a((Entity)this) && material != Material.field_151586_h && material != Material.field_151587_i) {
                            this.field_70170_p.func_147480_a(x + w, y + h, z + d, drop);
                        }
                    }
                    ++h;
                }
                ++d;
            }
            ++w;
        }
    }

    public boolean extraAnimation01() {
        return this.extraAnimation01;
    }

    protected Item func_146068_u() {
        if (this.drops != null && this.drops.get(0) != null && !this.isMinion() && !this.isBoundPet()) {
            return this.drops.get((int)0).item.func_77973_b();
        }
        return null;
    }

    protected void func_70628_a(boolean playerKill, int lootLevel) {
        if (this.field_70170_p.field_72995_K || this.isMinion() || this.isBoundPet()) {
            return;
        }
        int subspeciesScale = 1;
        if (this.getSubspeciesIndex() > 2) {
            subspeciesScale = Subspecies.rareDropScale;
        } else if (this.getSubspeciesIndex() > 0) {
            subspeciesScale = Subspecies.uncommonDropScale;
        }
        for (DropRate dropRate : this.drops) {
            if (dropRate.subspeciesID >= 0 && dropRate.subspeciesID != this.getSubspeciesIndex()) continue;
            int quantity = dropRate.getQuantity(this.field_70146_Z, lootLevel);
            if (dropRate.subspeciesID < 0) {
                quantity *= subspeciesScale;
            }
            if (this.extraMobBehaviour != null && this.extraMobBehaviour.itemDropMultiplierOverride != 1.0) {
                quantity = Math.round((float)quantity * (float)this.extraMobBehaviour.itemDropMultiplierOverride);
            }
            ItemStack dropStack = null;
            if (quantity > 0) {
                dropStack = dropRate.getItemStack((EntityLivingBase)this, quantity);
            }
            if (dropStack == null) continue;
            this.dropItem(dropStack);
        }
    }

    protected void func_70600_l(int par1) {
        if (this.isMinion() || this.isBoundPet()) {
            return;
        }
        super.func_70600_l(par1);
    }

    public void dropItem(ItemStack itemStack) {
        this.func_70099_a(itemStack, 0.0f);
    }

    public EntityItem func_70099_a(ItemStack itemStack, float heightOffset) {
        if (itemStack.field_77994_a != 0 && itemStack.func_77973_b() != null) {
            EntityItemCustom entityitem = new EntityItemCustom(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)heightOffset, this.field_70161_v, itemStack);
            entityitem.field_145804_b = 10;
            this.applyDropEffects(entityitem);
            if (this.captureDrops) {
                this.capturedDrops.add(entityitem);
            } else {
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            return entityitem;
        }
        return null;
    }

    public void applyDropEffects(EntityItemCustom entityitem) {
    }

    public void openGUI(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.addGUIViewer(player);
        this.refreshGUIViewers();
        this.openGUIToPlayer(player);
    }

    public void addGUIViewer(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            this.guiViewers.add(player);
        }
    }

    public void removeGUIViewer(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            this.guiViewers.remove(player);
        }
    }

    public void refreshGUIViewers() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.guiViewers.size() > 0) {
            for (EntityPlayer player : this.guiViewers.toArray(new EntityPlayer[this.guiViewers.size()])) {
                if (player.field_71070_bA == null || !(player.field_71070_bA instanceof ContainerCreature)) continue;
                if (((ContainerCreature)player.field_71070_bA).creature == this) {
                    this.openGUIToPlayer(player);
                    continue;
                }
                this.removeGUIViewer(player);
            }
        }
    }

    public void openGUIToPlayer(EntityPlayer player) {
        if (player != null) {
            player.openGui((Object)LycanitesMobs.instance, (int)GuiHandler.GuiType.ENTITY.id, this.field_70170_p, this.func_145782_y(), 0, 0);
        }
    }

    public void scheduleGUIRefresh() {
        this.guiRefreshTick = this.guiRefreshTime + 1;
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        if (this.assessInteractCommand(this.getInteractCommands(player, itemStack), player, itemStack)) {
            return true;
        }
        return super.func_70085_c(player);
    }

    public boolean assessInteractCommand(HashMap<Integer, String> commands, EntityPlayer player, ItemStack itemStack) {
        if (commands.isEmpty()) {
            return false;
        }
        int priority = 100;
        for (int testPriority : commands.keySet()) {
            if (testPriority >= priority) continue;
            priority = testPriority;
        }
        if (!commands.containsKey(priority)) {
            return false;
        }
        this.performCommand(commands.get(priority), player, itemStack);
        return true;
    }

    public HashMap<Integer, String> getInteractCommands(EntityPlayer player, ItemStack itemStack) {
        HashMap<Integer, String> commands = new HashMap<Integer, String>();
        if (itemStack != null) {
            if (itemStack.func_77973_b() == Items.field_151058_ca && this.canLeash(player)) {
                commands.put(CMD_PRIOR.ITEM_USE.id, "Leash");
            }
            if (itemStack.func_77973_b() == Items.field_151057_cb) {
                if (this.canNameTag(player)) {
                    return new HashMap<Integer, String>();
                }
                commands.put(CMD_PRIOR.ITEM_USE.id, "Name Tag");
            }
            if (this.canBeColored(player) && itemStack.func_77973_b() == Items.field_151100_aR) {
                commands.put(CMD_PRIOR.ITEM_USE.id, "Color");
            }
        }
        return commands;
    }

    public void performCommand(String command, EntityPlayer player, ItemStack itemStack) {
        int colorID;
        if ("Leash".equals(command)) {
            this.func_110162_b((Entity)player, true);
            this.consumePlayersItem(player, itemStack);
        }
        if ("Color".equals(command) && (colorID = BlockColored.func_150032_b((int)itemStack.func_77960_j())) != this.getColor()) {
            this.setColor(colorID);
            this.consumePlayersItem(player, itemStack);
        }
    }

    public boolean canNameTag(EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_94059_bO() {
        if (this.renderSubspeciesNameTag() && this.getSubspecies() != null) {
            return MobInfo.subspeciesTags;
        }
        return super.func_94059_bO();
    }

    public boolean renderSubspeciesNameTag() {
        return true;
    }

    public void consumePlayersItem(EntityPlayer player, ItemStack itemStack) {
        this.consumePlayersItem(player, itemStack, 1);
    }

    public void consumePlayersItem(EntityPlayer player, ItemStack itemStack, int amount) {
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.field_77994_a -= amount;
        }
        if (itemStack.field_77994_a <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
        }
    }

    public void replacePlayersItem(EntityPlayer player, ItemStack itemStack, ItemStack newStack) {
        this.replacePlayersItem(player, itemStack, 1, newStack);
    }

    public void replacePlayersItem(EntityPlayer player, ItemStack itemStack, int amount, ItemStack newStack) {
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.field_77994_a -= amount;
        }
        if (itemStack.field_77994_a <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newStack);
        } else if (!player.field_71071_by.func_70441_a(newStack)) {
            player.func_71019_a(newStack, false);
        }
    }

    public void performGUICommand(EntityPlayer player, byte guiCommandID) {
        this.scheduleGUIRefresh();
    }

    public boolean canCarryItems() {
        return this.getInventorySize() > 0;
    }

    public int getInventorySize() {
        return this.inventory.func_70302_i_();
    }

    public int getInventorySizeMax() {
        return Math.max(this.getNoBagSize(), this.getBagSize());
    }

    public boolean hasBag() {
        return this.inventory.getEquipmentStack("bag") != null;
    }

    public int getNoBagSize() {
        if (this.extraMobBehaviour != null && this.extraMobBehaviour.inventorySizeOverride > 0) {
            return this.extraMobBehaviour.inventorySizeOverride;
        }
        return 0;
    }

    public int getBagSize() {
        return 5;
    }

    public boolean canPickupItems() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.itemPickupOverride;
    }

    public int getSpaceForStack(ItemStack pickupStack) {
        return this.inventory.getSpaceForStack(pickupStack);
    }

    public boolean canEquip() {
        return this.mobInfo.isTameable();
    }

    public void func_70062_b(int slot, ItemStack itemStack) {
        String type = "item";
        if (slot == 0) {
            type = "weapon";
        }
        if (slot == 1) {
            type = "feet";
        }
        if (slot == 2) {
            type = "legs";
        }
        if (slot == 3) {
            type = "chest";
        }
        if (slot == 4) {
            type = "head";
        }
        if (slot == 100) {
            type = "bag";
        }
        this.inventory.setEquipmentStack(type, itemStack);
    }

    public String getEquipmentName(String type) {
        if (this.inventory.getEquipmentGrade(type) != null) {
            return type + this.inventory.getEquipmentGrade(type);
        }
        return null;
    }

    public int func_70658_aO() {
        return this.inventory.getArmorValue();
    }

    public void pickupItems() {
        List list = this.field_70170_p.func_72872_a(EntityItem.class, this.field_70121_D.func_72314_b(1.0, 0.0, 1.0));
        for (EntityItem entityItem : list) {
            ItemStack itemStack;
            int space;
            if (entityItem.field_70128_L || entityItem.func_92059_d() == null || (space = this.getSpaceForStack(itemStack = entityItem.func_92059_d())) <= 0) continue;
            this.onPickupStack(itemStack);
            this.doItemPickup(entityItem);
        }
    }

    public void onPickupStack(ItemStack itemStack) {
    }

    public void doItemPickup(EntityItem entityItem) {
        if (!entityItem.field_70128_L && entityItem.func_92059_d() != null) {
            ItemStack leftoverStack = this.inventory.autoInsertStack(entityItem.func_92059_d());
            if (leftoverStack != null) {
                entityItem.func_92058_a(leftoverStack);
            } else {
                entityItem.func_70106_y();
            }
        }
    }

    public boolean func_85032_ar() {
        return super.func_85032_ar();
    }

    public boolean isDamageTypeApplicable(String type) {
        return !"inWall".equals(type) && !"cactus".equals(type) || this.getSubspeciesIndex() < 3 && !this.isBoss();
    }

    public boolean isDamageEntityApplicable(Entity entity) {
        if (this.isBoss()) {
            if (entity == null) {
                return false;
            }
            return this.func_70032_d(entity) <= (float)this.bossRange;
        }
        return true;
    }

    public boolean func_70687_e(PotionEffect potionEffect) {
        return super.func_70687_e(potionEffect);
    }

    public boolean canBurn() {
        return this.extraMobBehaviour == null || !this.extraMobBehaviour.fireImmunityOverride;
    }

    public boolean daylightBurns() {
        return false;
    }

    public boolean waterDamage() {
        return false;
    }

    public boolean webproof() {
        return false;
    }

    public void func_70110_aj() {
        if (!this.webproof()) {
            super.func_70110_aj();
        }
    }

    public boolean func_70648_aU() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.waterBreathingOverride;
    }

    public boolean canBreatheAboveWater() {
        return true;
    }

    public void func_70050_g(int air) {
        if (air == 300 && !this.canBreatheAboveWater()) {
            return;
        }
        super.func_70050_g(air);
    }

    public boolean func_70090_H() {
        if (this.isLavaCreature) {
            return this.func_70058_J();
        }
        return super.func_70090_H();
    }

    public boolean waterContact() {
        if (this.func_70026_G()) {
            return true;
        }
        return this.field_70170_p.func_72896_J() && !this.isBlockUnderground((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
    }

    public boolean lavaContact() {
        return this.func_70058_J();
    }

    public boolean canBreatheAtLocation(int x, int y, int z) {
        Block block = this.field_70170_p.func_147439_a(x, y, z);
        if (block == null) {
            return true;
        }
        if (this.canBreatheAboveWater() && block.func_149688_o() == Material.field_151579_a) {
            return true;
        }
        if (this.func_70648_aU()) {
            if (!this.isLavaCreature && block.func_149688_o() == Material.field_151586_h) {
                return true;
            }
            if (this.isLavaCreature && block.func_149688_o() == Material.field_151587_i) {
                return true;
            }
        }
        return false;
    }

    public boolean isSwimmable(int x, int y, int z) {
        Block block = this.field_70170_p.func_147439_a(x, y, z);
        if (block == null) {
            return false;
        }
        if (this.isLavaCreature && Material.field_151587_i.equals(block.func_149688_o())) {
            return true;
        }
        return Material.field_151586_h.equals(block.func_149688_o());
    }

    public float getFallResistance() {
        return 0.0f;
    }

    public byte testLightLevel() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        return this.testLightLevel(i, j, k);
    }

    public byte testLightLevel(int x, int y, int z) {
        Block spawnBlock = this.field_70170_p.func_147439_a(x, y, z);
        if (y < 0) {
            return 0;
        }
        y = spawnBlock != null && spawnBlock.func_149688_o() == Material.field_151586_h && SpawnInfo.useSurfaceLightLevel ? this.getWaterSurfaceY(x, y, z) : this.getGroundY(x, y, z);
        int light = this.field_70170_p.func_72957_l(x, y, z);
        if (this.field_70170_p.func_72911_I()) {
            int i1 = this.field_70170_p.field_73008_k;
            this.field_70170_p.field_73008_k = 10;
            light = this.field_70170_p.func_72957_l(x, y, z);
            this.field_70170_p.field_73008_k = i1;
        }
        if (light == 0) {
            return 0;
        }
        if (light <= 7) {
            return 1;
        }
        if (light <= 14) {
            return 2;
        }
        return 3;
    }

    public boolean isDaytime() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70170_p.func_72935_r();
        }
        long time = this.field_70170_p.func_72820_D();
        if (time < 12500L) {
            return true;
        }
        return time < 12542L || time >= 23460L;
    }

    public int nearbyCreatureCount(Class targetClass, double range) {
        return this.getNearbyEntities(targetClass, range).size();
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return this.attribute;
    }

    public double func_70033_W() {
        return super.func_70033_W() - 0.5;
    }

    public List getNearbyEntities(Class targetClass, double range) {
        return this.field_70170_p.func_72872_a(targetClass, this.field_70121_D.func_72314_b(range, range, range));
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        this.firstSpawn = nbtTagCompound.func_74764_b("FirstSpawn") ? nbtTagCompound.func_74767_n("FirstSpawn") : false;
        if (nbtTagCompound.func_74764_b("SpawnEventType")) {
            this.spawnEventType = nbtTagCompound.func_74779_i("SpawnEventType");
        }
        if (nbtTagCompound.func_74764_b("SpawnEventCount")) {
            this.spawnEventCount = nbtTagCompound.func_74762_e("SpawnEventCount");
        }
        if (nbtTagCompound.func_74764_b("Stealth")) {
            this.setStealth(nbtTagCompound.func_74760_g("Stealth"));
        }
        if (nbtTagCompound.func_74764_b("IsMinion")) {
            this.setMinion(nbtTagCompound.func_74767_n("IsMinion"));
        }
        if (nbtTagCompound.func_74764_b("IsTemporary") && nbtTagCompound.func_74767_n("IsTemporary") && nbtTagCompound.func_74764_b("TemporaryDuration")) {
            this.setTemporary(nbtTagCompound.func_74762_e("TemporaryDuration"));
        } else {
            this.unsetTemporary();
        }
        if (nbtTagCompound.func_74764_b("IsBoundPet") && nbtTagCompound.func_74767_n("IsBoundPet") && !this.hasPetEntry()) {
            this.func_70106_y();
        }
        if (nbtTagCompound.func_74764_b("ForceNoDespawn")) {
            this.forceNoDespawn = nbtTagCompound.func_74767_n("ForceNoDespawn");
        }
        if (nbtTagCompound.func_74764_b("Color")) {
            this.setColor(nbtTagCompound.func_74771_c("Color"));
        }
        if (nbtTagCompound.func_74764_b("Subspecies")) {
            this.setSubspecies(nbtTagCompound.func_74771_c("Subspecies"), false);
        }
        if (nbtTagCompound.func_74764_b("Size")) {
            this.sizeScale = nbtTagCompound.func_74769_h("Size");
            this.updateSize();
        }
        super.func_70037_a(nbtTagCompound);
        this.inventory.readFromNBT(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("ExtraBehaviour")) {
            this.extraMobBehaviour.readFromNBT(nbtTagCompound.func_74775_l("ExtraBehaviour"));
        }
        if (nbtTagCompound.func_74764_b("HomeX") && nbtTagCompound.func_74764_b("HomeY") && nbtTagCompound.func_74764_b("HomeZ") && nbtTagCompound.func_74764_b("HomeDistanceMax")) {
            this.setHome(nbtTagCompound.func_74762_e("HomeX"), nbtTagCompound.func_74762_e("HomeY"), nbtTagCompound.func_74762_e("HomeZ"), nbtTagCompound.func_74760_g("HomeDistanceMax"));
        }
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74757_a("FirstSpawn", false);
        nbtTagCompound.func_74778_a("SpawnEventType", this.spawnEventType);
        nbtTagCompound.func_74768_a("SpawnEventCount", this.spawnEventCount);
        nbtTagCompound.func_74776_a("Stealth", this.getStealth());
        nbtTagCompound.func_74757_a("IsMinion", this.isMinion());
        nbtTagCompound.func_74757_a("IsTemporary", this.isTemporary);
        nbtTagCompound.func_74768_a("TemporaryDuration", this.temporaryDuration);
        nbtTagCompound.func_74757_a("IsBoundPet", this.isBoundPet());
        nbtTagCompound.func_74757_a("ForceNoDespawn", this.forceNoDespawn);
        nbtTagCompound.func_74774_a("Color", (byte)this.getColor());
        nbtTagCompound.func_74774_a("Subspecies", (byte)this.getSubspeciesIndex());
        nbtTagCompound.func_74780_a("Size", this.sizeScale);
        if (this.hasHome()) {
            ChunkCoordinates homePos = this.getHomePosition();
            nbtTagCompound.func_74768_a("HomeX", homePos.field_71574_a);
            nbtTagCompound.func_74768_a("HomeY", homePos.field_71572_b);
            nbtTagCompound.func_74768_a("HomeZ", homePos.field_71573_c);
            nbtTagCompound.func_74776_a("HomeDistanceMax", this.getHomeDistanceMax());
        }
        super.func_70014_b(nbtTagCompound);
        this.inventory.writeToNBT(nbtTagCompound);
        NBTTagCompound extTagCompound = new NBTTagCompound();
        this.extraMobBehaviour.writeToNBT(extTagCompound);
        nbtTagCompound.func_74782_a("ExtraBehaviour", (NBTBase)extTagCompound);
    }

    public boolean justAttacked() {
        return this.justAttacked > 0;
    }

    public void setJustAttacked() {
        this.justAttacked = this.justAttackedTime;
    }

    public ResourceLocation getTexture() {
        String textureName = this.getTextureName();
        if (this.getSubspecies() != null) {
            textureName = textureName + "_" + this.getSubspecies().name;
        }
        if (AssetManager.getTexture(textureName) == null) {
            AssetManager.addTexture(textureName, this.group, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }

    public ResourceLocation getEquipmentTexture(String equipmentName) {
        equipmentName = equipmentName.toLowerCase();
        String textureName = this.getTextureName();
        textureName = textureName + "_" + equipmentName;
        if (!this.canEquip()) {
            return this.getTexture();
        }
        if (AssetManager.getTexture(textureName) == null) {
            AssetManager.addTexture(textureName, this.group, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }

    public String getTextureName() {
        return this.mobInfo.name;
    }

    public boolean canBeColored(EntityPlayer player) {
        return false;
    }

    public int getColor() {
        if (this.field_70180_af == null) {
            return 0;
        }
        return this.field_70180_af.func_75683_a((int)WATCHER_ID.COLOR.id) & 0xF;
    }

    public void setColor(int color) {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b((int)WATCHER_ID.COLOR.id, (Object)((byte)(color & 0xF)));
        }
    }

    public boolean showBossHealthBar() {
        if (this.forceBossHealthBar) {
            return true;
        }
        if (this.getSubspeciesIndex() >= 3) {
            return Subspecies.rareHealthBars;
        }
        return false;
    }

    protected float func_70599_aP() {
        if (this.isBoss()) {
            return 4.0f;
        }
        if (this.getSubspeciesIndex() >= 3) {
            return 2.0f;
        }
        return 1.0f;
    }

    public int func_70627_aG() {
        return 80;
    }

    protected String func_70639_aQ() {
        return AssetManager.getSound(this.mobInfo.name + "_say");
    }

    protected String func_70621_aR() {
        return AssetManager.getSound(this.mobInfo.name + "_hurt");
    }

    protected String func_70673_aS() {
        return AssetManager.getSound(this.mobInfo.name + "_death");
    }

    protected void playStepSound(int x, int y, int z, Block block) {
        if (this.useFlightNavigator() || !this.hasStepSound) {
            return;
        }
        this.func_85030_a(AssetManager.getSound(this.mobInfo.name + "_step"), this.func_70599_aP() / 2.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.playStepSound(x, y, z, block);
    }

    public void playJumpSound() {
        if (!this.hasJumpSound) {
            return;
        }
        this.func_85030_a(AssetManager.getSound(this.mobInfo.name + "_jump"), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    protected void playFlySound() {
        if (!this.canFly()) {
            return;
        }
        this.func_85030_a(AssetManager.getSound(this.mobInfo.name + "_fly"), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    protected void playAttackSound() {
        if (!this.hasAttackSound) {
            return;
        }
        this.func_85030_a(AssetManager.getSound(this.mobInfo.name + "_attack"), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void func_85030_a(String soundName, float par2, float par3) {
        if (soundName == null) {
            return;
        }
        super.func_85030_a(soundName, par2, par3);
    }

    static /* synthetic */ byte access$008() {
        byte by = watcherID;
        watcherID = (byte)(by + 1);
        return by;
    }

    public static enum GUI_COMMAND_ID {
        CLOSE(0),
        SITTING(1),
        FOLLOWING(2),
        PASSIVE(3),
        STANCE(4),
        PVP(5),
        TELEPORT(6),
        SPAWNING(7),
        RELEASE(8);

        public byte id;

        private GUI_COMMAND_ID(byte i) {
            this.id = i;
        }
    }

    public static enum CMD_PRIOR {
        OVERRIDE(0),
        IMPORTANT(1),
        EQUIPPING(2),
        ITEM_USE(3),
        EMPTY_HAND(4),
        MAIN(5);

        public final int id;

        private CMD_PRIOR(int value) {
            this.id = value;
        }

        public int getValue() {
            return this.id;
        }
    }

    public static enum ANIM_ID {
        ATTACKED(1),
        GROUNDED(2),
        BLOCKING(4),
        MINION(8),
        EXTRA01(8);

        public final byte id;

        private ANIM_ID(byte value) {
            this.id = value;
        }

        public byte getValue() {
            return this.id;
        }
    }

    public static enum TARGET_ID {
        ATTACK(1),
        MASTER(2),
        PARENT(4),
        AVOID(8),
        RIDER(16);

        public final byte id;

        private TARGET_ID(byte value) {
            this.id = value;
        }

        public byte getValue() {
            return this.id;
        }
    }

    public static enum WATCHER_ID {
        HEALTH(EntityCreatureBase.access$008()),
        TARGET(EntityCreatureBase.access$008()),
        ANIMATION(EntityCreatureBase.access$008()),
        ATTACK_PHASE(EntityCreatureBase.access$008()),
        CLIMBING(EntityCreatureBase.access$008()),
        STEALTH(EntityCreatureBase.access$008()),
        HUNGER(EntityCreatureBase.access$008()),
        STAMINA(EntityCreatureBase.access$008()),
        AGE(EntityCreatureBase.access$008()),
        LOVE(EntityCreatureBase.access$008()),
        TAMED(EntityCreatureBase.access$008()),
        OWNER(EntityCreatureBase.access$008()),
        COLOR(EntityCreatureBase.access$008()),
        SIZE(EntityCreatureBase.access$008()),
        SUBSPECIES(EntityCreatureBase.access$008()),
        LAST(EntityCreatureBase.access$008()),
        SPECIAL(EntityCreatureBase.access$008()),
        EQUIPMENT(EntityCreatureBase.access$008());

        public final byte id;

        private WATCHER_ID(byte value) {
            this.id = value;
        }

        public byte getValue() {
            return this.id;
        }
    }
}

