/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.entity;

import java.util.HashMap;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.ExtendedPlayer;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureTameable;
import lycanite.lycanitesmobs.api.info.MobInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityCreatureRideable
extends EntityCreatureTameable {
    public Entity lastRiddenByEntity = null;
    public boolean mountJumping = false;
    public float jumpPower = 0.0f;
    public boolean abilityToggled = false;
    public boolean inventoryToggled = false;

    public EntityCreatureRideable(World world) {
        super(world);
        this.hasJumpSound = true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public double getSpeedMultiplier() {
        if (this.hasRiderTarget()) {
            return this.mobInfo.multiplierSpeed;
        }
        return super.getSpeedMultiplier();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.lastRiddenByEntity != this.field_70153_n) {
            if (this.lastRiddenByEntity != null) {
                this.onDismounted(this.lastRiddenByEntity);
            }
            this.lastRiddenByEntity = this.field_70153_n;
        }
        if (this.hasRiderTarget() && this.getRiderTarget() instanceof EntityLivingBase) {
            EntityLivingBase riderLiving = (EntityLivingBase)this.getRiderTarget();
            this.riderEffects(riderLiving);
            for (Object possibleEffect : riderLiving.func_70651_bq()) {
                PotionEffect potionEffect;
                if (!(possibleEffect instanceof PotionEffect) || this.func_70687_e(potionEffect = (PotionEffect)possibleEffect)) continue;
                riderLiving.func_82170_o(potionEffect.func_76456_a());
            }
        }
        if (this.hasRiderTarget()) {
            if (this.getRiderTarget() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)this.getRiderTarget();
                ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
                if (playerExt == null) {
                    return;
                }
                if (playerExt.isControlActive(ExtendedPlayer.CONTROL_ID.MOUNT_ABILITY)) {
                    this.mountAbility((Entity)player);
                    this.abilityToggled = true;
                } else {
                    this.abilityToggled = false;
                }
                if (playerExt.isControlActive(ExtendedPlayer.CONTROL_ID.MOUNT_INVENTORY)) {
                    if (!this.inventoryToggled) {
                        this.openGUI(player);
                    }
                    this.inventoryToggled = true;
                } else {
                    this.inventoryToggled = false;
                }
            }
        } else {
            this.abilityToggled = false;
            this.inventoryToggled = false;
        }
    }

    public void riderEffects(EntityLivingBase rider) {
        if (!rider.func_70648_aU() && rider.func_70090_H()) {
            rider.func_70050_g(300);
        }
    }

    public void mountAbility(Entity rider) {
    }

    public void onDismounted(Entity entity) {
    }

    @Override
    public boolean func_70104_M() {
        return this.field_70153_n == null;
    }

    protected boolean func_70610_aX() {
        return false;
    }

    public void func_70043_V() {
        if (this.hasRiderTarget()) {
            this.getRiderTarget().func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + this.getRiderTarget().func_70033_W(), this.field_70161_v);
        }
    }

    private void mountedByEntity(Entity entity) {
        entity.field_70177_z = this.field_70177_z;
        entity.field_70125_A = this.field_70125_A;
        if (!this.field_70170_p.field_72995_K) {
            entity.func_70078_a((Entity)this);
        }
    }

    @Override
    public void func_70612_e(float moveStrafe, float moveForward) {
        EntityPlayer player;
        ExtendedPlayer playerExt;
        if (!(this.isTamed() && this.hasSaddle() && this.hasRiderTarget() && this.getRiderTarget() instanceof EntityLivingBase && this.riderControl())) {
            super.func_70612_e(moveStrafe, moveForward);
            return;
        }
        EntityLivingBase rider = (EntityLivingBase)this.getRiderTarget();
        this.field_70126_B = this.field_70177_z = rider.field_70177_z;
        this.field_70125_A = rider.field_70125_A * 0.5f;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.field_70759_as = this.field_70761_aq = this.field_70177_z;
        moveStrafe = rider.field_70702_br * 0.5f;
        moveForward = rider.field_70701_bs;
        if (!this.isMountJumping() && this.field_70122_E && this.getRiderTarget() instanceof EntityPlayer && (playerExt = ExtendedPlayer.getForPlayer(player = (EntityPlayer)this.getRiderTarget())) != null && playerExt.isControlActive(ExtendedPlayer.CONTROL_ID.JUMP)) {
            this.startJumping();
        }
        if (this.getJumpPower() > 0.0f && !this.isMountJumping() && this.field_70122_E) {
            this.field_70181_x = this.getMountJumpHeight() * (double)this.getJumpPower();
            if (this.func_70644_a(Potion.field_76430_j)) {
                this.field_70181_x += (double)((float)(this.func_70660_b(Potion.field_76430_j).func_76458_c() + 1) * 0.1f);
            }
            this.setMountJumping(true);
            this.field_70160_al = true;
            if (moveForward > 0.0f) {
                float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                this.field_70159_w += (double)(-0.4f * f2 * this.jumpPower);
                this.field_70179_y += (double)(0.4f * f3 * this.jumpPower);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.playJumpSound();
            }
            this.setJumpPower(0);
        }
        this.field_70747_aH = (float)((double)this.func_70689_ay() * this.getGlideScale());
        if (!this.field_70170_p.field_72995_K) {
            this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            super.func_70612_e(moveStrafe, moveForward);
        }
        if (this.field_70122_E) {
            this.setJumpPower(0);
            this.setMountJumping(false);
        }
        this.field_70722_aY = this.field_70721_aZ;
        double d0 = this.field_70165_t - this.field_70169_q;
        double d1 = this.field_70161_v - this.field_70166_s;
        float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    public void startJumping() {
        this.setJumpPower();
    }

    public double getMountJumpHeight() {
        return 0.75;
    }

    public boolean isMountJumping() {
        return this.mountJumping;
    }

    public void setMountJumping(boolean set) {
        this.mountJumping = set;
    }

    public void setJumpPower(int power) {
        if (power < 0) {
            power = 0;
        }
        if (power > 99) {
            power = 99;
        }
        this.jumpPower = power < 90 ? 1.0f * ((float)power / 89.0f) : 1.0f + 1.0f * ((float)(power - 89) / 10.0f);
    }

    public void setJumpPower() {
        this.setJumpPower(89);
    }

    public float getJumpPower() {
        return this.jumpPower;
    }

    public double getGlideScale() {
        return 0.1f;
    }

    public boolean riderControl() {
        return true;
    }

    @Override
    public HashMap<Integer, String> getInteractCommands(EntityPlayer player, ItemStack itemStack) {
        HashMap<Integer, String> commands = new HashMap<Integer, String>();
        commands.putAll(super.getInteractCommands(player, itemStack));
        if (this.canBeMounted((Entity)player) && !player.func_70093_af() && !this.field_70170_p.field_72995_K && MobInfo.mountingEnabled) {
            commands.put(EntityCreatureBase.CMD_PRIOR.MAIN.id, "Mount");
        }
        return commands;
    }

    @Override
    public void performCommand(String command, EntityPlayer player, ItemStack itemStack) {
        if (command.equals("Mount")) {
            this.playMountSound();
            this.clearMovement();
            this.func_70624_b(null);
            this.mountedByEntity((Entity)player);
        }
        super.performCommand(command, player, itemStack);
    }

    @Override
    public Team func_96124_cp() {
        EntityLivingBase rider;
        if (this.hasRiderTarget() && (rider = this.getRider()) != null) {
            return rider.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    @Override
    public boolean func_142014_c(EntityLivingBase target) {
        if (this.hasRiderTarget()) {
            EntityLivingBase rider = this.getRider();
            if (target == rider) {
                return true;
            }
            if (rider != null) {
                return rider.func_142014_c(target);
            }
        }
        return super.func_142014_c(target);
    }

    @Override
    public boolean canSit() {
        return false;
    }

    public boolean canBeMounted(Entity entity) {
        if (this.getRiderTarget() != null) {
            return false;
        }
        if (this.isTamed() && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.func_70005_c_().equalsIgnoreCase(this.getOwnerName())) {
                return this.hasSaddle() && !this.func_70631_g_();
            }
        } else if (!this.isTamed() && !(entity instanceof EntityPlayer)) {
            return !this.func_70631_g_();
        }
        return false;
    }

    public boolean hasSaddle() {
        return this.inventory.getEquipmentStack("saddle") != null;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damage) {
        Entity entity = damageSource.func_76346_g();
        return this.field_70153_n != null && this.field_70153_n.equals((Object)entity) ? false : super.func_70097_a(damageSource, damage);
    }

    @Override
    public float getFallResistance() {
        return 2.0f;
    }

    public void playMountSound() {
        this.func_85030_a(AssetManager.getSound(this.mobInfo.name + "_mount"), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }
}

