/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.entity;

import cpw.mods.fml.common.eventhandler.Event;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureTameable;
import lycanite.lycanitesmobs.api.info.GroupInfo;
import lycanite.lycanitesmobs.api.info.MobInfo;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;

public class EntityProjectileBase
extends EntityThrowable {
    public String entityName = "projectile";
    public GroupInfo group;
    public boolean movement = true;
    public byte baseDamage = 1;
    public float projectileScale = 1.0f;
    public int projectileLife = 200;
    public double knockbackChance = 1.0;
    public boolean pierce = false;
    public boolean pierceBlocks = false;
    public boolean waterProof = false;
    public boolean lavaProof = false;
    public int projectileScaleID = 10;
    public int animationFrame = 0;
    public int animationFrameMax = 0;
    public int textureTiling = 1;
    public boolean clientOnly = false;

    public EntityProjectileBase(World world) {
        super(world);
        this.field_70180_af.func_75682_a(this.projectileScaleID, (Object)Float.valueOf(this.projectileScale));
        this.func_70105_a(0.3125f, 0.3125f);
        this.setup();
    }

    public EntityProjectileBase(World world, EntityLivingBase entityLiving) {
        super(world, entityLiving);
        this.field_70180_af.func_75682_a(this.projectileScaleID, (Object)Float.valueOf(this.projectileScale));
        this.func_70105_a(0.3125f, 0.3125f);
        this.setup();
    }

    public EntityProjectileBase(World world, double par2, double par4, double par6) {
        super(world, par2, par4, par6);
        this.field_70180_af.func_75682_a(this.projectileScaleID, (Object)Float.valueOf(this.projectileScale));
        this.func_70105_a(0.3125f, 0.3125f);
        this.setup();
    }

    public void setup() {
    }

    public void setProjectileSize(float width, float height) {
        this.func_70105_a(width, height);
    }

    public void func_70071_h_() {
        if (!this.movement) {
            this.field_70193_a = false;
            this.field_71088_bW = this.func_82147_ab();
        }
        double initX = this.field_70165_t;
        double initY = this.field_70163_u;
        double initZ = this.field_70161_v;
        super.func_70071_h_();
        if (!this.movement) {
            this.field_70165_t = initX;
            this.field_70163_u = initY;
            this.field_70161_v = initZ;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (this.field_70134_J) {
            this.field_70134_J = false;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!this.waterProof && this.func_70090_H()) {
                this.func_70106_y();
            } else if (!this.lavaProof && this.func_70055_a(Material.field_151587_i)) {
                this.func_70106_y();
            }
        }
        if ((!this.field_70170_p.field_72995_K || this.clientOnly) && this.projectileLife-- <= 0) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0) {
            this.projectileScale = this.field_70180_af.func_111145_d(this.projectileScaleID);
        }
        if (this.animationFrameMax > 0) {
            this.animationFrame = this.animationFrame == this.animationFrameMax || this.animationFrame < 0 ? 0 : ++this.animationFrame;
        }
    }

    protected float func_70185_h() {
        return 0.03f;
    }

    protected void func_70184_a(MovingObjectPosition movingObjectPosition) {
        boolean collided = false;
        boolean entityCollision = false;
        boolean blockCollision = false;
        if (movingObjectPosition.field_72308_g != null) {
            if (movingObjectPosition.field_72308_g == this.func_85052_h()) {
                return;
            }
            boolean doDamage = true;
            if (movingObjectPosition.field_72308_g instanceof EntityLivingBase) {
                doDamage = this.canDamage((EntityLivingBase)movingObjectPosition.field_72308_g);
            }
            if (doDamage) {
                EntityLivingBase target;
                this.entityCollision(movingObjectPosition.field_72308_g);
                if (movingObjectPosition.field_72308_g instanceof EntityLivingBase && this.entityLivingCollision(target = (EntityLivingBase)movingObjectPosition.field_72308_g)) {
                    float damage;
                    boolean attackSuccess = false;
                    float damageInit = damage = this.getDamage((Entity)target);
                    double pierceValue = 5.0;
                    if (this.func_85052_h() instanceof EntityCreatureBase) {
                        pierceValue = ((EntityCreatureBase)this.func_85052_h()).getPierceValue();
                    }
                    float pierceDamage = 1.0f + (float)Math.floor((double)damage / pierceValue);
                    double targetKnockbackResistance = 0.0;
                    if (this.knockbackChance < 1.0 && (this.knockbackChance <= 0.0 || this.field_70146_Z.nextDouble() <= this.knockbackChance) && target instanceof EntityLivingBase) {
                        targetKnockbackResistance = target.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
                        target.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
                    }
                    if (this.func_85052_h() instanceof EntityCreatureBase) {
                        EntityCreatureBase creatureThrower = (EntityCreatureBase)this.func_85052_h();
                        if (damage <= pierceDamage) {
                            attackSuccess = target.func_70097_a(creatureThrower.getDamageSource((EntityDamageSource)DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()).func_76348_h()).func_151518_m(), damage);
                        } else {
                            int hurtResistantTimeBefore = target.field_70172_ad;
                            target.func_70097_a(creatureThrower.getDamageSource((EntityDamageSource)DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()).func_76348_h()).func_151518_m(), pierceDamage);
                            target.field_70172_ad = hurtResistantTimeBefore;
                            attackSuccess = target.func_70097_a(creatureThrower.getDamageSource((EntityDamageSource)DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h())), damage -= pierceDamage);
                        }
                    } else if (damage <= pierceDamage) {
                        attackSuccess = target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()).func_76348_h().func_151518_m(), damage);
                    } else {
                        int hurtResistantTimeBefore = target.field_70172_ad;
                        target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()).func_76348_h().func_151518_m(), pierceDamage);
                        target.field_70172_ad = hurtResistantTimeBefore;
                        attackSuccess = target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), damage -= pierceDamage);
                    }
                    this.onDamage(target, damageInit, attackSuccess);
                    if (this.knockbackChance < 1.0 && (this.knockbackChance <= 0.0 || this.field_70146_Z.nextDouble() <= this.knockbackChance) && target instanceof EntityLivingBase) {
                        target.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(targetKnockbackResistance);
                    }
                }
            }
            collided = true;
            entityCollision = true;
            int i = (int)Math.floor(movingObjectPosition.field_72308_g.field_70165_t);
            int j = (int)Math.floor(movingObjectPosition.field_72308_g.field_70163_u);
            int k = (int)Math.floor(movingObjectPosition.field_72308_g.field_70161_v);
            if (!this.field_70170_p.field_72995_K && this.canDestroyBlock(i, j, k)) {
                this.placeBlock(this.field_70170_p, i, j, k);
            }
        } else {
            int i = movingObjectPosition.field_72311_b;
            int j = movingObjectPosition.field_72312_c;
            int k = movingObjectPosition.field_72309_d;
            if (this.field_70170_p.func_147439_a(i, j, k) != null) {
                boolean bl = collided = this.field_70170_p.func_147439_a(i, j, k).func_149668_a(this.field_70170_p, i, j, k) != null;
            }
            if (collided) {
                blockCollision = true;
                switch (movingObjectPosition.field_72310_e) {
                    case 0: {
                        --j;
                        break;
                    }
                    case 1: {
                        ++j;
                        break;
                    }
                    case 2: {
                        --k;
                        break;
                    }
                    case 3: {
                        ++k;
                        break;
                    }
                    case 4: {
                        --i;
                        break;
                    }
                    case 5: {
                        ++i;
                    }
                }
                if (!this.field_70170_p.field_72995_K && this.canDestroyBlock(i, j, k)) {
                    this.placeBlock(this.field_70170_p, i, j, k);
                }
            }
        }
        if (collided) {
            boolean blockPierced;
            if (!this.field_70170_p.field_72995_K) {
                this.onImpact();
            } else {
                this.onImpactVisuals();
            }
            boolean entityPierced = this.pierce && entityCollision;
            boolean bl = blockPierced = this.pierceBlocks && blockCollision;
            if (!(this.field_70170_p.field_72995_K || entityPierced || blockPierced)) {
                this.func_70106_y();
            }
        }
    }

    public boolean canDamage(EntityLivingBase targetEntity) {
        EntityLivingBase owner = this.func_85052_h();
        if (owner != null) {
            EntityCreatureBase ownerCreature;
            if (owner instanceof EntityCreatureBase && !(ownerCreature = (EntityCreatureBase)owner).canAttackEntity(targetEntity)) {
                return false;
            }
            if (owner instanceof EntityPlayer && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)owner, (Entity)targetEntity))) {
                return false;
            }
            if (!MinecraftServer.func_71276_C().func_71219_W() && owner instanceof EntityPlayer) {
                EntityCreatureTameable tamedTarget;
                if (targetEntity instanceof EntityPlayer) {
                    return false;
                }
                if (targetEntity instanceof EntityCreatureTameable && (tamedTarget = (EntityCreatureTameable)targetEntity).isTamed()) {
                    return false;
                }
            }
            if (owner.func_142014_c(targetEntity) && MobInfo.friendlyFire) {
                return false;
            }
        }
        return true;
    }

    public void onDamage(EntityLivingBase target, float damage, boolean attackSuccess) {
    }

    public void entityCollision(Entity entity) {
    }

    public boolean entityLivingCollision(EntityLivingBase entityLiving) {
        return true;
    }

    public boolean canDestroyBlock(int x, int y, int z) {
        return this.field_70170_p.func_147437_c(x, y, z);
    }

    public void placeBlock(World world, int x, int y, int z) {
    }

    public void onImpact() {
    }

    public void onImpactVisuals() {
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        return false;
    }

    public void setProjectileScale(float newScale) {
        this.projectileScale = newScale;
        if (this.field_70170_p.field_72995_K && !this.clientOnly) {
            return;
        }
        this.field_70180_af.func_75692_b(this.projectileScaleID, (Object)Float.valueOf(this.projectileScale));
        if (this.func_85052_h() != null && this.func_85052_h() instanceof EntityCreatureBase) {
            this.projectileScale = (float)((double)this.projectileScale * ((EntityCreatureBase)this.func_85052_h()).sizeScale);
        }
    }

    public float getProjectileScale() {
        return this.projectileScale;
    }

    public float getTextureOffsetY() {
        return 0.0f;
    }

    public void setBaseDamage(int newDamage) {
        this.baseDamage = (byte)newDamage;
    }

    public float getDamage(Entity entity) {
        float damage = this.baseDamage;
        if (this.func_85052_h() != null && this.func_85052_h() instanceof EntityCreatureBase) {
            damage = (float)((double)damage * ((EntityCreatureBase)this.func_85052_h()).getAttackDamageScale());
        }
        return damage;
    }

    public int getEffectDuration(int seconds) {
        if (this.func_85052_h() != null && this.func_85052_h() instanceof EntityCreatureBase) {
            return ((EntityCreatureBase)this.func_85052_h()).getEffectDuration(seconds);
        }
        return seconds * 20;
    }

    public float getEffectStrength(float value) {
        if (this.func_85052_h() != null && this.func_85052_h() instanceof EntityCreatureBase) {
            return ((EntityCreatureBase)this.func_85052_h()).getEffectStrength(value);
        }
        return value;
    }

    public double[] getFacingPosition(double distance) {
        return this.getFacingPosition((Entity)this, distance, 0.0);
    }

    public double[] getFacingPosition(Entity entity, double distance, double angleOffset) {
        double angle = Math.toRadians(entity.field_70177_z) + angleOffset;
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        double[] coords = new double[]{entity.field_70165_t + distance * xAmount, entity.field_70163_u, entity.field_70161_v + distance * zAmount};
        return coords;
    }

    public ResourceLocation getTexture() {
        if (AssetManager.getTexture(this.entityName) == null) {
            AssetManager.addTexture(this.entityName, this.group, "textures/items/" + this.entityName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(this.entityName);
    }

    public String getLaunchSound() {
        return AssetManager.getSound(this.entityName);
    }
}

