/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.entity.ai;

import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;

public abstract class EntityAITarget
extends EntityAIBase {
    protected EntityCreatureBase host;
    protected EntityLivingBase target;
    protected IEntitySelector targetSelector;
    protected boolean checkSight = true;
    protected boolean nearbyOnly = false;
    private int cantSeeTime;
    protected int cantSeeTimeMax = 60;
    private int targetSearchStatus;
    private int targetSearchDelay;

    public EntityAITarget(EntityCreatureBase setHost) {
        this.host = setHost;
    }

    public void func_75249_e() {
        this.setTarget(this.target);
        this.targetSearchStatus = 0;
        this.targetSearchDelay = 0;
        this.cantSeeTime = 0;
    }

    public boolean func_75253_b() {
        if (this.getTarget() == null) {
            return false;
        }
        if (!this.getTarget().func_70089_S()) {
            return false;
        }
        double distance = this.getTargetDistance();
        if (this.host.func_70068_e((Entity)this.getTarget()) > distance * distance) {
            return false;
        }
        if (this.checkSight) {
            if (this.host.func_70635_at().func_75522_a((Entity)this.getTarget())) {
                this.cantSeeTime = 0;
            } else if (++this.cantSeeTime > this.cantSeeTimeMax) {
                return false;
            }
        }
        return true;
    }

    public void func_75251_c() {
        this.setTarget(null);
    }

    protected EntityLivingBase getTarget() {
        return null;
    }

    protected void setTarget(EntityLivingBase newTarget) {
    }

    protected double getTargetDistance() {
        IAttributeInstance attributeInstance = this.host.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return attributeInstance == null ? 16.0 : attributeInstance.func_111126_e();
    }

    protected boolean isSuitableTarget(EntityLivingBase checkTarget, boolean targetCreative) {
        if (checkTarget == null) {
            return false;
        }
        if (checkTarget == this.host) {
            return false;
        }
        if (!checkTarget.func_70089_S()) {
            return false;
        }
        if (!this.isValidTarget(checkTarget)) {
            return false;
        }
        if (checkTarget instanceof EntityPlayer && !targetCreative && ((EntityPlayer)checkTarget).field_71075_bZ.field_75102_a) {
            return false;
        }
        if (!this.host.positionNearHome(MathHelper.func_76128_c((double)checkTarget.field_70165_t), MathHelper.func_76128_c((double)checkTarget.field_70163_u), MathHelper.func_76128_c((double)checkTarget.field_70161_v))) {
            return false;
        }
        if (this.checkSight && !this.host.func_70635_at().func_75522_a((Entity)checkTarget)) {
            return false;
        }
        if (this.nearbyOnly) {
            if (--this.targetSearchDelay <= 0) {
                this.targetSearchStatus = 0;
            }
            if (this.targetSearchStatus == 0) {
                int n = this.targetSearchStatus = this.isNearby(checkTarget) ? 1 : 2;
            }
            if (this.targetSearchStatus == 2) {
                return false;
            }
        }
        return true;
    }

    protected boolean isValidTarget(EntityLivingBase target) {
        return true;
    }

    private boolean isNearby(EntityLivingBase target) {
        int j;
        this.targetSearchDelay = 10 + this.host.func_70681_au().nextInt(5);
        PathEntity pathentity = this.host.func_70661_as().func_75494_a((Entity)target);
        if (pathentity == null) {
            return false;
        }
        PathPoint pathpoint = pathentity.func_75870_c();
        if (pathpoint == null) {
            return false;
        }
        int i = pathpoint.field_75839_a - MathHelper.func_76128_c((double)target.field_70165_t);
        return (double)(i * i + (j = pathpoint.field_75838_c - MathHelper.func_76128_c((double)target.field_70161_v)) * j) <= 2.25;
    }
}

