/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.entity.ai;

import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;

public class FlightNavigator {
    EntityCreatureBase host;
    public ChunkCoordinates targetPosition;
    public double flyingSpeed = 1.0;
    public boolean faceMovement = true;
    public double speedModifier = 1.0;
    private double randomStrafeAngle = 0.0;

    public FlightNavigator(EntityCreatureBase setHost) {
        this.host = setHost;
    }

    public FlightNavigator setSpeed(double setSpeed) {
        this.flyingSpeed = setSpeed;
        return this;
    }

    public FlightNavigator setFacing(boolean facing) {
        this.faceMovement = facing;
        return this;
    }

    public boolean setTargetPosition(ChunkCoordinates targetPosition, double setSpeedMod) {
        if (this.isTargetPositionValid(targetPosition)) {
            this.targetPosition = targetPosition;
            this.speedModifier = setSpeedMod;
            return true;
        }
        return false;
    }

    public boolean setTargetPosition(Entity targetEntity, double setSpeedMod) {
        return this.setTargetPosition(new ChunkCoordinates((int)targetEntity.field_70165_t, (int)targetEntity.field_70163_u, (int)targetEntity.field_70161_v), setSpeedMod);
    }

    public boolean clearTargetPosition(double setSpeedMod) {
        return this.setTargetPosition((ChunkCoordinates)null, setSpeedMod);
    }

    public boolean isTargetPositionValid() {
        return this.isTargetPositionValid(this.targetPosition);
    }

    public boolean isTargetPositionValid(ChunkCoordinates targetPosition) {
        if (targetPosition == null) {
            return true;
        }
        if (this.host.canSwim() && this.host.isSwimmable(targetPosition.field_71574_a, targetPosition.field_71572_b, targetPosition.field_71573_c)) {
            return true;
        }
        if (!this.host.canFly()) {
            return false;
        }
        if (!this.host.field_70170_p.func_147437_c(targetPosition.field_71574_a, targetPosition.field_71572_b, targetPosition.field_71573_c) && !this.host.field_70145_X) {
            return false;
        }
        return targetPosition.field_71572_b >= 3;
    }

    public double distanceToTargetPosition() {
        return this.host.func_70011_f(this.targetPosition.field_71574_a, this.targetPosition.field_71572_b, this.targetPosition.field_71573_c);
    }

    public boolean atTargetPosition() {
        if (this.targetPosition != null) {
            return this.distanceToTargetPosition() < (double)(this.host.field_70130_N / 2.0f);
        }
        return true;
    }

    public void updateFlight() {
        if (this.targetPosition == null) {
            return;
        }
        if (this.randomStrafeAngle <= 0.0 && this.host.func_70681_au().nextDouble() <= 0.25) {
            double d = this.randomStrafeAngle = this.host.func_70681_au().nextBoolean() ? 90.0 : -90.0;
        }
        if (this.randomStrafeAngle > 0.0) {
            this.randomStrafeAngle -= 0.5;
        }
        double[] coords = this.host.getFacingPosition((double)this.targetPosition.field_71574_a + 0.5, this.targetPosition.field_71572_b, (double)this.targetPosition.field_71573_c + 0.5, 1.0, this.randomStrafeAngle);
        double dirX = coords[0] - this.host.field_70165_t;
        double dirY = (double)this.targetPosition.field_71572_b + 0.1 - this.host.field_70163_u;
        double dirZ = coords[2] - this.host.field_70161_v;
        double speed = this.host.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 2.0;
        this.host.field_70159_w += (Math.signum(dirX) * speed - this.host.field_70159_w) * (double)0.1f * 0.3 * this.speedModifier;
        this.host.field_70181_x += (Math.signum(dirY) * speed - this.host.field_70181_x) * (double)0.1f * 0.3 * this.speedModifier;
        this.host.field_70179_y += (Math.signum(dirZ) * speed - this.host.field_70179_y) * (double)0.1f * 0.3 * this.speedModifier;
        float fullAngle = (float)(Math.atan2(this.host.field_70179_y, this.host.field_70159_w) * 180.0 / Math.PI) - 90.0f;
        float angle = MathHelper.func_76142_g((float)(fullAngle - this.host.field_70177_z));
        this.host.field_70701_bs = 0.5f;
        if (this.faceMovement && this.host.func_70638_az() != null && (this.host.field_70159_w > (double)0.025f || this.host.field_70179_y > (double)0.025f)) {
            this.host.field_70177_z += angle;
        }
    }

    public void flightMovement(float moveStrafe, float moveForward) {
        if (this.host.func_70090_H() && !this.host.canSwim()) {
            this.host.func_70060_a(moveStrafe, moveForward, 0.02f);
            this.host.func_70091_d(this.host.field_70159_w, this.host.field_70181_x, this.host.field_70179_y);
            this.host.field_70159_w *= (double)0.8f;
            this.host.field_70181_x *= (double)0.8f;
            this.host.field_70179_y *= (double)0.8f;
        } else if (this.host.func_70058_J() && !this.host.canSwim()) {
            this.host.func_70060_a(moveStrafe, moveForward, 0.02f);
            this.host.func_70091_d(this.host.field_70159_w, this.host.field_70181_x, this.host.field_70179_y);
            this.host.field_70159_w *= 0.5;
            this.host.field_70181_x *= 0.5;
            this.host.field_70179_y *= 0.5;
        } else {
            float motion = 0.91f;
            if (this.host.field_70122_E) {
                motion = 0.54600006f;
                Block block = this.host.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.host.field_70165_t), MathHelper.func_76128_c((double)this.host.field_70121_D.field_72338_b) - 1, MathHelper.func_76128_c((double)this.host.field_70161_v));
                if (block != null) {
                    motion = block.field_149765_K * 0.91f;
                }
            }
            float flyingMotion = 0.16277136f / (motion * motion * motion);
            this.host.func_70060_a(moveStrafe, moveForward, this.host.field_70122_E ? 0.1f * flyingMotion : (float)((double)0.02f * this.speedModifier));
            motion = 0.91f;
            if (this.host.field_70122_E) {
                motion = 0.54600006f;
                Block block = this.host.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.host.field_70165_t), MathHelper.func_76128_c((double)this.host.field_70121_D.field_72338_b) - 1, MathHelper.func_76128_c((double)this.host.field_70161_v));
                if (block != null) {
                    motion = block.field_149765_K * 0.91f;
                }
            }
            if (this.host != null && this.host.field_70121_D != null) {
                this.host.func_70091_d(this.host.field_70159_w, this.host.field_70181_x, this.host.field_70179_y);
            }
            this.host.field_70159_w *= (double)motion;
            this.host.field_70181_x *= (double)motion;
            this.host.field_70179_y *= (double)motion;
        }
        this.host.field_70722_aY = this.host.field_70721_aZ;
        double deltaX = this.host.field_70165_t - this.host.field_70169_q;
        double deltaZ = this.host.field_70161_v - this.host.field_70166_s;
        float var7 = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ)) * 4.0f;
        if (var7 > 1.0f) {
            var7 = 1.0f;
        }
        this.host.field_70721_aZ += (var7 - this.host.field_70721_aZ) * 0.4f;
        this.host.field_70754_ba += this.host.field_70721_aZ;
    }

    protected void adjustRotationToWaypoint() {
        double distZ = (double)this.targetPosition.field_71573_c - this.host.field_70161_v;
        double distX = (double)this.targetPosition.field_71574_a - this.host.field_70165_t;
        float fullAngle = (float)(Math.atan2(distZ, distX) * 180.0 / Math.PI);
        float angle = MathHelper.func_76142_g((float)(fullAngle - this.host.field_70177_z));
        if (angle > 30.0f) {
            angle = 30.0f;
        }
        if (angle < -30.0f) {
            angle = -30.0f;
        }
        this.host.field_70761_aq = this.host.field_70177_z += angle;
    }

    public void adjustRotationToTarget(ChunkCoordinates target) {
        double distX = (double)target.field_71574_a - this.host.field_70165_t;
        double distZ = (double)target.field_71573_c - this.host.field_70161_v;
        float fullAngle = (float)(Math.atan2(distZ, distX) * 180.0 / Math.PI) - 90.0f;
        float angle = MathHelper.func_76142_g((float)(fullAngle - this.host.field_70177_z));
        this.host.field_70177_z += angle;
    }
}

