/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.gui;

import cpw.mods.fml.client.GuiScrollingList;
import java.util.HashMap;
import java.util.Map;
import lycanite.lycanitesmobs.api.gui.GUIBeastiary;
import lycanite.lycanitesmobs.api.info.MobInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;

public class GUIBeastiaryCreatureList
extends GuiScrollingList {
    GUIBeastiary parentGUI;
    Map<Integer, MobInfo> creatureList = new HashMap<Integer, MobInfo>();

    public GUIBeastiaryCreatureList(GUIBeastiary parentGUI, int width, int height, int top, int bottom, int left) {
        super(Minecraft.func_71410_x(), width, height, top, bottom, left, 20);
        this.parentGUI = parentGUI;
        this.updateList();
    }

    public void updateList() {
        this.creatureList = new HashMap<Integer, MobInfo>();
        if (this.parentGUI.getSelectedGroup() == null) {
            return;
        }
        int creatureIndex = 0;
        for (String minionName : this.parentGUI.playerExt.getBeastiary().creatureKnowledgeList.keySet()) {
            MobInfo mobInfo = MobInfo.getFromName(minionName.toLowerCase());
            if (mobInfo == null || mobInfo.group != this.parentGUI.getSelectedGroup()) continue;
            this.creatureList.put(creatureIndex++, mobInfo);
        }
    }

    protected int getSize() {
        return this.creatureList.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.parentGUI.selectCreature(this.creatureList.get(index));
    }

    protected boolean isSelected(int index) {
        return this.parentGUI.getSelectedCreature() != null && this.parentGUI.getSelectedCreature().equals(this.creatureList.get(index));
    }

    protected void drawBackground() {
    }

    protected int getContentHeight() {
        return this.getSize() * 24;
    }

    protected void drawSlot(int index, int boxRight, int boxTop, int boxBottom, Tessellator tessellator) {
        MobInfo mobInfo = this.creatureList.get(index);
        if (mobInfo == null) {
            return;
        }
        this.parentGUI.getFontRenderer().func_78276_b(mobInfo.getTitle(), this.left + 20, boxTop + 4, 0xFFFFFF);
        if (mobInfo.getIcon() != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(mobInfo.getIcon());
            this.parentGUI.drawImage(this.left + 2, boxTop, 0, 0, 16, 16, 0.0625f, 0.0625f);
        }
    }
}

