/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.inventory;

import java.util.HashMap;
import java.util.Map;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureRideable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemSaddle;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryCreature
implements IInventory {
    public EntityCreatureBase creature;
    public String inventoryName = "Creature Inventory";
    protected ItemStack[] items;
    protected boolean basicArmor = true;
    public Map<String, Integer> equipmentIDs = new HashMap<String, Integer>();
    public Map<Integer, String> equipmentTypes = new HashMap<Integer, String>();
    private int nextID = 0;
    private static final Map<String, Integer> armorValues = new HashMap<String, Integer>();

    public InventoryCreature(String inventoryName, EntityCreatureBase creature) {
        this.inventoryName = inventoryName;
        this.creature = creature;
        this.addEquipmentSlot("chest");
        this.addEquipmentSlot("saddle");
        this.addEquipmentSlot("bag");
        this.items = new ItemStack[this.func_70302_i_()];
    }

    protected void addEquipmentSlot(String type) {
        int id = this.nextID++;
        this.equipmentIDs.put(type, id);
        this.equipmentTypes.put(id, type);
        this.creature.func_70096_w().func_82709_a(EntityCreatureBase.WATCHER_ID.EQUIPMENT.id + id, 5);
    }

    public String func_145825_b() {
        return this.inventoryName;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return this.getItemSlotsSize() + this.getSpecialSlotsSize();
    }

    public int getActiveItemSlotsSize() {
        if (this.getEquipmentStack("bag") != null) {
            return this.creature.getBagSize();
        }
        return this.creature.getNoBagSize();
    }

    public int getItemSlotsSize() {
        return this.creature.getInventorySizeMax();
    }

    public int getSpecialSlotsSize() {
        return this.equipmentIDs.size();
    }

    public boolean hasBagItems() {
        for (ItemStack itemStack : this.items) {
            if (itemStack == null) continue;
            return true;
        }
        return false;
    }

    public void onInventoryChanged() {
        int bagSizeDiff;
        if (this.creature.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getEquipmentStack("bag") == null && (bagSizeDiff = this.creature.getBagSize() - this.creature.getNoBagSize()) > 0) {
            for (int i = this.creature.getNoBagSize(); i <= this.getItemSlotsSize(); ++i) {
                if (this.func_70301_a(i - 1) == null) continue;
                this.creature.dropItem(this.func_70301_a(i - 1));
                this.setInventorySlotContentsNoUpdate(i - 1, null);
            }
        }
        for (String type : this.equipmentIDs.keySet()) {
            ItemStack itemStack = this.getEquipmentStack(type);
            if (itemStack == null) {
                itemStack = new ItemStack(Blocks.field_150348_b, 1, 0);
            }
            this.creature.func_70096_w().func_75692_b(EntityCreatureBase.WATCHER_ID.EQUIPMENT.id + this.equipmentIDs.get(type), (Object)itemStack);
        }
        this.creature.scheduleGUIRefresh();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70301_a(int slotID) {
        if (slotID >= this.func_70302_i_() || slotID < 0) {
            return null;
        }
        return this.items[slotID];
    }

    public void func_70299_a(int slotID, ItemStack itemStack) {
        this.setInventorySlotContentsNoUpdate(slotID, itemStack);
        this.onInventoryChanged();
    }

    public void setInventorySlotContentsNoUpdate(int slotID, ItemStack itemStack) {
        if (slotID >= this.func_70302_i_() || slotID < 0) {
            return;
        }
        if (itemStack != null) {
            if (itemStack.field_77994_a > this.func_70297_j_()) {
                itemStack.field_77994_a = this.func_70297_j_();
            }
            if (itemStack.field_77994_a < 1) {
                itemStack = null;
            }
        }
        this.items[slotID] = itemStack;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack[] splitStacks = this.decrStackSize(this.func_70301_a(slot), amount);
        this.func_70299_a(slot, splitStacks[0]);
        this.onInventoryChanged();
        return splitStacks[1];
    }

    public ItemStack[] decrStackSize(ItemStack itemStack, int amount) {
        ItemStack[] splitStacks = new ItemStack[]{null, null};
        if (itemStack == null) {
            return splitStacks;
        }
        if (itemStack.field_77994_a <= amount) {
            splitStacks[0] = null;
            splitStacks[1] = itemStack;
        } else {
            splitStacks[1] = itemStack.func_77979_a(amount);
            if (itemStack.field_77994_a == 0) {
                itemStack = null;
            }
            splitStacks[0] = itemStack;
        }
        return splitStacks;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        String type = this.getTypeFromSlot(slotID);
        if (type != null) {
            if (!this.isEquipmentValidForSlot(type, itemStack)) {
                return false;
            }
            if (this.func_70301_a(slotID) != null) {
                return false;
            }
        }
        return true;
    }

    public int getSpaceForStack(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        if (itemStack.func_77973_b() == null || itemStack.field_77994_a < 1) {
            return 0;
        }
        int space = 0;
        for (int slotID = 0; slotID < this.items.length; ++slotID) {
            if (this.func_94041_b(slotID, itemStack)) {
                ItemStack slotStack = this.items[slotID];
                if (slotStack != null) {
                    if (slotStack.field_77994_a < slotStack.func_77976_d() && slotStack.func_77973_b() == itemStack.func_77973_b() && slotStack.func_77960_j() == itemStack.func_77960_j()) {
                        space += slotStack.func_77976_d() - slotStack.field_77994_a;
                    }
                } else {
                    space += itemStack.func_77976_d();
                }
            }
            if (space >= itemStack.field_77994_a) break;
        }
        return Math.min(space, itemStack.field_77994_a);
    }

    public ItemStack autoInsertStack(ItemStack itemStack) {
        if (itemStack == null) {
            return itemStack;
        }
        if (itemStack.func_77973_b() == null || itemStack.field_77994_a < 1) {
            return null;
        }
        for (int slotID = 0; slotID < this.items.length; ++slotID) {
            ItemStack slotStack = this.items[slotID];
            if (slotStack != null) {
                if (slotStack.field_77994_a < slotStack.func_77976_d() && slotStack.func_77973_b() == itemStack.func_77973_b() && slotStack.func_77960_j() == itemStack.func_77960_j()) {
                    int space = Math.max(slotStack.func_77976_d() - slotStack.field_77994_a, 0);
                    if (space >= itemStack.field_77994_a) {
                        this.func_70301_a((int)slotID).field_77994_a += itemStack.field_77994_a;
                        itemStack = null;
                    } else {
                        this.func_70301_a((int)slotID).field_77994_a += space;
                        itemStack.field_77994_a -= space;
                    }
                }
            } else {
                this.func_70299_a(slotID, itemStack);
                itemStack = null;
            }
            if (itemStack == null) break;
        }
        return itemStack;
    }

    public void setAdvancedArmor(boolean advanced) {
        boolean bl = this.basicArmor = !advanced;
        if (advanced) {
            this.addEquipmentSlot("head");
            this.addEquipmentSlot("legs");
            this.addEquipmentSlot("feet");
        }
    }

    public boolean useAdvancedArmor() {
        return !this.basicArmor;
    }

    public int getSlotFromType(String type) {
        if (this.equipmentIDs.containsKey(type)) {
            return this.equipmentIDs.get(type) + this.getItemSlotsSize();
        }
        return -1;
    }

    public String getTypeFromSlot(int slotID) {
        if (this.equipmentTypes.containsKey(slotID - this.getItemSlotsSize())) {
            return this.equipmentTypes.get(slotID - this.getItemSlotsSize());
        }
        return null;
    }

    public ItemStack getEquipmentStack(String type) {
        if (!this.equipmentIDs.containsKey(type)) {
            return null;
        }
        if (this.creature.field_70170_p.field_72995_K) {
            ItemStack itemStack = this.creature.func_70096_w().func_82710_f(EntityCreatureBase.WATCHER_ID.EQUIPMENT.id + this.equipmentIDs.get(type));
            if (itemStack != null && itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150348_b)) {
                itemStack = null;
            }
            return itemStack;
        }
        return this.func_70301_a(this.getSlotFromType(type));
    }

    public void setEquipmentStack(String type, ItemStack itemStack) {
        if (!this.creature.field_70170_p.field_72995_K && this.equipmentIDs.containsKey(type) && this.isEquipmentValidForSlot(type, itemStack)) {
            this.func_70299_a(this.getSlotFromType(type), itemStack);
        }
    }

    public void setEquipmentStack(ItemStack itemStack) {
        String type = this.getSlotForEquipment(itemStack);
        if (type != null) {
            this.setEquipmentStack(type, itemStack);
        }
    }

    public String getSlotForEquipment(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (this.basicArmor) {
            if (itemStack.func_77973_b() == Items.field_151138_bX) {
                return "chest";
            }
            if (itemStack.func_77973_b() == Items.field_151136_bY) {
                return "chest";
            }
            if (itemStack.func_77973_b() == Items.field_151125_bZ) {
                return "chest";
            }
        }
        if (!this.basicArmor && itemStack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armorstack = (ItemArmor)itemStack.func_77973_b();
            if (armorstack.field_77881_a == 0) {
                return "head";
            }
            if (armorstack.field_77881_a == 1) {
                return "chest";
            }
            if (armorstack.field_77881_a == 2) {
                return "legs";
            }
            if (armorstack.field_77881_a == 3) {
                return "feet";
            }
        }
        if (itemStack.func_77973_b() instanceof ItemSaddle && this.creature instanceof EntityCreatureRideable) {
            return "saddle";
        }
        if (itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
            return "bag";
        }
        return null;
    }

    public boolean isEquipmentValidForSlot(String type, ItemStack itemStack) {
        if (itemStack == null) {
            return true;
        }
        return type.equals(this.getSlotForEquipment(itemStack));
    }

    public String getEquipmentGrade(String type) {
        ItemStack equipmentStack = this.getEquipmentStack(type);
        if (equipmentStack == null) {
            return null;
        }
        if (equipmentStack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)equipmentStack.func_77973_b();
            if (armor.func_82812_d() == ItemArmor.ArmorMaterial.CLOTH) {
                return "Leather";
            }
            if (armor.func_82812_d() == ItemArmor.ArmorMaterial.IRON) {
                return "Iron";
            }
            if (armor.func_82812_d() == ItemArmor.ArmorMaterial.CHAIN) {
                return "Chain";
            }
            if (armor.func_82812_d() == ItemArmor.ArmorMaterial.GOLD) {
                return "Gold";
            }
            if (armor.func_82812_d() == ItemArmor.ArmorMaterial.DIAMOND) {
                return "Diamond";
            }
        }
        if (equipmentStack.func_77973_b() == Items.field_151138_bX) {
            return "Iron";
        }
        if (equipmentStack.func_77973_b() == Items.field_151136_bY) {
            return "Gold";
        }
        if (equipmentStack.func_77973_b() == Items.field_151125_bZ) {
            return "Diamond";
        }
        return null;
    }

    public int getArmorValue() {
        String[] armorSlots = new String[]{"head", "chest", "legs", "feet"};
        int totalArmor = 0;
        for (String armorSlot : armorSlots) {
            ItemStack armorStack = this.getEquipmentStack(armorSlot);
            if (armorStack == null) continue;
            if (armorStack.func_77973_b() instanceof ItemArmor) {
                totalArmor += ((ItemArmor)armorStack.func_77973_b()).field_77879_b;
                continue;
            }
            if (this.getEquipmentGrade(armorSlot) == null) continue;
            if (!armorValues.containsKey(this.getEquipmentGrade(armorSlot))) continue;
            totalArmor += armorValues.get(this.getEquipmentGrade(armorSlot)).intValue();
        }
        return totalArmor;
    }

    public void dropInventory() {
        for (ItemStack itemStack : this.items) {
            if (itemStack == null) continue;
            this.creature.dropItem(itemStack);
            itemStack = null;
        }
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList itemList = nbtTagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound itemCompound = itemList.func_150305_b(i);
            int slot = itemCompound.func_74771_c("Slot") & 0xFF;
            if (slot >= this.func_70302_i_()) continue;
            this.setInventorySlotContentsNoUpdate(slot, ItemStack.func_77949_a((NBTTagCompound)itemCompound));
        }
        this.onInventoryChanged();
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack entry = this.func_70301_a(i);
            if (entry == null) continue;
            NBTTagCompound itemCompound = new NBTTagCompound();
            itemCompound.func_74774_a("Slot", (byte)i);
            entry.func_77955_b(itemCompound);
            itemList.func_74742_a((NBTBase)itemCompound);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)itemList);
    }

    public void func_70296_d() {
    }

    static {
        armorValues.put("Leather", 3);
        armorValues.put("Iron", 5);
        armorValues.put("Gold", 7);
        armorValues.put("Chain", 9);
        armorValues.put("Diamond", 11);
    }
}

