/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.item;

import lycanite.lycanitesmobs.ExtendedPlayer;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureTameable;
import lycanite.lycanitesmobs.api.entity.EntityPortal;
import lycanite.lycanitesmobs.api.gui.GUIMinion;
import lycanite.lycanitesmobs.api.item.ItemScepter;
import lycanite.lycanitesmobs.api.pets.SummonSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemStaffSummoning
extends ItemScepter {
    public EntityPortal portalEntity;

    public ItemStaffSummoning() {
        this.itemName = "summoningstaff";
        this.setup();
        this.textureName = "staffsummoning";
    }

    @Override
    public int getDurability() {
        return 250;
    }

    @Override
    public void damageItemRapid(ItemStack itemStack, EntityPlayer player) {
    }

    @Override
    public void damageItemCharged(ItemStack itemStack, EntityPlayer player, float power) {
        if (this.portalEntity != null) {
            itemStack.func_77972_a(5 * this.portalEntity.summonAmount, (EntityLivingBase)player);
        }
    }

    @Override
    public int getChargeTime(ItemStack itemStack) {
        return 1;
    }

    @Override
    public int getRapidTime(ItemStack itemStack) {
        return 20;
    }

    public int getSummonCostBoost() {
        return 0;
    }

    public float getSummonCostMod() {
        return 1.0f;
    }

    public int getSummonDuration() {
        return 1200;
    }

    public int getSummonAmount() {
        return 1;
    }

    public boolean getAdditionalCosts(EntityPlayer player) {
        return true;
    }

    public void applyMinionBehaviour(EntityCreatureTameable minion, EntityPlayer player) {
        SummonSet summonSet = ExtendedPlayer.getForPlayer(player).getSelectedSummonSet();
        summonSet.applyBehaviour(minion);
    }

    public void applyMinionEffects(EntityCreatureBase minion) {
    }

    @Override
    public void func_77615_a(ItemStack itemStack, World world, EntityPlayer player, int useRemaining) {
        super.func_77615_a(itemStack, world, player, useRemaining);
        this.portalEntity = null;
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt != null) {
            SummonSet summonSet = playerExt.getSelectedSummonSet();
            if (summonSet.isUseable()) {
                if (!player.field_70170_p.field_72995_K) {
                    this.portalEntity = new EntityPortal(world, player, summonSet.getCreatureClass(), this);
                    this.portalEntity.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)this.portalEntity);
                }
            } else {
                this.portalEntity = null;
                if (!player.field_70170_p.field_72995_K) {
                    playerExt.sendAllSummonSetsToPlayer();
                }
                if (player.field_70170_p.field_72995_K) {
                    GUIMinion.openToPlayer(player, playerExt.selectedSummonSet);
                }
            }
        }
        return super.func_77659_a(itemStack, world, player);
    }

    @Override
    public boolean rapidAttack(ItemStack itemStack, World world, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean chargedAttack(ItemStack itemStack, World world, EntityPlayer player, float power) {
        if (this.portalEntity != null) {
            boolean success = this.portalEntity.summonCreatures();
            this.portalEntity = null;
            return success;
        }
        return false;
    }

    @Override
    public boolean func_82789_a(ItemStack itemStack, ItemStack repairStack) {
        if (repairStack.func_77973_b() == Items.field_151043_k) {
            return true;
        }
        return super.func_82789_a(itemStack, repairStack);
    }
}

