/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import lycanite.lycanitesmobs.ExtendedPlayer;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.pets.PetEntry;
import lycanite.lycanitesmobs.api.pets.PetManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class MessagePetEntryRemove
implements IMessage,
IMessageHandler<MessagePetEntryRemove, IMessage> {
    public int petEntryID;

    public MessagePetEntryRemove() {
    }

    public MessagePetEntryRemove(ExtendedPlayer playerExt, PetEntry petEntry) {
        this.petEntryID = petEntry.petEntryID;
    }

    public IMessage onMessage(MessagePetEntryRemove message, MessageContext ctx) {
        EntityPlayer player = null;
        if (ctx.side == Side.CLIENT) {
            player = LycanitesMobs.proxy.getClientPlayer();
        } else if (ctx.side == Side.SERVER) {
            player = ctx.getServerHandler().field_147369_b;
        }
        if (player == null) {
            return null;
        }
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt == null) {
            return null;
        }
        PetManager petManager = playerExt.petManager;
        PetEntry petEntry = petManager.getEntry(message.petEntryID);
        if (petEntry == null) {
            LycanitesMobs.printWarning("", "Tried to remove a null PetEntry from " + (player.field_70170_p.field_72995_K ? "client" : "server") + "!");
            return null;
        }
        petEntry.remove();
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        try {
            this.petEntryID = packet.readInt();
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "There was a problem decoding the packet: " + packet + ".");
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        try {
            packet.writeInt(this.petEntryID);
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "There was a problem encoding the packet: " + packet + ".");
            e.printStackTrace();
        }
    }
}

