/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.pets;

import lycanite.lycanitesmobs.ExtendedPlayer;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.entity.EntityCreatureTameable;
import lycanite.lycanitesmobs.api.info.MobInfo;
import net.minecraft.nbt.NBTTagCompound;

public class SummonSet {
    public ExtendedPlayer playerExt;
    public String summonType = "";
    public boolean summonableOnly = true;
    public boolean sitting = false;
    public boolean following = true;
    public boolean passive = false;
    public boolean aggressive = false;
    public boolean pvp = true;

    public static boolean isSummonableCreature(String creatureName) {
        return MobInfo.summonableCreatures.contains(creatureName);
    }

    public SummonSet(ExtendedPlayer playerExt) {
        this.playerExt = playerExt;
    }

    public void setSummonType(String summonType) {
        this.summonType = summonType;
    }

    public boolean getSitting() {
        return this.sitting;
    }

    public boolean getFollowing() {
        return this.following;
    }

    public boolean getPassive() {
        return this.passive;
    }

    public boolean getAggressive() {
        return this.aggressive;
    }

    public boolean getPVP() {
        return this.pvp;
    }

    public MobInfo getMobInfo() {
        return MobInfo.getFromName(this.summonType);
    }

    public void applyBehaviour(EntityCreatureTameable minion) {
        minion.setSitting(this.getSitting());
        minion.setFollowing(this.getFollowing());
        minion.setPassive(this.getPassive());
        minion.setAggressive(this.getAggressive());
        minion.setPVP(this.getPVP());
    }

    public void updateBehaviour(EntityCreatureTameable minion) {
        this.sitting = minion.isSitting();
        this.following = minion.isFollowing();
        this.passive = minion.isPassive();
        this.aggressive = minion.isAggressive();
        this.pvp = minion.isPVP();
    }

    public boolean isUseable() {
        return this.summonType != null && !"".equals(this.summonType) && ObjectManager.getMob(this.summonType) != null && SummonSet.isSummonableCreature(this.summonType);
    }

    public Class getCreatureClass() {
        return ObjectManager.getMob(this.summonType);
    }

    public void readFromPacket(String summonType, byte behaviour) {
        this.setSummonType(summonType);
        this.setBehaviourByte(behaviour);
    }

    public void setBehaviourByte(byte behaviour) {
        this.sitting = (behaviour & BEHAVIOUR_ID.SITTING.id) > 0;
        this.following = (behaviour & BEHAVIOUR_ID.FOLLOWING.id) > 0;
        this.passive = (behaviour & BEHAVIOUR_ID.PASSIVE.id) > 0;
        this.aggressive = (behaviour & BEHAVIOUR_ID.STANCE.id) > 0;
        this.pvp = (behaviour & BEHAVIOUR_ID.PVP.id) > 0;
    }

    public byte getBehaviourByte() {
        byte behaviour = 0;
        if (this.getSitting()) {
            behaviour = (byte)(behaviour + BEHAVIOUR_ID.SITTING.id);
        }
        if (this.getFollowing()) {
            behaviour = (byte)(behaviour + BEHAVIOUR_ID.FOLLOWING.id);
        }
        if (this.getPassive()) {
            behaviour = (byte)(behaviour + BEHAVIOUR_ID.PASSIVE.id);
        }
        if (this.getAggressive()) {
            behaviour = (byte)(behaviour + BEHAVIOUR_ID.STANCE.id);
        }
        if (this.getPVP()) {
            behaviour = (byte)(behaviour + BEHAVIOUR_ID.PVP.id);
        }
        return behaviour;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("SummonType")) {
            this.setSummonType(nbtTagCompound.func_74779_i("SummonType"));
        }
        if (nbtTagCompound.func_74764_b("Sitting")) {
            this.sitting = nbtTagCompound.func_74767_n("Sitting");
        }
        if (nbtTagCompound.func_74764_b("Following")) {
            this.following = nbtTagCompound.func_74767_n("Following");
        }
        if (nbtTagCompound.func_74764_b("Passive")) {
            this.passive = nbtTagCompound.func_74767_n("Passive");
        }
        if (nbtTagCompound.func_74764_b("Aggressive")) {
            this.aggressive = nbtTagCompound.func_74767_n("Aggressive");
        }
        if (nbtTagCompound.func_74764_b("PVP")) {
            this.pvp = nbtTagCompound.func_74767_n("PVP");
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74778_a("SummonType", this.summonType);
        nbtTagCompound.func_74757_a("Sitting", this.sitting);
        nbtTagCompound.func_74757_a("Following", this.following);
        nbtTagCompound.func_74757_a("Passive", this.passive);
        nbtTagCompound.func_74757_a("Aggressive", this.aggressive);
        nbtTagCompound.func_74757_a("PVP", this.pvp);
    }

    public static enum BEHAVIOUR_ID {
        SITTING(1),
        FOLLOWING(2),
        PASSIVE(4),
        STANCE(8),
        PVP(16);

        public byte id;

        private BEHAVIOUR_ID(byte i) {
            this.id = i;
        }
    }
}

