/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.spawning;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lycanite.lycanitesmobs.ExtendedWorld;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.info.MobInfo;
import lycanite.lycanitesmobs.api.info.SpawnInfo;
import lycanite.lycanitesmobs.api.mobevent.MobEventBase;
import lycanite.lycanitesmobs.api.spawning.CoordSorterNearest;
import lycanite.lycanitesmobs.api.spawning.CustomSpawner;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeBlock;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeCrop;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeDarkness;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeDeath;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeLunar;
import lycanite.lycanitesmobs.api.spawning.SpawnTypePortal;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeRock;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeSky;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeSleep;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeStorm;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeTree;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeUndeath;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeUnderground;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeWater;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public class SpawnTypeBase {
    public static Map<String, SpawnTypeBase> spawnTypeMap = new HashMap<String, SpawnTypeBase>();
    public static int rangeMin = 10;
    public String typeName;
    public boolean enabled = true;
    public List<SpawnInfo> spawnList = new ArrayList<SpawnInfo>();
    public Map<SpawnInfo, Integer> spawnWaveLimits = new HashMap<SpawnInfo, Integer>();
    public Map<SpawnInfo, Integer> currentSpawnWaveCount;
    public MobEventBase mobEvent = null;
    public int rate;
    public double chance;
    public int range;
    public int blockLimit;
    public int mobLimit;
    public Block[] blocks = null;
    public String[] blockStrings = null;
    public Material[] materials = null;
    public boolean ignoreBiome = false;
    public boolean ignoreDimension = false;
    public boolean ignoreLight = true;
    public boolean ignoreRangeMin = false;
    public boolean ignoreMobConditions = false;
    public boolean forceSpawning = false;
    public boolean forceNoDespawn = false;

    public static void loadSpawnTypes() {
        ArrayList<SpawnTypeBase> spawnTypes = new ArrayList<SpawnTypeBase>();
        SpawnTypeBase fireBlockSpawner = new SpawnTypeBlock("Fire").setRate(400).setChance(0.5).setRange(32).setBlockLimit(32).setMobLimit(32);
        fireBlockSpawner.blocks = new Block[]{Blocks.field_150480_ab};
        fireBlockSpawner.ignoreBiome = true;
        fireBlockSpawner.ignoreLight = true;
        fireBlockSpawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(fireBlockSpawner);
        spawnTypes.add(fireBlockSpawner);
        SpawnTypeBase frostfireBlockSpawner = new SpawnTypeBlock("Frostfire").setRate(400).setChance(0.5).setRange(32).setBlockLimit(32).setMobLimit(32);
        frostfireBlockSpawner.blockStrings = new String[]{"frostfire"};
        frostfireBlockSpawner.ignoreBiome = true;
        frostfireBlockSpawner.ignoreLight = true;
        frostfireBlockSpawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(frostfireBlockSpawner);
        spawnTypes.add(frostfireBlockSpawner);
        SpawnTypeBase undergroundSpawner = new SpawnTypeUnderground("Underground").setRate(800).setChance(0.25).setRange(32).setBlockLimit(16).setMobLimit(8);
        undergroundSpawner.materials = new Material[]{Material.field_151579_a};
        undergroundSpawner.ignoreBiome = false;
        undergroundSpawner.ignoreLight = false;
        undergroundSpawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(undergroundSpawner);
        spawnTypes.add(undergroundSpawner);
        SpawnTypeBase skySpawner = new SpawnTypeSky("Sky").setRate(800).setChance(0.5).setRange(48).setBlockLimit(16).setMobLimit(8);
        skySpawner.materials = new Material[]{Material.field_151579_a};
        skySpawner.ignoreBiome = false;
        skySpawner.ignoreLight = false;
        skySpawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(skySpawner);
        spawnTypes.add(skySpawner);
        SpawnTypeBase waterSpawner = new SpawnTypeWater("Water").setRate(400).setChance(0.75).setRange(32).setBlockLimit(64).setMobLimit(32);
        waterSpawner.blocks = new Block[]{Blocks.field_150355_j};
        waterSpawner.ignoreBiome = false;
        waterSpawner.ignoreLight = false;
        waterSpawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(waterSpawner);
        spawnTypes.add(waterSpawner);
        SpawnTypeBase lavaBlockSpawner = new SpawnTypeBlock("Lava").setRate(400).setChance(0.5).setRange(32).setBlockLimit(64).setMobLimit(32);
        lavaBlockSpawner.blocks = new Block[]{Blocks.field_150353_l};
        lavaBlockSpawner.ignoreBiome = true;
        lavaBlockSpawner.ignoreLight = true;
        lavaBlockSpawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(lavaBlockSpawner);
        spawnTypes.add(lavaBlockSpawner);
        SpawnTypeBase spawner = new SpawnTypeBlock("Ooze").setRate(400).setChance(0.5).setRange(32).setBlockLimit(64).setMobLimit(32);
        spawner.blockStrings = new String[]{"ooze"};
        spawner.ignoreBiome = true;
        spawner.ignoreLight = true;
        spawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(spawner);
        spawnTypes.add(spawner);
        SpawnTypeBase portalBlockSpawner = new SpawnTypePortal("Portal").setRate(1200).setChance(0.25).setRange(32).setBlockLimit(32).setMobLimit(1);
        portalBlockSpawner.blocks = new Block[]{Blocks.field_150427_aO};
        portalBlockSpawner.ignoreBiome = true;
        portalBlockSpawner.ignoreDimension = true;
        portalBlockSpawner.ignoreLight = true;
        portalBlockSpawner.forceSpawning = true;
        portalBlockSpawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(portalBlockSpawner);
        spawnTypes.add(portalBlockSpawner);
        SpawnTypeBase rockSpawner = new SpawnTypeRock("Rock").setRate(0).setChance(0.02).setRange(2).setBlockLimit(32).setMobLimit(1);
        rockSpawner.materials = new Material[]{Material.field_151579_a};
        rockSpawner.ignoreBiome = true;
        rockSpawner.ignoreLight = true;
        rockSpawner.forceSpawning = true;
        rockSpawner.loadFromConfig();
        spawnTypes.add(rockSpawner);
        SpawnTypeBase cropSpawner = new SpawnTypeCrop("Crop").setRate(0).setChance(0.005).setRange(2).setBlockLimit(32).setMobLimit(1);
        cropSpawner.materials = new Material[]{Material.field_151579_a};
        cropSpawner.ignoreBiome = true;
        cropSpawner.ignoreLight = true;
        cropSpawner.forceSpawning = true;
        cropSpawner.loadFromConfig();
        spawnTypes.add(cropSpawner);
        SpawnTypeBase treeSpawner = new SpawnTypeTree("Tree").setRate(0).setChance(0.01).setRange(2).setBlockLimit(32).setMobLimit(1);
        treeSpawner.materials = new Material[]{Material.field_151579_a};
        treeSpawner.ignoreBiome = true;
        treeSpawner.ignoreLight = true;
        treeSpawner.forceSpawning = true;
        treeSpawner.loadFromConfig();
        spawnTypes.add(treeSpawner);
        SpawnTypeBase stormSpawner = new SpawnTypeStorm("Storm").setRate(800).setChance(0.125).setRange(48).setBlockLimit(32).setMobLimit(32);
        stormSpawner.materials = new Material[]{Material.field_151579_a};
        stormSpawner.ignoreBiome = true;
        stormSpawner.ignoreLight = true;
        stormSpawner.forceSpawning = true;
        stormSpawner.loadFromConfig();
        spawnTypes.add(stormSpawner);
        SpawnTypeBase lunarSpawner = new SpawnTypeLunar("Lunar").setRate(800).setChance(0.125).setRange(48).setBlockLimit(32).setMobLimit(32);
        lunarSpawner.materials = new Material[]{Material.field_151579_a};
        lunarSpawner.ignoreBiome = true;
        lunarSpawner.ignoreDimension = false;
        lunarSpawner.ignoreLight = false;
        lunarSpawner.forceSpawning = true;
        lunarSpawner.loadFromConfig();
        spawnTypes.add(lunarSpawner);
        SpawnTypeBase darknessSpawner = new SpawnTypeDarkness("Darkness").setRate(0).setChance(0.1).setRange(2).setBlockLimit(32).setMobLimit(1);
        darknessSpawner.enabled = false;
        darknessSpawner.materials = new Material[]{Material.field_151579_a};
        darknessSpawner.ignoreBiome = true;
        darknessSpawner.ignoreDimension = true;
        darknessSpawner.ignoreLight = true;
        darknessSpawner.forceSpawning = true;
        darknessSpawner.loadFromConfig();
        spawnTypes.add(darknessSpawner);
        SpawnTypeBase deathSpawner = new SpawnTypeDeath("Death").setRate(0).setChance(0.03).setRange(2).setBlockLimit(32).setMobLimit(1);
        deathSpawner.materials = new Material[]{Material.field_151579_a};
        deathSpawner.ignoreBiome = true;
        deathSpawner.ignoreDimension = true;
        deathSpawner.ignoreLight = true;
        deathSpawner.forceSpawning = true;
        deathSpawner.loadFromConfig();
        spawnTypes.add(deathSpawner);
        SpawnTypeBase undeathSpawner = new SpawnTypeUndeath("Undeath").setRate(0).setChance(0.03).setRange(2).setBlockLimit(32).setMobLimit(1);
        undeathSpawner.materials = new Material[]{Material.field_151579_a};
        undeathSpawner.ignoreBiome = true;
        undeathSpawner.ignoreDimension = true;
        undeathSpawner.ignoreLight = true;
        undeathSpawner.forceSpawning = true;
        undeathSpawner.loadFromConfig();
        spawnTypes.add(undeathSpawner);
        SpawnTypeBase sleepSpawner = new SpawnTypeSleep("Sleep").setRate(0).setChance(0.1).setRange(2).setBlockLimit(32).setMobLimit(1);
        sleepSpawner.materials = new Material[]{Material.field_151579_a};
        sleepSpawner.ignoreBiome = true;
        sleepSpawner.ignoreDimension = true;
        sleepSpawner.ignoreLight = true;
        sleepSpawner.forceSpawning = true;
        sleepSpawner.loadFromConfig();
        spawnTypes.add(sleepSpawner);
        for (SpawnTypeBase spawnType : spawnTypes) {
            spawnTypeMap.put(spawnType.typeName.toUpperCase(), spawnType);
            LycanitesMobs.printDebug("CustomSpawner", "Added custom spawn type: " + spawnType.typeName);
        }
    }

    public static SpawnTypeBase getSpawnType(String spawnTypeName) {
        if (spawnTypeMap.containsKey(spawnTypeName)) {
            return spawnTypeMap.get(spawnTypeName);
        }
        return null;
    }

    public static SpawnTypeBase[] getSpawnTypes(String spawnTypeNames) {
        ArrayList<SpawnTypeBase> spawnTypeList = new ArrayList<SpawnTypeBase>();
        for (String spawnTypeName : spawnTypeNames.split(",")) {
            SpawnTypeBase spawnType = SpawnTypeBase.getSpawnType(spawnTypeName);
            if (spawnType == null) continue;
            spawnTypeList.add(spawnType);
        }
        return spawnTypeList.toArray(new SpawnTypeBase[spawnTypeList.size()]);
    }

    public SpawnTypeBase(String typeName) {
        this.typeName = typeName.toUpperCase();
    }

    public void loadFromConfig() {
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.group, "spawning");
        config.setCategoryComment("Spawners Enabled", "Here you can turn each special spawner on or off.");
        this.enabled = config.getBool("Spawners Enabled", this.getCfgName("Spawn Enabled"), this.enabled);
        config.setCategoryComment("Spawner Ticks", "Here you can set the interval that a spawner will try and spawn in ticks. (20 ticks = 1 second). Increase this and lower and the chance if you are having lag issues, this will make the spawner less frequent but more predicatable.");
        this.rate = config.getInt("Spawner Ticks", this.getCfgName("Spawn Tick"), this.rate);
        config.setCategoryComment("Spawner Chances", "Here you can set the chance that a spawner will try and spawn mobs, this chance is tested after every interval.");
        this.chance = config.getDouble("Spawner Chances", this.getCfgName("Spawn Chance"), this.chance);
        config.setCategoryComment("Spawner Ranges", "Here you can set how far from the player or event location that mobs can be spawned. Lower this is you are having major lag issues.");
        this.range = config.getInt("Spawner Ranges", this.getCfgName("Spawn Range"), this.range);
        config.setCategoryComment("Spawner Block Limits", "Here you can set a maximum limit of how many locations the spawner is allowed to spawn mobs at.");
        this.blockLimit = config.getInt("Spawner Block Limits", this.getCfgName("Spawn Block Limit"), this.blockLimit);
        config.setCategoryComment("Spawner Mob Limits", "Here you can set the limit of how many mobs a spawner can spawn every interval. Be aware that each mob will use it's own Area Spawn Limit which will drastically decrease the number of mobs spawned overall.");
        this.mobLimit = config.getInt("Spawner Mob Limits", this.getCfgName("Spawn Mob Limit"), this.mobLimit);
        config.setCategoryComment("Spawner Checks", "Here you can set whether or not each spawn ignores certain mob checks such as dimension, biome or light level. If Ignores Event is set to true, the spawn type will ignore the mob spawn event meaning that other mods also cannot prevent mob spawns.");
        this.ignoreDimension = config.getBool("Spawner Checks", this.getCfgName("Ignores Dimension"), this.ignoreDimension);
        this.ignoreBiome = config.getBool("Spawner Checks", this.getCfgName("Ignores Biome"), this.ignoreBiome);
        this.ignoreLight = config.getBool("Spawner Checks", this.getCfgName("Ignores Light Level"), this.ignoreLight);
        this.forceSpawning = config.getBool("Spawner Checks", this.getCfgName("Ignores Event"), this.forceSpawning);
    }

    public String getCfgName(String configKey) {
        return this.typeName + " " + configKey;
    }

    public void addSpawn(MobInfo mobInfo) {
        this.addSpawn(mobInfo, 0);
    }

    public void addSpawn(MobInfo mobInfo, int spawnWaveLimit) {
        if (mobInfo == null || mobInfo.spawnInfo == null) {
            return;
        }
        this.spawnList.add(mobInfo.spawnInfo);
        if (spawnWaveLimit > 0) {
            this.spawnWaveLimits.put(mobInfo.spawnInfo, spawnWaveLimit);
        }
    }

    public List<SpawnInfo> getSpawnList() {
        return this.spawnList;
    }

    public boolean hasSpawns() {
        return this.spawnList.size() > 0;
    }

    public boolean spawnMobs(long tick, World world, int x, int y, int z, EntityPlayer player, boolean rare) {
        if (!(this.getSpawnList() != null && this.getSpawnList().size() >= 1 && this.enabled && this.hasSpawns() && world.func_82736_K().func_82766_b("doMobSpawning"))) {
            return false;
        }
        if (!this.canSpawn(tick, world, x, y, z, rare)) {
            return false;
        }
        LycanitesMobs.printDebug("CustomSpawner", "~0==================== " + this.typeName + " Spawner ====================0~");
        LycanitesMobs.printDebug("CustomSpawner", "Attempting to spawn mobs.");
        this.currentSpawnWaveCount = new HashMap<SpawnInfo, Integer>();
        List<int[]> coords = this.getSpawnCoordinates(world, x, y, z);
        if (coords == null) {
            LycanitesMobs.printWarning("CustomSpawner", "Null coordinates! This spawn type might never be able to find coordinates as it has no materials or blocks set, not even air.");
            return false;
        }
        LycanitesMobs.printDebug("CustomSpawner", "Found " + coords.size() + "/" + this.blockLimit + " coordinates for mob spawning.");
        if (coords.size() <= 0) {
            LycanitesMobs.printDebug("CustomSpawner", "No valid coordinates were found, spawning cancelled.");
            return false;
        }
        coords = this.orderCoords(coords, x, y, z);
        coords = this.applyCoordLimits(coords);
        LycanitesMobs.printDebug("CustomSpawner", "Applied coordinate limits. New size is " + coords.size());
        ArrayList<BiomeGenBase> targetBiomes = new ArrayList<BiomeGenBase>();
        if (!this.ignoreBiome) {
            for (int[] coord : coords) {
                BiomeGenBase coordBiome = world.func_72807_a(coord[0], coord[2]);
                if (targetBiomes.contains(coordBiome)) continue;
                targetBiomes.add(coordBiome);
            }
        }
        LycanitesMobs.printDebug("CustomSpawner", "Getting a list of all mobs that can spawn within the found coordinates.");
        List<SpawnInfo> possibleSpawns = this.getPossibleSpawns(coords.size(), targetBiomes);
        if (possibleSpawns == null || possibleSpawns.size() <= 0) {
            LycanitesMobs.printDebug("CustomSpawner", "No mobs are able to spawn, either not enough blocks, empty biome/dimension or all weights are 0. Spawning cancelled.");
            return false;
        }
        LycanitesMobs.printDebug("CustomSpawner", "Cycling through each possible spawn coordinate and attempting to spawn a mob there. Mob limit is " + this.mobLimit + " overall.");
        int mobsSpawned = 0;
        for (int[] coord : coords) {
            Event.Result canSpawn;
            SpawnInfo spawnInfo = this.getRandomMob(possibleSpawns, world);
            EntityLiving entityLiving = null;
            try {
                entityLiving = (EntityLiving)spawnInfo.mobInfo.entityClass.getConstructor(World.class).newInstance(world);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (entityLiving == null) {
                LycanitesMobs.printWarning("CustomSpawner", "Unable to instantiate an entity from SpawnInfo: " + spawnInfo);
                continue;
            }
            LycanitesMobs.printDebug("CustomSpawner", "Attempting to spawn " + entityLiving + "...");
            LycanitesMobs.printDebug("CustomSpawner", "Coordinates: X" + coord[0] + " Y" + coord[1] + " Z" + coord[2]);
            entityLiving.func_70012_b((double)coord[0] + 0.5, (double)coord[1], (double)coord[2] + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (entityLiving instanceof EntityCreatureBase) {
                ((EntityCreatureBase)entityLiving).spawnedFromType = this;
            }
            if ((canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityLiving, (World)world, (float)coord[0], (float)coord[1], (float)coord[2])) == Event.Result.DENY && !this.forceSpawning) {
                LycanitesMobs.printDebug("CustomSpawner", "Spawn Check Failed! Spawning blocked by Forge Event, this is caused another mod.");
                continue;
            }
            boolean validLocation = true;
            if (!this.ignoreMobConditions) {
                validLocation = entityLiving.func_70601_bi();
            } else if (entityLiving instanceof EntityCreatureBase) {
                LycanitesMobs.printDebug("CustomSpawner", "Ignoring all mob spawn checks except for collision...");
                boolean ignoreLightTemp = this.ignoreLight;
                this.ignoreLight = true;
                validLocation = ((EntityCreatureBase)entityLiving).fixedSpawnCheck(world, coord[0], coord[1], coord[2]);
                this.ignoreLight = ignoreLightTemp;
            }
            if (canSpawn == Event.Result.DEFAULT && !validLocation) {
                LycanitesMobs.printDebug("CustomSpawner", "Spawn Check Failed! The entity may not fit, there may be to many of it in the area, it may require specific lighting, etc.");
                continue;
            }
            entityLiving.field_71088_bW = entityLiving.func_82147_ab();
            if (entityLiving instanceof EntityCreatureBase) {
                EntityCreatureBase entityCreature = (EntityCreatureBase)entityLiving;
                entityCreature.forceNoDespawn = this.forceNoDespawn;
                entityCreature.spawnedRare = rare;
                ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
                if (this.mobEvent != null && worldExt != null) {
                    entityCreature.spawnEventType = this.mobEvent.name;
                    entityCreature.spawnEventCount = worldExt.getWorldEventCount();
                }
            }
            this.spawnEntity(world, entityLiving);
            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityLiving, (World)world, (float)coord[0], (float)coord[1], (float)coord[2])) {
                entityLiving.func_110161_a(null);
            }
            LycanitesMobs.printDebug("CustomSpawner", "Spawn Check Passed! Mob spawned.");
            ++mobsSpawned;
            if (!this.currentSpawnWaveCount.containsKey(spawnInfo)) {
                this.currentSpawnWaveCount.put(spawnInfo, 1);
            } else {
                this.currentSpawnWaveCount.put(spawnInfo, this.currentSpawnWaveCount.get(spawnInfo) + 1);
            }
            if (mobsSpawned < this.mobLimit) continue;
            break;
        }
        LycanitesMobs.printDebug("CustomSpawner", "Spawning finished. Spawned " + mobsSpawned + " mobs.");
        return mobsSpawned > 0;
    }

    public boolean spawnMobs(long tick, World world, int x, int y, int z, EntityPlayer player) {
        return this.spawnMobs(tick, world, x, y, z, player, false);
    }

    public boolean canSpawn(long tick, World world, int x, int y, int z, boolean rare) {
        if (this.getRate(world) == 0 || tick % (long)this.getRate(world) != 0L) {
            return false;
        }
        return !(world.field_73012_v.nextDouble() >= this.chance);
    }

    public List<int[]> getSpawnCoordinates(World world, int x, int y, int z) {
        return this.searchForBlockCoords(world, x, y, z);
    }

    public List<int[]> orderCoords(List<int[]> coords, int x, int y, int z) {
        Collections.shuffle(coords);
        return coords;
    }

    public List<int[]> applyCoordLimits(List<int[]> coords) {
        if (coords.size() > this.blockLimit) {
            coords = coords.subList(0, this.blockLimit);
        }
        return coords;
    }

    public List<SpawnInfo> getPossibleSpawns(int coordsFound, List<BiomeGenBase> biomes) {
        ArrayList<SpawnInfo> possibleSpawns = new ArrayList<SpawnInfo>();
        for (SpawnInfo possibleSpawn : this.getSpawnList()) {
            boolean isValidBiome;
            boolean isEnabled;
            boolean withinWaveLimit = true;
            if (this.spawnWaveLimits.containsKey(possibleSpawn) && this.currentSpawnWaveCount.containsKey(possibleSpawn) && this.currentSpawnWaveCount.get(possibleSpawn) >= this.spawnWaveLimits.get(possibleSpawn)) {
                withinWaveLimit = false;
                LycanitesMobs.printDebug("CustomSpawner", possibleSpawn.mobInfo.name + ": Spawn Wave Limit reached for this mob.");
            }
            if (!((isEnabled = withinWaveLimit) && possibleSpawn != null && possibleSpawn.mobInfo.mobEnabled && possibleSpawn.enabled && possibleSpawn.spawnWeight > 0 && possibleSpawn.spawnGroupMax > 0)) {
                LycanitesMobs.printDebug("CustomSpawner", possibleSpawn.mobInfo.name + ": Not enabled, will not spawn.");
                isEnabled = false;
            }
            boolean enoughCoords = true;
            if (coordsFound < possibleSpawn.spawnBlockCost) {
                LycanitesMobs.printDebug("CustomSpawner", possibleSpawn.mobInfo.name + ": Not enough of the required blocks available for spawning.");
                enoughCoords = false;
            }
            boolean bl = isValidBiome = this.ignoreBiome || possibleSpawn.ignoreBiome;
            if (enoughCoords && !isValidBiome) {
                for (BiomeGenBase validBiome : possibleSpawn.biomes) {
                    for (BiomeGenBase targetBiome : biomes) {
                        if (targetBiome != validBiome) continue;
                        isValidBiome = true;
                        break;
                    }
                    if (isValidBiome) break;
                }
            }
            if (!isValidBiome) {
                LycanitesMobs.printDebug("CustomSpawner", possibleSpawn.mobInfo.name + ": No valid spawning biomes could be found within the coordinates.");
            }
            if (!isEnabled || !enoughCoords || !isValidBiome) continue;
            LycanitesMobs.printDebug("CustomSpawner", possibleSpawn.mobInfo.name + ": Able to spawn.");
            possibleSpawns.add(possibleSpawn);
        }
        return possibleSpawns;
    }

    public SpawnInfo getRandomMob(List<SpawnInfo> possibleSpawns, World world) {
        int totalWeights = 0;
        for (SpawnInfo spawnEntry : possibleSpawns) {
            totalWeights += spawnEntry.spawnWeight;
        }
        if (totalWeights <= 0) {
            return null;
        }
        int randomWeight = 1;
        if (totalWeights > 1) {
            randomWeight = world.field_73012_v.nextInt(totalWeights - 1) + 1;
        }
        int searchWeight = 0;
        SpawnInfo spawnInfo = null;
        Iterator<SpawnInfo> iterator = possibleSpawns.iterator();
        while (iterator.hasNext()) {
            SpawnInfo spawnEntry;
            spawnInfo = spawnEntry = iterator.next();
            if (spawnEntry.spawnWeight + searchWeight > randomWeight) break;
            searchWeight += spawnEntry.spawnWeight;
        }
        return spawnInfo;
    }

    public void spawnEntity(World world, EntityLiving entityLiving) {
        world.func_72838_d((Entity)entityLiving);
        if (this.mobEvent != null) {
            this.mobEvent.onSpawn(entityLiving);
        }
    }

    public List<int[]> searchForBlockCoords(World world, int x, int y, int z) {
        ArrayList<int[]> blockCoords = null;
        int range = this.getRange(world);
        for (int i = x - range; i <= x + range; ++i) {
            for (int j = y - range; j <= y + range; ++j) {
                block2: for (int k = z - range; k <= z + range; ++k) {
                    if (this.materials != null && this.materials.length > 0) {
                        if (blockCoords == null) {
                            blockCoords = new ArrayList<int[]>();
                        }
                        for (Material material : this.materials) {
                            if (world.func_147439_a(i, j, k).func_149688_o() != material || !this.isValidCoord(world, i, j, k)) continue;
                            blockCoords.add(new int[]{i, j, k});
                            break;
                        }
                    }
                    if (this.blocks != null && this.blocks.length > 0) {
                        if (blockCoords == null) {
                            blockCoords = new ArrayList();
                        }
                        for (Block block : this.blocks) {
                            if (world.func_147439_a(i, j, k) != block) continue;
                            blockCoords.add(new int[]{i, j, k});
                            break;
                        }
                    }
                    if (this.blockStrings == null || this.blockStrings.length <= 0) continue;
                    if (blockCoords == null) {
                        blockCoords = new ArrayList();
                    }
                    for (String string : this.blockStrings) {
                        if (world.func_147439_a(i, j, k) != ObjectManager.getBlock(string)) continue;
                        blockCoords.add(new int[]{i, j, k});
                        continue block2;
                    }
                }
            }
        }
        return blockCoords;
    }

    public ChunkPosition getRandomLandCoord(World world, ChunkPosition originPos, int range) {
        int z;
        int radius = Math.round((float)range * 0.5f);
        int[] xz = this.getRandomXZCoord(world, originPos.field_151329_a, originPos.field_151328_c, rangeMin, range);
        int x = xz[0];
        int y = this.getRandomYCoord(world, x, originPos.field_151327_b, z = xz[1], rangeMin, range, true, Blocks.field_150350_a, false);
        return y > -1 ? new ChunkPosition(x, y, z) : null;
    }

    public ChunkPosition getRandomWaterCoord(World world, ChunkPosition originPos, int range) {
        int z;
        int radius = Math.round((float)range * 0.5f);
        int[] xz = this.getRandomXZCoord(world, originPos.field_151329_a, originPos.field_151328_c, rangeMin, range);
        int x = xz[0];
        int y = this.getRandomYCoord(world, x, originPos.field_151327_b, z = xz[1], rangeMin, range, false, Blocks.field_150355_j, false);
        return y > -1 ? new ChunkPosition(x, y, z) : null;
    }

    public ChunkPosition getRandomSkyCoord(World world, ChunkPosition originPos, int range) {
        int z;
        int radius = Math.round((float)range * 0.5f);
        int[] xz = this.getRandomXZCoord(world, originPos.field_151329_a, originPos.field_151328_c, rangeMin, range);
        int x = xz[0];
        int y = this.getRandomYCoord(world, x, originPos.field_151327_b, z = xz[1], rangeMin, range, false, Blocks.field_150350_a, false);
        return y > -1 ? new ChunkPosition(x, y, z) : null;
    }

    public int[] getRandomXZCoord(World world, int originX, int originZ, int rangeMin, int rangeMax) {
        float minScale;
        float zScale;
        float xScale = world.field_73012_v.nextFloat();
        if (xScale + (zScale = world.field_73012_v.nextFloat()) < (minScale = (float)rangeMin / (float)rangeMin) * 2.0f) {
            float xShare = world.field_73012_v.nextFloat();
            float zShare = 1.0f - xShare;
            xScale += minScale * xShare;
            zScale += minScale * zShare;
        }
        int x = Math.round((float)rangeMax * xScale);
        int z = Math.round((float)rangeMax * zScale);
        x = world.field_73012_v.nextBoolean() ? originX + x : originX - x;
        z = world.field_73012_v.nextBoolean() ? originZ + z : originZ - z;
        return new int[]{x, z};
    }

    public int getRandomYCoord(World world, int originX, int originY, int originZ, int rangeMin, int rangeMax, boolean solid, Block insideBlock, boolean underground) {
        int minY = Math.max(originY - rangeMax, 0);
        int maxY = originY + rangeMax;
        ArrayList<Integer> yCoordsLow = new ArrayList<Integer>();
        ArrayList<Integer> yCoordsHigh = new ArrayList<Integer>();
        for (int nextY = minY; nextY <= maxY; ++nextY) {
            Block block = world.func_147439_a(originX, nextY, originZ);
            if (block == null || (solid || block != insideBlock) && (!solid || !this.validGroundBlock(block, world, originX, nextY, originZ)) || nextY + 1 > originY - minY && nextY + 1 < originY - maxY) continue;
            if (world.func_72937_j(originX, nextY, originZ)) {
                if (underground) break;
                if (!solid) {
                    int skyCoord = nextY;
                    int skyMax = Math.min(world.func_72800_K() - 1, maxY) - skyCoord;
                    if (skyMax > 1) {
                        nextY += world.field_73012_v.nextInt(skyMax);
                    }
                    if (skyMax == 1) {
                        nextY = 1;
                    }
                }
                if (nextY + 1 <= 64) {
                    yCoordsLow.add(nextY + 1);
                    break;
                }
                yCoordsHigh.add(nextY + 1);
                break;
            }
            if (!this.doesCoordHaveSpace(world, originX, nextY + 1, originZ, insideBlock)) continue;
            if (nextY + 1 <= 64) {
                yCoordsLow.add(nextY + 1);
            } else {
                yCoordsHigh.add(nextY + 1);
            }
            nextY += 2;
        }
        int y = -1;
        if (yCoordsHigh.size() > 0 && (yCoordsLow.size() <= 0 || world.field_73012_v.nextFloat() > 0.25f)) {
            y = yCoordsHigh.size() == 1 ? ((Integer)yCoordsHigh.get(0)).intValue() : ((Integer)yCoordsHigh.get(world.field_73012_v.nextInt(yCoordsHigh.size() - 1))).intValue();
        } else if (yCoordsLow.size() > 0) {
            y = yCoordsLow.size() == 1 ? ((Integer)yCoordsLow.get(0)).intValue() : ((Integer)yCoordsLow.get(world.field_73012_v.nextInt(yCoordsLow.size() - 1))).intValue();
        }
        return y;
    }

    public boolean validGroundBlock(Block block, World world, int x, int y, int z) {
        if (block == null) {
            return false;
        }
        try {
            if (block.isNormalCube((IBlockAccess)world, x, y, z)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (block.isSideSolid((IBlockAccess)world, x, y, z, ForgeDirection.UP)) {
                return true;
            }
            if (block.isSideSolid((IBlockAccess)world, x, y, z, ForgeDirection.DOWN)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean doesCoordHaveSpace(World world, int x, int y, int z, Block insideBlock) {
        Block feet = world.func_147439_a(x, y, z);
        if (feet == null) {
            return false;
        }
        if (feet != insideBlock) {
            return false;
        }
        Block head = world.func_147439_a(x, y + 1, z);
        if (head == null) {
            return false;
        }
        return head == insideBlock;
    }

    public ChunkPosition getRandomChunkCoord(World world, Chunk chunk, int range) {
        range = Math.min(range, 16);
        int x = chunk.field_76635_g + world.field_73012_v.nextInt(range);
        int z = chunk.field_76647_h + world.field_73012_v.nextInt(range);
        int y = world.field_73012_v.nextInt(chunk == null ? world.func_72940_L() : chunk.func_76625_h() + 1);
        return new ChunkPosition(x += 16 - range, y, z += 16 - range);
    }

    public boolean isValidCoord(World world, int x, int y, int z) {
        return true;
    }

    public List<int[]> orderCoordsCloseToFar(List<int[]> coords, int x, int y, int z) {
        Collections.sort(coords, new CoordSorterNearest(new int[]{x, y, z}));
        return coords;
    }

    public SpawnTypeBase setRate(int integer) {
        this.rate = integer;
        return this;
    }

    public SpawnTypeBase setChance(double dbl) {
        this.chance = dbl;
        return this;
    }

    public SpawnTypeBase setRange(int integer) {
        this.range = integer;
        return this;
    }

    public SpawnTypeBase setBlockLimit(int integer) {
        this.blockLimit = integer;
        return this;
    }

    public SpawnTypeBase setMobLimit(int integer) {
        this.mobLimit = integer;
        return this;
    }

    public SpawnTypeBase setMobEvent(MobEventBase mobEvent) {
        this.mobEvent = mobEvent;
        this.forceSpawning = mobEvent.forceSpawning;
        this.forceNoDespawn = mobEvent.forceNoDespawn;
        return this;
    }

    public int getRate(World world) {
        if (this.mobEvent != null) {
            return this.mobEvent.getRate(world);
        }
        return this.rate;
    }

    public int getRange(World world) {
        if (this.mobEvent != null) {
            return this.mobEvent.getRange(world);
        }
        return this.range;
    }
}

