/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.spawning;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lycanite.lycanitesmobs.ExtendedWorld;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.spawning.CustomSpawner;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class SpawnTypeDarkness
extends SpawnTypeBase {
    public boolean displayChatWarnings = true;
    public int lightLevelMax = 5;
    public int checkRate = 100;
    public double lowChance = 0.125;
    public double medChance = 0.25;
    public double hiChance = 0.5;
    public Map<EntityPlayer, Byte> darknessLevels = new HashMap<EntityPlayer, Byte>();

    public SpawnTypeDarkness(String typeName) {
        super(typeName);
        CustomSpawner.instance.updateSpawnTypes.add(this);
    }

    @Override
    public void loadFromConfig() {
        super.loadFromConfig();
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.group, "spawning");
        this.displayChatWarnings = config.getBool("Spawner Features", "Darkness Spawn Chat Warnings", this.displayChatWarnings, "Set to false to prevent the darkness warning messages from showing.");
        this.lightLevelMax = config.getInt("Spawner Features", "Darkness Spawn Highest Light Level", this.lightLevelMax, "The highest light level the Darkness spawn type will work in. 5 Is above ground in the overworld at night time. 0 is pitch black.");
        this.checkRate = config.getInt("Spawner Features", "Darkness Spawn Check Rate", this.checkRate, "The rate in ticks (20 ticks = 1 second) that the light level is checked, a higher rate will make things spawn much faster from the darkness.");
        this.lowChance = config.getDouble("Spawner Features", "Darkness Spawn Low Chance", this.lowChance, "The chance from 0.0-1.0 that a monster will spawn when in most dark light levels.");
        this.medChance = config.getDouble("Spawner Features", "Darkness Spawn Medium Chance", this.medChance, "The chance from 0.0-1.0 that a monster will spawn when in light level 1 (almost the darkest).");
        this.hiChance = config.getDouble("Spawner Features", "Darkness Spawn High Chance", this.hiChance, "The chance from 0.0-1.0 that a monster will spawn when in light level 0 (the darkest).");
    }

    @Override
    public boolean spawnMobs(long tick, World world, int x, int y, int z, EntityPlayer player) {
        boolean isValidBlock;
        boolean spawned = false;
        ChunkCoordinates playerCoords = player.func_82114_b();
        Block block = world.func_147439_a(playerCoords.field_71574_a, playerCoords.field_71572_b, playerCoords.field_71573_c);
        boolean bl = isValidBlock = block != null;
        if (isValidBlock) {
            boolean bl2 = isValidBlock = !block.func_149721_r();
        }
        if (isValidBlock) {
            boolean bl3 = isValidBlock = block.func_149688_o() != Material.field_151586_h;
        }
        if (!player.field_71075_bZ.field_75098_d && isValidBlock && tick % (long)this.checkRate == 0L && this.enabled && this.hasSpawns()) {
            int lightLevel = world.func_72957_l(playerCoords.field_71574_a, playerCoords.field_71572_b, playerCoords.field_71573_c);
            byte darknessLevel = 0;
            if (this.darknessLevels.containsKey(player)) {
                darknessLevel = (byte)Math.max(0, Math.min(2, this.darknessLevels.get(player).byteValue()));
            }
            LycanitesMobs.printDebug("CustomSpawner", "Darkness Level Read: " + darknessLevel);
            if (lightLevel <= this.lightLevelMax) {
                double chance = this.lowChance;
                if (lightLevel <= 0) {
                    chance = this.hiChance;
                } else if (lightLevel == 1) {
                    chance = this.medChance;
                }
                float roll = player.func_70681_au().nextFloat();
                ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
                if (worldExt != null && "shadowgames".equalsIgnoreCase(worldExt.getWorldEventType())) {
                    roll /= 2.0f;
                }
                if (chance > (double)roll) {
                    if ((darknessLevel = (byte)(darknessLevel + 1)) == 1 && this.displayChatWarnings) {
                        String message = StatCollector.func_74838_a((String)"spawner.darkness.level1");
                        player.func_145747_a((IChatComponent)new ChatComponentText(message));
                    } else if (darknessLevel == 2 && this.displayChatWarnings) {
                        String message = StatCollector.func_74838_a((String)"spawner.darkness.level2");
                        player.func_145747_a((IChatComponent)new ChatComponentText(message));
                    } else if (darknessLevel == 3) {
                        if (this.displayChatWarnings) {
                            String message = StatCollector.func_74838_a((String)"spawner.darkness.level3");
                            player.func_145747_a((IChatComponent)new ChatComponentText(message));
                        }
                        spawned = super.spawnMobs(tick, world, playerCoords.field_71574_a, playerCoords.field_71572_b, playerCoords.field_71573_c, player);
                        darknessLevel = 0;
                    } else {
                        darknessLevel = 0;
                    }
                }
            } else if (darknessLevel > 0) {
                if (darknessLevel == 2 && this.displayChatWarnings) {
                    String message = StatCollector.func_74838_a((String)"spawner.darkness.level1.back");
                    player.func_145747_a((IChatComponent)new ChatComponentText(message));
                }
                darknessLevel = (byte)(darknessLevel - 1);
            }
            this.darknessLevels.put(player, darknessLevel);
            LycanitesMobs.printDebug("CustomSpawner", "Darkness Level Write: " + darknessLevel);
        }
        return spawned;
    }

    @Override
    public boolean canSpawn(long tick, World world, int x, int y, int z, boolean rare) {
        return true;
    }

    @Override
    public List<int[]> orderCoords(List<int[]> coords, int x, int y, int z) {
        return this.orderCoordsCloseToFar(coords, x, y, z);
    }
}

