/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.spawning;

import java.util.List;
import lycanite.lycanitesmobs.ExtendedWorld;
import lycanite.lycanitesmobs.api.info.ObjectLists;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeBlockBreak;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class SpawnTypeTree
extends SpawnTypeBlockBreak {
    public SpawnTypeTree(String typeName) {
        super(typeName);
    }

    @Override
    public boolean validBlockBreak(Block block, World world, int x, int y, int z, Entity entity) {
        return this.isTreeLeavesBlock(block, world, x, y, z);
    }

    @Override
    public boolean validBlockHarvest(Block block, World world, int x, int y, int z, Entity entity) {
        if (!super.validBlockHarvest(block, world, x, y, z, entity)) {
            return false;
        }
        return this.isTreeLogBlock(block, world, x, y, z) || this.isTreeLeavesBlock(block, world, x, y, z);
    }

    public boolean isTreeLogBlock(Block block, World world, int x, int y, int z) {
        if (ObjectLists.isInOreDictionary("logWood", block)) {
            for (int searchX = x - 1; searchX <= x + 1; ++searchX) {
                block1: for (int searchZ = z - 1; searchZ <= z + 1; ++searchZ) {
                    for (int searchY = y; searchY <= Math.min(world.func_72800_K(), y + 32); ++searchY) {
                        Block searchBlock = world.func_147439_a(searchX, searchY, searchZ);
                        if (searchBlock == block || searchBlock == null) continue;
                        if (ObjectLists.isInOreDictionary("treeLeaves", searchBlock)) {
                            return true;
                        }
                        if (!world.func_147437_c(x, searchY, z)) continue block1;
                    }
                }
            }
        }
        return false;
    }

    public boolean isTreeLeavesBlock(Block block, World world, int x, int y, int z) {
        if (ObjectLists.isInOreDictionary("treeLeaves", block)) {
            for (int searchX = x - 1; searchX <= x + 1; ++searchX) {
                block1: for (int searchZ = z - 1; searchZ <= z + 1; ++searchZ) {
                    for (int searchY = y; searchY >= Math.max(0, y - 32); --searchY) {
                        Block searchBlock = world.func_147439_a(searchX, searchY, searchZ);
                        if (searchBlock == block || searchBlock == null) continue;
                        if (ObjectLists.isInOreDictionary("logWood", searchBlock)) {
                            return true;
                        }
                        if (!world.func_147437_c(x, searchY, z)) continue block1;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean canSpawn(long tick, World world, int x, int y, int z, boolean rare) {
        double roll = world.field_73012_v.nextDouble();
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        if (worldExt != null && "rootriot".equalsIgnoreCase(worldExt.getWorldEventType())) {
            roll /= 4.0;
        }
        return !(roll >= this.chance);
    }

    @Override
    public List<int[]> orderCoords(List<int[]> coords, int x, int y, int z) {
        return this.orderCoordsCloseToFar(coords, x, y, z);
    }
}

