/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.spawning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.spawning.CustomSpawner;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeLand;
import net.minecraft.init.Blocks;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import org.apache.commons.lang3.math.NumberUtils;

public class SpawnTypeUnderground
extends SpawnTypeLand {
    public String dimensionYLevelsSetup = "56; 0,56; -1,16; 1,64; 2,40; 7,40";
    public int defaultYLevel = 56;
    public Map<Integer, Integer> dimensionYLevels = new HashMap<Integer, Integer>();

    public SpawnTypeUnderground(String typeName) {
        super(typeName);
        CustomSpawner.instance.updateSpawnTypes.add(this);
    }

    @Override
    public void loadFromConfig() {
        super.loadFromConfig();
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.group, "spawning");
        this.dimensionYLevelsSetup = config.getString("Spawner Features", "Underground Spawn Dimension Y Levels", this.dimensionYLevelsSetup, "A list of Y levels for each dimension that should be used when determining the maximum spawn height for underground spawning. The first entry is the default to use, every other entry is a per dimension entry using this format: DefaultYLevel;DimensionID,YLevel;DimensionID,YLevel spaces will be ignored so can be used to make things look clearer.");
        boolean defaultSet = false;
        for (String dimensionYLevelEntry : this.dimensionYLevelsSetup.replace(" ", "").split(";")) {
            String[] dimensionYLevelEntryValues = dimensionYLevelEntry.split(",");
            if (!defaultSet) {
                if (NumberUtils.isNumber((String)dimensionYLevelEntryValues[0])) {
                    this.defaultYLevel = Integer.parseInt(dimensionYLevelEntryValues[0]);
                }
                defaultSet = true;
                continue;
            }
            if (!NumberUtils.isNumber((String)dimensionYLevelEntryValues[0]) || !NumberUtils.isNumber((String)dimensionYLevelEntryValues[1])) continue;
            this.dimensionYLevels.put(Integer.parseInt(dimensionYLevelEntryValues[0]), Integer.parseInt(dimensionYLevelEntryValues[1]));
        }
    }

    @Override
    public List<int[]> getSpawnCoordinates(World world, int x, int y, int z) {
        if (world.field_73011_w.field_76574_g == 1) {
            return super.getSpawnCoordinates(world, x, y, z);
        }
        ArrayList<int[]> blockCoords = null;
        int range = this.getRange(world);
        ChunkPosition originPos = new ChunkPosition(x, this.getYLevelForWorld(world), z);
        for (int i = 0; i < this.blockLimit; ++i) {
            ChunkPosition chunkCoords = this.getRandomUndergroundLandCoord(world, originPos, range);
            if (chunkCoords == null) continue;
            if (blockCoords == null) {
                blockCoords = new ArrayList<int[]>();
            }
            blockCoords.add(new int[]{chunkCoords.field_151329_a, chunkCoords.field_151327_b, chunkCoords.field_151328_c});
        }
        return blockCoords;
    }

    public int getYLevelForWorld(World world) {
        if (this.dimensionYLevels.containsKey(world.field_73011_w.field_76574_g)) {
            return this.dimensionYLevels.get(world.field_73011_w.field_76574_g);
        }
        return this.defaultYLevel;
    }

    public ChunkPosition getRandomUndergroundLandCoord(World world, ChunkPosition originPos, int range) {
        int z;
        int radius = Math.round((float)range * 0.5f);
        int[] xz = this.getRandomXZCoord(world, originPos.field_151329_a, originPos.field_151328_c, rangeMin, range);
        int x = xz[0];
        int y = this.getRandomYCoord(world, x, 0, z = xz[1], rangeMin, originPos.field_151327_b, true, Blocks.field_150350_a, true);
        return y > -1 ? new ChunkPosition(x, y, z) : null;
    }
}

