/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.arcticmobs.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.ClientProxy;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.block.BlockBase;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.info.ItemInfo;
import lycanite.lycanitesmobs.arcticmobs.ArcticMobs;
import net.minecraft.block.Block;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockPackedIce;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFrostfire
extends BlockBase {
    public BlockFrostfire() {
        super(Material.field_151581_o);
        this.group = ArcticMobs.group;
        this.blockName = "frostfire";
        this.setup();
        this.tickRate = ConfigBase.getConfig(this.group, "general").getBool("Features", "Enable Frostfire", true) ? 200 : 1;
        this.removeOnTick = false;
        this.loopTicks = true;
        this.canBeCrushed = true;
        this.noEntityCollision = true;
        this.noBreakCollision = false;
        this.isOpaque = false;
        this.func_149713_g(1);
    }

    @Override
    public int func_149738_a(World par1World) {
        return 30;
    }

    @Override
    public void func_149674_a(World world, int x, int y, int z, Random random) {
        boolean onFireFuel;
        if (!ConfigBase.getConfig(this.group, "general").getBool("Features", "Enable Frostfire")) {
            world.func_147468_f(x, y, z);
        }
        if (!world.func_82736_K().func_82766_b("doFireTick") && ItemInfo.removeOnNoFireTick) {
            world.func_147468_f(x, y, z);
            return;
        }
        if (!world.func_82736_K().func_82766_b("doFireTick") && !ItemInfo.removeOnNoFireTick) {
            return;
        }
        Block base = world.func_147439_a(x, y - 1, z);
        if (base == Blocks.field_150432_aD) {
            world.func_147449_b(x, y - 1, z, Blocks.field_150403_cj);
        }
        if (base == Blocks.field_150431_aC || base == Blocks.field_150329_H) {
            world.func_147449_b(x, y - 1, z, (Block)this);
        }
        boolean bl = onFireFuel = base == Blocks.field_150433_aE;
        if (!this.func_149742_c(world, x, y, z)) {
            world.func_147468_f(x, y, z);
        }
        super.func_149674_a(world, x, y, z, random);
        int metadata = world.func_72805_g(x, y, z);
        if (metadata < 15) {
            world.func_72921_c(x, y, z, metadata + random.nextInt(3) / 2, 4);
        }
        if (!onFireFuel && !this.canNeighborBurn(world, x, y, z)) {
            if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && base != Blocks.field_150355_j || metadata > 3) {
                world.func_147468_f(x, y, z);
                return;
            }
        }
        if (!onFireFuel && metadata == 15 && random.nextInt(4) == 0) {
            world.func_147468_f(x, y, z);
            return;
        }
    }

    @Override
    public boolean func_149698_L() {
        return false;
    }

    public boolean canBlockBurn(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150433_aE) {
            return true;
        }
        if (block == Blocks.field_150431_aC && face != ForgeDirection.UP && face != ForgeDirection.DOWN) {
            return true;
        }
        if (block instanceof BlockIce) {
            return true;
        }
        return block instanceof BlockPackedIce;
    }

    public boolean canNeighborBurn(World world, int x, int y, int z) {
        return this.canBlockBurn((IBlockAccess)world, x + 1, y, z, ForgeDirection.WEST) || this.canBlockBurn((IBlockAccess)world, x - 1, y, z, ForgeDirection.EAST) || this.canBlockBurn((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP) || this.canBlockBurn((IBlockAccess)world, x, y + 1, z, ForgeDirection.DOWN) || this.canBlockBurn((IBlockAccess)world, x, y, z - 1, ForgeDirection.SOUTH) || this.canBlockBurn((IBlockAccess)world, x, y, z + 1, ForgeDirection.NORTH);
    }

    private void tryCatchFire(World world, int x, int y, int z, int chance, Random random, int metadata, ForgeDirection face) {
        int j1 = 0;
        Block block = world.func_147439_a(x, y, z);
        if (block != null) {
            j1 = 0;
        }
        if (random.nextInt(chance) < j1 / 8) {
            if (random.nextInt(metadata + 10) < 5) {
                int k1 = metadata + random.nextInt(5) / 4;
                if (k1 > 15) {
                    k1 = 15;
                }
                world.func_147465_d(x, y, z, (Block)this, k1, 3);
            } else {
                world.func_147468_f(x, y, z);
            }
        }
    }

    public int getChanceOfNeighborsEncouragingFire(World world, int x, int y, int z) {
        int initialChance = 0;
        if (!world.func_147437_c(x, y, z)) {
            return 0;
        }
        int fireChance = initialChance;
        fireChance = this.getChanceToEncourageFire((IBlockAccess)world, x + 1, y, z, fireChance, ForgeDirection.WEST);
        fireChance = this.getChanceToEncourageFire((IBlockAccess)world, x - 1, y, z, fireChance, ForgeDirection.EAST);
        fireChance = this.getChanceToEncourageFire((IBlockAccess)world, x, y - 1, z, fireChance, ForgeDirection.UP);
        fireChance = this.getChanceToEncourageFire((IBlockAccess)world, x, y + 1, z, fireChance, ForgeDirection.DOWN);
        fireChance = this.getChanceToEncourageFire((IBlockAccess)world, x, y, z - 1, fireChance, ForgeDirection.SOUTH);
        fireChance = this.getChanceToEncourageFire((IBlockAccess)world, x, y, z + 1, fireChance, ForgeDirection.NORTH);
        return fireChance;
    }

    public int getChanceToEncourageFire(IBlockAccess world, int x, int y, int z, int oldChance, ForgeDirection face) {
        int newChance = 0;
        if (world.func_147439_a(x, y, z) == Blocks.field_150433_aE) {
            newChance = 50;
        }
        if (this.canBlockBurn(world, x, y, z, face)) {
            newChance = 10;
        }
        return newChance > oldChance ? newChance : oldChance;
    }

    @Override
    public Item func_149650_a(int metadata, Random random, int fortune) {
        return ObjectManager.getItem("tundracharge");
    }

    @Override
    public int func_149692_a(int metadata) {
        return 0;
    }

    @Override
    public int func_149745_a(Random par1Random) {
        return 0;
    }

    @Override
    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        super.func_149670_a(world, x, y, z, entity);
        if (entity instanceof EntityItem) {
            return;
        }
        if (entity.func_70027_ad()) {
            entity.func_70066_B();
        }
        PotionEffect effectSlowness = new PotionEffect(Potion.field_76421_d.field_76415_H, 100, 0);
        PotionEffect effectHunger = new PotionEffect(Potion.field_76438_s.field_76415_H, 100, 0);
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase entityLiving = (EntityLivingBase)entity;
            if (!entityLiving.func_70687_e(effectSlowness) && !entityLiving.func_70687_e(effectHunger)) {
                return;
            }
            entityLiving.func_70690_d(effectSlowness);
        }
        entity.func_70097_a(DamageSource.field_76376_m, 2.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (random.nextInt(24) == 0) {
            world.func_72980_b((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), AssetManager.getSound("frostfire"), 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
        }
        for (int l = 0; l < 12; ++l) {
            float f = (float)x + random.nextFloat();
            float f1 = (float)y + random.nextFloat() * 0.5f;
            float f2 = (float)z + random.nextFloat();
            world.func_72869_a("snowshovel", (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        AssetManager.addIconGroup(this.blockName, this.group, new String[]{"frostfire_layer_0", "frostfire_layer_1"}, iconRegister);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return AssetManager.getIconGroup(this.blockName)[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return ClientProxy.RENDER_ID;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }
}

