/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.freshwatermobs.entity;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.HashMap;
import java.util.List;
import lycanite.lycanitesmobs.ExtendedEntity;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.entity.EntityCreatureRideable;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAttackMelee;
import lycanite.lycanitesmobs.api.entity.ai.EntityAILookIdle;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIStayByWater;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISwimming;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRiderAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRiderRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITempt;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWatchClosest;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.api.info.ObjectLists;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;

public class EntityStrider
extends EntityCreatureRideable {
    protected EntityAIWander wanderAI = new EntityAIWander(this);
    protected EntityAIAttackMelee attackAI;
    protected int pickupCooldown = 100;
    private int pickupTime = 0;

    public EntityStrider(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 0;
        this.experience = 7;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.0;
        this.canGrow = true;
        this.setWidth = 4.9f;
        this.setHeight = 10.9f;
        this.setupMob();
        this.field_70138_W = 2.0f;
        this.func_70661_as().func_75495_e(true);
        this.func_70661_as().func_75491_a(false);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this).setSink(true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiSit);
        this.attackAI = new EntityAIAttackMelee(this).setLongMemory(false);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.attackAI);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("stridertreat"))).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIStayByWater(this).setSpeed(1.25));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.wanderAI);
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRiderRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetRiderAttack(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class).setCheckSight(false));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class).setCheckSight(false));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 40.0);
        baseAttributes.put("movementSpeed", 0.24);
        baseAttributes.put("knockbackResistance", 1.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 2.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151115_aP), 1.0f).setBurningDrop(new ItemStack(Items.field_151101_aQ)).setMaxAmount(5));
        this.drops.add(new DropRate(new ItemStack(Items.field_151115_aP, 1, 3), 0.5f).setBurningDrop(new ItemStack(Items.field_151101_aQ, 1, 3)).setMaxAmount(5));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70090_H()) {
                this.wanderAI.setPauseRate(120);
            } else {
                this.wanderAI.setPauseRate(0);
            }
            if (this.isTamed() && this.hasPickupEntity() && this.getPickupEntity() == this.getOwner()) {
                this.dropPickupEntity();
            }
            this.attackAI.setEnabled(!this.hasPickupEntity());
            if (this.hasPickupEntity()) {
                ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity());
                if (extendedEntity != null) {
                    extendedEntity.setPickedUpByEntity((Entity)this);
                }
                if (this.pickupTime++ % 40 == 0) {
                    this.attackEntityAsMob(this.getPickupEntity(), 0.5);
                    if (this.getPickupEntity() instanceof EntityLivingBase && ObjectManager.getPotionEffect("penetration") != null && ObjectManager.getPotionEffect((String)"penetration").field_76415_H < Potion.field_76425_a.length) {
                        ((EntityLivingBase)this.getPickupEntity()).func_70690_d(new PotionEffect(ObjectManager.getPotionEffect((String)"penetration").field_76415_H, this.getEffectDuration(5), 1));
                    }
                }
            } else {
                if (this.pickupCooldown > 0) {
                    --this.pickupCooldown;
                }
                this.pickupTime = 0;
            }
        }
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        double distance = 10.0;
        List possibleTargets = this.field_70170_p.func_82733_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(distance, distance, distance), null);
        if (!possibleTargets.isEmpty()) {
            for (EntityLivingBase possibleTarget : possibleTargets) {
                if (possibleTarget == null || !possibleTarget.func_70089_S() || possibleTarget == this || possibleTarget == this.getRider() || this.func_142014_c(possibleTarget)) continue;
                boolean doDamage = true;
                if (this.getRider() instanceof EntityPlayer && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)this.getRider(), (Entity)possibleTarget))) {
                    doDamage = false;
                }
                if (!doDamage) continue;
                if (ObjectManager.getPotionEffect("penetration") != null && ObjectManager.getPotionEffect((String)"penetration").field_76415_H < Potion.field_76425_a.length) {
                    possibleTarget.func_70690_d(new PotionEffect(ObjectManager.getPotionEffect((String)"penetration").field_76415_H, this.getEffectDuration(5), 1));
                    continue;
                }
                possibleTarget.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 0));
            }
        }
        this.playAttackSound();
        this.setJustAttacked();
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 20.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    @Override
    public float getAISpeedModifier() {
        if (this.func_70090_H()) {
            return 8.0f;
        }
        if (this.waterContact()) {
            return 2.0f;
        }
        return super.getAISpeedModifier();
    }

    @Override
    public float getBlockPathWeight(int par1, int par2, int par3) {
        int waterWeight = 10;
        if (this.field_70170_p.func_147439_a(par1, par2, par3) == Blocks.field_150355_j) {
            return (super.getBlockPathWeight(par1, par2, par3) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.field_70170_p.func_147439_a(par1, par2, par3) == Blocks.field_150358_i) {
            return (super.getBlockPathWeight(par1, par2, par3) + 1.0f) * (float)waterWeight;
        }
        if (this.field_70170_p.func_72896_J() && this.field_70170_p.func_72937_j(par1, par2, par3)) {
            return (super.getBlockPathWeight(par1, par2, par3) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(par1, par2, par3);
        }
        if (this.waterContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(par1, par2, par3);
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 1.0;
    }

    @Override
    public void onDismounted(Entity entity) {
        super.onDismounted(entity);
        if (entity != null && entity instanceof EntityLivingBase && ObjectManager.getPotionEffect("fallresist") != null && ObjectManager.getPotionEffect((String)"fallresist").field_76415_H < Potion.field_76425_a.length) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(ObjectManager.getPotionEffect((String)"fallresist").field_76415_H, 60, 1));
        }
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityLivingBase && ObjectManager.getPotionEffect("penetration") != null && ObjectManager.getPotionEffect((String)"penetration").field_76415_H < Potion.field_76425_a.length) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(ObjectManager.getPotionEffect((String)"penetration").field_76415_H, this.getEffectDuration(8), 1));
        }
        if (this.canPickupEntity(target) && this.func_70685_l(target)) {
            this.pickupEntity(target);
            this.pickupCooldown = 100;
        }
        return true;
    }

    @Override
    public void onDamage(DamageSource damageSrc, float damage) {
        if (this.hasPickupEntity() && this.func_70681_au().nextFloat() <= 0.25f) {
            this.dropPickupEntity();
        }
        super.onDamage(damageSrc, damage);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (ObjectManager.getPotionEffect("Penetration") != null && potionEffect.func_76456_a() == ObjectManager.getPotionEffect((String)"Penetration").field_76415_H) {
            return false;
        }
        if (ObjectManager.getPotionEffect("Paralysis") != null && potionEffect.func_76456_a() == ObjectManager.getPotionEffect((String)"Paralysis").field_76415_H) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public float getFallResistance() {
        return 20.0f;
    }

    @Override
    public double[] getPickupOffset(Entity entity) {
        return new double[]{0.0, 5.5, 0.0};
    }

    @Override
    public boolean canPickupEntity(Entity entity) {
        if (this.pickupCooldown > 0) {
            return false;
        }
        return super.canPickupEntity(entity);
    }

    @Override
    public void dropPickupEntity() {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity());
        if (extendedEntity != null) {
            extendedEntity.setPickedUpByEntity(null);
        }
        this.pickupEntity = null;
    }

    @Override
    public int getBagSize() {
        return 15;
    }

    @Override
    public boolean petControlsEnabled() {
        return false;
    }

    @Override
    public boolean isTamingItem(ItemStack itemstack) {
        return itemstack.func_77973_b() == ObjectManager.getItem("stridertreat");
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cookedmeat", testStack);
    }
}

