/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.junglemobs.entity;

import java.util.HashMap;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.IGroupAlpha;
import lycanite.lycanitesmobs.api.IGroupAnimal;
import lycanite.lycanitesmobs.api.IGroupPrey;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureAgeable;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAttackMelee;
import lycanite.lycanitesmobs.api.entity.ai.EntityAILookIdle;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISwimming;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITempt;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWatchClosest;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.api.info.ObjectLists;
import lycanite.lycanitesmobs.junglemobs.entity.EntityConcapedeSegment;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class EntityConcapedeHead
extends EntityCreatureAgeable
implements IAnimals,
IGroupAnimal,
IGroupAlpha {
    public static int CONCAPEDE_SIZE_MAX = 10;

    public EntityConcapedeHead(World world) {
        super(world);
        CONCAPEDE_SIZE_MAX = Math.max(1, ConfigBase.getConfig(this.group, "general").getInt("Features", "Concapede Size Limit", 10, "The maximum amount of segments long a Concapede can be, including the head."));
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.defense = 0;
        this.experience = 5;
        this.hasAttackSound = true;
        this.canGrow = true;
        this.babySpawnChance = 0.0;
        this.setWidth = 0.5f;
        this.setHeight = 0.9f;
        this.setupMob();
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee(this).setLongMemory(false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAITempt(this).setItemList("Vegetables"));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander(this).setPauseRate(30));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 10.0);
        baseAttributes.put("movementSpeed", 0.28);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 2.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("ConcapedeMeatRaw")), 1.0f).setMinAmount(3).setMaxAmount(6).setBurningDrop(new ItemStack(ObjectManager.getItem("ConcapedeMeatCooked"))));
        this.drops.add(new DropRate(new ItemStack(Items.field_151007_F), 0.5f).setMinAmount(1).setMaxAmount(2));
    }

    @Override
    public void onFirstSpawn() {
        if (!this.field_70170_p.field_72995_K && !this.hasMaster()) {
            this.setGrowingAge(-this.growthTime / 4);
            int segmentCount = this.func_70681_au().nextInt(CONCAPEDE_SIZE_MAX);
            EntityCreatureAgeable parentSegment = this;
            for (int segment = 0; segment < segmentCount; ++segment) {
                EntityConcapedeSegment segmentEntity = new EntityConcapedeSegment(parentSegment.field_70170_p);
                segmentEntity.func_70012_b(parentSegment.field_70165_t, parentSegment.field_70163_u, parentSegment.field_70161_v, 0.0f, 0.0f);
                segmentEntity.setParentTarget((EntityLivingBase)parentSegment);
                parentSegment.field_70170_p.func_72838_d((Entity)segmentEntity);
                parentSegment = segmentEntity;
            }
        }
        super.onFirstSpawn();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
    }

    @Override
    public void setGrowingAge(int age) {
        if (age == 0 && ObjectManager.getMob("ConcapedeSegment") != null && !this.field_70170_p.field_72995_K) {
            age = -(this.growthTime / 4);
            EntityCreatureBase parentSegment = this;
            boolean lastSegment = false;
            int size = 0;
            while (!lastSegment) {
                ++size;
                if (parentSegment.hasMaster() && parentSegment.getMasterTarget() instanceof EntityCreatureBase) {
                    parentSegment = (EntityCreatureBase)parentSegment.getMasterTarget();
                    continue;
                }
                lastSegment = true;
            }
            if (size < CONCAPEDE_SIZE_MAX) {
                EntityConcapedeSegment segmentEntity = new EntityConcapedeSegment(this.field_70170_p);
                segmentEntity.func_70012_b(parentSegment.field_70165_t, parentSegment.field_70163_u, parentSegment.field_70161_v, 0.0f, 0.0f);
                parentSegment.field_70170_p.func_72838_d((Entity)segmentEntity);
                segmentEntity.setParentTarget((EntityLivingBase)parentSegment);
            }
        }
        super.setGrowingAge(age);
    }

    @Override
    public float getBlockPathWeight(int par1, int par2, int par3) {
        if (this.field_70170_p.func_147439_a(par1, par2 - 1, par3) != Blocks.field_150350_a) {
            Block block = this.field_70170_p.func_147439_a(par1, par2 - 1, par3);
            if (block.func_149688_o() == Material.field_151577_b) {
                return 10.0f;
            }
            if (block.func_149688_o() == Material.field_151578_c) {
                return 7.0f;
            }
        }
        return super.getBlockPathWeight(par1, par2, par3);
    }

    @Override
    public boolean canLeash(EntityPlayer player) {
        return !this.hasAttackTarget();
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityLivingBase) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, this.getEffectDuration(8), 0));
        }
        return true;
    }

    @Override
    public boolean func_70686_a(Class targetClass) {
        if (targetClass.isAssignableFrom(EntityConcapedeSegment.class)) {
            return false;
        }
        return super.func_70686_a(targetClass);
    }

    @Override
    public boolean isAggressive() {
        if (this.isInLove()) {
            return false;
        }
        if (this.field_70170_p.func_72935_r()) {
            return this.testLightLevel() < 2;
        }
        return super.isAggressive();
    }

    @Override
    public boolean isProtective(Entity entity) {
        if (this.isInLove()) {
            return false;
        }
        if (entity instanceof EntityConcapedeSegment) {
            for (EntityCreatureBase checkSegment = this; checkSegment != null; checkSegment = (EntityCreatureBase)checkSegment.getMasterTarget()) {
                if (checkSegment == entity) {
                    return true;
                }
                if (!checkSegment.hasMaster()) break;
            }
        }
        return false;
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable partener) {
        return null;
    }

    @Override
    public boolean isBreedingItem(ItemStack testStack) {
        return ObjectLists.inItemList("Vegetables", testStack);
    }

    @Override
    public boolean canBreed() {
        return this.getGrowingAge() >= 0;
    }

    @Override
    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        if (par1PotionEffect.func_76456_a() == Potion.field_76436_u.field_76415_H) {
            return false;
        }
        if (par1PotionEffect.func_76456_a() == Potion.field_76421_d.field_76415_H) {
            return false;
        }
        super.func_70687_e(par1PotionEffect);
        return true;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }
}

