/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.junglemobs.entity;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.IGroupAnimal;
import lycanite.lycanitesmobs.api.entity.EntityCreatureAgeable;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIFollowParent;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISwimming;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.api.info.ObjectLists;
import lycanite.lycanitesmobs.api.info.SpawnInfo;
import lycanite.lycanitesmobs.junglemobs.entity.EntityConcapedeHead;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class EntityConcapedeSegment
extends EntityCreatureAgeable
implements IAnimals,
IGroupAnimal {
    UUID parentUUID = null;

    public EntityConcapedeSegment(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.defense = 0;
        this.experience = 3;
        this.hasAttackSound = true;
        this.hasStepSound = false;
        this.canGrow = true;
        this.babySpawnChance = 0.0;
        this.setWidth = 0.5f;
        this.setHeight = 0.9f;
        this.isHostileByDefault = false;
        this.setupMob();
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent(this).setSpeed(1.1).setStrayDistance(0.0).setLostDistance(0.0).setAdultFollowing(true).setFollowBehind(0.25));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander(this).setPauseRate(30));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRevenge(this).setHelpClasses(EntityConcapedeHead.class));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 5.0);
        baseAttributes.put("movementSpeed", 0.28);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 1.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("ConcapedeMeatRaw")), 1.0f).setMinAmount(1).setMaxAmount(2).setBurningDrop(new ItemStack(ObjectManager.getItem("ConcapedeMeatCooked"))));
        this.drops.add(new DropRate(new ItemStack(Items.field_151007_F), 0.25f).setMinAmount(1).setMaxAmount(2));
    }

    @Override
    public boolean naturalSpawnCheck(World world, int i, int j, int k) {
        if (this.getNearbyEntities(EntityConcapedeHead.class, SpawnInfo.spawnLimitRange).size() <= 0) {
            return false;
        }
        return super.naturalSpawnCheck(world, i, j, k);
    }

    @Override
    public void getRandomSubspecies() {
        if (this.subspecies == null && !this.hasParent()) {
            this.subspecies = this.mobInfo.getRandomSubspecies((EntityLivingBase)this);
            if (this.subspecies != null) {
                LycanitesMobs.printDebug("Subspecies", "Setting " + this.getSpeciesName() + " to " + this.subspecies.getTitle());
            } else {
                LycanitesMobs.printDebug("Subspecies", "Setting " + this.getSpeciesName() + " to base species.");
            }
        }
        if (this.hasParent() && this.getParentTarget() instanceof EntityCreatureBase) {
            this.setSubspecies(((EntityCreatureBase)this.getParentTarget()).getSubspeciesIndex(), true);
        }
    }

    @Override
    protected boolean func_70692_ba() {
        if (!super.func_70692_ba()) {
            return false;
        }
        return !this.hasParent();
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && !this.hasParent() && this.parentUUID != null) {
            double range = 64.0;
            List connections = this.field_70170_p.func_72872_a(EntityCreatureAgeable.class, this.field_70121_D.func_72314_b(range, range, range));
            for (EntityCreatureAgeable possibleConnection : connections) {
                if (possibleConnection == this || !possibleConnection.func_110124_au().equals(this.parentUUID)) continue;
                this.setParentTarget((EntityLivingBase)possibleConnection);
                break;
            }
            this.parentUUID = null;
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.hasMaster() && !this.getMasterTarget().func_70089_S()) {
                this.setMasterTarget(null);
            }
            if (this.hasParent() && !this.getParentTarget().func_70089_S()) {
                this.setParentTarget(null);
            }
            if (this.hasParent()) {
                this.func_70625_a((Entity)this.getParentTarget(), 360.0f, 360.0f);
                double segmentDistance = 0.5;
                double[] coords = this.getParentTarget() instanceof EntityCreatureBase ? ((EntityCreatureBase)this.getParentTarget()).getFacingPosition(-0.25) : new double[]{this.getParentTarget().field_70165_t, this.getParentTarget().field_70163_u, this.getParentTarget().field_70161_v};
                if (this.field_70165_t - coords[0] > segmentDistance) {
                    this.field_70165_t = coords[0] + segmentDistance;
                } else if (this.field_70165_t - coords[0] < -segmentDistance) {
                    this.field_70165_t = coords[0] - segmentDistance;
                }
                if (this.field_70163_u - coords[1] > segmentDistance) {
                    this.field_70163_u = coords[1] + segmentDistance;
                } else if (this.field_70163_u - coords[1] < -(segmentDistance / 2.0)) {
                    this.field_70163_u = coords[1];
                }
                if (this.field_70161_v - coords[2] > segmentDistance) {
                    this.field_70161_v = coords[2] + segmentDistance;
                } else if (this.field_70161_v - coords[2] < -segmentDistance) {
                    this.field_70161_v = coords[2] - segmentDistance;
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.getGrowingAge() <= 0) {
            this.setGrowingAge(-this.growthTime);
        }
    }

    @Override
    public void setGrowingAge(int age) {
        if (this.hasParent()) {
            age = -this.growthTime;
        }
        super.setGrowingAge(age);
        if (age == 0 && !this.field_70170_p.field_72995_K) {
            EntityConcapedeHead concapedeHead = new EntityConcapedeHead(this.field_70170_p);
            concapedeHead.func_82149_j((Entity)this);
            concapedeHead.firstSpawn = false;
            concapedeHead.setGrowingAge(-this.growthTime / 4);
            this.field_70170_p.func_72838_d((Entity)concapedeHead);
            if (this.hasMaster() && this.getMasterTarget() instanceof EntityConcapedeSegment) {
                ((EntityConcapedeSegment)this.getMasterTarget()).setParentTarget((EntityLivingBase)concapedeHead);
            }
            this.field_70170_p.func_72900_e((Entity)this);
        }
    }

    @Override
    public float getBlockPathWeight(int par1, int par2, int par3) {
        if (this.field_70170_p.func_147439_a(par1, par2 - 1, par3) != Blocks.field_150350_a) {
            Block block = this.field_70170_p.func_147439_a(par1, par2 - 1, par3);
            if (block.func_149688_o() == Material.field_151577_b) {
                return 10.0f;
            }
            if (block.func_149688_o() == Material.field_151578_c) {
                return 7.0f;
            }
        }
        return super.getBlockPathWeight(par1, par2, par3);
    }

    @Override
    public boolean canLeash(EntityPlayer player) {
        return !this.hasParent();
    }

    @Override
    public double getFallingMod() {
        if (this.field_70170_p.field_72995_K) {
            return 0.0;
        }
        if (this.hasParent() && this.getParentTarget().field_70163_u > this.field_70163_u) {
            return 0.0;
        }
        return super.getFallingMod();
    }

    @Override
    public void setParentTarget(EntityLivingBase setTarget) {
        if (setTarget instanceof EntityConcapedeSegment || setTarget instanceof EntityConcapedeHead) {
            ((EntityCreatureBase)setTarget).setMasterTarget((EntityLivingBase)this);
        }
        super.setParentTarget(setTarget);
    }

    @Override
    public boolean renderSubspeciesNameTag() {
        return !this.hasParent();
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    @Override
    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        if (par1PotionEffect.func_76456_a() == Potion.field_76436_u.field_76415_H) {
            return false;
        }
        if (par1PotionEffect.func_76456_a() == Potion.field_76421_d.field_76415_H) {
            return false;
        }
        super.func_70687_e(par1PotionEffect);
        return true;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable partener) {
        return null;
    }

    @Override
    public boolean isBreedingItem(ItemStack testStack) {
        return ObjectLists.inItemList("Vegetables", testStack);
    }

    @Override
    public boolean breed() {
        if (!this.canBreed()) {
            return false;
        }
        this.setGrowingAge(0);
        return true;
    }

    @Override
    public boolean canBreed() {
        return !this.hasParent();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("ParentUUIDMost") && nbtTagCompound.func_74764_b("ParentUUIDLeast")) {
            this.parentUUID = new UUID(nbtTagCompound.func_74763_f("ParentUUIDMost"), nbtTagCompound.func_74763_f("ParentUUIDLeast"));
        }
        super.func_70037_a(nbtTagCompound);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        if (this.hasParent()) {
            nbtTagCompound.func_74772_a("ParentUUIDMost", this.getParentTarget().func_110124_au().getMostSignificantBits());
            nbtTagCompound.func_74772_a("ParentUUIDLeast", this.getParentTarget().func_110124_au().getLeastSignificantBits());
        }
        super.func_70014_b(nbtTagCompound);
    }
}

