/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.mountainmobs.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.entity.EntityCreatureTameable;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAttackRanged;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIFollowOwner;
import lycanite.lycanitesmobs.api.entity.ai.EntityAILookIdle;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerThreats;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWatchClosest;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.api.info.ObjectLists;
import lycanite.lycanitesmobs.mountainmobs.entity.EntityArcaneLaserStorm;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityBeholder
extends EntityCreatureTameable {
    public EntityBeholder(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 2;
        this.experience = 5;
        this.hasAttackSound = false;
        this.setWidth = 3.9f;
        this.setHeight = 3.9f;
        this.justAttackedTime = (short)20;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRanged(this).setSpeed(0.25).setRate(80).setRange(40.0f).setMinChaseDistance(10.0f).setLongMemory(false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(4.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander(this).setPauseRate(30));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 20.0);
        baseAttributes.put("movementSpeed", 0.24);
        baseAttributes.put("knockbackResistance", 1.0);
        baseAttributes.put("followRange", 40.0);
        baseAttributes.put("attackDamage", 0.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151073_bk), 0.25f).setMinAmount(1).setMaxAmount(3));
        this.drops.add(new DropRate(new ItemStack(Items.field_151016_H), 0.5f).setMinAmount(1).setMaxAmount(3));
        this.drops.add(new DropRate(new ItemStack(Items.field_151114_aO), 0.5f).setMinAmount(4).setMaxAmount(16));
        this.drops.add(new DropRate(new ItemStack(Items.field_151061_bv), 0.25f).setMinAmount(1).setMaxAmount(2));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("arcanelaserstormcharge")), 0.25f));
    }

    @Override
    public void onDamage(DamageSource damageSrc, float damage) {
        super.onDamage(damageSrc, damage);
        Entity damageEntity = damageSrc.func_76364_f();
        if (damageEntity != null && ("mob".equals(damageSrc.field_76373_n) || "player".equals(damageSrc.field_76373_n)) && damageEntity instanceof EntityLivingBase) {
            EntityLivingBase targetLiving = (EntityLivingBase)damageEntity;
            ArrayList<Integer> goodEffectIDs = new ArrayList<Integer>();
            for (Object potionEffectObj : targetLiving.func_70651_bq()) {
                Potion potion;
                int potionID;
                if (!(potionEffectObj instanceof PotionEffect) || (potionID = ((PotionEffect)potionEffectObj).func_76456_a()) >= Potion.field_76425_a.length || (potion = Potion.field_76425_a[potionID]) == null || !ObjectLists.inEffectList("buffs", potion)) continue;
                goodEffectIDs.add(potionID);
            }
            if (goodEffectIDs.size() > 0 && this.func_70681_au().nextBoolean()) {
                if (goodEffectIDs.size() > 1) {
                    targetLiving.func_82170_o(((Integer)goodEffectIDs.get(this.func_70681_au().nextInt(goodEffectIDs.size()))).intValue());
                } else {
                    targetLiving.func_82170_o(((Integer)goodEffectIDs.get(0)).intValue());
                }
                float leeching = damage * 1.1f;
                this.func_70691_i(leeching);
            }
        }
    }

    @Override
    public boolean canFly() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public void rangedAttack(Entity target, float range) {
        EntityArcaneLaserStorm projectile = new EntityArcaneLaserStorm(this.field_70170_p, (EntityLivingBase)this);
        projectile.setProjectileScale(1.0f);
        projectile.field_70163_u -= (double)this.field_70131_O * 0.5;
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.field_70163_u - projectile.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.1f;
        float velocity = 0.5f;
        projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 0.0f);
        this.func_85030_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)projectile);
        super.rangedAttack(target, range);
    }

    @Override
    public boolean isDamageEntityApplicable(Entity entity) {
        if (entity instanceof EntityBeholder) {
            return false;
        }
        return super.isDamageEntityApplicable(entity);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_76456_a() == Potion.field_76419_f.field_76415_H) {
            return false;
        }
        if (ObjectManager.getPotionEffect("Weight") != null && potionEffect.func_76456_a() == ObjectManager.getPotionEffect((String)"Weight").field_76415_H) {
            return false;
        }
        super.func_70687_e(potionEffect);
        return true;
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    public float func_70013_c(float par1) {
        if (this.justAttacked()) {
            return 1.0f;
        }
        return super.func_70013_c(par1);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        if (this.justAttacked()) {
            return 0xF000F0;
        }
        return super.func_70070_b(par1);
    }
}

