/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.shadowmobs.entity;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.HashMap;
import java.util.List;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.IGroupAlpha;
import lycanite.lycanitesmobs.api.IGroupHunter;
import lycanite.lycanitesmobs.api.IGroupPredator;
import lycanite.lycanitesmobs.api.IGroupPrey;
import lycanite.lycanitesmobs.api.IGroupShadow;
import lycanite.lycanitesmobs.api.entity.EntityCreatureAgeable;
import lycanite.lycanitesmobs.api.entity.EntityCreatureRideable;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAttackMelee;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIBeg;
import lycanite.lycanitesmobs.api.entity.ai.EntityAILookIdle;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISwimming;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerThreats;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRiderAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRiderRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITempt;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWatchClosest;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.api.info.MobInfo;
import lycanite.lycanitesmobs.api.info.ObjectLists;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;

public class EntityShade
extends EntityCreatureRideable
implements IGroupPredator,
IGroupHunter,
IGroupShadow {
    public EntityShade(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 2;
        this.experience = 10;
        this.hasAttackSound = true;
        this.hasJumpSound = true;
        this.canGrow = false;
        this.setWidth = 0.9f;
        this.setHeight = 2.8f;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.field_70724_aR = 40;
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("shadetreat"))).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee(this).setSpeed(1.5).setRate(40));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander(this).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIBeg(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRiderRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetRiderAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this));
        if (MobInfo.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityCow.class).setTameTargetting(true));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPig.class).setTameTargetting(true));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntitySheep.class).setTameTargetting(true));
        }
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPigZombie.class));
        if (MobInfo.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAlpha.class));
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityAnimal.class));
        }
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        this.field_70715_bh.func_75776_a(7, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 40.0);
        baseAttributes.put("movementSpeed", 0.26);
        baseAttributes.put("knockbackResistance", 0.5);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 3.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151079_bi), 1.0f).setMaxAmount(5));
        this.drops.add(new DropRate(new ItemStack(Blocks.field_150343_Z), 0.75f).setMaxAmount(5));
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.specialAttack();
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 100.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.85;
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        float leeching = this.getEffectStrength(this.getAttackDamage(damageScale) / 4.0f);
        this.func_70691_i(leeching);
        if (this.func_70681_au().nextFloat() <= 0.1f) {
            this.specialAttack();
        }
        return true;
    }

    public void specialAttack() {
        double distance = 4.0;
        List possibleTargets = this.field_70170_p.func_82733_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(distance, distance, distance), null);
        if (!possibleTargets.isEmpty()) {
            for (EntityLivingBase possibleTarget : possibleTargets) {
                if (possibleTarget == null || !possibleTarget.func_70089_S() || possibleTarget == this || possibleTarget == this.getRider() || this.func_142014_c(possibleTarget)) continue;
                boolean doDamage = true;
                if (this.hasRiderTarget() && this.getRider() instanceof EntityPlayer && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)this.getRider(), (Entity)possibleTarget))) {
                    doDamage = false;
                }
                if (!doDamage) continue;
                if (ObjectManager.getPotionEffect("penetration") != null && ObjectManager.getPotionEffect((String)"fear").field_76415_H < Potion.field_76425_a.length) {
                    possibleTarget.func_70690_d(new PotionEffect(ObjectManager.getPotionEffect((String)"fear").field_76415_H, this.getEffectDuration(5), 1));
                    continue;
                }
                possibleTarget.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 0));
            }
        }
        this.playAttackSound();
        this.setJustAttacked();
    }

    @Override
    public boolean canBeTempted() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return false;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_76456_a() == Potion.field_76440_q.field_76415_H) {
            return false;
        }
        if (ObjectManager.getPotionEffect("Fear") != null && potionEffect.func_76456_a() == ObjectManager.getPotionEffect((String)"Fear").field_76415_H) {
            return false;
        }
        super.func_70687_e(potionEffect);
        return true;
    }

    @Override
    public float getFallResistance() {
        return 10.0f;
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        return new EntityShade(this.field_70170_p);
    }

    @Override
    public boolean isBreedingItem(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isTamingItem(ItemStack itemstack) {
        return itemstack.func_77973_b() == ObjectManager.getItem("shadetreat");
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cookedmeat", testStack);
    }
}

