/*
 * Decompiled with CFR 0.152.
 */
package com.voidswrath.util;

import com.voidswrath.util.OS;
import java.io.File;

public class OSInfo {
    private static OS PLATFORM;

    public static OS getPlatform() {
        if (PLATFORM == null) {
            String str = System.getProperty("os.name").toLowerCase();
            PLATFORM = str.contains("win") ? OS.WINDOWS : (str.contains("mac") ? OS.MACOS : (str.contains("solaris") ? OS.SOLARIS : (str.contains("sunos") ? OS.SOLARIS : (str.contains("linux") ? OS.LINUX : (str.contains("unix") ? OS.LINUX : OS.UNKNOWN)))));
        }
        return PLATFORM;
    }

    public static File getWorkingDirectory(String installDir) {
        File localFile;
        System.getProperty("user.home", ".");
        String str1 = System.getProperty("user.home", ".");
        switch (OSInfo.getPlatform()) {
            case LINUX: 
            case SOLARIS: {
                localFile = new File(str1, String.valueOf('.') + installDir + File.separator);
                break;
            }
            case WINDOWS: {
                String str2 = System.getenv("APPDATA");
                String str3 = str2 != null ? str2 : str1;
                localFile = new File(str3, String.valueOf('.') + installDir + File.separator);
                break;
            }
            case MACOS: {
                localFile = new File(str1, "Library" + File.separator + "Application Support" + File.separator + installDir + File.separator);
                break;
            }
            default: {
                localFile = new File(str1, String.valueOf(installDir) + File.separator);
            }
        }
        if (!localFile.exists() && !localFile.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + localFile);
        }
        return localFile;
    }
}

