/*
 * Decompiled with CFR 0.152.
 */
package morph.client.core;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import ichun.client.render.RendererHelper;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import morph.api.Ability;
import morph.client.model.ModelMorph;
import morph.client.morph.MorphInfoClient;
import morph.client.render.RenderMorph;
import morph.client.render.RenderPlayerHand;
import morph.common.Morph;
import morph.common.ability.AbilityHandler;
import morph.common.ability.AbilityPotionEffect;
import morph.common.morph.MorphState;
import morph.common.packet.PacketGuiInput;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class TickHandlerClient {
    public long clock;
    public RenderMorph renderMorphInstance;
    public RenderPlayerHand renderHandInstance;
    public float playerRenderShadowSize = -1.0f;
    public HashMap<String, MorphInfoClient> playerMorphInfo = new HashMap();
    public LinkedHashMap<String, ArrayList<MorphState>> playerMorphCatMap = new LinkedHashMap();
    public float renderTick;
    public float playerHeight = 1.8f;
    public float ySize;
    public float eyeHeight;
    public boolean shiftedPosY;
    public boolean allowRender;
    public boolean forceRender;
    public boolean renderingMorph;
    public byte renderingPlayer;
    public boolean selectorShow;
    public int selectorTimer;
    public int selectorSelectedPrev;
    public int selectorSelected;
    public int selectorSelectedHoriPrev;
    public int selectorSelectedHori;
    public long systemTime;
    public int currentItem;
    public int scrollTimer;
    public int scrollTimerHori;
    public int abilityScroll;
    public boolean radialShow;
    public float radialPlayerYaw;
    public float radialPlayerPitch;
    public double radialDeltaX;
    public double radialDeltaY;
    public int radialTime;
    public ArrayList<MorphState> favouriteStates = new ArrayList();
    public final int selectorShowTime = 10;
    public final int scrollTime = 3;
    public static final ResourceLocation rlFavourite = new ResourceLocation("morph", "textures/gui/fav.png");
    public static final ResourceLocation rlSelected = new ResourceLocation("morph", "textures/gui/guiSelected.png");
    public static final ResourceLocation rlUnselected = new ResourceLocation("morph", "textures/gui/guiUnselected.png");
    public static final ResourceLocation rlUnselectedSide = new ResourceLocation("morph", "textures/gui/guiUnselectedSide.png");
    public static final ResourceLocation rlGuiInventory = new ResourceLocation("textures/gui/container/inventory.png");

    public TickHandlerClient() {
        this.renderMorphInstance = new RenderMorph(new ModelMorph(), 0.0f);
        this.renderMorphInstance.func_76976_a(RenderManager.field_78727_a);
        this.renderHandInstance = new RenderPlayerHand();
        this.renderHandInstance.func_76976_a(RenderManager.field_78727_a);
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            if (event.phase == TickEvent.Phase.START) {
                this.renderTick = event.renderTickTime;
                MorphInfoClient info1 = this.playerMorphInfo.get(mc.field_71439_g.func_70005_c_());
                if (info1 != null) {
                    float prog;
                    float f = prog = info1.morphProgress > 10 ? ((float)info1.morphProgress + this.renderTick) / 60.0f : 0.0f;
                    if (prog > 1.0f) {
                        prog = 1.0f;
                    }
                    prog = (float)Math.pow(prog, 2.0);
                    float prev = info1.prevState != null && !(info1.prevState.entInstance instanceof EntityPlayer) ? info1.prevState.entInstance.func_70047_e() : mc.field_71439_g.field_70129_M + mc.field_71439_g.getDefaultEyeHeight();
                    float next = info1.nextState != null && !(info1.nextState.entInstance instanceof EntityPlayer) ? info1.nextState.entInstance.func_70047_e() : mc.field_71439_g.field_70129_M + mc.field_71439_g.getDefaultEyeHeight();
                    this.ySize = mc.field_71439_g.field_70129_M - (prev + (next - prev) * prog) + mc.field_71439_g.getDefaultEyeHeight();
                    this.eyeHeight = mc.field_71439_g.eyeHeight;
                    mc.field_71439_g.field_70137_T -= (double)this.ySize;
                    mc.field_71439_g.field_70167_r -= (double)this.ySize;
                    mc.field_71439_g.field_70163_u -= (double)this.ySize;
                    mc.field_71439_g.eyeHeight = mc.field_71439_g.getDefaultEyeHeight();
                    this.shiftedPosY = true;
                }
                if (this.radialShow) {
                    Mouse.getDX();
                    Mouse.getDY();
                    mc.field_71417_B.field_74375_b = 0;
                    mc.field_71417_B.field_74377_a = 0;
                    mc.field_71451_h.field_70758_at = mc.field_71451_h.field_70759_as = this.radialPlayerYaw;
                    mc.field_71451_h.field_70126_B = mc.field_71451_h.field_70177_z = this.radialPlayerYaw;
                    mc.field_71451_h.field_70127_C = mc.field_71451_h.field_70125_A = this.radialPlayerPitch;
                }
            } else {
                MorphInfoClient info = this.playerMorphInfo.get(mc.field_71439_g.func_70005_c_());
                if (info != null) {
                    this.shiftedPosY = false;
                    mc.field_71439_g.field_70137_T += (double)this.ySize;
                    mc.field_71439_g.field_70167_r += (double)this.ySize;
                    mc.field_71439_g.field_70163_u += (double)this.ySize;
                    mc.field_71439_g.eyeHeight = this.eyeHeight;
                }
                float bossHealthScale = BossStatus.field_82828_a;
                int bossStatusBarTime = BossStatus.field_82826_b;
                String bossName = BossStatus.field_82827_c;
                boolean hasColorModifier = BossStatus.field_82825_d;
                if ((this.selectorTimer > 0 || this.selectorShow) && !mc.field_71474_y.field_74319_N) {
                    GL11.glPushMatrix();
                    float progress = (11.0f - ((float)this.selectorTimer + (1.0f - this.renderTick))) / 11.0f;
                    if (this.selectorShow) {
                        progress = 1.0f - progress;
                    }
                    if (this.selectorShow && this.selectorTimer == 0) {
                        progress = 0.0f;
                    }
                    progress = (float)Math.pow(progress, 2.0);
                    GL11.glTranslatef((float)(-52.0f * progress), (float)0.0f, (float)0.0f);
                    ScaledResolution reso = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
                    int gap = (reso.func_78328_b() - 210) / 2;
                    double size = 42.0;
                    double width1 = 0.0;
                    GL11.glPushMatrix();
                    int maxShowable = (int)Math.ceil((double)reso.func_78328_b() / size) + 2;
                    if (this.selectorSelected == 0 && this.selectorSelectedPrev > 0 || this.selectorSelectedPrev == 0 && this.selectorSelected > 0) {
                        maxShowable = 150;
                    }
                    float progressV = (3.0f - ((float)this.scrollTimer - this.renderTick)) / 3.0f;
                    if ((progressV = (float)Math.pow(progressV, 2.0)) > 1.0f) {
                        progressV = 1.0f;
                        this.selectorSelectedPrev = this.selectorSelected;
                    }
                    float progressH = (3.0f - ((float)this.scrollTimerHori - this.renderTick)) / 3.0f;
                    if ((progressH = (float)Math.pow(progressH, 2.0)) > 1.0f) {
                        progressH = 1.0f;
                        this.selectorSelectedHoriPrev = this.selectorSelectedHori;
                    }
                    GL11.glTranslatef((float)0.0f, (float)((float)(this.selectorSelected - this.selectorSelectedPrev) * 42.0f * (1.0f - progressV)), (float)0.0f);
                    GL11.glDisable((int)2929);
                    GL11.glDepthMask((boolean)false);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3008);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    int i = 0;
                    Iterator<Map.Entry<String, ArrayList<MorphState>>> ite = this.playerMorphCatMap.entrySet().iterator();
                    while (ite.hasNext()) {
                        Map.Entry<String, ArrayList<MorphState>> e = ite.next();
                        if (i > this.selectorSelected + maxShowable || i < this.selectorSelected - maxShowable) {
                            ++i;
                            continue;
                        }
                        double height1 = (double)gap + size * (double)(i - this.selectorSelected);
                        ArrayList<MorphState> states = e.getValue();
                        if (states == null || states.isEmpty()) {
                            ite.remove();
                            ++i;
                            break;
                        }
                        Tessellator tessellator = Tessellator.field_78398_a;
                        if (i == this.selectorSelected) {
                            if (this.selectorSelectedHori < 0) {
                                this.selectorSelectedHori = states.size() - 1;
                            }
                            if (this.selectorSelectedHori >= states.size()) {
                                this.selectorSelectedHori = 0;
                            }
                            boolean newSlide = false;
                            if (progressV < 1.0f && this.selectorSelectedPrev != this.selectorSelected) {
                                this.selectorSelectedHoriPrev = states.size() - 1;
                                this.selectorSelectedHori = 0;
                                newSlide = true;
                            }
                            if (!this.selectorShow) {
                                this.selectorSelectedHori = states.size() - 1;
                                newSlide = true;
                            } else if (progress > 0.0f) {
                                this.selectorSelectedHoriPrev = states.size() - 1;
                                newSlide = true;
                            }
                            for (int j = 0; j < states.size(); ++j) {
                                GL11.glPushMatrix();
                                GL11.glTranslated((double)(newSlide && j == 0 ? 0.0 : (double)((float)(this.selectorSelectedHori - this.selectorSelectedHoriPrev) * 42.0f * (1.0f - progressH))), (double)0.0, (double)0.0);
                                mc.func_110434_K().func_110577_a(states.size() == 1 || j == states.size() - 1 ? rlUnselected : rlUnselectedSide);
                                double dist = size * (double)(j - this.selectorSelectedHori);
                                tessellator.func_78382_b();
                                tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                                tessellator.func_78374_a(width1 + dist, height1 + size, -90.0 + (double)j, 0.0, 1.0);
                                tessellator.func_78374_a(width1 + dist + size, height1 + size, -90.0 + (double)j, 1.0, 1.0);
                                tessellator.func_78374_a(width1 + dist + size, height1, -90.0 + (double)j, 1.0, 0.0);
                                tessellator.func_78374_a(width1 + dist, height1, -90.0 + (double)j, 0.0, 0.0);
                                tessellator.func_78381_a();
                                GL11.glPopMatrix();
                            }
                        } else {
                            mc.func_110434_K().func_110577_a(rlUnselected);
                            tessellator.func_78382_b();
                            tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                            tessellator.func_78374_a(width1, height1 + size, -90.0, 0.0, 1.0);
                            tessellator.func_78374_a(width1 + size, height1 + size, -90.0, 1.0, 1.0);
                            tessellator.func_78374_a(width1 + size, height1, -90.0, 1.0, 0.0);
                            tessellator.func_78374_a(width1, height1, -90.0, 0.0, 0.0);
                            tessellator.func_78381_a();
                        }
                        ++i;
                    }
                    GL11.glDisable((int)3042);
                    int height1 = gap;
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)2929);
                    GL11.glEnable((int)3008);
                    gap += 36;
                    i = 0;
                    for (Map.Entry<String, ArrayList<MorphState>> e : this.playerMorphCatMap.entrySet()) {
                        if (i > this.selectorSelected + maxShowable || i < this.selectorSelected - maxShowable) {
                            ++i;
                            continue;
                        }
                        height1 = gap + (int)size * (i - this.selectorSelected);
                        ArrayList<MorphState> states = e.getValue();
                        if (i == this.selectorSelected) {
                            boolean newSlide = false;
                            if (progressV < 1.0f && this.selectorSelectedPrev != this.selectorSelected) {
                                this.selectorSelectedHoriPrev = states.size() - 1;
                                this.selectorSelectedHori = 0;
                                newSlide = true;
                            }
                            if (!this.selectorShow) {
                                this.selectorSelectedHori = states.size() - 1;
                                newSlide = true;
                            }
                            for (int j = 0; j < states.size(); ++j) {
                                float entSize;
                                MorphState state = states.get(j);
                                GL11.glPushMatrix();
                                GL11.glTranslated((double)(newSlide && j == 0 ? 0.0 : (double)((float)(this.selectorSelectedHori - this.selectorSelectedHoriPrev) * 42.0f * (1.0f - progressH))), (double)0.0, (double)0.0);
                                double dist = size * (double)(j - this.selectorSelectedHori);
                                GL11.glTranslated((double)dist, (double)0.0, (double)0.0);
                                float f = entSize = state.entInstance.field_70130_N > state.entInstance.field_70131_O ? state.entInstance.field_70130_N : state.entInstance.field_70131_O;
                                float prog = j - this.selectorSelectedHori == 0 ? (!this.selectorShow ? (float)this.scrollTimerHori - this.renderTick : 3.0f - (float)this.scrollTimerHori + this.renderTick) / 3.0f : 0.0f;
                                prog = MathHelper.func_76131_a((float)prog, (float)0.0f, (float)1.0f);
                                float scaleMag = (2.5f + (entSize - 2.5f) * prog) / entSize;
                                this.drawEntityOnScreen(state, state.entInstance, 20, height1, entSize > 2.5f ? 16.0f * scaleMag : 16.0f, 2.0f, 2.0f, this.renderTick, true, j == states.size() - 1);
                                GL11.glPopMatrix();
                            }
                        } else {
                            float entSize;
                            MorphState state = states.get(0);
                            float f = entSize = state.entInstance.field_70130_N > state.entInstance.field_70131_O ? state.entInstance.field_70130_N : state.entInstance.field_70131_O;
                            float prog = this.selectorSelected == i ? (!this.selectorShow ? (float)this.scrollTimer - this.renderTick : 3.0f - (float)this.scrollTimer + this.renderTick) / 3.0f : 0.0f;
                            prog = MathHelper.func_76131_a((float)prog, (float)0.0f, (float)1.0f);
                            float scaleMag = 2.5f / entSize;
                            this.drawEntityOnScreen(state, state.entInstance, 20, height1, entSize > 2.5f ? 16.0f * scaleMag : 16.0f, 2.0f, 2.0f, this.renderTick, this.selectorSelected == i, true);
                        }
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)20.0f);
                        ++i;
                    }
                    GL11.glPopMatrix();
                    if (this.selectorShow) {
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)771);
                        height1 = gap -= 36;
                        mc.func_110434_K().func_110577_a(rlSelected);
                        Tessellator tessellator = Tessellator.field_78398_a;
                        tessellator.func_78382_b();
                        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                        tessellator.func_78374_a(width1, (double)height1 + size, -90.0, 0.0, 1.0);
                        tessellator.func_78374_a(width1 + size, (double)height1 + size, -90.0, 1.0, 1.0);
                        tessellator.func_78374_a(width1 + size, (double)height1, -90.0, 1.0, 0.0);
                        tessellator.func_78374_a(width1, (double)height1, -90.0, 0.0, 0.0);
                        tessellator.func_78381_a();
                        GL11.glDisable((int)3042);
                    }
                    GL11.glPopMatrix();
                }
                if (this.radialShow && !mc.field_71474_y.field_74319_N) {
                    double mag = Math.sqrt(Morph.proxy.tickHandlerClient.radialDeltaX * Morph.proxy.tickHandlerClient.radialDeltaX + Morph.proxy.tickHandlerClient.radialDeltaY * Morph.proxy.tickHandlerClient.radialDeltaY);
                    double magAcceptance = 0.8;
                    ScaledResolution reso = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
                    float prog = (3.0f - (float)this.radialTime + this.renderTick) / 3.0f;
                    if (prog > 1.0f) {
                        prog = 1.0f;
                    }
                    float rad = (mag > magAcceptance ? 0.85f : 0.82f) * prog;
                    int radius = 80;
                    radius = (int)((double)radius * Math.pow(prog, 0.5));
                    if (!mc.field_71474_y.field_74319_N) {
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)771);
                        GL11.glMatrixMode((int)5888);
                        GL11.glPushMatrix();
                        GL11.glLoadIdentity();
                        GL11.glMatrixMode((int)5889);
                        GL11.glPushMatrix();
                        GL11.glLoadIdentity();
                        int NUM_PIZZA_SLICES = 100;
                        double zLev = 0.05;
                        GL11.glDisable((int)3553);
                        int stencilBit = MinecraftForgeClient.reserveStencilBit();
                        if (stencilBit >= 0) {
                            int i;
                            GL11.glEnable((int)2960);
                            GL11.glDepthMask((boolean)false);
                            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                            int stencilMask = 1 << stencilBit;
                            GL11.glStencilMask((int)stencilMask);
                            GL11.glStencilFunc((int)519, (int)stencilMask, (int)stencilMask);
                            GL11.glStencilOp((int)7680, (int)7680, (int)7681);
                            GL11.glClear((int)1024);
                            rad = (mag > magAcceptance ? 0.85f : 0.82f) * prog * (257.0f / (float)reso.func_78328_b());
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            GL11.glBegin((int)6);
                            GL11.glVertex3d((double)0.0, (double)0.0, (double)zLev);
                            for (i = 0; i <= NUM_PIZZA_SLICES; ++i) {
                                double angle = Math.PI * 2 * (double)i / (double)NUM_PIZZA_SLICES;
                                GL11.glVertex3d((double)(Math.cos(angle) * reso.func_78324_d() / reso.func_78327_c() * (double)rad), (double)(Math.sin(angle) * (double)rad), (double)zLev);
                            }
                            GL11.glEnd();
                            GL11.glStencilFunc((int)519, (int)0, (int)stencilMask);
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            rad = 0.44f * prog * (257.0f / (float)reso.func_78328_b());
                            GL11.glBegin((int)6);
                            GL11.glVertex3d((double)0.0, (double)0.0, (double)zLev);
                            for (i = 0; i <= NUM_PIZZA_SLICES; ++i) {
                                double angle = Math.PI * 2 * (double)i / (double)NUM_PIZZA_SLICES;
                                GL11.glVertex3d((double)(Math.cos(angle) * reso.func_78324_d() / reso.func_78327_c() * (double)rad), (double)(Math.sin(angle) * (double)rad), (double)zLev);
                            }
                            GL11.glEnd();
                            GL11.glStencilMask((int)0);
                            GL11.glStencilFunc((int)514, (int)stencilMask, (int)stencilMask);
                            GL11.glDepthMask((boolean)true);
                            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                        }
                        rad = (mag > magAcceptance ? 0.85f : 0.82f) * prog * (257.0f / (float)reso.func_78328_b());
                        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)(mag > magAcceptance ? 0.6f : 0.4f));
                        GL11.glBegin((int)6);
                        GL11.glVertex3d((double)0.0, (double)0.0, (double)zLev);
                        for (int i = 0; i <= NUM_PIZZA_SLICES; ++i) {
                            double angle = Math.PI * 2 * (double)i / (double)NUM_PIZZA_SLICES;
                            GL11.glVertex3d((double)(Math.cos(angle) * reso.func_78324_d() / reso.func_78327_c() * (double)rad), (double)(Math.sin(angle) * (double)rad), (double)zLev);
                        }
                        GL11.glEnd();
                        if (stencilBit >= 0) {
                            GL11.glDisable((int)2960);
                        }
                        MinecraftForgeClient.releaseStencilBit((int)stencilBit);
                        GL11.glEnable((int)3553);
                        GL11.glPopMatrix();
                        GL11.glMatrixMode((int)5888);
                        GL11.glPopMatrix();
                    }
                    GL11.glPushMatrix();
                    int showAb = Morph.config.getSessionInt("showAbilitiesInGui");
                    Morph.config.updateSession("showAbilitiesInGui", (Object)0);
                    double radialAngle = -720.0;
                    if (mag > magAcceptance) {
                        double aSin = Math.toDegrees(Math.asin(Morph.proxy.tickHandlerClient.radialDeltaX));
                        if (Morph.proxy.tickHandlerClient.radialDeltaY >= 0.0 && Morph.proxy.tickHandlerClient.radialDeltaX >= 0.0) {
                            radialAngle = aSin;
                        } else if (Morph.proxy.tickHandlerClient.radialDeltaY < 0.0 && Morph.proxy.tickHandlerClient.radialDeltaX >= 0.0) {
                            radialAngle = 90.0 + (90.0 - aSin);
                        } else if (Morph.proxy.tickHandlerClient.radialDeltaY < 0.0 && Morph.proxy.tickHandlerClient.radialDeltaX < 0.0) {
                            radialAngle = 180.0 - aSin;
                        } else if (Morph.proxy.tickHandlerClient.radialDeltaY >= 0.0 && Morph.proxy.tickHandlerClient.radialDeltaX < 0.0) {
                            radialAngle = 270.0 + (90.0 + aSin);
                        }
                    }
                    if (mag > 0.9999999) {
                        mag = Math.round(mag);
                    }
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)2929);
                    GL11.glEnable((int)3008);
                    for (int i = 0; i < this.favouriteStates.size(); ++i) {
                        float entSize;
                        double angle = Math.PI * 2 * (double)i / (double)this.favouriteStates.size();
                        angle -= Math.toRadians(90.0);
                        float leeway = 360.0f / (float)this.favouriteStates.size();
                        boolean selected = false;
                        if (mag > magAcceptance * 0.75 && (i == 0 && (radialAngle < (double)(leeway / 2.0f) && radialAngle >= 0.0 || radialAngle > (double)(360.0f - leeway / 2.0f)) || i != 0 && radialAngle < (double)(leeway * (float)i + leeway / 2.0f) && radialAngle > (double)(leeway * (float)i - leeway / 2.0f))) {
                            selected = true;
                        }
                        this.favouriteStates.get((int)i).isFavourite = false;
                        float f = entSize = this.favouriteStates.get((int)i).entInstance.field_70130_N > this.favouriteStates.get((int)i).entInstance.field_70131_O ? this.favouriteStates.get((int)i).entInstance.field_70130_N : this.favouriteStates.get((int)i).entInstance.field_70131_O;
                        float scaleMag = entSize > 2.5f ? (float)((2.5 + (double)(entSize - 2.5f) * (mag > magAcceptance && selected ? (mag - magAcceptance) / (1.0 - magAcceptance) : 0.0)) / (double)entSize) : 1.0f;
                        this.drawEntityOnScreen(this.favouriteStates.get(i), this.favouriteStates.get((int)i).entInstance, reso.func_78326_a() / 2 + (int)((double)radius * Math.cos(angle)), (reso.func_78328_b() + 32) / 2 + (int)((double)radius * Math.sin(angle)), 16.0f * prog * scaleMag + (float)(selected ? 6.0 * mag : 0.0), 2.0f, 2.0f, this.renderTick, selected, true);
                        this.favouriteStates.get((int)i).isFavourite = true;
                    }
                    Morph.config.updateSession("showAbilitiesInGui", (Object)showAb);
                    GL11.glPopMatrix();
                }
                BossStatus.field_82828_a = bossHealthScale;
                BossStatus.field_82826_b = bossStatusBarTime;
                BossStatus.field_82827_c = bossName;
                BossStatus.field_82825_d = hasColorModifier;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                for (Map.Entry<String, MorphInfoClient> e : this.playerMorphInfo.entrySet()) {
                    MorphInfoClient morphInfo = e.getValue();
                    for (Ability ability : morphInfo.morphAbilities) {
                        if (ability.inactive) continue;
                        ability.postRender();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e != null) {
            Minecraft mc = Minecraft.func_71410_x();
            WorldClient world = mc.field_71441_e;
            ++this.abilityScroll;
            if (mc.field_71462_r != null) {
                if (this.selectorShow) {
                    if (mc.field_71462_r instanceof GuiIngameMenu) {
                        mc.func_147108_a(null);
                    }
                    this.selectorShow = false;
                    this.selectorTimer = 10 - this.selectorTimer;
                    this.scrollTimerHori = 3;
                }
                if (this.radialShow) {
                    this.radialShow = false;
                }
            }
            if (this.selectorTimer > 0) {
                --this.selectorTimer;
                if (this.selectorTimer == 0 && !this.selectorShow) {
                    this.selectorSelected = 0;
                    MorphInfoClient info = this.playerMorphInfo.get(mc.field_71439_g.func_70005_c_());
                    if (info != null) {
                        MorphState state = info.nextState;
                        String entName = state.entInstance.func_70005_c_();
                        int i = 0;
                        block2: for (Map.Entry<String, ArrayList<MorphState>> e : this.playerMorphCatMap.entrySet()) {
                            if (e.getKey().equalsIgnoreCase(entName)) {
                                this.selectorSelected = i;
                                ArrayList<MorphState> states = e.getValue();
                                for (int j = 0; j < states.size(); ++j) {
                                    if (!states.get((int)j).identifier.equalsIgnoreCase(state.identifier)) continue;
                                    this.selectorSelectedHori = j;
                                    break block2;
                                }
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
            if (this.scrollTimer > 0) {
                --this.scrollTimer;
            }
            if (this.scrollTimerHori > 0) {
                --this.scrollTimerHori;
            }
            if (this.radialTime > 0) {
                --this.radialTime;
            }
            if (this.clock != world.func_72820_D() || !world.func_82736_K().func_82766_b("doDaylightCycle")) {
                this.clock = world.func_72820_D();
                for (Map.Entry<String, MorphInfoClient> e : this.playerMorphInfo.entrySet()) {
                    MorphInfoClient info = e.getValue();
                    if (info.getMorphing()) {
                        ++info.morphProgress;
                        if (info.morphProgress > 80) {
                            info.morphProgress = 80;
                            info.setMorphing(false);
                            if (info.player != null) {
                                info.player.func_70105_a(info.nextState.entInstance.field_70130_N, info.nextState.entInstance.field_70131_O);
                                info.player.func_70107_b(info.player.field_70165_t, info.player.field_70163_u, info.player.field_70161_v);
                                info.player.eyeHeight = info.nextState.entInstance instanceof EntityPlayer ? (((EntityPlayer)info.nextState.entInstance).func_70005_c_().equalsIgnoreCase(mc.field_71439_g.func_70005_c_()) || info.player == mc.field_71439_g ? mc.field_71439_g.getDefaultEyeHeight() : ((EntityPlayer)info.nextState.entInstance).getDefaultEyeHeight()) : info.nextState.entInstance.func_70047_e() - info.player.field_70129_M;
                                ArrayList<Ability> newAbilities = AbilityHandler.getEntityAbilities(info.nextState.entInstance.getClass());
                                ArrayList oldAbilities = info.morphAbilities;
                                info.morphAbilities = new ArrayList();
                                for (Ability ability : newAbilities) {
                                    try {
                                        Ability clone = ability.clone();
                                        clone.setParent((EntityLivingBase)info.player);
                                        info.morphAbilities.add(clone);
                                    }
                                    catch (Exception clone) {}
                                }
                                for (Ability ability : oldAbilities) {
                                    if (ability.inactive) continue;
                                    boolean isRemoved = true;
                                    for (Ability newAbility : info.morphAbilities) {
                                        if (!newAbility.getType().equalsIgnoreCase(ability.getType())) continue;
                                        isRemoved = false;
                                        break;
                                    }
                                    if (!isRemoved || ability.getParent() == null) continue;
                                    ability.kill();
                                }
                            }
                        } else if (info.prevState != null && info.player != null) {
                            float prevEyeHeight;
                            info.player.func_70105_a(info.prevState.entInstance.field_70130_N + (info.nextState.entInstance.field_70130_N - info.prevState.entInstance.field_70130_N) * ((float)info.morphProgress / 80.0f), info.prevState.entInstance.field_70131_O + (info.nextState.entInstance.field_70131_O - info.prevState.entInstance.field_70131_O) * ((float)info.morphProgress / 80.0f));
                            info.player.func_70107_b(info.player.field_70165_t, info.player.field_70163_u, info.player.field_70161_v);
                            float f = info.prevState.entInstance instanceof EntityPlayer ? (((EntityPlayer)info.prevState.entInstance).func_70005_c_().equalsIgnoreCase(mc.field_71439_g.func_70005_c_()) || info.player == mc.field_71439_g ? mc.field_71439_g.getDefaultEyeHeight() : ((EntityPlayer)info.prevState.entInstance).getDefaultEyeHeight()) : (prevEyeHeight = info.prevState.entInstance.func_70047_e() - info.player.field_70129_M);
                            float nextEyeHeight = info.nextState.entInstance instanceof EntityPlayer ? (((EntityPlayer)info.nextState.entInstance).func_70005_c_().equalsIgnoreCase(mc.field_71439_g.func_70005_c_()) || info.player == mc.field_71439_g ? mc.field_71439_g.getDefaultEyeHeight() : ((EntityPlayer)info.nextState.entInstance).getDefaultEyeHeight()) : info.nextState.entInstance.func_70047_e() - info.player.field_70129_M;
                            info.player.eyeHeight = prevEyeHeight + (nextEyeHeight - prevEyeHeight) * ((float)info.morphProgress / 80.0f);
                        }
                    } else if (info.player != null && Morph.config.getSessionInt("forceSizeWhenMorphed") == 1) {
                        info.player.func_70105_a(info.nextState.entInstance.field_70130_N, info.nextState.entInstance.field_70131_O);
                        info.player.func_70107_b(info.player.field_70165_t, info.player.field_70163_u, info.player.field_70161_v);
                        float f = info.nextState.entInstance instanceof EntityPlayer ? (((EntityPlayer)info.nextState.entInstance).func_70005_c_().equalsIgnoreCase(mc.field_71439_g.func_70005_c_()) || info.player == mc.field_71439_g ? mc.field_71439_g.getDefaultEyeHeight() : ((EntityPlayer)info.nextState.entInstance).getDefaultEyeHeight()) : (info.player.eyeHeight = info.nextState.entInstance.func_70047_e() - info.player.field_70129_M);
                    }
                    if (!(info.player == null || info.player.field_71093_bK == mc.field_71439_g.field_71093_bK && info.player.func_70089_S() && world.field_73010_i.contains(info.player) && !info.player.func_70608_bn() && info.player.func_71060_bI() <= 0)) {
                        info.player = null;
                    }
                    if (info.player == null) {
                        info.player = world.func_72924_a(e.getKey());
                        if (info.player != null) {
                            if (!info.getMorphing()) {
                                info.player.func_70105_a(info.nextState.entInstance.field_70130_N, info.nextState.entInstance.field_70131_O);
                                info.player.func_70107_b(info.player.field_70165_t, info.player.field_70163_u, info.player.field_70161_v);
                                info.player.eyeHeight = info.nextState.entInstance instanceof EntityPlayer ? (((EntityPlayer)info.nextState.entInstance).func_70005_c_().equalsIgnoreCase(mc.field_71439_g.func_70005_c_()) || info.player == mc.field_71439_g ? mc.field_71439_g.getDefaultEyeHeight() : ((EntityPlayer)info.nextState.entInstance).getDefaultEyeHeight()) : info.nextState.entInstance.func_70047_e() - info.player.field_70129_M;
                                double nextMaxHealth = MathHelper.func_151237_a((double)info.nextState.entInstance.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b(), (double)0.0, (double)20.0) + info.healthOffset;
                                if (nextMaxHealth < 1.0) {
                                    nextMaxHealth = 1.0;
                                }
                                if (nextMaxHealth != info.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b()) {
                                    info.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(nextMaxHealth);
                                    if ((double)info.player.func_110143_aJ() < nextMaxHealth) {
                                        info.player.func_70606_j((float)nextMaxHealth);
                                    }
                                }
                            }
                            for (Ability ability : info.morphAbilities) {
                                ability.setParent((EntityLivingBase)info.player);
                            }
                        }
                    }
                    if (info.prevState.entInstance == null) {
                        info.prevState.entInstance = info.player;
                    }
                    if (info.player != null) {
                        for (Ability ability : info.morphAbilities) {
                            if (ability.inactive || ability.getParent() == null) continue;
                            ability.tick();
                        }
                        if (info.prevState.entInstance != null && info.nextState.entInstance != null) {
                            info.player.field_70158_ak = true;
                            if (info.morphProgress < 10) {
                                if (info.prevState.entInstance != mc.field_71439_g) {
                                    info.prevState.entInstance.field_70137_T -= (double)info.player.field_70129_M;
                                    info.prevState.entInstance.field_70167_r -= (double)info.player.field_70129_M;
                                    info.prevState.entInstance.field_70163_u -= (double)info.player.field_70129_M;
                                    info.prevState.entInstance.func_70107_b(info.prevState.entInstance.field_70165_t, info.prevState.entInstance.field_70163_u, info.prevState.entInstance.field_70161_v);
                                    info.prevState.entInstance.func_70071_h_();
                                    info.prevState.entInstance.field_70137_T += (double)info.player.field_70129_M;
                                    info.prevState.entInstance.field_70167_r += (double)info.player.field_70129_M;
                                    info.prevState.entInstance.field_70163_u += (double)info.player.field_70129_M;
                                    info.prevState.entInstance.func_70107_b(info.prevState.entInstance.field_70165_t, info.prevState.entInstance.field_70163_u, info.prevState.entInstance.field_70161_v);
                                }
                            } else if (info.morphProgress > 70 && info.nextState.entInstance != mc.field_71439_g) {
                                if (!(info.nextState.entInstance instanceof EntityPlayer) && !(RenderManager.field_78727_a.func_78713_a((Entity)info.nextState.entInstance) instanceof RenderBiped)) {
                                    info.nextState.entInstance.field_70129_M = 0.0f;
                                }
                                info.nextState.entInstance.field_70137_T -= (double)info.player.field_70129_M;
                                info.nextState.entInstance.field_70167_r -= (double)info.player.field_70129_M;
                                info.nextState.entInstance.field_70163_u -= (double)info.player.field_70129_M;
                                info.nextState.entInstance.func_70107_b(info.nextState.entInstance.field_70165_t, info.nextState.entInstance.field_70163_u, info.nextState.entInstance.field_70161_v);
                                info.nextState.entInstance.func_70071_h_();
                                info.nextState.entInstance.field_70137_T += (double)info.player.field_70129_M;
                                info.nextState.entInstance.field_70167_r += (double)info.player.field_70129_M;
                                info.nextState.entInstance.field_70163_u += (double)info.player.field_70129_M;
                                info.nextState.entInstance.func_70107_b(info.nextState.entInstance.field_70165_t, info.nextState.entInstance.field_70163_u, info.nextState.entInstance.field_70161_v);
                            }
                            info.prevState.entInstance.field_70758_at = info.nextState.entInstance.field_70758_at = info.player.field_70758_at;
                            info.prevState.entInstance.field_70126_B = info.nextState.entInstance.field_70126_B = info.player.field_70126_B;
                            info.prevState.entInstance.field_70127_C = info.nextState.entInstance.field_70127_C = info.player.field_70127_C;
                            info.prevState.entInstance.field_70760_ar = info.nextState.entInstance.field_70760_ar = info.player.field_70760_ar;
                            info.prevState.entInstance.field_70722_aY = info.nextState.entInstance.field_70722_aY = info.player.field_70722_aY;
                            info.prevState.entInstance.field_70732_aI = info.nextState.entInstance.field_70732_aI = info.player.field_70732_aI;
                            info.prevState.entInstance.field_70169_q = info.nextState.entInstance.field_70169_q = info.player.field_70169_q;
                            info.prevState.entInstance.field_70167_r = info.nextState.entInstance.field_70167_r = info.player.field_70167_r;
                            info.prevState.entInstance.field_70166_s = info.nextState.entInstance.field_70166_s = info.player.field_70166_s;
                            info.prevState.entInstance.field_70759_as = info.nextState.entInstance.field_70759_as = info.player.field_70759_as;
                            info.prevState.entInstance.field_70177_z = info.nextState.entInstance.field_70177_z = info.player.field_70177_z;
                            info.prevState.entInstance.field_70125_A = info.nextState.entInstance.field_70125_A = info.player.field_70125_A;
                            info.prevState.entInstance.field_70761_aq = info.nextState.entInstance.field_70761_aq = info.player.field_70761_aq;
                            info.prevState.entInstance.field_70721_aZ = info.nextState.entInstance.field_70721_aZ = info.player.field_70721_aZ;
                            info.prevState.entInstance.field_70733_aJ = info.nextState.entInstance.field_70733_aJ = info.player.field_70733_aJ;
                            info.prevState.entInstance.field_70754_ba = info.nextState.entInstance.field_70754_ba = info.player.field_70754_ba;
                            info.prevState.entInstance.field_70165_t = info.nextState.entInstance.field_70165_t = info.player.field_70165_t;
                            info.prevState.entInstance.field_70163_u = info.nextState.entInstance.field_70163_u = info.player.field_70163_u;
                            info.prevState.entInstance.field_70161_v = info.nextState.entInstance.field_70161_v = info.player.field_70161_v;
                            info.prevState.entInstance.field_70159_w = info.nextState.entInstance.field_70159_w = info.player.field_70159_w;
                            info.prevState.entInstance.field_70181_x = info.nextState.entInstance.field_70181_x = info.player.field_70181_x;
                            info.prevState.entInstance.field_70179_y = info.nextState.entInstance.field_70179_y = info.player.field_70179_y;
                            info.prevState.entInstance.field_70173_aa = info.nextState.entInstance.field_70173_aa = info.player.field_70173_aa;
                            info.prevState.entInstance.field_70160_al = info.nextState.entInstance.field_70160_al = info.player.field_70160_al;
                            info.prevState.entInstance.field_70702_br = info.nextState.entInstance.field_70702_br = info.player.field_70702_br;
                            info.prevState.entInstance.field_70701_bs = info.nextState.entInstance.field_70701_bs = info.player.field_70701_bs;
                            info.prevState.entInstance.field_71093_bK = info.nextState.entInstance.field_71093_bK = info.player.field_71093_bK;
                            info.prevState.entInstance.field_70170_p = info.nextState.entInstance.field_70170_p = info.player.field_70170_p;
                            info.prevState.entInstance.field_70154_o = info.nextState.entInstance.field_70154_o = info.player.field_70154_o;
                            info.prevState.entInstance.field_70737_aN = info.nextState.entInstance.field_70737_aN = info.player.field_70737_aN;
                            info.prevState.entInstance.field_70725_aQ = info.nextState.entInstance.field_70725_aQ = info.player.field_70725_aQ;
                            info.prevState.entInstance.field_82175_bq = info.nextState.entInstance.field_82175_bq = info.player.field_82175_bq;
                            boolean prevOnGround = info.nextState.entInstance.field_70122_E;
                            info.prevState.entInstance.field_70122_E = info.nextState.entInstance.field_70122_E = info.player.field_70122_E;
                            if (info.player != mc.field_71439_g) {
                                info.nextState.entInstance.field_70145_X = false;
                                info.nextState.entInstance.field_70121_D.func_72328_c(info.player.field_70121_D);
                                info.nextState.entInstance.func_70091_d(0.0, -0.01, 0.0);
                                info.prevState.entInstance.field_70167_r = info.nextState.entInstance.field_70167_r = info.player.field_70167_r;
                            }
                            info.prevState.entInstance.field_70145_X = info.nextState.entInstance.field_70145_X = info.player.field_70145_X;
                            info.prevState.entInstance.func_70095_a(info.player.func_70093_af());
                            info.nextState.entInstance.func_70095_a(info.player.func_70093_af());
                            info.prevState.entInstance.func_70031_b(info.player.func_70051_ag());
                            info.nextState.entInstance.func_70031_b(info.player.func_70051_ag());
                            info.prevState.entInstance.func_82142_c(info.player.func_82150_aj());
                            info.nextState.entInstance.func_82142_c(info.player.func_82150_aj());
                            info.prevState.entInstance.func_70606_j(info.prevState.entInstance.func_110138_aP() * (info.player.func_110143_aJ() / info.player.func_110138_aP()));
                            info.nextState.entInstance.func_70606_j(info.nextState.entInstance.func_110138_aP() * (info.player.func_110143_aJ() / info.player.func_110138_aP()));
                            if (!(info.nextState.entInstance instanceof EntityPlayer) && !(RenderManager.field_78727_a.func_78713_a((Entity)info.nextState.entInstance) instanceof RenderBiped)) {
                                info.nextState.entInstance.field_70129_M = info.player.field_70129_M;
                            }
                            if (prevOnGround && !info.nextState.entInstance.field_70122_E && info.nextState.entInstance instanceof EntitySlime) {
                                ((EntitySlime)info.nextState.entInstance).field_70813_a = 0.6f;
                            }
                            if (info.nextState.entInstance instanceof EntityDragon) {
                                info.nextState.entInstance.field_70126_B += 180.0f;
                                info.nextState.entInstance.field_70177_z += 180.0f;
                                ((EntityDragon)info.nextState.entInstance).field_70995_bG = info.player.field_70725_aQ;
                            }
                            for (int i = 0; i < 5; ++i) {
                                if (!(info.nextState.entInstance.func_71124_b(i) == null && info.player.func_71124_b(i) != null || info.nextState.entInstance.func_71124_b(i) != null && info.player.func_71124_b(i) == null) && (info.nextState.entInstance.func_71124_b(i) == null || info.player.func_71124_b(i) == null || info.nextState.entInstance.func_71124_b(i).func_77969_a(info.player.func_71124_b(i)))) continue;
                                info.nextState.entInstance.func_70062_b(i, info.player.func_71124_b(i) != null ? info.player.func_71124_b(i).func_77946_l() : null);
                            }
                            if (info.nextState.entInstance instanceof EntityPlayer && ((EntityPlayer)info.nextState.entInstance).func_71011_bu() != info.player.func_71011_bu()) {
                                ((EntityPlayer)info.nextState.entInstance).func_71008_a(info.player.func_71011_bu() == null ? null : info.player.func_71011_bu().func_77946_l(), info.player.func_71052_bv());
                            }
                        }
                        if (info.flying && info.firstUpdate) {
                            info.player.field_71075_bZ.field_75100_b = true;
                            info.player.field_71075_bZ.field_75101_c = true;
                            info.player.func_71016_p();
                        }
                    }
                    info.firstUpdate = false;
                }
            }
            if (Morph.config.getSessionInt("allowMorphSelection") == 0 && this.selectorShow) {
                this.selectorShow = false;
                this.selectorTimer = 0;
            }
        }
    }

    public void drawEntityOnScreen(MorphState state, EntityLivingBase ent, int posX, int posY, float scale, float par4, float par5, float renderTick, boolean selected, boolean text) {
        this.forceRender = true;
        if (ent != null) {
            boolean hideGui = Minecraft.func_71410_x().field_71474_y.field_74319_N;
            Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
            GL11.glEnable((int)2903);
            GL11.glPushMatrix();
            GL11.glDisable((int)3008);
            GL11.glTranslatef((float)posX, (float)posY, (float)50.0f);
            GL11.glScalef((float)(-scale), (float)scale, (float)scale);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float f2 = ent.field_70761_aq;
            float f3 = ent.field_70177_z;
            float f4 = ent.field_70125_A;
            float f5 = ent.field_70759_as;
            GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-((float)Math.atan(par5 / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            ent.field_70761_aq = (float)Math.atan(par4 / 40.0f) * 20.0f;
            ent.field_70177_z = (float)Math.atan(par4 / 40.0f) * 40.0f;
            ent.field_70125_A = -((float)Math.atan(par5 / 40.0f)) * 20.0f;
            ent.field_70759_as = ent.field_70761_aq;
            GL11.glTranslatef((float)0.0f, (float)ent.field_70129_M, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (ent instanceof EntityDragon) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            float viewY = RenderManager.field_78727_a.field_78735_i;
            RenderManager.field_78727_a.field_78735_i = 180.0f;
            RenderManager.field_78727_a.func_147940_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f);
            if (ent instanceof EntityDragon) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)-0.22f, (float)0.0f);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)204.0f, (float)204.0f);
            Tessellator.field_78398_a.func_78380_c(240);
            RenderManager.field_78727_a.field_78735_i = viewY;
            ent.field_70761_aq = f2;
            ent.field_70177_z = f3;
            ent.field_70125_A = f4;
            ent.field_70759_as = f5;
            GL11.glPopMatrix();
            RenderHelper.func_74518_a();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)posX, (float)posY, (float)50.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            MorphInfoClient info = this.playerMorphInfo.get(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
            if (text) {
                if (this.radialShow) {
                    GL11.glPushMatrix();
                    float scaleee = 0.75f;
                    GL11.glScalef((float)scaleee, (float)scaleee, (float)scaleee);
                    String name = (selected ? EnumChatFormatting.YELLOW : (info != null && info.nextState.identifier.equalsIgnoreCase(state.identifier) || info == null && state.playerMorph.equalsIgnoreCase(Minecraft.func_71410_x().field_71439_g.func_70005_c_()) ? EnumChatFormatting.GOLD : "")) + ent.func_70005_c_();
                    Minecraft.func_71410_x().field_71466_p.func_78261_a(name, (int)(-3.0f - (float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2) * scaleee), 5, 0xFFFFFF);
                    GL11.glPopMatrix();
                } else {
                    Minecraft.func_71410_x().field_71466_p.func_78261_a((selected ? EnumChatFormatting.YELLOW : (info != null && info.nextState.entInstance.func_70005_c_().equalsIgnoreCase(state.entInstance.func_70005_c_()) || info == null && ent.func_70005_c_().equalsIgnoreCase(Minecraft.func_71410_x().field_71439_g.func_70005_c_()) ? EnumChatFormatting.GOLD : "")) + ent.func_70005_c_(), 26, -32, 0xFFFFFF);
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (state != null && !state.playerMorph.equalsIgnoreCase(state.playerName) && state.isFavourite) {
                double pX = 9.5;
                double pY = -33.5;
                double size = 9.0;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(rlFavourite);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78370_a(255, 255, 255, 255);
                tessellator.func_78382_b();
                double iconX = pX;
                double iconY = pY;
                tessellator.func_78374_a(iconX, iconY + size, 0.0, 0.0, 1.0);
                tessellator.func_78374_a(iconX + size, iconY + size, 0.0, 1.0, 1.0);
                tessellator.func_78374_a(iconX + size, iconY, 0.0, 1.0, 0.0);
                tessellator.func_78374_a(iconX, iconY, 0.0, 0.0, 0.0);
                tessellator.func_78381_a();
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6f);
                tessellator.func_78382_b();
                iconX = pX + 1.0;
                iconY = pY + 1.0;
                tessellator.func_78374_a(iconX, iconY + size, -1.0, 0.0, 1.0);
                tessellator.func_78374_a(iconX + size, iconY + size, -1.0, 1.0, 1.0);
                tessellator.func_78374_a(iconX + size, iconY, -1.0, 1.0, 0.0);
                tessellator.func_78374_a(iconX, iconY, -1.0, 0.0, 0.0);
                tessellator.func_78381_a();
            }
            if (Morph.config.getSessionInt("showAbilitiesInGui") == 1) {
                ArrayList<Ability> abilities = AbilityHandler.getEntityAbilities(ent.getClass());
                int abilitiesSize = abilities.size();
                for (int i = abilities.size() - 1; i >= 0; --i) {
                    if (abilities.get(i).entityHasAbility(ent) && (abilities.get(i).getIcon() != null || abilities.get(i) instanceof AbilityPotionEffect) && (!(abilities.get(i) instanceof AbilityPotionEffect) || Potion.field_76425_a[((AbilityPotionEffect)abilities.get((int)i)).potionId] == null || Potion.field_76425_a[((AbilityPotionEffect)abilities.get((int)i)).potionId].func_76400_d())) continue;
                    --abilitiesSize;
                }
                boolean shouldScroll = false;
                int stencilBit = MinecraftForgeClient.reserveStencilBit();
                if (stencilBit >= 0 && abilitiesSize > 3) {
                    MorphState selectedState = null;
                    int i = 0;
                    block1: for (Map.Entry<String, ArrayList<MorphState>> e : this.playerMorphCatMap.entrySet()) {
                        if (i == this.selectorSelected) {
                            ArrayList<MorphState> states = e.getValue();
                            for (int j = 0; j < states.size(); ++j) {
                                if (j != this.selectorSelectedHori) continue;
                                selectedState = states.get(j);
                                break block1;
                            }
                            break;
                        }
                        ++i;
                    }
                    if (state != null && selectedState == state) {
                        shouldScroll = true;
                    }
                    if (shouldScroll) {
                        int stencilMask = 1 << stencilBit;
                        GL11.glEnable((int)2960);
                        GL11.glDepthMask((boolean)false);
                        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                        GL11.glStencilFunc((int)519, (int)stencilMask, (int)stencilMask);
                        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
                        GL11.glStencilMask((int)stencilMask);
                        GL11.glClear((int)1024);
                        RendererHelper.drawColourOnScreen((int)255, (int)255, (int)255, (int)255, (double)-20.5, (double)-32.5, (double)40.0, (double)35.0, (double)-10.0);
                        GL11.glStencilMask((int)0);
                        GL11.glStencilFunc((int)514, (int)stencilMask, (int)stencilMask);
                        GL11.glDepthMask((boolean)true);
                        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                }
                int offsetX = 0;
                int offsetY = 0;
                int renders = 0;
                for (int i = 0; i < (abilitiesSize > 3 && stencilBit >= 0 && abilities.size() > 3 ? abilities.size() * 2 : abilities.size()); ++i) {
                    Ability ability = abilities.get(i >= abilities.size() ? i - abilities.size() : i);
                    if (!ability.entityHasAbility(ent) || ability.getIcon() == null && !(ability instanceof AbilityPotionEffect) || ability instanceof AbilityPotionEffect && Potion.field_76425_a[((AbilityPotionEffect)ability).potionId] != null && !Potion.field_76425_a[((AbilityPotionEffect)ability).potionId].func_76400_d() || abilitiesSize > 3 && stencilBit >= 0 && abilities.size() > 3 && !shouldScroll && renders >= 3) continue;
                    ResourceLocation loc = ability.getIcon();
                    if (loc != null || ability instanceof AbilityPotionEffect) {
                        int yStart;
                        int xStart;
                        float f1;
                        float f;
                        int l;
                        double pX = -20.5;
                        double pY = -33.5;
                        double size = 12.0;
                        if (stencilBit >= 0 && abilities.size() > 3 && shouldScroll) {
                            int round = this.abilityScroll % (30 * abilities.size());
                            pY -= (size + 1.0) * ((double)round + (double)renderTick) / 30.0;
                        }
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        Tessellator tessellator = Tessellator.field_78398_a;
                        tessellator.func_78370_a(255, 255, 255, 255);
                        double iconX = pX + (double)offsetX * (size + 1.0);
                        double iconY = pY + (double)offsetY * (size + 1.0);
                        if (loc != null) {
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(loc);
                            tessellator.func_78382_b();
                            tessellator.func_78374_a(iconX, iconY + size, 0.0, 0.0, 1.0);
                            tessellator.func_78374_a(iconX + size, iconY + size, 0.0, 1.0, 1.0);
                            tessellator.func_78374_a(iconX + size, iconY, 0.0, 1.0, 0.0);
                            tessellator.func_78374_a(iconX, iconY, 0.0, 0.0, 0.0);
                            tessellator.func_78381_a();
                        } else {
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(rlGuiInventory);
                            l = Potion.field_76425_a[((AbilityPotionEffect)ability).potionId].func_76392_e();
                            f = 0.00390625f;
                            f1 = 0.00390625f;
                            xStart = l % 8 * 18;
                            yStart = 198 + l / 8 * 18;
                            tessellator.func_78382_b();
                            tessellator.func_78374_a(iconX, iconY + size, 0.0, (double)((float)xStart * f), (double)((float)(yStart + 18) * f1));
                            tessellator.func_78374_a(iconX + size, iconY + size, 0.0, (double)((float)(xStart + 18) * f), (double)((float)(yStart + 18) * f1));
                            tessellator.func_78374_a(iconX + size, iconY, 0.0, (double)((float)(xStart + 18) * f), (double)((float)yStart * f1));
                            tessellator.func_78374_a(iconX, iconY, 0.0, (double)((float)xStart * f), (double)((float)yStart * f1));
                            tessellator.func_78381_a();
                        }
                        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6f);
                        size = 12.0;
                        iconX = pX + 1.0 + (double)offsetX * (size + 1.0);
                        iconY = pY + 1.0 + (double)offsetY * (size + 1.0);
                        if (loc != null) {
                            tessellator.func_78382_b();
                            tessellator.func_78374_a(iconX, iconY + size, -1.0, 0.0, 1.0);
                            tessellator.func_78374_a(iconX + size, iconY + size, -1.0, 1.0, 1.0);
                            tessellator.func_78374_a(iconX + size, iconY, -1.0, 1.0, 0.0);
                            tessellator.func_78374_a(iconX, iconY, -1.0, 0.0, 0.0);
                            tessellator.func_78381_a();
                        } else {
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(rlGuiInventory);
                            l = Potion.field_76425_a[((AbilityPotionEffect)ability).potionId].func_76392_e();
                            f = 0.00390625f;
                            f1 = 0.00390625f;
                            xStart = l % 8 * 18;
                            yStart = 198 + l / 8 * 18;
                            tessellator.func_78382_b();
                            tessellator.func_78374_a(iconX, iconY + size, -1.0, (double)((float)xStart * f), (double)((float)(yStart + 18) * f1));
                            tessellator.func_78374_a(iconX + size, iconY + size, -1.0, (double)((float)(xStart + 18) * f), (double)((float)(yStart + 18) * f1));
                            tessellator.func_78374_a(iconX + size, iconY, -1.0, (double)((float)(xStart + 18) * f), (double)((float)yStart * f1));
                            tessellator.func_78374_a(iconX, iconY, -1.0, (double)((float)xStart * f), (double)((float)yStart * f1));
                            tessellator.func_78381_a();
                        }
                        if (++offsetY == 3 && stencilBit < 0) {
                            offsetY = 0;
                            ++offsetX;
                        }
                    }
                    ++renders;
                }
                if (stencilBit >= 0 && abilities.size() > 3 && shouldScroll) {
                    GL11.glDisable((int)2960);
                }
                MinecraftForgeClient.releaseStencilBit((int)stencilBit);
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            GL11.glEnable((int)3008);
            GL11.glDisable((int)32826);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
            GL11.glDisable((int)3553);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
            Minecraft.func_71410_x().field_71474_y.field_74319_N = hideGui;
        }
        this.forceRender = false;
    }

    public void selectRadialMenu() {
        double mag = Math.sqrt(Morph.proxy.tickHandlerClient.radialDeltaX * Morph.proxy.tickHandlerClient.radialDeltaX + Morph.proxy.tickHandlerClient.radialDeltaY * Morph.proxy.tickHandlerClient.radialDeltaY);
        double magAcceptance = 0.8;
        double radialAngle = -720.0;
        if (mag > magAcceptance) {
            double aSin = Math.toDegrees(Math.asin(Morph.proxy.tickHandlerClient.radialDeltaX));
            if (Morph.proxy.tickHandlerClient.radialDeltaY >= 0.0 && Morph.proxy.tickHandlerClient.radialDeltaX >= 0.0) {
                radialAngle = aSin;
            } else if (Morph.proxy.tickHandlerClient.radialDeltaY < 0.0 && Morph.proxy.tickHandlerClient.radialDeltaX >= 0.0) {
                radialAngle = 90.0 + (90.0 - aSin);
            } else if (Morph.proxy.tickHandlerClient.radialDeltaY < 0.0 && Morph.proxy.tickHandlerClient.radialDeltaX < 0.0) {
                radialAngle = 180.0 - aSin;
            } else if (Morph.proxy.tickHandlerClient.radialDeltaY >= 0.0 && Morph.proxy.tickHandlerClient.radialDeltaX < 0.0) {
                radialAngle = 270.0 + (90.0 + aSin);
            }
        } else {
            return;
        }
        if (mag > 0.9999999) {
            mag = Math.round(mag);
        }
        for (int i = 0; i < this.favouriteStates.size(); ++i) {
            double angle = Math.PI * 2 * (double)i / (double)this.favouriteStates.size();
            angle -= Math.toRadians(90.0);
            int radius = 80;
            float leeway = 360.0f / (float)this.favouriteStates.size();
            boolean selected = false;
            if (!(mag > magAcceptance * 0.75) || !(i == 0 && (radialAngle < (double)(leeway / 2.0f) && radialAngle >= 0.0 || radialAngle > (double)(360.0f - leeway / 2.0f))) && (i == 0 || !(radialAngle < (double)(leeway * (float)i + leeway / 2.0f)) || !(radialAngle > (double)(leeway * (float)i - leeway / 2.0f)))) continue;
            this.favouriteStates.get(i);
            MorphInfoClient info = this.playerMorphInfo.get(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
            if ((info == null || info.nextState.identifier.equalsIgnoreCase(this.favouriteStates.get((int)i).identifier)) && (info != null || this.favouriteStates.get((int)i).playerMorph.equalsIgnoreCase(Minecraft.func_71410_x().field_71439_g.func_70005_c_()))) continue;
            PacketHandler.sendToServer(Morph.channels, (AbstractPacket)new PacketGuiInput(0, this.favouriteStates.get((int)i).identifier, false));
            break;
        }
    }
}

